/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.util;

import info.aduna.collections.iterators.Iterators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtil {
    public static boolean equals(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        LinkedHashSet set1 = new LinkedHashSet();
        Iterators.addAll(model1.iterator(), set1);
        LinkedHashSet set2 = new LinkedHashSet();
        Iterators.addAll(model2.iterator(), set2);
        return ModelUtil.equals(set1, set2);
    }

    public static boolean equals(Set<? extends Statement> model1, Set<? extends Statement> model2) {
        if (model1.size() != model2.size()) {
            return false;
        }
        return ModelUtil.isSubsetInternal(model1, model2);
    }

    public static boolean isSubset(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        LinkedHashSet set1 = new LinkedHashSet();
        Iterators.addAll(model1.iterator(), set1);
        LinkedHashSet set2 = new LinkedHashSet();
        Iterators.addAll(model2.iterator(), set2);
        return ModelUtil.isSubset(set1, set2);
    }

    public static boolean isSubset(Set<? extends Statement> model1, Set<? extends Statement> model2) {
        if (model1.size() > model2.size()) {
            return false;
        }
        return ModelUtil.isSubsetInternal(model1, model2);
    }

    private static boolean isSubsetInternal(Set<? extends Statement> model1, Set<? extends Statement> model2) {
        return ModelUtil.matchModels(model1, model2);
    }

    private static boolean matchModels(Set<? extends Statement> model1, Set<? extends Statement> model2) {
        ArrayList<Statement> model1BNodes = new ArrayList<Statement>(model1.size());
        for (Statement statement : model1) {
            if (statement.getSubject() instanceof BNode || statement.getObject() instanceof BNode) {
                model1BNodes.add(statement);
                continue;
            }
            if (model2.contains(statement)) continue;
            return false;
        }
        return ModelUtil.matchModels(model1BNodes, model2, new HashMap<BNode, BNode>(), 0);
    }

    private static boolean matchModels(List<? extends Statement> model1, Iterable<? extends Statement> model2, Map<BNode, BNode> bNodeMapping, int idx) {
        boolean result = false;
        if (idx < model1.size()) {
            Statement st1 = model1.get(idx);
            List<Statement> matchingStats = ModelUtil.findMatchingStatements(st1, model2, bNodeMapping);
            for (Statement st2 : matchingStats) {
                HashMap<BNode, BNode> newBNodeMapping = new HashMap<BNode, BNode>(bNodeMapping);
                if (st1.getSubject() instanceof BNode && st2.getSubject() instanceof BNode) {
                    newBNodeMapping.put((BNode)st1.getSubject(), (BNode)st2.getSubject());
                }
                if (st1.getObject() instanceof BNode && st2.getObject() instanceof BNode) {
                    newBNodeMapping.put((BNode)st1.getObject(), (BNode)st2.getObject());
                }
                if (!(result = ModelUtil.matchModels(model1, model2, newBNodeMapping, idx + 1))) continue;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static List<Statement> findMatchingStatements(Statement st, Iterable<? extends Statement> model, Map<BNode, BNode> bNodeMapping) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        for (Statement statement : model) {
            if (!ModelUtil.statementsMatch(st, statement, bNodeMapping)) continue;
            result.add(statement);
        }
        return result;
    }

    private static boolean statementsMatch(Statement st1, Statement st2, Map<BNode, BNode> bNodeMapping) {
        BNode mappedBNode;
        BNode mappedBNode2;
        URI pred2;
        URI pred1 = st1.getPredicate();
        if (!((Object)pred1).equals(pred2 = st2.getPredicate())) {
            return false;
        }
        Resource subj1 = st1.getSubject();
        Resource subj2 = st2.getSubject();
        if (subj1 instanceof BNode && subj2 instanceof BNode ? ((mappedBNode2 = bNodeMapping.get(subj1)) != null ? !subj2.equals(mappedBNode2) : bNodeMapping.containsValue(subj2)) : !subj1.equals(subj2)) {
            return false;
        }
        Value obj1 = st1.getObject();
        Value obj2 = st2.getObject();
        return !(obj1 instanceof BNode && obj2 instanceof BNode ? ((mappedBNode = bNodeMapping.get(obj1)) != null ? !obj2.equals(mappedBNode) : bNodeMapping.containsValue(obj2)) : !obj1.equals(obj2));
    }
}

