// Package webauthn provides the Chrome DevTools Protocol
// commands, types, and events for the WebAuthn domain.
//
// This domain allows configuring virtual authenticators to test the WebAuthn
// API.
//
// Generated by the cdproto-gen command.
package webauthn

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"context"

	"github.com/chromedp/cdproto/cdp"
)

// EnableParams enable the WebAuthn domain and start intercepting credential
// storage and retrieval with a virtual authenticator.
type EnableParams struct {
	EnableUI bool `json:"enableUI,omitempty,omitzero"` // Whether to enable the WebAuthn user interface. Enabling the UI is recommended for debugging and demo purposes, as it is closer to the real experience. Disabling the UI is recommended for automated testing. Supported at the embedder's discretion if UI is available. Defaults to false.
}

// Enable enable the WebAuthn domain and start intercepting credential
// storage and retrieval with a virtual authenticator.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#method-enable
//
// parameters:
func Enable() *EnableParams {
	return &EnableParams{}
}

// WithEnableUI whether to enable the WebAuthn user interface. Enabling the
// UI is recommended for debugging and demo purposes, as it is closer to the
// real experience. Disabling the UI is recommended for automated testing.
// Supported at the embedder's discretion if UI is available. Defaults to false.
func (p EnableParams) WithEnableUI(enableUI bool) *EnableParams {
	p.EnableUI = enableUI
	return &p
}

// Do executes WebAuthn.enable against the provided context.
func (p *EnableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandEnable, p, nil)
}

// DisableParams disable the WebAuthn domain.
type DisableParams struct{}

// Disable disable the WebAuthn domain.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#method-disable
func Disable() *DisableParams {
	return &DisableParams{}
}

// Do executes WebAuthn.disable against the provided context.
func (p *DisableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandDisable, nil, nil)
}

// AddVirtualAuthenticatorParams creates and adds a virtual authenticator.
type AddVirtualAuthenticatorParams struct {
	Options *VirtualAuthenticatorOptions `json:"options"`
}

// AddVirtualAuthenticator creates and adds a virtual authenticator.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#method-addVirtualAuthenticator
//
// parameters:
//
//	options
func AddVirtualAuthenticator(options *VirtualAuthenticatorOptions) *AddVirtualAuthenticatorParams {
	return &AddVirtualAuthenticatorParams{
		Options: options,
	}
}

// AddVirtualAuthenticatorReturns return values.
type AddVirtualAuthenticatorReturns struct {
	AuthenticatorID AuthenticatorID `json:"authenticatorId,omitempty,omitzero"`
}

// Do executes WebAuthn.addVirtualAuthenticator against the provided context.
//
// returns:
//
//	authenticatorID
func (p *AddVirtualAuthenticatorParams) Do(ctx context.Context) (authenticatorID AuthenticatorID, err error) {
	// execute
	var res AddVirtualAuthenticatorReturns
	err = cdp.Execute(ctx, CommandAddVirtualAuthenticator, p, &res)
	if err != nil {
		return "", err
	}

	return res.AuthenticatorID, nil
}

// SetResponseOverrideBitsParams resets parameters isBogusSignature, isBadUV,
// isBadUP to false if they are not present.
type SetResponseOverrideBitsParams struct {
	AuthenticatorID  AuthenticatorID `json:"authenticatorId"`
	IsBogusSignature bool            `json:"isBogusSignature,omitempty,omitzero"` // If isBogusSignature is set, overrides the signature in the authenticator response to be zero. Defaults to false.
	IsBadUV          bool            `json:"isBadUV,omitempty,omitzero"`          // If isBadUV is set, overrides the UV bit in the flags in the authenticator response to be zero. Defaults to false.
	IsBadUP          bool            `json:"isBadUP,omitempty,omitzero"`          // If isBadUP is set, overrides the UP bit in the flags in the authenticator response to be zero. Defaults to false.
}

// SetResponseOverrideBits resets parameters isBogusSignature, isBadUV,
// isBadUP to false if they are not present.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#method-setResponseOverrideBits
//
// parameters:
//
//	authenticatorID
func SetResponseOverrideBits(authenticatorID AuthenticatorID) *SetResponseOverrideBitsParams {
	return &SetResponseOverrideBitsParams{
		AuthenticatorID: authenticatorID,
	}
}

// WithIsBogusSignature if isBogusSignature is set, overrides the signature
// in the authenticator response to be zero. Defaults to false.
func (p SetResponseOverrideBitsParams) WithIsBogusSignature(isBogusSignature bool) *SetResponseOverrideBitsParams {
	p.IsBogusSignature = isBogusSignature
	return &p
}

// WithIsBadUV if isBadUV is set, overrides the UV bit in the flags in the
// authenticator response to be zero. Defaults to false.
func (p SetResponseOverrideBitsParams) WithIsBadUV(isBadUV bool) *SetResponseOverrideBitsParams {
	p.IsBadUV = isBadUV
	return &p
}

// WithIsBadUP if isBadUP is set, overrides the UP bit in the flags in the
// authenticator response to be zero. Defaults to false.
func (p SetResponseOverrideBitsParams) WithIsBadUP(isBadUP bool) *SetResponseOverrideBitsParams {
	p.IsBadUP = isBadUP
	return &p
}

// Do executes WebAuthn.setResponseOverrideBits against the provided context.
func (p *SetResponseOverrideBitsParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetResponseOverrideBits, p, nil)
}

// RemoveVirtualAuthenticatorParams removes the given authenticator.
type RemoveVirtualAuthenticatorParams struct {
	AuthenticatorID AuthenticatorID `json:"authenticatorId"`
}

// RemoveVirtualAuthenticator removes the given authenticator.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#method-removeVirtualAuthenticator
//
// parameters:
//
//	authenticatorID
func RemoveVirtualAuthenticator(authenticatorID AuthenticatorID) *RemoveVirtualAuthenticatorParams {
	return &RemoveVirtualAuthenticatorParams{
		AuthenticatorID: authenticatorID,
	}
}

// Do executes WebAuthn.removeVirtualAuthenticator against the provided context.
func (p *RemoveVirtualAuthenticatorParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandRemoveVirtualAuthenticator, p, nil)
}

// AddCredentialParams adds the credential to the specified authenticator.
type AddCredentialParams struct {
	AuthenticatorID AuthenticatorID `json:"authenticatorId"`
	Credential      *Credential     `json:"credential"`
}

// AddCredential adds the credential to the specified authenticator.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#method-addCredential
//
// parameters:
//
//	authenticatorID
//	credential
func AddCredential(authenticatorID AuthenticatorID, credential *Credential) *AddCredentialParams {
	return &AddCredentialParams{
		AuthenticatorID: authenticatorID,
		Credential:      credential,
	}
}

// Do executes WebAuthn.addCredential against the provided context.
func (p *AddCredentialParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandAddCredential, p, nil)
}

// GetCredentialParams returns a single credential stored in the given
// virtual authenticator that matches the credential ID.
type GetCredentialParams struct {
	AuthenticatorID AuthenticatorID `json:"authenticatorId"`
	CredentialID    string          `json:"credentialId"`
}

// GetCredential returns a single credential stored in the given virtual
// authenticator that matches the credential ID.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#method-getCredential
//
// parameters:
//
//	authenticatorID
//	credentialID
func GetCredential(authenticatorID AuthenticatorID, credentialID string) *GetCredentialParams {
	return &GetCredentialParams{
		AuthenticatorID: authenticatorID,
		CredentialID:    credentialID,
	}
}

// GetCredentialReturns return values.
type GetCredentialReturns struct {
	Credential *Credential `json:"credential,omitempty,omitzero"`
}

// Do executes WebAuthn.getCredential against the provided context.
//
// returns:
//
//	credential
func (p *GetCredentialParams) Do(ctx context.Context) (credential *Credential, err error) {
	// execute
	var res GetCredentialReturns
	err = cdp.Execute(ctx, CommandGetCredential, p, &res)
	if err != nil {
		return nil, err
	}

	return res.Credential, nil
}

// GetCredentialsParams returns all the credentials stored in the given
// virtual authenticator.
type GetCredentialsParams struct {
	AuthenticatorID AuthenticatorID `json:"authenticatorId"`
}

// GetCredentials returns all the credentials stored in the given virtual
// authenticator.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#method-getCredentials
//
// parameters:
//
//	authenticatorID
func GetCredentials(authenticatorID AuthenticatorID) *GetCredentialsParams {
	return &GetCredentialsParams{
		AuthenticatorID: authenticatorID,
	}
}

// GetCredentialsReturns return values.
type GetCredentialsReturns struct {
	Credentials []*Credential `json:"credentials,omitempty,omitzero"`
}

// Do executes WebAuthn.getCredentials against the provided context.
//
// returns:
//
//	credentials
func (p *GetCredentialsParams) Do(ctx context.Context) (credentials []*Credential, err error) {
	// execute
	var res GetCredentialsReturns
	err = cdp.Execute(ctx, CommandGetCredentials, p, &res)
	if err != nil {
		return nil, err
	}

	return res.Credentials, nil
}

// RemoveCredentialParams removes a credential from the authenticator.
type RemoveCredentialParams struct {
	AuthenticatorID AuthenticatorID `json:"authenticatorId"`
	CredentialID    string          `json:"credentialId"`
}

// RemoveCredential removes a credential from the authenticator.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#method-removeCredential
//
// parameters:
//
//	authenticatorID
//	credentialID
func RemoveCredential(authenticatorID AuthenticatorID, credentialID string) *RemoveCredentialParams {
	return &RemoveCredentialParams{
		AuthenticatorID: authenticatorID,
		CredentialID:    credentialID,
	}
}

// Do executes WebAuthn.removeCredential against the provided context.
func (p *RemoveCredentialParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandRemoveCredential, p, nil)
}

// ClearCredentialsParams clears all the credentials from the specified
// device.
type ClearCredentialsParams struct {
	AuthenticatorID AuthenticatorID `json:"authenticatorId"`
}

// ClearCredentials clears all the credentials from the specified device.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#method-clearCredentials
//
// parameters:
//
//	authenticatorID
func ClearCredentials(authenticatorID AuthenticatorID) *ClearCredentialsParams {
	return &ClearCredentialsParams{
		AuthenticatorID: authenticatorID,
	}
}

// Do executes WebAuthn.clearCredentials against the provided context.
func (p *ClearCredentialsParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandClearCredentials, p, nil)
}

// SetUserVerifiedParams sets whether User Verification succeeds or fails for
// an authenticator. The default is true.
type SetUserVerifiedParams struct {
	AuthenticatorID AuthenticatorID `json:"authenticatorId"`
	IsUserVerified  bool            `json:"isUserVerified"`
}

// SetUserVerified sets whether User Verification succeeds or fails for an
// authenticator. The default is true.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#method-setUserVerified
//
// parameters:
//
//	authenticatorID
//	isUserVerified
func SetUserVerified(authenticatorID AuthenticatorID, isUserVerified bool) *SetUserVerifiedParams {
	return &SetUserVerifiedParams{
		AuthenticatorID: authenticatorID,
		IsUserVerified:  isUserVerified,
	}
}

// Do executes WebAuthn.setUserVerified against the provided context.
func (p *SetUserVerifiedParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetUserVerified, p, nil)
}

// SetAutomaticPresenceSimulationParams sets whether tests of user presence
// will succeed immediately (if true) or fail to resolve (if false) for an
// authenticator. The default is true.
type SetAutomaticPresenceSimulationParams struct {
	AuthenticatorID AuthenticatorID `json:"authenticatorId"`
	Enabled         bool            `json:"enabled"`
}

// SetAutomaticPresenceSimulation sets whether tests of user presence will
// succeed immediately (if true) or fail to resolve (if false) for an
// authenticator. The default is true.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#method-setAutomaticPresenceSimulation
//
// parameters:
//
//	authenticatorID
//	enabled
func SetAutomaticPresenceSimulation(authenticatorID AuthenticatorID, enabled bool) *SetAutomaticPresenceSimulationParams {
	return &SetAutomaticPresenceSimulationParams{
		AuthenticatorID: authenticatorID,
		Enabled:         enabled,
	}
}

// Do executes WebAuthn.setAutomaticPresenceSimulation against the provided context.
func (p *SetAutomaticPresenceSimulationParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetAutomaticPresenceSimulation, p, nil)
}

// SetCredentialPropertiesParams allows setting credential properties.
// https://w3c.github.io/webauthn/#sctn-automation-set-credential-properties.
type SetCredentialPropertiesParams struct {
	AuthenticatorID   AuthenticatorID `json:"authenticatorId"`
	CredentialID      string          `json:"credentialId"`
	BackupEligibility bool            `json:"backupEligibility,omitempty,omitzero"`
	BackupState       bool            `json:"backupState,omitempty,omitzero"`
}

// SetCredentialProperties allows setting credential properties.
// https://w3c.github.io/webauthn/#sctn-automation-set-credential-properties.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAuthn#method-setCredentialProperties
//
// parameters:
//
//	authenticatorID
//	credentialID
func SetCredentialProperties(authenticatorID AuthenticatorID, credentialID string) *SetCredentialPropertiesParams {
	return &SetCredentialPropertiesParams{
		AuthenticatorID: authenticatorID,
		CredentialID:    credentialID,
	}
}

// WithBackupEligibility [no description].
func (p SetCredentialPropertiesParams) WithBackupEligibility(backupEligibility bool) *SetCredentialPropertiesParams {
	p.BackupEligibility = backupEligibility
	return &p
}

// WithBackupState [no description].
func (p SetCredentialPropertiesParams) WithBackupState(backupState bool) *SetCredentialPropertiesParams {
	p.BackupState = backupState
	return &p
}

// Do executes WebAuthn.setCredentialProperties against the provided context.
func (p *SetCredentialPropertiesParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetCredentialProperties, p, nil)
}

// Command names.
const (
	CommandEnable                         = "WebAuthn.enable"
	CommandDisable                        = "WebAuthn.disable"
	CommandAddVirtualAuthenticator        = "WebAuthn.addVirtualAuthenticator"
	CommandSetResponseOverrideBits        = "WebAuthn.setResponseOverrideBits"
	CommandRemoveVirtualAuthenticator     = "WebAuthn.removeVirtualAuthenticator"
	CommandAddCredential                  = "WebAuthn.addCredential"
	CommandGetCredential                  = "WebAuthn.getCredential"
	CommandGetCredentials                 = "WebAuthn.getCredentials"
	CommandRemoveCredential               = "WebAuthn.removeCredential"
	CommandClearCredentials               = "WebAuthn.clearCredentials"
	CommandSetUserVerified                = "WebAuthn.setUserVerified"
	CommandSetAutomaticPresenceSimulation = "WebAuthn.setAutomaticPresenceSimulation"
	CommandSetCredentialProperties        = "WebAuthn.setCredentialProperties"
)
