package WordList::SU::LTIS;

our $DATE = '2016-01-13'; # DATE
our $VERSION = '0.04'; # VERSION

use utf8;

use WordList;
our @ISA = qw(WordList);

our %STATS = ("num_words_contains_unicode",572,"avg_word_len",7.28101751859851,"longest_word_len",18,"shortest_word_len",2,"num_words",4167,"num_words_contains_nonword_chars",1,"num_words_contains_whitespace",0); # STATS

1;
# ABSTRACT: Sundanese words from Loka Tarjamah Otomatis Indonesia-Sunda




=pod

=encoding UTF-8

=head1 NAME

WordList::SU::LTIS - Sundanese words from Loka Tarjamah Otomatis Indonesia-Sunda

=head1 VERSION

This document describes version 0.04 of WordList::SU::LTIS (from Perl distribution WordList-SU-LTIS), released on 2016-01-13.

=head1 SYNOPSIS

 use WordList::SU::LTIS;

 my $wl = WordList::SU::LTIS->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 STATISTICS

 +----------------------------------+------------------+
 | key                              | value            |
 +----------------------------------+------------------+
 | avg_word_len                     | 7.28101751859851 |
 | longest_word_len                 | 18               |
 | num_words                        | 4167             |
 | num_words_contains_nonword_chars | 1                |
 | num_words_contains_unicode       | 572              |
 | num_words_contains_whitespace    | 0                |
 | shortest_word_len                | 2                |
 +----------------------------------+------------------+

The statistics is available in the C<%STATS> package variable.

=head1 DESCRIPTION

This word list is extracted from a free Stardict dictionary (only single words
are included). Copyright notice from the dictionary:

 Hak Cipta (c) 2007 Dian Tresna Nugraha <dian.nugraha@gmail.com>, dikompilasi ku Steven Haryanto <steven@masterweb.net>. v0.01 2009-04-15

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-SU-LTIS>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-SU-LTIS>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-SU-LTIS>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut


__DATA__
abad
abong
abotna
acara
acarana
acay
adegan
adek
adi
adigung
adil
adu
agamana
ageman
agénda
agung
agustus
ahad
ahéng
ahérat
ahir
ahirna
ahli
ajak
ajakan
ajaran
ajeg
ajén
ajengan
ajrih
ajudan
akang
akar
aki
akibat
akina
aksara
aksés
aksésna
aksi
aksina
aktip
aktipkeun
akur
alam
alamat
alamatna
alatan
albeum
alesan
alesanna
alih
aling
alkohol
alo
alona
alpukah
alung
alus
alusna
aman
amanat
amarah
ambacak
ambéh
ambek
ambekan
ambeu
ambles
ambulan
amis
ampir
amplop
ampuh
amunisi
anak
anaking
anakna
analisis
anca
anceman
ancemna
ancik
anco
ancrub
ancur
andeprok
anduk
angar
anggapan
anggaran
angger
anggota
anggotana
angka
angkatan
angkeub
angklung
animasi
anjeun
anjeunna
anjing
anjog
antara
antara
antarana
antaré
anti
antieum
anu
anyar
anyarna
apalan
aparat
apes
apoték
april
arah
arahan
aral
arang
ararahéng
aréna
arileu
armada
arsip
arsiték
artikel
arus
asak
asal
asalna
asar
asas
asasi
aseupan
asih
asin
asing
asli
aslina
asong
aspal
aspék
asrama
asri
astana
asup
asupna
atah
atawa
ateul
atikan
atikanana
atlét
atoh
atuh
aturan
awahan
awak
awakna
awalna
awér
awét
aweuhan
awéwé
awi
awon
awuntah
awut
aya
ayana
ayat
ayeuna
bab
babagi
babak
babakan
babalantik
babarengan
babasan
babatok
babaturanana
bacaan
bacacar
badag
badagna
badan
badarat
badminton
baganti
bagian
bagja
baha
bahan
bahé
baheula
baheulana
bajigur
bajo
bajoan
bajoang
baju
bakal
bakalan
bakat
bako
bakrek
bakti
baktos
bal
balabah
balai
balakécrakan
balangah
balanja
balaréa
balayar
balé
balédog
balem
bales
balesan
balik
balukarna
banding
bandingan
bangkerut
bangor
bangsa
bank
banténg
banting
bantingan
bantu
bantuan
bapa
bapana
baragajul
barang
baraya
bareng
baréntol
barét
baréto
bareuh
bari
baris
barudak
baruk
basa
basajan
basana
baseuh
basis
basisir
baskét
baso
batalkeun
batan
batang
batok
batu
batur
baturna
bawa
bawang
bayabah
bayangkeun
bayaranana
bayeungyang
béak
béakkeun
béar
béas
bébas
bébéakan
beberesih
bécék
béda
bédana
bedil
bedilna
bedo
bedog
bedug
bedugna
bégal
begang
begér
béja
bejad
béjana
bekasi
bekel
béla
beleger
belut
bendéra
bener
benerna
béngkok
béntang
béntés
bentukna
bérak
béré
bérés
berik
berkas
bersih
bet
betah
beubeut
beueus
beuheung
beuki
beuleum
beuli
beunang
beuneur
beungbeurat
beungeut
beungeutna
beunghar
beurang
beurat
beureum
beurit
beus
beusi
beuteung
beuti
béwara
beyé
biantara
biasa
biasana
biayana
bibi
bibina
bikeun
bilateral
bingkeng
bingung
binih
bintara
bisa
bisnis
bitis
bitu
biwir
blogna
blok
bobok
boboko
bocor
bodas
boga
bogana
bolos
bongbolongan
bongkok
bongoh
bool
borangan
bosen
brigade
buah
buahna
buaya
bubuka
budak
budaya
bugang
bujal
bujur
bukti
buku
bukuna
bulan
bulanan
bulao
bulenan
buleud
buligir
bumi
bunderan
bungah
bungangang
bungin
bungkem
bungkus
bungkusna
bungsu
bungur
buntut
burahay
buringas
buronan
buronanna
buruh
buruy
busik
buta
butek
buuk
caah
caang
cabang
cabé
cacad
cacak
cageur
cahara
cahya
cai
caian
calakan
calana
calikong
calon
cambepem
campur
campuran
cangkaruk
cangkéng
cangkeul
capé
cara
carana
carangka
careham
caremot
carita
catetan
cau
cawérang
cawokah
cecekelan
cécépét
cedit
cék
cenah
cenahna
centil
cérét
céréwét
ceuceub
ceuceuleukeuteukan
ceuceuleuweungan
ceudeum
ceuk
ceuli
ceulina
ceurik
cicing
ciduh
cikal
cikénéh
cikur
cileureun
cingir
cingogo
cinta
cinyusu
cipanonna
cipta
ciriwis
citak
citakan
citakna
coba
cocog
cokél
coklat
cokot
colok
condong
conto
contona
coplok
cua
cucu
cucuk
cukup
culik
curuk
da
daék
daérah
dagang
dagangan
dagdégdog
daging
dahar
dahlia
dalapan
dalapanan
damar
damelna
damis
dana
dangah
dangdan
dangdaunan
dangdut
dangong
daptar
darat
daratan
daratang
daréhdéh
dasar
dasarna
data
datang
datangan
datangna
dawam
daweung
dawuk
dayeuh
dedek
déét
dékadeu
deku
delegasi
demés
demi
demit
démografi
démokrasi
démokrat
demokratis
déngé
déngékeun
depa
dépot
désa
desain
desainna
désémber
detik
deudeuieun
deui
deukeut
deungeun
dévisa
déwa
déwan
di
diabusan
diacungan
diadilan
diadopsi
diadu
diagram
diajak
diajar
diaktifkeun
diaku
dialaman
dialungkeun
dianggap
dianggarkeun
diangkat
diantarana
dianut
diapungkeun
diarahkeun
diartikeun
diasosiasikeun
diasupkeun
diatur
diawurkeun
diayakeun
diayakeunana
dibabantukeun
dibaca
dibadamikeun
dibagi
dibagikeun
dibahas
dibajo
dibakukeun
dibalukarkeun
dibandingkeun
dibantuan
dibarengan
dibarung
dibaturan
dibawa
dibedahkeun
dibédakeun
dibéjakeun
dibenerkeun
dibéré
dibersihkeun
dibeuleum
dibeuli
dibeungbeuratan
dibiasakeun
dibikeun
dibinasakeun
dibiruyungan
diboncéngan
dibuktikeun
dibungkus
dicampur
dicatet
dicatetkeun
dicekel
dicelukkeun
dicempad
dicicikeun
dicicil
dicicingan
dicindekkeun
diciptakeun
diciptakeunana
dicoba
dicokot
dicoo
dicoplok
dicutat
didadarkeun
didatangan
didesek
dideukeutan
diékstradisi
diéléhkeun
diémbarkeun
dieu
dieureunkeun
dieusi
digalurakeun
diganjar
digantian
digantikeun
digantung
digaplokan
digaringkeun
digawé
digecek
digedéan
digembrong
digerebeg
digeroan
digiling
digital
digogogan
digoréng
digulingkeun
dihadiran
diharepkeun
dihasilkeun
diheulakeun
dihijikeun
dihontal
dihuapan
dihubungan
dihudang
dihukum
diidek
diidinan
diinget
diingetan
diingkeun
diinjeum
diitung
dijabél
dijadikeun
dijagokeun
dijalankeun
dijangjian
dijelaskeun
dijemput
dijieun
dijual
dijudulan
dijungjung
dikadalikeun
dikadoan
dikaitkeun
dikaluarkeun
dikamanakeun
dikantongan
dikaput
dikawasa
dikawasana
dikécéng
dikedalkeun
dikeputan
dikeukeup
dikirim
dikirimkeun
diklat
dikokolakeun
dikompilasi
dikontrak
dikontrakkeun
dikoordinasikeun
dikosongkeun
dikunjal
dilakonan
dilaksanakeun
dilaksanakeunana
dilancarkeun
dilapisan
dilaporkeun
dilarang
dilarapkeun
dilayanan
dilelempeng
diléngkahan
dilengkepan
dileupas
dileupaskeun
diliwatan
diluuhan
dimangpaatkeun
dimeunangkeun
dimimitian
dimodifikasi
dina
dinamis
dines
dingaranan
dinya
dinyatakeun
diomongkeun
diondang
dioperkeun
dioyag
dipager
dipageran
dipahaman
dipaké
dipakéna
dipangaruhan
dipanggihan
dipangnepikeun
dipangnyieunkeun
dipapaésan
dipapag
dipapagahan
diparebutkeun
dipariksa
diparkir
dipasang
dipastikeun
dipedar
dipegatkeun
dipenggel
dipenjara
dipénta
dipercaya
diperlukeun
dipeunteun
dipeupeuskeun
dipibanda
dipiboga
dipiceun
dipigawé
dipihormat
dipikanyaho
dipikawanoh
dipikir
dipilih
dipilihna
dipindahkeun
dipingpin
dipingpinna
dipintonkeun
dipinuhan
dipirig
diproduksi
diprosés
diprotés
dipuji
dipulangkeun
dipulasara
dipunggu
dipungkas
dipupuhuan
dipuseurkeun
dirakrak
dirarancang
dirawat
direbut
diregepkeun
diréktur
diréndéngan
diresmikeun
diri
dirina
dirobah
dirojong
dirombak
dironjatkeun
dirumajakeun
dirumuskeun
dirusiahkeun
disadiakeun
disahkeun
disalabarkeun
disalametkeun
disalurkeun
disaluyukeun
disamarutkeun
disampurnakeun
disanghareupan
disangka
disangkana
disaruakeun
disatujuan
disawalakeun
disebarkeun
disebut
disebutkeun
disebutna
disembah
diserep
disésakeun
diseureud
diséwakeun
disiapkeun
disiplin
diskriminasi
disponsoran
disuguhan
disumputkeun
disuratan
disurungkeun
disusud
disusul
disusun
ditaékkeun
ditagih
ditahan
ditakol
ditakolan
ditalukkeun
ditalungtik
ditambah
ditambahkeun
ditambal
ditampik
ditandaan
ditandatanganan
ditanggung
ditangtayungan
ditangtukeun
ditanjeurkeun
ditanya
ditanyakeun
ditapsirkeun
ditarékahan
ditarima
ditarjamahkeun
ditaros
ditatanyakeun
ditawaran
ditawarkeun
ditéang
ditelepon
ditémbak
ditémbalan
ditembrakkeun
ditembus
ditempatan
ditempatkeun
ditémpél
ditempo
ditepikeun
ditepungan
ditéror
diteruskeun
dités
ditetepkeun
ditéwak
ditibankeunana
ditinggalkeun
ditingker
dititah
ditu
ditugaskeun
ditukeur
ditulis
dituliskeun
dituluykeun
ditumpakan
ditumpes
ditunda
ditungkulan
ditungtungan
ditungtut
ditunjuk
diturunkeun
ditutup
ditutupan
dituturkeun
diudag
diuk
diungkabkeun
diungkulan
diutus
diwajibkeun
diwakilan
diwangun
diwangunna
diwanohkeun
diwarnaan
diwaspadaan
diwatesan
diwayuh
diwuwuhan
dobel
doktor
doktrin
dokumén
dokuméntasi
domain
domba
dongko
doraka
dosa
doyong
dua
duaan
duanana
dubur
duduluran
dugal
duit
duitna
dukung
dumadakan
dumasar
dunya
duplikat
duruk
dusun
duta
écés
écéskeun
édisi
éfék
éh
éjahan
éjahanana
éjéktor
ékol
ékonom
ékonomi
ékspor
éksportir
ékstradisi
éléh
éléktronik
éléktronika
élevasina
élit
élmu
emas
émbaran
embé
émboh
émbohna
émosional
émpér
éncér
éndah
éndahna
endog
engké
engkéna
engkol
enol
éntog
enya
enyaan
épisodeu
épték
éra
erém
éskalator
éstuning
éta
étik
étika
eumeur
eunteung
eunteup
eupan
eureun
eureunkeun
eureunna
eusi
eusina
euweuh
evakuasi
fakultas
fasilitasna
fatwa
fisik
fluorida
forum
fraksina
fundaméntal
gabug
gabungan
gading
gado
gagal
gaganti
gagantina
gagarabah
gaib
gajah
galagat
galengan
galéri
galing
galo
galura
gambar
gambaran
gambuhang
gampang
gampangna
ganas
gancang
gandong
gangguan
ganjor
ganjorna
gantar
ganti
gantina
garadah
garah
garatis
garelut
garihal
garing
gas
gasna
gawé
gawéna
gawir
gaya
gebrag
gedang
gedeg
gedong
gegedéan
gégéléhéan
gelar
gelas
gelendeng
gélo
gembleng
gemi
gemuk
génder
genep
genepan
genggerong
géologi
gepéng
geremet
gering
gésér
géték
geter
getih
getihan
getol
geulis
geuneuk
geunjleung
geunyal
geus
geutah
geuwat
gigireunana
giji
giling
ginanjar
ginséng
gitar
giwar
gogog
gogoléncéngan
golongan
goréng
goréngna
gorolong
gorowok
granat
grup
guaran
gubernur
gudang
gugurah
gujrud
gula
gulat
gulawing
guludug
gumantung
gumbira
gunana
gunung
gupitan
gurat
gurawés
gurinjal
guru
hadéna
hadir
hahalang
hahaok
hajat
haji
hak
hakim
hal
halangan
haleungheum
halimpu
halimun
halis
halodo
halu
hamham
hampang
hampas
hamperu
hampura
handap
haneut
haneutna
hangseur
hanjakal
hanjakalna
hanjelu
hanjeluna
haratis
harepan
harepkeun
hareudang
hareup
hareupeunana
harga
hargana
harigu
hariring
hariwang
harta
harti
hartina
hartosna
has
hasanah
haseup
hasiatna
hasil
hasilna
haté
hateup
hawa
hayam
hayang
hayangeun
hayu
hébat
héjo
héktar
henteu
héot
hérang
herbivora
heroik
hésé
héséna
heuay
heureut
heureutna
hibarna
hiber
hiburan
hideung
hiem
hiji
hijian
hikmah
hileud
hiliwir
hinis
hipu
hirup
hirupna
hitut
hoé
hoghag
honor
hontalan
hontalanana
hookeun
hormat
hotél
hubungan
hubunganana
hujan
hukum
hukuman
humandeuar
huntu
hurang
huru
hurup
husus
hususna
ibun
idéal
idéntik
idéologi
ideu
idin
ieu
ilmiah
imah
imahna
iman
impor
imunisasi
imut
incu
indéks
indit
indung
indungna
industri
info
informasi
inget
inggeung
ingkeun
injeum
injil
inohong
inovasi
inspéktur
instruktur
intelijen
interior
internasional
internet
intina
inum
inuman
inumanana
ipis
ipisna
iraha
irung
isa
iser
islam
israél
istilah
istimiwa
isuk
isukan
iteuk
itung
itungan
iwal
jabatanna
jadi
jadwal
jaga
jagat
jago
jail
jajahan
jajar
jajaran
jalan
jalanan
jalankeun
jalantah
jalingkak
jalir
jalma
jalu
jam
jamaah
jaman
jambu
jaminan
jampé
jamu
jandela
jangjang
jangji
jangkung
jangkungna
januari
japati
jaram
jasa
jauhna
jawab
jawabanana
jawara
jaya
jebi
jeger
jegud
jejer
jejero
jelas
jelemana
jenderal
jéndral
jengker
jenis
jeniusna
jero
jerona
jeruk
jerukna
jibril
jieunan
jiga
jigana
jiwa
jiwana
jiwir
jojodog
jomantara
jorowokan
jual
judi
jujur
jukut
jukutan
juli
jumaah
jumaahan
jumlah
jumlahna
jumplukan
juni
junun
juragan
jurig
jurnal
juru
jurumudina
jurusan
juta
jutaan
ka
kaadilan
kaagamaan
kaahlian
kaamanan
kaamananana
kaambek
kaampeuh
kaancam
kaanéhan
kaanggotaan
kaasih
kaasup
kaasupan
kaayaan
kabagi
kabagjaan
kabangsaan
kabawa
kabaya
kabayang
kabébasan
kabéh
kabéhanana
kabel
kabentuk
kaberesihan
kabetot
kabeuleum
kabeuratan
kabiasaan
kabinét
kabiruyungan
kabogoh
kabogohna
kabongkar
kabudayaan
kabuka
kabuktian
kabupatén
kabur
kacamatan
kacatet
kaceluk
kaci
kacicikeun
kacilakaan
kacindekan
kacindekanana
kadaharan
kadali
kadaptar
kadatangan
kadatanganana
kadaulatan
kadé
kadéngé
kader
kadieunakeun
kado
kadona
kadu
kadua
kaduhung
kaduitan
kaduitanana
kadupak
kaéléh
kaésaan
kaeureunkeun
kaeusi
kagabung
kagagalan
kagamah
kagambarkeun
kaganggu
kageulisan
kagiatan
kagiatanana
kagok
kagumantungan
kagumantunganana
kahakiman
kahalangan
kahanjelu
kahariwang
kahayang
kahayangna
kahésé
kahiji
kahijina
kahilapan
kahirupan
kahirupanana
kahontal
kahoréam
kahot
kahumandeuar
kai
kainget
kaitan
kaitanana
kaitung
kajaba
kajadian
kajaga
kajaksaan
kajembaran
kajeun
kakawasaan
kakayaan
kakejeman
kakeueum
kakeunaan
kakeupeul
kakoncara
kaku
kakuatan
kakulawargaan
kakunjal
kakurangan
kalahiran
kalahka
kalakuan
kalaluasaan
kalangkang
kalantipan
kalapa
kalaparan
kalatih
kalawan
kalayanan
kalér
kaleuleuwihan
kaleungitan
kaleuwihan
kaleuwihanana
kaliber
kalibet
kalima
kalimah
kalinglap
kaliru
kaliwat
kalolobaan
kaluar
kaluman
kalungguhan
kalurahan
kamahéran
kamajuan
kamakmuran
kamalir
kamandirian
kamangmang
kamanusaan
kamar
kamari
kamasarakatan
kamekaran
kaméra
kamerdikaan
kameunang
kami
kamilitéran
kamiskinan
kampung
kampus
kamudi
kanabian
kanaékan
kanagaraan
kanceuh
kandel
kandelna
kaniaya
kantong
kantor
kanyaho
kanyahoan
kanyataan
kaopat
kaoténtikan
kapacikeuh
kapadulian
kapaké
kapaksa
kapal
kapamingpinan
kapangéranan
kapanggih
kapanggihna
kapastian
kapegatkeun
kapéngpéongan
kapentingan
kapercayaan
kaperluan
kaperluanana
kapidara
kapikir
kapikirkeun
kapimilik
kapinuhan
kapinunjulan
kapok
kaptén
kapulisian
kapuloan
kaput
kaputusan
kapuuk
karacunan
karaharjaan
karajaan
karakawihan
karaman
karasaeun
karat
karatan
karaton
karatonna
karémbong
karét
karéta
karétna
karijut
karinjang
karir
kartu
karuhun
karuksakan
karuksakanana
kasadaran
kasalahan
kasalamatenana
kasalametan
kasalempang
kasampak
kasang
kasangka
kasapukan
kasaragaman
kasaréan
kasasar
kasatiaan
kasebut
kaséhatan
kasempetan
kasenian
kasép
kasiangan
kasinugrahan
kasorang
kasulitan
kasusna
kataji
katalayah
katalimbeng
katandangan
katandasa
katangtuan
katatanagaraan
kategori
katelahna
katelengesan
katémbak
katémbong
katempo
katempona
katengtreman
katerangan
kateupastian
katilu
katingker
katingtriman
katiténan
katolik
katresna
katuhu
katulung
katumbiri
katungkulan
katuruban
katut
katutup
katutupan
kaukur
kaulinan
kaum
kaungkab
kauntungan
kaurugan
kausikkeun
kawajiban
kawajibanana
kawalahan
kawanohan
kawas
kawasa
kawates
kawéntar
kawihna
kawijakan
kawilang
kayakinan
kayas
kebek
kebi
kebon
kecap
kécéng
kécéngan
kedal
kedalan
kedalkeun
kedalna
kédé
kédér
kedul
kekemben
keker
kelas
kélék
kelir
kemba
kembang
kemis
kemot
kempés
kénca
kendang
kentel
kenténg
kenyang
kéom
keprok
keris
kérod
kertas
késang
kesed
kesit
keueum
keuneung
keupat
keupeul
keur
keusik
kewung
kiamat
kiceupan
kidul
kieu
kiih
kikiping
kilométer
kios
kiosna
kira
kirana
kirim
kiriman
kiruh
kitab
kitu
kiwari
koalisi
kode
koét
kohkol
koin
kokoro
kokotor
kolécér
kolonél
kolonial
kolot
kolotna
koma
komandan
komandanna
komando
komara
komarana
koméntar
koméntarna
komérsial
komisaris
komo
kompénsasi
kompetisi
komponén
komputer
komputerna
konci
koncina
kondisina
konéksi
konéng
konférénsi
kongkorong
kongrés
konsép
konspirasi
konsul
konsumén
konsumsi
kontak
koperasi
kopi
koran
korban
koréksi
koréspondén
korma
koropok
korps
korpsna
korsi
korsina
kosong
kotak
kotok
krisis
kristen
kritik
kritis
ku
kualitas
kualitasna
kuat
kuciwana
kuda
kudéta
kudu
kueh
kuis
kujang
kuku
kukumbah
kukupu
kulawarga
kulawargana
kuliah
kuliahna
kulimis
kulit
kulon
kulub
kumaha
kumbah
kumis
kumplit
kuna
kungsi
kuningan
kuntung
kurabu
kurang
kuraweud
kuriling
kuring
kurung
kusial
kutan
kuya
kuyumbang
labuh
lada
ladén
laér
lagu
laguna
lahan
lahanna
lahir
lain
lainna
laja
lajur
laksamana
laku
lalajo
lalaki
lalakon
lalampahan
lalangsé
lalangséna
lalawanan
lalawora
laleur
lambak
lambang
lambokot
lampah
lamping
lampu
lamun
lamur
lancah
lancar
lanceuk
landeuh
landian
langganan
langgananna
langgeng
langit
langka
langlang
langlangan
langsung
lantaran
lanté
lantip
lapang
lapar
laporan
laporanana
larangan
laras
latihan
lauk
laun
laut
lawan
lawon
layan
layanan
layar
layon
lebaran
lebu
lééh
lega
legleg
lého
lekasan
lélépén
lembaga
lembaran
lembong
lembur
lemes
lempeng
léncop
léngkah
léngkahan
lengkepan
léngkob
léngkong
létah
létak
létkol
létnan
leubeut
leuheung
leukeun
leuleus
leumpang
leungeun
leungeunnya
leungit
leungitna
leupas
leuseuh
leutak
leutik
leuweung
leuwi
leuwih
liang
lianna
licik
lieur
lila
lilana
lima
limaan
limpas
limpeuran
lindeuk
lingkungan
lini
lintuh
linyok
lipet
lir
lisénsi
listrik
lisung
liter
liwar
liwat
loba
lobana
logor
loka
lokasi
lolobana
lolong
lomari
lombang
los
lowongan
luar
lucir
lucu
luhur
luhurna
lukut
lulugu
lulumpatan
lulus
lulusan
lumaku
lumangsung
lumayan
lumpat
luncat
luyu
mabek
mabok
maca
macakal
macana
macangkrama
macem
macok
macrek
macul
maculna
madanan
madon
madya
maéhan
maén
mageran
magrib
mahabu
mahal
mahar
mahasiswa
mahér
mahkamah
majalah
majelis
maju
majuna
maké
makena
makéna
maksud
maksudna
makuta
malaékat
malahan
malang
maligé
malik
ma'lum
maluruh
mamala
mamang
mamanis
mana
manajemén
mancanagara
mancegkeun
mancing
mancung
mandi
manéh
manéhna
mangaruhan
mangga
manggihan
manggu
manggul
mangka
mangnyieunkeun
mangpaat
mangpaatna
mangrupa
mangsa
manjang
manjangkeun
mantuan
manuk
manusa
manyun
maok
maot
maotna
mapag
mapalangan
marahmay
maranéh
maranéhanana
marengan
maréntah
maréntahkeun
maret
mariksa
maritimna
markas
markasna
markir
masak
masalah
masalahna
masangkeun
masarakat
masarkeunnana
masih
masjid
massa
mastikeun
maténkeun
materil
maturan
maung
mawa
maya
mayar
mayeng
mayit
mayor
méakkeun
mebes
mecakan
mecenghul
medal
medar
medarna
meded
média
médis
megatkeun
méi
méja
mékanik
mékanikna
mekar
melak
melang
melendung
meléng
melengkungkeun
melong
mendet
mending
menggel
mengi
mengkel
méngkol
menit
menitan
ménta
mentéréng
menteri
menyan
merangan
mercayaan
mercayakeun
merdika
méré
mérek
merenah
meres
mérkuri
merlukeun
mesék
mésem
mesen
mesin
méter
méteran
metot
meujeuhna
meuleum
meuli
meunang
meunangkeun
meuncit
meungpeung
meunteun
meupeus
meureun
meuseul
miara
miboga
miceun
miéling
migawé
migawena
mihak
miharep
mikaresep
mikawanoh
mikeun
mikir
mikiran
mikiranana
milampah
milih
milik
milikna
militer
milu
miluan
milyar
milyaran
milyarna
mimiti
mimitian
mimitina
minangka
minantu
mindahkeun
mindeng
minggu
mingguan
mingpin
mini
minoritas
mintonkeun
mintul
minuhan
minyak
misahkeun
misan
miskin
mitembeyan
mitoha
mitohana
mitra
mitresna
moal
mobil
modal
mode
modél
modém
modéren
molotot
moméntum
moncor
moncorong
mondokkeun
monyét
mopohokeun
moro
morosotna
motong
motor
mroduksi
muatan
mudun
muga
muja
muji
muka
muket
mulangkeun
mulintirkeun
muluskeun
mumuluk
munapék
muncrat
mundel
munding
mundur
mundurkeun
mundurna
mungkas
muntah
murag
murah
murengked
muringis
murub
murudul
musibah
musieum
muslim
muslimat
muslimin
mustahil
muter
na
nabeuh
nabi
naék
naékan
naékkeun
nagara
nagarana
nagari
nagen
nagih
naha
nahan
nakleuk
nakol
nalangsara
nalapung
nalatahan
nalungtik
nambahan
nampa
nampik
nananyakeun
nanaon
nandakeun
nandangan
nandasa
nandatanganan
nandéan
nandéanana
nandonkeun
nanggepan
nanggung
nangkarak
nangtang
nangtawing
nangtayungan
nangtukeun
nangtung
nanjeurkeun
nanjung
nanya
nanyakeun
naon
naonkeun
napakah
napsu
narajang
naraka
narékahan
nargétkeun
narima
nasib
nasional
nasrani
natamu
navigasi
nawarkeun
néangan
négatif
negeskeun
nelen
nelepon
némbak
némbakkeun
némbalan
némbongkeun
nembus
nempatkeun
némpél
nempo
nempokeun
nengetan
nenggel
néngtéréwéléng
népana
nepikeun
nepungan
nerapkeun
nerus
neruskeun
netepkeun
neuleuman
neunggeul
neunggeulan
néwak
néwakan
nga
ngaalusan
ngababarkeun
ngababaturan
ngabacakeun
ngabagéakeun
ngabagi
ngabahas
ngabahayakeun
ngabaheum
ngabahula
ngabajo
ngabalangkeun
ngabalanjaan
ngabales
ngabalukarkeun
ngabantuan
ngabatesan
ngabatur
ngabawa
ngabayangkeun
ngabédakeun
ngabejaan
ngabekokan
ngabéla
ngabeledag
ngabenerkeun
ngabenerkeunana
ngabéréskeun
ngabersihkeun
ngabeuleum
ngabeungbeuratan
ngabeureumkeun
ngabiayaan
ngabiluk
ngabina
ngabingungkeun
ngabintih
ngabirigidig
ngabocorkeun
ngabogaan
ngabolaykeun
ngabolongan
ngabombardir
ngabrul
ngabubarkeun
ngaco
ngadadak
ngadadarkeun
ngadagleg
ngadagoan
ngadahar
ngadakom
ngadalikeun
ngadapang
ngadaptar
ngadasar
ngadatangan
ngadatangkeun
ngadéang
ngadégdég
ngadegkeun
ngadéhém
ngadék
ngadekem
ngadéklarasikeun
ngadelék
ngadéngé
ngadesek
ngadeukeutan
ngadigleg
ngadistribusikeun
ngado
ngadoan
ngadon
ngadongdon
ngadongéngkeun
ngadongkang
ngadongkar
ngadudut
ngadukeun
ngaduruk
ngagabig
ngagabrug
ngagabung
ngagabungkeun
ngagacel
ngagadil
ngagaléong
ngagambarkeun
ngagampangkeun
ngaganggayong
ngaganggu
ngaganjel
ngaganti
ngagantikeun
ngagantina
ngagantung
ngagantungkeun
ngagaringkeun
ngagayem
ngagebah
ngagéboy
ngagebros
ngagedéan
ngageduk
ngagéhan
ngagem
ngagemukan
ngagerem
ngagereyem
ngagero
ngageuingkeun
ngageuri
ngagiling
ngagogog
ngagogogan
ngagolak
ngagolér
ngagoréng
ngagotong
ngagulundung
ngagunakeun
ngagundam
ngagungkeun
ngagusrukan
ngagusur
ngahadiran
ngahaja
ngaharepkeun
ngaharéwos
ngahargaan
ngahasilkeun
ngahaturkeun
ngahésékeun
ngaheujeun
ngaheureutkeun
ngahibar
ngahieng
ngahiji
ngahirupkeun
ngahontal
ngahormatan
ngahuapan
ngahudangkeun
ngahulag
ngahuleng
ngaipisanana
ngais
ngait
ngajabél
ngajadikeun
ngajadikeunna
ngajaga
ngajajah
ngajajar
ngajak
ngajalanan
ngajalankeun
ngajalankeunana
ngajamin
ngajanggélék
ngajangjian
ngajarkeun
ngajarumat
ngajaul
ngajebian
ngajejewét
ngajelaskeun
ngajelegur
ngajénan
ngajenghok
ngajerit
ngajingjing
ngajleng
ngajorowokeun
ngajual
ngajul
ngajumpluk
ngajungjung
ngajurung
ngakat
ngakeup
ngaku
ngalaan
ngalabuhkeun
ngaladénan
ngalahun
ngalakonan
ngalakonanana
ngalaksanakeun
ngalakukeun
ngalalana
ngalaman
ngalamun
ngalanggengkeun
ngalanglang
ngalapor
ngalaporkeun
ngalarapkeunana
ngalatih
ngalawan
ngalayad
ngalayang
ngalayangkeun
ngalegaan
ngaléléwé
ngaléng
ngaléngkah
ngaléngkahan
ngaléor
ngaleukeunan
ngaleungitkeun
ngaleuwihan
ngaleyek
ngali
ngalicin
ngalieuk
ngalindur
ngalingkung
ngalipet
ngaliwat
ngaliwatan
ngaliwatkeun
ngaluarkeun
ngalucutan
ngaluuhan
ngamajukeun
ngamaklum
ngamaknaan
ngamangpaatkeun
ngamankeun
ngamasarakatkeun
ngambah
ngambay
ngamekarkeun
ngameunangan
ngamomorékeun
ngampar
ngamuara
ngamuk
ngamuliakeun
ngan
ngancem
ngancurkeun
ngandeg
ngandelan
ngandelkeun
ngandung
ngangah
nganggap
nganggarkeun
nganggepan
nganggur
ngangkang
ngangkog
ngangles
ngangon
ngangson
nganiaya
nganistakeun
nganjang
nganjuk
ngantay
ngantep
nganteur
nganteurkeun
ngantongan
nganuhunkeun
ngapalkeun
ngapung
ngaput
ngaracik
ngarak
ngaraketkeun
ngaralat
ngaran
ngarang
ngaranna
ngarapikeun
ngararancang
ngararangna
ngararasakeun
ngarasa
ngarasakeun
ngarayakeun
ngarayap
ngarebut
ngaregepkeun
ngarékam
ngarémpak
ngaréngsékeun
ngarérét
ngareureuhkeun
ngarévisi
ngaréwong
ngaringkuk
ngariung
ngariungna
ngarobah
ngaroés
ngarojok
ngarojong
ngarojongna
ngaronjatkeun
ngaruang
ngarubung
ngarugikeun
ngarujuk
ngarumuskeun
ngarusak
ngasaan
ngasah
ngasongkeun
ngasumsikeun
ngasupan
ngasupkeun
ngatik
ngawadahan
ngawakilan
ngawangun
ngawanohan
ngawanohkeun
ngawar
ngawariskeun
ngawarnaan
ngawartakeun
ngawasa
ngawaskeun
ngawates
ngawayuh
ngawelah
ngawengku
ngawincik
ngawisuna
ngawowoy
ngawujudkeun
ngawujudkeunana
ngawur
ngawurukan
ngayak
ngayakeun
ngayakinan
ngayap
ngayun
ngebog
ngebul
ngécé
ngécéng
ngécér
ngécéskeun
ngécos
ngedalkeun
ngedeng
ngeduk
ngégél
ngelas
ngelay
ngéléhan
ngéléhkeun
ngeleketek
ngeleper
ngembang
ngembangkeun
ngémbarkeun
ngempit
ngempur
ngenyot
ngepél
ngeplek
ngérakeun
ngerekeb
ngerem
ngésod
ngeueum
ngeunaan
ngeunah
ngeunteung
ngeupeulkeun
ngeureunkeun
ngeusian
ngeuweuhkeun
ngiceup
ngiles
ngimanan
ngimeutan
ngimpel
ngimpi
nginget
ngingetan
ngingetkeun
ngintip
nginum
ngipisan
ngirabkeun
ngirim
ngirimkeun
ngirining
ngising
ngistrénan
ngitung
ngobarkeun
ngobrol
ngocék
ngoclok
ngocor
ngocorkeun
ngohkoh
ngojay
ngokolakeun
ngolomoh
ngolotan
ngoméntaran
ngomong
ngomongkeun
ngomongna
ngondang
ngontrak
ngora
ngorbankeun
ngoréjat
ngoréksi
ngorondang
ngosok
ngotéktak
ngoyagkeun
nguatkeun
nguciwakeun
ngudag
ngudud
nguduhkeun
ngudukeun
ngugung
nguliat
ngultimatum
nguluwut
nguluyur
ngumbara
ngumpulkeun
ngunggelkeun
ngungkab
ngungkabkeun
ngunjalan
nguntungkeun
ngurangan
nguras
ngured
ngurihit
ngurus
nguruskeun
nguseup
ngusikkeun
ngusir
ngusulkeun
ngutamakeun
ngutruk
ngutus
nguyang
nguyumbang
niat
nikah
nikmatna
nindes
nindihan
ninggalkeun
ningker
nini
nitetan
niwaskeun
nohonan
nojos
nomer
nonoman
nopémber
nuduh
nuju
nukeur
nulak
nulis
nuliskeun
nuliskeunana
nulungan
nuluykeun
numiba
numpakan
numpang
numpes
numpuk
numuwuhkeun
nunda
nungguan
nungkulan
nungkulkeun
nungtut
nunjuk
nunungguan
nurunkeun
nurutkeun
nusantara
nutupan
nutupkeun
nuturkeun
nyaah
nyaan
nyabak
nyabet
nyabeulahan
nyabok
nyabut
nyadap
nyadar
nyadiakeun
nyaéta
nyageurkeun
nyaho
nyakclakan
nyaksian
nyalabarkeun
nyalahan
nyalametkeun
nyalurkeun
nyalusup
nyaluyukeun
nyambat
nyamber
nyambung
nyambungkeun
nyambungkeunana
nyampurnakeun
nyampurnakeunana
nyamur
nyandet
nyandu
nyandung
nyanghareup
nyanghareupan
nyanghareupanana
nyangka
nyapék
nyapluk
nyapu
nyaram
nyarangkeun
nyarékan
nyarita
nyaritakeun
nyaruakeun
nyarupaan
nyata
nyatakeun
nyatujuan
nyawa
nyawad
nyawana
nyebarkeun
nyebutkeun
nyeceb
nyedek
nyegah
nyekel
nyekelan
nyelekit
nyempad
nyenangkeun
nyengir
nyerah
nyerbu
nyerek
nyérélék
nyerepan
nyésakeun
nyeureud
nyéwa
nyiapkeun
nyicikeun
nyicil
nyicip
nyieun
nyigeung
nyimbeuh
nyimpang
nyimpen
nyingcet
nyingcetkeun
nyingkahkeun
nyintreuk
nyiptakeun
nyipuh
nyiruan
nyisi
nyium
nyobaan
nyodor
nyoékkeun
nyokot
nyontoan
nyopot
nyorong
nyukupan
nyulik
nyumbang
nyumponan
nyumponanana
nyumput
nyumputkeun
nyuratan
nyurtian
nyurungkeun
nyusul
nyusun
nyutat
obrolanna
ogé
ogo
oktober
olah
olahraga
olé
omongan
ondangan
ondanganna
opat
opatan
operasi
opini
oposisi
optik
oranyeu
organisasi
orok
otobiografina
otomatis
otoritas
oyag
paamprok
paamprokna
pabajoan
pabaliut
pabéasan
pabiayaan
pabrik
pacét
pacul
pada
padagang
padahal
padamucunghul
padempét
padeukeut
padika
padoman
paduduaan
paduli
padumukan
padungdengan
pagawé
pagawéan
pager
pagéto
pageuh
pagorényang
paguron
paham
pahatu
pahlawan
paila
pais
pait
pajabat
pajeg
pajoang
pajurawet
pakakas
pakarang
pakarangna
pakasaban
paké
pakéan
palabuhan
palajaran
palaksanaan
palaku
palanggaran
palangkakan
palapah
palatih
palatihan
palebah
palid
palika
palipisan
palsu
palu
pamaca
pamadegan
pamaén
pamahaman
pamajikan
pamaké
pamakéan
pamaksudanna
pamali
pamanah
pamaréntah
pamaréntahan
pamariksaan
pamasaran
pamatuk
pamayang
paménta
pameunteunan
pamikiran
pamilu
pamiluna
pamingpin
pamingpinna
pamodal
pamrogram
pamrograman
pamujana
pamulasara
pamungkas
pamustunganana
pan
panakolna
panalungtikan
panandéan
panangtayungan
panarima
panawaran
pancadria
pancén
pancing
pandeuri
panéangan
panémbak
panempo
panén
paneunggeul
paneuteup
pang
pangabisa
pangadeg
pangadilan
pangagem
pangajaran
pangajén
pangakuan
pangalaman
pangangguran
panganteur
panganut
panganyarna
pangapungan
pangaruh
pangasilan
pangaturan
pangawas
pangawasa
pangawasaan
pangaweruh
pangaweruhna
pangbadagna
pangbagéa
pangbagéana
pangbalikan
pangdeukeutna
pangedulan
pangéran
panggero
panggilingan
panggoréngna
panghina
pangimeutan
pangjagaan
pangjajah
pangjajahan
pangjajahanana
pangkalan
pangkatna
pangladén
panglima
pangluhurna
pangmahalna
pangpentingna
pangrojong
pangsiun
pangurus
pangusaha
pangwangunan
pangwates
panjang
panjara
panon
panongton
panonna
panonpoé
panteng
panto
panulung
panunggu
panungtung
panutup
panyakit
panyampurna
panyéhatan
panyicingan
panyicinganana
panyipta
panyiptaan
panyocokan
panyopotan
panyumputan
papadana
papan
papang
papanggih
papasanganana
papatong
para
parabot
paradoks
parahu
parakanca
parapatan
paraséa
parat
paré
pareng
paréntah
pareum
paria
paribasa
pariksa
pariwara
pariwisata
parkir
parna
parobahan
partéi
partéina
parud
parunggu
pas
pasagi
pasalna
pasamoan
pasanggiri
pasantrén
pasar
pasaratan
pasca
paseuk
pasini
pasir
paspor
pasrah
pasti
pasualan
pasualanana
pasukan
patali
patalimarga
patalina
pataneuhan
patani
patanina
patarosan
patémbalan
patén
pati
patri
patroli
patugas
patung
patut
pausahaan
pawon
payung
péang
pebruari
pecut
pedes
pegat
pégo
pejret
pelak
pelem
pelengkung
pélor
pencét
penclut
pendék
péngkor
pengkuh
penting
pentingna
pényon
pepedut
pepek
pepekna
pepelakan
pér
pérak
perang
pérang
percaya
perenahna
période
perkara
perlu
perlukeun
perluna
persén
pésak
pesenan
péso
péstol
pétét
peucang
peujit
peuncit
peuntas
peunteun
peupeus
peura
peureup
peurih
peurihna
peuteuy
peuting
peuyeum
pianakan
piboga
piceun
picilakaeun
pidawuh
pigawé
pihakna
pihapé
piit
pikahariwangeun
pikalebareun
pikasono
pikeun
pikir
pikiran
pikiranana
pikirkeun
pilemburan
pileuweungan
pilih
pilihan
pilihna
pinareup
pindah
pinggel
pingping
pintonan
pinuh
pinunjul
pirak
pisan
piseurieun
pita
pites
pituin
planét
poé
poéan
poéna
pogot
pohara
poho
poko
pokona
pola
polimér
politéisme
pondok
ponggawa
popor
populasi
portalna
posisi
posisina
poto
potona
potong
prakték
praktékna
présidén
pribadi
pribumi
produk
produksi
produksina
produsén
profésional
program
programna
promosi
propinsi
prosedur
prosés
puadé
puasa
pulasara
pules
pulisi
pulitik
pulitikna
pulitisi
pulo
puluh
puluhan
punah
pungkaskeun
punjul
punten
puntir
pupuhu
pupuhuna
purnawirawan
puseur
pustaka
puter
puteri
putra
putuskeun
rabeng
rada
rahayat
rajakaya
rajol
raksasa
ramadan
ramat
rambay
rambutan
ramé
ramo
rampak
rampus
ranca
rancagé
randa
rangkeng
rangkep
rangkul
rangkuman
rangsang
rangu
ranteng
rapet
rapih
raramat
rarampéolan
rarancang
rarancangna
rarangkén
rarasaan
raratan
rasa
rasakeun
rasana
rata
ratu
ratus
raya
réa
rebo
rébu
rébuan
rédaksi
référénsi
régang
regep
regot
rék
rékaman
rekening
réktor
réméh
rencana
réncang
rengat
réngsé
réplika
republik
rérégéan
rerencepan
resep
résiden
resmi
reueuk
reueus
reueusna
reuhak
reujeung
reukeut
reungit
reureuh
reureunceupan
reuwas
rikes
rinci
rinyuh
ririwit
ris
riung
riweuh
robah
rohangan
rojong
roko
rokona
rongkah
ronjatkeun
rosul
rubak
rubuh
rugi
ruhay
rujukan
rukmi
ruksak
rukun
rumahuh
rumaja
rungkun
runtah
runtuh
runtuy
runtuyan
rusiah
rutinna
saab
saajén
saarah
sabab
sababaraha
sababna
sabada
sabalikna
saban
sabanding
sabangsa
sabar
sabaraé
sabaraha
sabatang
sabéak
sabelas
sabenerna
sabot
sabulan
sacangkir
sacara
sada
sadar
sadia
saémbér
saéstuna
saeutik
saeutikna
sagala
sagancangna
sagara
sagedé
sagelas
sagi
saha
saharga
sahenteuna
saimah
saimbang
sajaba
sajabana
sajajar
sajarah
sajarahna
sajati
sajauh
sajongjonan
sajumlah
sajuta
sakabéh
sakahayangna
sakali
sakalian
sakaligus
sakampung
sakanyaho
sakapeung
sakarat
sakeudeung
sakeudeung
saking
sakitu
sakola
sakolana
sakolébat
sakotamadya
sakotéap
saksi
saksian
sakuduna
sakuliah
sakumaha
sakumna
sakurilingna
salah
salahna
salaki
salakina
salaku
salam
salamet
salametkeun
salapan
salapanan
salasa
salawasna
salega
salemah
salempang
salengkepna
saleuseurian
saleutik
saleuwihna
salila
salinan
salisik
saloba
salsé
saluhur
saluhureunana
saluyu
samagaha
samak
samara
samawi
sambarang
sambetan
sambungkeun
sambungna
saméméh
saméméhna
samentara
samilyar
saminggu
samiuk
sampeu
sampeur
sampeurkeun
sampurna
sanajan
sanding
sandra
sanepina
sanggal
sanggeus
sanggul
sanggup
sanghareupan
sangka
sangkan
sangu
sapanjang
saparapat
sapasang
sapatemon
sapatu
sapédah
sapeuting
sapi
sapinuhna
sapoé
sapopoé
saprak
saptu
sapuk
sapuluh
sapuluhan
saragam
sarakah
saramé
sarangéngé
sarat
saratus
saré
saréat
sarébu
saréngsé
sarikat
sarimbag
sarombong
sarta
sarua
sarupa
sarupaning
sarurak
sarwa
sasama
sasamana
sasaruaan
sasaruanana
sastra
satakerna
satapak
satarik
sataun
saté
satempat
satengah
saterusna
satia
satiana
sato
satria
satrilyun
satru
satutasna
saukur
saumur
saung
sauntuyan
saurang
sawajarna
sawaktu
sawala
sawaréh
sawatara
sawawa
sebel
sebelna
sebrét
sebut
sebutan
sedengkeun
sedep
sedot
sééng
seger
segruk
séjén
séjénna
sekrup
séks
sél
sélular
sémah
sempet
sénat
sénator
séndok
senén
seni
sénsitip
séntiméter
sepa
sépak
sepi
séptember
serang
sérang
serbu
sérémonial
sérép
séri
sersan
sértipikat
sésa
sésana
sesek
seubeuh
seueul
seukeut
seuneu
seuneuan
seungit
seureuh
seuri
seuseungitan
séwang
siam
siap
siapkeun
sidang
sieun
sihung
siki
silih
silinder
simbol
simbut
simeut
simpen
sina
sinambungan
sinarieun
sindiran
singer
singget
singgetan
sintreuk
sipat
sipatna
sipil
sipuh
sirah
sirahna
siraru
sireum
sirit
sirung
sisi
sisidueun
sisit
sistem
sistematis
siswa
siuk
skala
skandal
slogan
sloganna
soal
soalna
soang
soéh
sok
solat
soldadu
solédat
solobong
soméah
songong
sono
sopan
sora
sorana
sorangan
soré
soré
sosial
stadion
stamina
standar
statusna
studi
subaya
subuh
suci
sugan
sukarélawan
suksés
suku
sukuna
sulundupan
sumanget
sumangetna
sumangga
sumawona
sumbang
sumbangan
sumebar
sumebarken
sumebarna
sumerah
sumujud
sumur
sungut
sungutna
supir
suplemén
surat
suratna
surélék
surup
susu
susuganan
susunan
suweng
taat
tabéat
tablég
tabrakan
tacan
tadi
tadina
tagihan
tah
tahan
tahanan
tajongan
takbiran
taker
takis
taktak
talari
talatah
taliti
taluk
tambaga
tambahan
tambahna
tampik
tampikan
tanaga
tanda
tandé
tanding
tanduk
taneuh
taneuhna
tangga
tanggal
tanggung
tangkal
tangsi
tangtangan
tangtu
tani
tanpa
tanya
tapak
tapi
tapis
tarajang
tarang
tarapti
tarasi
tarigu
tarima
tarjamah
tarjamahan
tarung
tasma
tata
tataman
tatamba
tatanan
tatanén
tatangga
tatangkalan
tatu
tauhid
taunan
taurat
tawaran
tawekal
téang
tegep
teger
teges
tegeskeun
tegesna
tégtog
teguh
téh
téknik
téknis
téknologi
téla
telat
telenges
telepon
télévisi
téma
témbakan
témbalna
tempat
tempatna
tempo
témpo
tenang
tengah
tengahan
tengtrem
téorina
tépa
tepas
tepung
téré
terjun
téroris
terus
terusna
tétéla
tetempoan
tetep
teu
teuas
teuing
teuneung
teunggeulan
ti
tiguling
tihang
tiheula
tiis
tijengkang
tikerelep
tikoro
tikoséwad
tiktikbrek
tilu
tiluan
timbangan
timbulna
timburu
timuan
tinangtu
tinggal
tinggaleun
tinggalkeun
tingkah
tingkat
tingker
tinimbang
tinimbangan
tinun
tinyuh
tipe
tipu
tipung
tirisna
titah
titénan
titik
titilar
tiung
tiupan
tiwas
tiwaskeun
tiwasna
tiwu
todél
toél
togmol
toko
toléransi
tonggong
tonjok
tonjol
torék
torobos
toropong
torowongan
total
tresna
treuk
trinitas
tuar
tugu
tujuan
tujuanana
tujuh
tujuhan
tukang
tukangeunana
tukeur
tulang
tulatén
tulis
tulisan
tuliskeun
tulung
tuluy
tumbak
tumbu
tumiba
tumpang
tumpes
tumuwuh
tumuwuhna
tunduh
tunggal
tunggara
tunggu
tungkul
tungkus
tungtung
tungtungna
tungtut
tungtutan
tunjang
tunjuk
tunjukkeun
turis
turun
turunan
turunna
turut
turutan
turuy
tutul
tutumpakan
tutup
tutuwuhan
tuur
tuus
ubar
ubeng
ucing
ucul
udag
udagan
udunan
uger
ujub
ujung
ukuran
ukuranana
ulah
ulin
umat
umroh
umum
umumna
umur
umurna
unggal
unggeuk
unggut
ungkab
unikna
unit
universitas
unsur
untung
untungna
upacara
upama
upamana
uplek
urang
urug
urusan
urut
usaha
usik
usul
usum
utah
utahna
utama
utamana
uteuk
utusan
utusanna
variatif
vérsi
vidéo
waé
waja
wajar
wajib
waktu
waktuna
walikat
walirang
walungan
wanda
wangun
wangunan
wangwangan
wani
wanoja
waragad
waras
wareg
warga
warganagara
warnana
warsih
warta
wartawan
warung
watek
wates
watesan
watir
wawadukan
wawakil
wawancara
wawaran
wawarkeun
wawuh
wayah
wedak
welasan
wengkuan
wening
werit
weruh
wétan
weuteuhan
wewengkon
wiati
widang
widé
wijaksana
wijén
wirahma
wirasat
wiwaha
wujudna
wungkul
wungu
wuwungan
yahudi
yakin
yatim
yayasan
yén
yeuh
yuyu
zabur
zakat
