/*
 * Decompiled with CFR 0.152.
 */
package openlink.util;

import java.util.Enumeration;
import openlink.util.VectorEnumerator;

public class Vector {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public Vector(int n, int n2) {
        this.elementData = new Object[n];
        this.capacityIncrement = n2;
    }

    public Vector(int n) {
        this(n, 0);
    }

    public Vector() {
        this(10);
    }

    public Vector(Object[] objectArray) {
        this.elementData = objectArray;
        this.elementCount = objectArray.length;
    }

    public void copyInto(Object[] objectArray) {
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
    }

    public void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public void ensureCapacity(int n) {
        if (n > this.elementData.length) {
            this.ensureCapacityHelper(n);
        }
    }

    private void ensureCapacityHelper(int n) {
        int n2;
        int n3 = this.elementData.length;
        Object[] objectArray = this.elementData;
        int n4 = n2 = this.capacityIncrement > 0 ? n3 + this.capacityIncrement : n3 * 2;
        if (n2 < n) {
            n2 = n;
        }
        this.elementData = new Object[n2];
        System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
    }

    public void setSize(int n) {
        if (n > this.elementCount && n > this.elementData.length) {
            this.ensureCapacityHelper(n);
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = n;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Enumeration elements() {
        return new VectorEnumerator(this);
    }

    public boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public int indexOf(Object object, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (!object.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public int lastIndexOf(Object object, int n) {
        for (int i = n; i >= 0; --i) {
            if (!object.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public Object elementAt(int n) {
        return this.elementData[n];
    }

    public Object firstElement() {
        return this.elementData[0];
    }

    public Object lastElement() {
        return this.elementData[this.elementCount - 1];
    }

    public void setElementAt(Object object, int n) {
        this.elementData[n] = object;
        if (n >= this.elementCount) {
            this.elementCount = n + 1;
        }
    }

    public void removeElementAt(int n) {
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        if (this.elementCount > 0) {
            --this.elementCount;
        }
        this.elementData[this.elementCount] = null;
    }

    public void insertElementAt(Object object, int n) {
        int n2 = this.elementCount + 1;
        if (n2 > this.elementData.length) {
            this.ensureCapacityHelper(n2);
        }
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = object;
        ++this.elementCount;
    }

    public void addElement(Object object) {
        int n = this.elementCount + 1;
        if (n > this.elementData.length) {
            this.ensureCapacityHelper(n);
        }
        this.elementData[this.elementCount++] = object;
    }

    public boolean removeElement(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.elements();
        stringBuffer.append("[");
        for (int i = 0; i <= n; ++i) {
            Object e = enumeration.nextElement();
            String string = e == null ? "<null>" : e.toString();
            stringBuffer.append(string);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return new Vector(objectArray);
    }
}

