/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.format;

import java.text.DateFormatSymbols;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.threeten.bp.format.DateTimeTextProvider;
import org.threeten.bp.format.TextStyle;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.IsoFields;
import org.threeten.bp.temporal.TemporalField;

final class SimpleDateTimeTextProvider
extends DateTimeTextProvider {
    private static final ConcurrentMap<Map.Entry<TemporalField, Locale>, Object> CACHE = new ConcurrentHashMap<Map.Entry<TemporalField, Locale>, Object>(16, 0.75f, 2);
    private static final Comparator<Map.Entry<String, Long>> COMPARATOR = new Comparator<Map.Entry<String, Long>>(){

        @Override
        public int compare(Map.Entry<String, Long> obj1, Map.Entry<String, Long> obj2) {
            return obj2.getKey().length() - obj1.getKey().length();
        }
    };

    SimpleDateTimeTextProvider() {
    }

    @Override
    public Locale[] getAvailableLocales() {
        return DateFormatSymbols.getAvailableLocales();
    }

    @Override
    public String getText(TemporalField field, long value, TextStyle style, Locale locale) {
        Object store = this.findStore(field, locale);
        if (store instanceof LocaleStore) {
            return ((LocaleStore)store).getText(value, style);
        }
        return null;
    }

    @Override
    public Iterator<Map.Entry<String, Long>> getTextIterator(TemporalField field, TextStyle style, Locale locale) {
        Object store = this.findStore(field, locale);
        if (store instanceof LocaleStore) {
            return ((LocaleStore)store).getTextIterator(style);
        }
        return null;
    }

    private Object findStore(TemporalField field, Locale locale) {
        Map.Entry<TemporalField, Locale> key = SimpleDateTimeTextProvider.createEntry(field, locale);
        Object store = CACHE.get(key);
        if (store == null) {
            store = this.createStore(field, locale);
            CACHE.putIfAbsent(key, store);
            store = CACHE.get(key);
        }
        return store;
    }

    private Object createStore(TemporalField field, Locale locale) {
        if (field == ChronoField.MONTH_OF_YEAR) {
            DateFormatSymbols oldSymbols = DateFormatSymbols.getInstance(locale);
            HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
            Long f1 = 1L;
            Long f2 = 2L;
            Long f3 = 3L;
            Long f4 = 4L;
            Long f5 = 5L;
            Long f6 = 6L;
            Long f7 = 7L;
            Long f8 = 8L;
            Long f9 = 9L;
            Long f10 = 10L;
            Long f11 = 11L;
            Long f12 = 12L;
            String[] array = oldSymbols.getMonths();
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(f1, array[0]);
            map.put(f2, array[1]);
            map.put(f3, array[2]);
            map.put(f4, array[3]);
            map.put(f5, array[4]);
            map.put(f6, array[5]);
            map.put(f7, array[6]);
            map.put(f8, array[7]);
            map.put(f9, array[8]);
            map.put(f10, array[9]);
            map.put(f11, array[10]);
            map.put(f12, array[11]);
            styleMap.put(TextStyle.FULL, map);
            map = new HashMap();
            map.put(f1, array[0].substring(0, 1));
            map.put(f2, array[1].substring(0, 1));
            map.put(f3, array[2].substring(0, 1));
            map.put(f4, array[3].substring(0, 1));
            map.put(f5, array[4].substring(0, 1));
            map.put(f6, array[5].substring(0, 1));
            map.put(f7, array[6].substring(0, 1));
            map.put(f8, array[7].substring(0, 1));
            map.put(f9, array[8].substring(0, 1));
            map.put(f10, array[9].substring(0, 1));
            map.put(f11, array[10].substring(0, 1));
            map.put(f12, array[11].substring(0, 1));
            styleMap.put(TextStyle.NARROW, map);
            array = oldSymbols.getShortMonths();
            map = new HashMap();
            map.put(f1, array[0]);
            map.put(f2, array[1]);
            map.put(f3, array[2]);
            map.put(f4, array[3]);
            map.put(f5, array[4]);
            map.put(f6, array[5]);
            map.put(f7, array[6]);
            map.put(f8, array[7]);
            map.put(f9, array[8]);
            map.put(f10, array[9]);
            map.put(f11, array[10]);
            map.put(f12, array[11]);
            styleMap.put(TextStyle.SHORT, map);
            return SimpleDateTimeTextProvider.createLocaleStore(styleMap);
        }
        if (field == ChronoField.DAY_OF_WEEK) {
            DateFormatSymbols oldSymbols = DateFormatSymbols.getInstance(locale);
            HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
            Long f1 = 1L;
            Long f2 = 2L;
            Long f3 = 3L;
            Long f4 = 4L;
            Long f5 = 5L;
            Long f6 = 6L;
            Long f7 = 7L;
            String[] array = oldSymbols.getWeekdays();
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(f1, array[2]);
            map.put(f2, array[3]);
            map.put(f3, array[4]);
            map.put(f4, array[5]);
            map.put(f5, array[6]);
            map.put(f6, array[7]);
            map.put(f7, array[1]);
            styleMap.put(TextStyle.FULL, map);
            map = new HashMap();
            map.put(f1, array[2].substring(0, 1));
            map.put(f2, array[3].substring(0, 1));
            map.put(f3, array[4].substring(0, 1));
            map.put(f4, array[5].substring(0, 1));
            map.put(f5, array[6].substring(0, 1));
            map.put(f6, array[7].substring(0, 1));
            map.put(f7, array[1].substring(0, 1));
            styleMap.put(TextStyle.NARROW, map);
            array = oldSymbols.getShortWeekdays();
            map = new HashMap();
            map.put(f1, array[2]);
            map.put(f2, array[3]);
            map.put(f3, array[4]);
            map.put(f4, array[5]);
            map.put(f5, array[6]);
            map.put(f6, array[7]);
            map.put(f7, array[1]);
            styleMap.put(TextStyle.SHORT, map);
            return SimpleDateTimeTextProvider.createLocaleStore(styleMap);
        }
        if (field == ChronoField.AMPM_OF_DAY) {
            DateFormatSymbols oldSymbols = DateFormatSymbols.getInstance(locale);
            HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
            String[] array = oldSymbols.getAmPmStrings();
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(0L, array[0]);
            map.put(1L, array[1]);
            styleMap.put(TextStyle.FULL, map);
            styleMap.put(TextStyle.SHORT, map);
            return SimpleDateTimeTextProvider.createLocaleStore(styleMap);
        }
        if (field == ChronoField.ERA) {
            DateFormatSymbols oldSymbols = DateFormatSymbols.getInstance(locale);
            HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
            String[] array = oldSymbols.getEras();
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(0L, array[0]);
            map.put(1L, array[1]);
            styleMap.put(TextStyle.SHORT, map);
            if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
                map = new HashMap();
                map.put(0L, "Before Christ");
                map.put(1L, "Anno Domini");
                styleMap.put(TextStyle.FULL, map);
            } else {
                styleMap.put(TextStyle.FULL, map);
            }
            map = new HashMap();
            map.put(0L, array[0].substring(0, 1));
            map.put(1L, array[1].substring(0, 1));
            styleMap.put(TextStyle.NARROW, map);
            return SimpleDateTimeTextProvider.createLocaleStore(styleMap);
        }
        if (field == IsoFields.QUARTER_OF_YEAR) {
            HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(1L, "Q1");
            map.put(2L, "Q2");
            map.put(3L, "Q3");
            map.put(4L, "Q4");
            styleMap.put(TextStyle.SHORT, map);
            map = new HashMap();
            map.put(1L, "1st quarter");
            map.put(2L, "2nd quarter");
            map.put(3L, "3rd quarter");
            map.put(4L, "4th quarter");
            styleMap.put(TextStyle.FULL, map);
            return SimpleDateTimeTextProvider.createLocaleStore(styleMap);
        }
        return "";
    }

    private static <A, B> Map.Entry<A, B> createEntry(A text, B field) {
        return new AbstractMap.SimpleImmutableEntry<A, B>(text, field);
    }

    private static LocaleStore createLocaleStore(Map<TextStyle, Map<Long, String>> valueTextMap) {
        valueTextMap.put(TextStyle.FULL_STANDALONE, valueTextMap.get((Object)TextStyle.FULL));
        valueTextMap.put(TextStyle.SHORT_STANDALONE, valueTextMap.get((Object)TextStyle.SHORT));
        if (valueTextMap.containsKey((Object)TextStyle.NARROW) && !valueTextMap.containsKey((Object)TextStyle.NARROW_STANDALONE)) {
            valueTextMap.put(TextStyle.NARROW_STANDALONE, valueTextMap.get((Object)TextStyle.NARROW));
        }
        return new LocaleStore(valueTextMap);
    }

    static final class LocaleStore {
        private final Map<TextStyle, Map<Long, String>> valueTextMap;
        private final Map<TextStyle, List<Map.Entry<String, Long>>> parsable;

        LocaleStore(Map<TextStyle, Map<Long, String>> valueTextMap) {
            this.valueTextMap = valueTextMap;
            HashMap<TextStyle, List<Map.Entry<String, Long>>> map = new HashMap<TextStyle, List<Map.Entry<String, Long>>>();
            ArrayList allList = new ArrayList();
            for (TextStyle style : valueTextMap.keySet()) {
                HashMap<String, Map.Entry> reverse = new HashMap<String, Map.Entry>();
                for (Map.Entry<Long, String> entry : valueTextMap.get((Object)style).entrySet()) {
                    if (reverse.put(entry.getValue(), SimpleDateTimeTextProvider.createEntry(entry.getValue(), entry.getKey())) == null) continue;
                }
                ArrayList list = new ArrayList(reverse.values());
                Collections.sort(list, COMPARATOR);
                map.put(style, list);
                allList.addAll(list);
                map.put(null, allList);
            }
            Collections.sort(allList, COMPARATOR);
            this.parsable = map;
        }

        String getText(long value, TextStyle style) {
            Map<Long, String> map = this.valueTextMap.get((Object)style);
            return map != null ? map.get(value) : null;
        }

        Iterator<Map.Entry<String, Long>> getTextIterator(TextStyle style) {
            List<Map.Entry<String, Long>> list = this.parsable.get((Object)style);
            return list != null ? list.iterator() : null;
        }
    }
}

