/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Context;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.InstantiationException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.OverrideType;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.OverrideValue;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Support;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Type;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Value;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.InputNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.OutputNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Position;
import java.lang.reflect.Modifier;

abstract class Factory {
    protected Context context;
    protected Support support;
    protected Class override;
    protected Type type;

    protected Factory(Context context, Type type) {
        this(context, type, null);
    }

    protected Factory(Context context, Type type, Class clazz) {
        this.support = context.getSupport();
        this.override = clazz;
        this.context = context;
        this.type = type;
    }

    public Class getType() {
        if (this.override != null) {
            return this.override;
        }
        return this.type.getType();
    }

    public Object getInstance() {
        Class clazz = this.getType();
        if (!Factory.isInstantiable(clazz)) {
            throw new InstantiationException("Type %s can not be instantiated", clazz);
        }
        return clazz.newInstance();
    }

    protected Value getOverride(InputNode inputNode) {
        Value value = this.getConversion(inputNode);
        if (value != null) {
            Position position = inputNode.getPosition();
            Class clazz = value.getType();
            Class clazz2 = this.getType();
            if (!Factory.isCompatible(clazz2, clazz)) {
                throw new InstantiationException("Incompatible %s for %s at %s", clazz, this.type, position);
            }
        }
        return value;
    }

    public boolean setOverride(Type type, Object object, OutputNode outputNode) {
        Class clazz = type.getType();
        if (clazz.isPrimitive()) {
            type = this.getPrimitive(type, clazz);
        }
        return this.context.setOverride(type, object, outputNode);
    }

    private Type getPrimitive(Type type, Class clazz) {
        Class clazz2 = Support.getPrimitive(clazz);
        if (clazz2 != clazz) {
            return new OverrideType(type, clazz2);
        }
        return type;
    }

    public Value getConversion(InputNode inputNode) {
        Class clazz;
        Value value = this.context.getOverride(this.type, inputNode);
        if (value != null && this.override != null && !Factory.isCompatible(this.override, clazz = value.getType())) {
            return new OverrideValue(value, this.override);
        }
        return value;
    }

    public static boolean isCompatible(Class clazz, Class clazz2) {
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz.isAssignableFrom(clazz2);
    }

    public static boolean isInstantiable(Class clazz) {
        int n = clazz.getModifiers();
        if (Modifier.isAbstract(n)) {
            return false;
        }
        return !Modifier.isInterface(n);
    }
}

