/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;

public final class ValidatingTokenFilter
extends TokenFilter {
    private static final int MAX_DEBUG_TOKENS = 20;
    private int pos;
    private int lastStartOffset;
    private final Map<Integer, Integer> posToStartOffset = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> posToEndOffset = new HashMap<Integer, Integer>();
    private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.getAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLenAtt = (PositionLengthAttribute)this.getAttribute(PositionLengthAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.getAttribute(OffsetAttribute.class);
    private final CharTermAttribute termAtt = (CharTermAttribute)this.getAttribute(CharTermAttribute.class);
    private final List<Token> tokens = new LinkedList<Token>();
    private final String name;

    public ValidatingTokenFilter(TokenStream in, String name) {
        super(in);
        this.name = name;
    }

    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        int startOffset = 0;
        int endOffset = 0;
        int posLen = 0;
        int posInc = 0;
        if (this.posIncAtt != null) {
            posInc = this.posIncAtt.getPositionIncrement();
        }
        if (this.offsetAtt != null) {
            startOffset = this.offsetAtt.startOffset();
            endOffset = this.offsetAtt.endOffset();
        }
        posLen = this.posLenAtt == null ? 1 : this.posLenAtt.getPositionLength();
        this.addToken(startOffset, endOffset, posInc);
        if (this.posIncAtt != null) {
            this.pos += posInc;
            if (this.pos == -1) {
                ValidatingTokenFilter.dumpValidatingTokenFilters((TokenStream)this, System.err);
                throw new IllegalStateException(this.name + ": first posInc must be > 0");
            }
        }
        if (this.offsetAtt != null) {
            if (startOffset < this.lastStartOffset) {
                ValidatingTokenFilter.dumpValidatingTokenFilters((TokenStream)this, System.err);
                throw new IllegalStateException(this.name + ": offsets must not go backwards startOffset=" + startOffset + " is < lastStartOffset=" + this.lastStartOffset);
            }
            this.lastStartOffset = this.offsetAtt.startOffset();
        }
        if (this.offsetAtt != null && this.posIncAtt != null) {
            if (!this.posToStartOffset.containsKey(this.pos)) {
                this.posToStartOffset.put(this.pos, startOffset);
            } else {
                int oldStartOffset = this.posToStartOffset.get(this.pos);
                if (oldStartOffset != startOffset) {
                    ValidatingTokenFilter.dumpValidatingTokenFilters((TokenStream)this, System.err);
                    throw new IllegalStateException(this.name + ": inconsistent startOffset at pos=" + this.pos + ": " + oldStartOffset + " vs " + startOffset + "; token=" + this.termAtt);
                }
            }
            int endPos = this.pos + posLen;
            if (!this.posToEndOffset.containsKey(endPos)) {
                this.posToEndOffset.put(endPos, endOffset);
            } else {
                int oldEndOffset = this.posToEndOffset.get(endPos);
                if (oldEndOffset != endOffset) {
                    ValidatingTokenFilter.dumpValidatingTokenFilters((TokenStream)this, System.err);
                    throw new IllegalStateException(this.name + ": inconsistent endOffset at pos=" + endPos + ": " + oldEndOffset + " vs " + endOffset + "; token=" + this.termAtt);
                }
            }
        }
        return true;
    }

    public void end() throws IOException {
        super.end();
    }

    public void reset() throws IOException {
        super.reset();
        this.pos = -1;
        this.posToStartOffset.clear();
        this.posToEndOffset.clear();
        this.lastStartOffset = 0;
        this.tokens.clear();
    }

    private void addToken(int startOffset, int endOffset, int posInc) {
        if (this.tokens.size() == 20) {
            this.tokens.remove(0);
        }
        this.tokens.add(new Token(this.termAtt.toString(), posInc, startOffset, endOffset));
    }

    public static void dumpValidatingTokenFilters(TokenStream in, PrintStream out) {
        if (in instanceof TokenFilter) {
            ValidatingTokenFilter.dumpValidatingTokenFilters(((TokenFilter)in).input, out);
            if (in instanceof ValidatingTokenFilter) {
                out.println(((ValidatingTokenFilter)in).dump());
            }
        }
    }

    public String dump() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name).append(": ");
        for (Token token : this.tokens) {
            buf.append(String.format(Locale.ROOT, "%s<[%d-%d] +%d> ", new Object[]{token, token.startOffset(), token.endOffset(), token.getPositionIncrement()}));
        }
        return buf.toString();
    }
}

