/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.InvalidCredentialsException;
import com.healthmarketscience.jackcess.InvalidCryptoConfigurationException;
import com.healthmarketscience.jackcess.PasswordCallback;
import com.healthmarketscience.jackcess.impl.BaseCryptCodecHandler;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.CodecHandler;
import com.healthmarketscience.jackcess.impl.DefaultCodecProvider;
import com.healthmarketscience.jackcess.impl.JetFormat;
import com.healthmarketscience.jackcess.impl.PageChannel;
import com.healthmarketscience.jackcess.impl.UnsupportedCodecException;
import com.healthmarketscience.jackcess.impl.office.AgileEncryptionProvider;
import com.healthmarketscience.jackcess.impl.office.ECMAStandardEncryptionProvider;
import com.healthmarketscience.jackcess.impl.office.EncryptionHeader;
import com.healthmarketscience.jackcess.impl.office.NonStandardEncryptionProvider;
import com.healthmarketscience.jackcess.impl.office.OfficeBinaryDocRC4Provider;
import com.healthmarketscience.jackcess.impl.office.RC4CryptoAPIProvider;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.bouncycastle.crypto.Digest;

public abstract class OfficeCryptCodecHandler
extends BaseCryptCodecHandler {
    private static final int MAX_PASSWORD_LEN = 255;
    private static final int CRYPT_STRUCTURE_OFFSET = 665;
    private Digest _digest;
    private ByteBuffer _tempIntBuf;
    private Phase _phase = Phase.PWD_VERIFY;

    protected OfficeCryptCodecHandler(PageChannel channel, byte[] encodingKey) {
        super(channel, encodingKey);
    }

    public static CodecHandler create(PasswordCallback callback, PageChannel channel, Charset charset) throws IOException {
        ByteBuffer buffer = OfficeCryptCodecHandler.readHeaderPage(channel);
        JetFormat format = channel.getFormat();
        byte[] encodingKey = ByteUtil.getBytes((ByteBuffer)buffer, (int)format.OFFSET_ENCODING_KEY, (int)4);
        if (OfficeCryptCodecHandler.isBlankKey(encodingKey)) {
            return DefaultCodecProvider.DUMMY_HANDLER;
        }
        short infoLen = buffer.getShort(665);
        ByteBuffer encProvBuf = OfficeCryptCodecHandler.wrap(ByteUtil.getBytes((ByteBuffer)buffer, (int)667, (int)infoLen));
        int vMajor = ByteUtil.getUnsignedShort((ByteBuffer)encProvBuf);
        int vMinor = ByteUtil.getUnsignedShort((ByteBuffer)encProvBuf);
        byte[] pwdBytes = OfficeCryptCodecHandler.getPasswordBytes(callback.getPassword());
        OfficeCryptCodecHandler handler = null;
        if (vMajor == 4 && vMinor == 4) {
            handler = new AgileEncryptionProvider(channel, encodingKey, encProvBuf, pwdBytes);
        } else if (vMajor == 1 && vMinor == 1) {
            handler = new OfficeBinaryDocRC4Provider(channel, encodingKey, encProvBuf, pwdBytes);
        } else {
            int flags;
            if ((vMajor == 3 || vMajor == 4) && vMinor == 3) {
                throw new UnsupportedCodecException("Extensible encryption provider is not supported");
            }
            if ((vMajor == 2 || vMajor == 3 || vMajor == 4) && vMinor == 2 && EncryptionHeader.isFlagSet(flags = encProvBuf.getInt(), 4)) {
                if (EncryptionHeader.isFlagSet(flags, 32)) {
                    handler = new ECMAStandardEncryptionProvider(channel, encodingKey, encProvBuf, pwdBytes);
                } else {
                    int initPos = encProvBuf.position();
                    try {
                        handler = new RC4CryptoAPIProvider(channel, encodingKey, encProvBuf, pwdBytes);
                    }
                    catch (InvalidCryptoConfigurationException icce) {
                        try {
                            encProvBuf.position(initPos);
                            handler = new NonStandardEncryptionProvider(channel, encodingKey, encProvBuf, pwdBytes);
                        }
                        catch (Exception ignored) {
                            throw icce;
                        }
                    }
                }
            }
        }
        if (handler == null) {
            throw new UnsupportedCodecException("Unsupported office encryption provider: vMajor " + vMajor + ", vMinor " + vMinor);
        }
        if (!handler.verifyPassword(pwdBytes)) {
            throw new InvalidCredentialsException("Incorrect password provided");
        }
        handler.reset();
        handler._phase = Phase.CRYPT;
        return handler;
    }

    protected Phase getPhase() {
        return this._phase;
    }

    protected Digest getDigest() {
        if (this._digest == null) {
            this._digest = this.initDigest();
        }
        return this._digest;
    }

    protected Digest initDigest() {
        switch (this.getPhase()) {
            case PWD_VERIFY: {
                return this.initPwdDigest();
            }
            case CRYPT: {
                return this.initCryptDigest();
            }
        }
        throw new RuntimeException("unknown phase " + (Object)((Object)this.getPhase()));
    }

    protected Digest initPwdDigest() {
        throw new UnsupportedOperationException();
    }

    protected Digest initCryptDigest() {
        throw new UnsupportedOperationException();
    }

    protected final byte[] int2bytes(int val) {
        if (this._tempIntBuf == null) {
            this._tempIntBuf = OfficeCryptCodecHandler.wrap(new byte[4]);
        }
        this._tempIntBuf.putInt(0, val);
        return this._tempIntBuf.array();
    }

    protected void reset() {
        this._digest = null;
    }

    public void decodePage(ByteBuffer inPage, ByteBuffer outPage, int pageNumber) throws IOException {
        if (!OfficeCryptCodecHandler.isEncryptedPage(pageNumber)) {
            return;
        }
        this.decodePageImpl(inPage, outPage, pageNumber);
    }

    public ByteBuffer encodePage(ByteBuffer buffer, int pageNumber, int pageOffset) throws IOException {
        if (!OfficeCryptCodecHandler.isEncryptedPage(pageNumber)) {
            return buffer;
        }
        return this.encodePageImpl(buffer, pageNumber, pageOffset);
    }

    protected byte[] iterateHash(byte[] baseHash, int iterations) {
        if (iterations == 0) {
            return baseHash;
        }
        Digest digest = this.getDigest();
        byte[] iterHash = baseHash;
        for (int i = 0; i < iterations; ++i) {
            iterHash = OfficeCryptCodecHandler.hash(digest, this.int2bytes(i), iterHash);
        }
        return iterHash;
    }

    private static boolean isEncryptedPage(int pageNumber) {
        return pageNumber > 0;
    }

    private static byte[] getPasswordBytes(String password) {
        if (password == null) {
            return new byte[0];
        }
        if (password.length() > 255) {
            password = password.substring(0, 255);
        }
        return password.getBytes(EncryptionHeader.UNICODE_CHARSET);
    }

    protected static int bits2bytes(int bits) {
        return bits / 8;
    }

    protected abstract void decodePageImpl(ByteBuffer var1, ByteBuffer var2, int var3) throws IOException;

    protected abstract ByteBuffer encodePageImpl(ByteBuffer var1, int var2, int var3) throws IOException;

    protected abstract boolean verifyPassword(byte[] var1);

    protected static enum Phase {
        PWD_VERIFY,
        CRYPT;

    }
}

