/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.derby.iapi.types.HarmonySerialBlob;

public class HarmonySerialClob
implements Clob,
Serializable,
Cloneable {
    private static final long serialVersionUID = -1662519690087375313L;
    private char[] buf;
    private Clob clob;
    private long len;
    private long origLen;

    public HarmonySerialClob(String string) {
        this(string.toCharArray());
    }

    public HarmonySerialClob(char[] cArray) {
        this.buf = new char[cArray.length];
        this.len = this.origLen = (long)cArray.length;
        System.arraycopy(cArray, 0, this.buf, 0, (int)this.len);
    }

    public HarmonySerialClob(Clob clob) throws SQLException {
        if (clob == null) {
            throw new IllegalArgumentException();
        }
        Reader reader = clob.getCharacterStream();
        if (reader == null && clob.getAsciiStream() == null) {
            throw new IllegalArgumentException();
        }
        this.clob = clob;
        this.len = this.origLen = clob.length();
        this.buf = new char[(int)this.len];
        try {
            reader.read(this.buf);
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException("SerialClob: " + iOException.getMessage());
            sQLException.initCause(iOException);
            throw sQLException;
        }
    }

    public long length() throws SQLException {
        this.checkValidation();
        return this.len;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.checkValidation();
        if (this.clob == null) {
            throw new IllegalStateException();
        }
        return this.clob.getAsciiStream();
    }

    public Reader getCharacterStream() throws SQLException {
        this.checkValidation();
        return new CharArrayReader(this.buf);
    }

    public String getSubString(long l, int n) throws SQLException {
        this.checkValidation();
        if (n < 0) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{new Integer(n)});
        }
        if (l < 1L || l > this.len || l + (long)n > this.len + 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{new Long(l)});
        }
        try {
            return new String(this.buf, (int)(l - 1L), n);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new SQLException();
        }
    }

    public long position(Clob clob, long l) throws SQLException {
        this.checkValidation();
        String string = clob.getSubString(1L, (int)clob.length());
        return this.position(string, l);
    }

    public long position(String string, long l) throws SQLException, SQLException {
        this.checkValidation();
        if (l < 1L || this.len - (l - 1L) < (long)string.length()) {
            return -1L;
        }
        char[] cArray = string.toCharArray();
        int n = (int)l - 1;
        while ((long)n < this.len) {
            if (this.match(this.buf, n, cArray)) {
                return n + 1;
            }
            ++n;
        }
        return -1L;
    }

    private boolean match(char[] cArray, int n, char[] cArray2) {
        int n2 = 0;
        while (n2 < cArray2.length) {
            if (cArray[n++] == cArray2[n2++]) continue;
            return false;
        }
        return true;
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        this.checkValidation();
        if (this.clob == null) {
            throw new IllegalStateException();
        }
        OutputStream outputStream = this.clob.setAsciiStream(l);
        if (outputStream == null) {
            throw new IllegalStateException();
        }
        return outputStream;
    }

    public Writer setCharacterStream(long l) throws SQLException {
        this.checkValidation();
        if (this.clob == null) {
            throw new IllegalStateException();
        }
        Writer writer = this.clob.setCharacterStream(l);
        if (writer == null) {
            throw new IllegalStateException();
        }
        return writer;
    }

    public int setString(long l, String string) throws SQLException {
        this.checkValidation();
        return this.setString(l, string, 0, string.length());
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        this.checkValidation();
        if (l < 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{new Long(l)});
        }
        if (n2 < 0) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", null);
        }
        if (l > this.len - (long)n2 + 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ076.S", null);
        }
        if (n < 0 || n > string.length() - n2) {
            throw HarmonySerialBlob.makeSQLException("XJ078.S", null);
        }
        if ((long)n2 > this.len + (long)n) {
            throw HarmonySerialBlob.makeSQLException("XJ078.S", null);
        }
        string.getChars(n, n + n2, this.buf, (int)l - 1);
        return n2;
    }

    public void truncate(long l) throws SQLException {
        this.checkValidation();
        if (l < 0L) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{new Long(l)});
        }
        if (l > this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ079.S", new Object[]{new Long(l)});
        }
        char[] cArray = new char[(int)l];
        System.arraycopy(this.buf, 0, cArray, 0, (int)l);
        this.buf = cArray;
        this.len = l;
    }

    public void free() throws SQLException {
        if (this.len != -1L) {
            this.len = -1L;
            this.clob = null;
            this.buf = null;
        }
    }

    public Reader getCharacterStream(long l, long l2) throws SQLException {
        this.checkValidation();
        return new CharArrayReader(this.buf, (int)l, (int)l2);
    }

    private void checkValidation() throws SQLException {
        if (this.len == -1L) {
            throw HarmonySerialBlob.makeSQLException("XJ215.S", null);
        }
    }
}

