/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.turboproject;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.common.StreamHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.turboproject.MapRow;
import net.sf.mpxj.turboproject.PEPUtility;
import net.sf.mpxj.turboproject.Table;
import net.sf.mpxj.turboproject.TableA0TAB;
import net.sf.mpxj.turboproject.TableA1TAB;
import net.sf.mpxj.turboproject.TableA2TAB;
import net.sf.mpxj.turboproject.TableA3TAB;
import net.sf.mpxj.turboproject.TableA5TAB;
import net.sf.mpxj.turboproject.TableCALXTAB;
import net.sf.mpxj.turboproject.TableCONTAB;
import net.sf.mpxj.turboproject.TableNCALTAB;
import net.sf.mpxj.turboproject.TableRTAB;
import net.sf.mpxj.turboproject.TableUSGTAB;
import net.sf.mpxj.turboproject.TableWBSTAB;

public final class TurboProjectReader
extends AbstractProjectReader {
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private List<ProjectListener> m_projectListeners;
    private HashMap<String, Table> m_tables;
    private static final Table EMPTY_TABLE = new Table();
    private static final Map<String, Class<? extends Table>> TABLE_CLASSES = new HashMap<String, Class<? extends Table>>();
    private static final Map<FieldType, String> ALIASES;
    private static final Map<String, FieldType> RESOURCE_FIELDS;
    private static final Map<String, FieldType> A0TAB_FIELDS;
    private static final Map<String, FieldType> A1TAB_FIELDS;
    private static final Map<String, FieldType> A2TAB_FIELDS;
    private static final Map<String, FieldType> A3TAB_FIELDS;
    private static final Map<String, FieldType> A5TAB_FIELDS;

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            this.m_tables = new HashMap();
            ProjectConfig projectConfig = this.m_projectFile.getProjectConfig();
            projectConfig.setAutoResourceID(false);
            projectConfig.setAutoCalendarUniqueID(false);
            projectConfig.setAutoResourceUniqueID(false);
            projectConfig.setAutoTaskID(false);
            projectConfig.setAutoTaskUniqueID(false);
            projectConfig.setAutoOutlineLevel(true);
            projectConfig.setAutoOutlineNumber(true);
            projectConfig.setAutoWBS(true);
            this.m_projectFile.getProjectProperties().setFileApplication("TurboProject");
            this.m_projectFile.getProjectProperties().setFileType("PEP");
            this.m_eventManager.addProjectListeners(this.m_projectListeners);
            this.applyAliases();
            this.readFile(inputStream);
            this.readCalendars();
            this.readResources();
            this.readTasks();
            this.readRelationships();
            this.readResourceAssignments();
            projectConfig.updateUniqueCounters();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (IOException iOException) {
            throw new MPXJException("Failed to parse file", iOException);
        }
        finally {
            this.m_projectFile = null;
            this.m_eventManager = null;
            this.m_projectListeners = null;
            this.m_tables = null;
        }
    }

    private void readFile(InputStream inputStream) throws IOException {
        StreamHelper.skip(inputStream, 64L);
        int n = 64;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (true) {
            byte[] byArray = new byte[32];
            inputStream.read(byArray);
            n += 32;
            int n2 = PEPUtility.getInt(byArray, 0);
            arrayList.add(n2);
            if (n2 == 0) break;
            arrayList2.add(PEPUtility.getString(byArray, 5).toUpperCase());
        }
        StreamHelper.skip(inputStream, (Integer)arrayList.get(0) - n);
        for (int i = 1; i < arrayList.size() - 1; ++i) {
            Table table;
            String string = (String)arrayList2.get(i - 1);
            Class<? extends Table> clazz = TABLE_CLASSES.get(string);
            if (clazz == null) {
                clazz = Table.class;
            }
            try {
                table = clazz.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            this.m_tables.put(string, table);
            table.read(inputStream);
        }
    }

    private void readCalendars() {
        for (Object object : this.getTable("NCALTAB")) {
            Object object2 = this.m_projectFile.addCalendar();
            ((ProjectCalendar)object2).setUniqueID(((MapRow)object).getInteger("UNIQUE_ID"));
            ((ProjectCalendarWeek)object2).setName(((MapRow)object).getString("NAME"));
            ((ProjectCalendarWeek)object2).setWorkingDay(Day.SUNDAY, ((MapRow)object).getBoolean("SUNDAY"));
            ((ProjectCalendarWeek)object2).setWorkingDay(Day.MONDAY, ((MapRow)object).getBoolean("MONDAY"));
            ((ProjectCalendarWeek)object2).setWorkingDay(Day.TUESDAY, ((MapRow)object).getBoolean("TUESDAY"));
            ((ProjectCalendarWeek)object2).setWorkingDay(Day.WEDNESDAY, ((MapRow)object).getBoolean("WEDNESDAY"));
            ((ProjectCalendarWeek)object2).setWorkingDay(Day.THURSDAY, ((MapRow)object).getBoolean("THURSDAY"));
            ((ProjectCalendarWeek)object2).setWorkingDay(Day.FRIDAY, ((MapRow)object).getBoolean("FRIDAY"));
            ((ProjectCalendarWeek)object2).setWorkingDay(Day.SATURDAY, ((MapRow)object).getBoolean("SATURDAY"));
            for (Day day : Day.values()) {
                if (!((ProjectCalendar)object2).isWorkingDay(day)) continue;
                ((ProjectCalendarWeek)object2).addDefaultCalendarHours(day);
            }
        }
        Table table = this.getTable("CALXTAB");
        for (Object object2 : this.getTable("NCALTAB")) {
            Day[] dayArray = this.m_projectFile.getCalendarByUniqueID(((MapRow)object2).getInteger("UNIQUE_ID"));
            ProjectCalendar projectCalendar = this.m_projectFile.getCalendarByUniqueID(((MapRow)object2).getInteger("BASE_CALENDAR_ID"));
            if (dayArray != null && projectCalendar != null) {
                dayArray.setParent(projectCalendar);
            }
            this.addCalendarExceptions(table, (ProjectCalendar)dayArray, ((MapRow)object2).getInteger("FIRST_CALENDAR_EXCEPTION_ID"));
            this.m_eventManager.fireCalendarReadEvent((ProjectCalendar)dayArray);
        }
    }

    private void addCalendarExceptions(Table table, ProjectCalendar projectCalendar, Integer n) {
        MapRow mapRow;
        Integer n2 = n;
        while ((mapRow = table.find(n2)) != null) {
            Date date = mapRow.getDate("DATE");
            ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date, date);
            if (mapRow.getBoolean("WORKING")) {
                projectCalendarException.addRange(ProjectCalendarWeek.DEFAULT_WORKING_MORNING);
                projectCalendarException.addRange(ProjectCalendarWeek.DEFAULT_WORKING_AFTERNOON);
            }
            n2 = mapRow.getInteger("NEXT_CALENDAR_EXCEPTION_ID");
        }
    }

    private void readResources() {
        for (MapRow mapRow : this.getTable("RTAB")) {
            Resource resource = this.m_projectFile.addResource();
            this.setFields(RESOURCE_FIELDS, mapRow, resource);
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void readTasks() {
        Integer n = 1;
        this.readWBS(this.m_projectFile, n);
        this.readTasks(n);
        this.m_projectFile.getTasks().synchronizeTaskIDToHierarchy();
    }

    private void readWBS(ChildTaskContainer childTaskContainer, Integer n) {
        Integer n2 = n;
        Table table = this.getTable("WBSTAB");
        while (n2 != 0) {
            MapRow mapRow = table.find(n2);
            Integer n3 = mapRow.getInteger("TASK_ID");
            Task task = this.readTask(childTaskContainer, n3);
            Integer n4 = mapRow.getInteger("CHILD_ID");
            if (n4 != 0) {
                this.readWBS(task, n4);
            }
            n2 = mapRow.getInteger("NEXT_ID");
        }
    }

    private void readTasks(Integer n) {
        Integer n2 = n;
        Table table = this.getTable("WBSTAB");
        while (n2 != 0) {
            MapRow mapRow = table.find(n2);
            Task task = this.m_projectFile.getTaskByUniqueID(mapRow.getInteger("TASK_ID"));
            this.readLeafTasks(task, mapRow.getInteger("FIRST_CHILD_TASK_ID"));
            Integer n3 = mapRow.getInteger("CHILD_ID");
            if (n3 != 0) {
                this.readTasks(n3);
            }
            n2 = mapRow.getInteger("NEXT_ID");
        }
    }

    private void readLeafTasks(Task task, Integer n) {
        Integer n2 = n;
        Table table = this.getTable("A1TAB");
        while (n2 != 0) {
            if (this.m_projectFile.getTaskByUniqueID(n2) == null) {
                this.readTask(task, n2);
            }
            n2 = table.find(n2).getInteger("NEXT_TASK_ID");
        }
    }

    private Task readTask(ChildTaskContainer childTaskContainer, Integer n) {
        Table table = this.getTable("A0TAB");
        Table table2 = this.getTable("A1TAB");
        Table table3 = this.getTable("A2TAB");
        Table table4 = this.getTable("A3TAB");
        Table table5 = this.getTable("A4TAB");
        Task task = childTaskContainer.addTask();
        MapRow mapRow = table2.find(n);
        MapRow mapRow2 = table3.find(n);
        this.setFields(A0TAB_FIELDS, table.find(n), task);
        this.setFields(A1TAB_FIELDS, mapRow, task);
        this.setFields(A2TAB_FIELDS, mapRow2, task);
        this.setFields(A3TAB_FIELDS, table4.find(n), task);
        this.setFields(A5TAB_FIELDS, table5.find(n), task);
        task.setStart(task.getEarlyStart());
        task.setFinish(task.getEarlyFinish());
        if (task.getName() == null) {
            task.setName(task.getText(1));
        }
        this.m_eventManager.fireTaskReadEvent(task);
        return task;
    }

    private void readRelationships() {
        for (MapRow mapRow : this.getTable("CONTAB")) {
            Task task = this.m_projectFile.getTaskByUniqueID(mapRow.getInteger("TASK_ID_1"));
            Task task2 = this.m_projectFile.getTaskByUniqueID(mapRow.getInteger("TASK_ID_2"));
            if (task == null || task2 == null) continue;
            RelationType relationType = mapRow.getRelationType("TYPE");
            Duration duration = mapRow.getDuration("LAG");
            Relation relation = task2.addPredecessor(task, relationType, duration);
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private void readResourceAssignments() {
        for (MapRow mapRow : this.getTable("USGTAB")) {
            Task task = this.m_projectFile.getTaskByUniqueID(mapRow.getInteger("TASK_ID"));
            Resource resource = this.m_projectFile.getResourceByUniqueID(mapRow.getInteger("RESOURCE_ID"));
            if (task == null || resource == null) continue;
            ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
            this.m_eventManager.fireAssignmentReadEvent(resourceAssignment);
        }
    }

    private Table getTable(String string) {
        Table table = this.m_tables.get(string);
        if (table == null) {
            table = EMPTY_TABLE;
        }
        return table;
    }

    private void applyAliases() {
        CustomFieldContainer customFieldContainer = this.m_projectFile.getCustomFields();
        for (Map.Entry<FieldType, String> entry : ALIASES.entrySet()) {
            customFieldContainer.getCustomField(entry.getKey()).setAlias(entry.getValue());
        }
    }

    private void setFields(Map<String, FieldType> map, MapRow mapRow, FieldContainer fieldContainer) {
        if (mapRow != null) {
            for (Map.Entry<String, FieldType> entry : map.entrySet()) {
                fieldContainer.set(entry.getValue(), mapRow.getObject(entry.getKey()));
            }
        }
    }

    private static void defineField(Map<String, FieldType> map, String string, FieldType fieldType) {
        TurboProjectReader.defineField(map, string, fieldType, null);
    }

    private static void defineField(Map<String, FieldType> map, String string, FieldType fieldType, String string2) {
        map.put(string, fieldType);
        if (string2 != null) {
            ALIASES.put(fieldType, string2);
        }
    }

    static {
        TABLE_CLASSES.put("RTAB", TableRTAB.class);
        TABLE_CLASSES.put("A0TAB", TableA0TAB.class);
        TABLE_CLASSES.put("A1TAB", TableA1TAB.class);
        TABLE_CLASSES.put("A2TAB", TableA2TAB.class);
        TABLE_CLASSES.put("A3TAB", TableA3TAB.class);
        TABLE_CLASSES.put("A5TAB", TableA5TAB.class);
        TABLE_CLASSES.put("CONTAB", TableCONTAB.class);
        TABLE_CLASSES.put("USGTAB", TableUSGTAB.class);
        TABLE_CLASSES.put("NCALTAB", TableNCALTAB.class);
        TABLE_CLASSES.put("CALXTAB", TableCALXTAB.class);
        TABLE_CLASSES.put("WBSTAB", TableWBSTAB.class);
        ALIASES = new HashMap<FieldType, String>();
        RESOURCE_FIELDS = new HashMap<String, FieldType>();
        A0TAB_FIELDS = new HashMap<String, FieldType>();
        A1TAB_FIELDS = new HashMap<String, FieldType>();
        A2TAB_FIELDS = new HashMap<String, FieldType>();
        A3TAB_FIELDS = new HashMap<String, FieldType>();
        A5TAB_FIELDS = new HashMap<String, FieldType>();
        TurboProjectReader.defineField(RESOURCE_FIELDS, "ID", ResourceField.ID);
        TurboProjectReader.defineField(RESOURCE_FIELDS, "UNIQUE_ID", ResourceField.UNIQUE_ID);
        TurboProjectReader.defineField(RESOURCE_FIELDS, "NAME", ResourceField.NAME);
        TurboProjectReader.defineField(RESOURCE_FIELDS, "GROUP", ResourceField.GROUP);
        TurboProjectReader.defineField(RESOURCE_FIELDS, "DESCRIPTION", ResourceField.NOTES);
        TurboProjectReader.defineField(RESOURCE_FIELDS, "PARENT_ID", ResourceField.PARENT_ID);
        TurboProjectReader.defineField(RESOURCE_FIELDS, "RATE", ResourceField.NUMBER1, "Rate");
        TurboProjectReader.defineField(RESOURCE_FIELDS, "POOL", ResourceField.NUMBER2, "Pool");
        TurboProjectReader.defineField(RESOURCE_FIELDS, "PER_DAY", ResourceField.NUMBER3, "Per Day");
        TurboProjectReader.defineField(RESOURCE_FIELDS, "PRIORITY", ResourceField.NUMBER4, "Priority");
        TurboProjectReader.defineField(RESOURCE_FIELDS, "PERIOD_DUR", ResourceField.NUMBER5, "Period Dur");
        TurboProjectReader.defineField(RESOURCE_FIELDS, "EXPENSES_ONLY", ResourceField.FLAG1, "Expenses Only");
        TurboProjectReader.defineField(RESOURCE_FIELDS, "MODIFY_ON_INTEGRATE", ResourceField.FLAG2, "Modify On Integrate");
        TurboProjectReader.defineField(RESOURCE_FIELDS, "UNIT", ResourceField.TEXT1, "Unit");
        TurboProjectReader.defineField(A0TAB_FIELDS, "UNIQUE_ID", TaskField.UNIQUE_ID);
        TurboProjectReader.defineField(A1TAB_FIELDS, "ORDER", TaskField.ID);
        TurboProjectReader.defineField(A1TAB_FIELDS, "PLANNED_START", TaskField.BASELINE_START);
        TurboProjectReader.defineField(A1TAB_FIELDS, "PLANNED_FINISH", TaskField.BASELINE_FINISH);
        TurboProjectReader.defineField(A2TAB_FIELDS, "DESCRIPTION", TaskField.TEXT1, "Description");
        TurboProjectReader.defineField(A3TAB_FIELDS, "EARLY_START", TaskField.EARLY_START);
        TurboProjectReader.defineField(A3TAB_FIELDS, "LATE_START", TaskField.LATE_START);
        TurboProjectReader.defineField(A3TAB_FIELDS, "EARLY_FINISH", TaskField.EARLY_FINISH);
        TurboProjectReader.defineField(A3TAB_FIELDS, "LATE_FINISH", TaskField.LATE_FINISH);
        TurboProjectReader.defineField(A5TAB_FIELDS, "ORIGINAL_DURATION", TaskField.DURATION);
        TurboProjectReader.defineField(A5TAB_FIELDS, "REMAINING_DURATION", TaskField.REMAINING_DURATION);
        TurboProjectReader.defineField(A5TAB_FIELDS, "PERCENT_COMPLETE", TaskField.PERCENT_COMPLETE);
        TurboProjectReader.defineField(A5TAB_FIELDS, "TARGET_START", TaskField.DATE1, "Target Start");
        TurboProjectReader.defineField(A5TAB_FIELDS, "TARGET_FINISH", TaskField.DATE2, "Target Finish");
        TurboProjectReader.defineField(A5TAB_FIELDS, "ACTUAL_START", TaskField.ACTUAL_START);
        TurboProjectReader.defineField(A5TAB_FIELDS, "ACTUAL_FINISH", TaskField.ACTUAL_FINISH);
    }
}

