/*
 * Decompiled with CFR 0.152.
 */
package groovy.sql;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingPropertyException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;

public class GroovyResultSet
extends GroovyObjectSupport
implements ResultSet {
    private ResultSet _resultSet;
    private boolean updated;

    public GroovyResultSet(ResultSet resultSet) {
        this._resultSet = resultSet;
    }

    protected GroovyResultSet() {
    }

    protected ResultSet getResultSet() throws SQLException {
        return this._resultSet;
    }

    public Object getProperty(String property) {
        try {
            return this.getResultSet().getObject(property);
        }
        catch (SQLException e) {
            throw new MissingPropertyException(property, GroovyResultSet.class, e);
        }
    }

    public void setProperty(String property, Object newValue) {
        try {
            this.getResultSet().updateObject(property, newValue);
            this.updated = true;
        }
        catch (SQLException e) {
            throw new MissingPropertyException(property, GroovyResultSet.class, e);
        }
    }

    public Object getAt(int index) throws SQLException {
        index = this.normalizeIndex(index);
        return this.getResultSet().getObject(index);
    }

    public void putAt(int index, Object newValue) throws SQLException {
        index = this.normalizeIndex(index);
        this.getResultSet().updateObject(index, newValue);
    }

    public void add(Map values) throws SQLException {
        this.getResultSet().moveToInsertRow();
        Iterator iter = values.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.getResultSet().updateObject(entry.getKey().toString(), entry.getValue());
        }
        this.getResultSet().insertRow();
    }

    protected int normalizeIndex(int index) throws SQLException {
        if (index < 0) {
            int columnCount = this.getResultSet().getMetaData().getColumnCount();
            while ((index += columnCount) < 0) {
            }
        }
        return index + 1;
    }

    public void eachRow(Closure closure) throws SQLException {
        while (this.next()) {
            closure.call(this);
        }
    }

    public boolean next() throws SQLException {
        if (this.updated) {
            this.getResultSet().updateRow();
            this.updated = false;
        }
        return this.getResultSet().next();
    }

    public void close() throws SQLException {
        this.getResultSet().close();
    }

    public boolean wasNull() throws SQLException {
        return this.getResultSet().wasNull();
    }

    public String getString(int columnIndex) throws SQLException {
        return this.getResultSet().getString(columnIndex);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getResultSet().getBoolean(columnIndex);
    }

    public byte getByte(int columnIndex) throws SQLException {
        return this.getResultSet().getByte(columnIndex);
    }

    public short getShort(int columnIndex) throws SQLException {
        return this.getResultSet().getShort(columnIndex);
    }

    public int getInt(int columnIndex) throws SQLException {
        return this.getResultSet().getInt(columnIndex);
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.getResultSet().getLong(columnIndex);
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this.getResultSet().getFloat(columnIndex);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.getResultSet().getDouble(columnIndex);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getResultSet().getBigDecimal(columnIndex, scale);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getResultSet().getBytes(columnIndex);
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.getResultSet().getDate(columnIndex);
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this.getResultSet().getTime(columnIndex);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getResultSet().getTimestamp(columnIndex);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getResultSet().getAsciiStream(columnIndex);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getResultSet().getUnicodeStream(columnIndex);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getResultSet().getBinaryStream(columnIndex);
    }

    public String getString(String columnName) throws SQLException {
        return this.getResultSet().getString(columnName);
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getResultSet().getBoolean(columnName);
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getResultSet().getByte(columnName);
    }

    public short getShort(String columnName) throws SQLException {
        return this.getResultSet().getShort(columnName);
    }

    public int getInt(String columnName) throws SQLException {
        return this.getResultSet().getInt(columnName);
    }

    public long getLong(String columnName) throws SQLException {
        return this.getResultSet().getLong(columnName);
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getResultSet().getFloat(columnName);
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getResultSet().getDouble(columnName);
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getResultSet().getBigDecimal(columnName, scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getResultSet().getBytes(columnName);
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getResultSet().getDate(columnName);
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getResultSet().getTime(columnName);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getResultSet().getTimestamp(columnName);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getResultSet().getAsciiStream(columnName);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getResultSet().getUnicodeStream(columnName);
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getResultSet().getBinaryStream(columnName);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.getResultSet().getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.getResultSet().clearWarnings();
    }

    public String getCursorName() throws SQLException {
        return this.getResultSet().getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getResultSet().getMetaData();
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.getResultSet().getObject(columnIndex);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getResultSet().getObject(columnName);
    }

    public int findColumn(String columnName) throws SQLException {
        return this.getResultSet().findColumn(columnName);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.getResultSet().getCharacterStream(columnIndex);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getResultSet().getCharacterStream(columnName);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getResultSet().getBigDecimal(columnIndex);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getResultSet().getBigDecimal(columnName);
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.getResultSet().isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        return this.getResultSet().isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        return this.getResultSet().isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.getResultSet().isLast();
    }

    public void beforeFirst() throws SQLException {
        this.getResultSet().beforeFirst();
    }

    public void afterLast() throws SQLException {
        this.getResultSet().afterLast();
    }

    public boolean first() throws SQLException {
        return this.getResultSet().first();
    }

    public boolean last() throws SQLException {
        return this.getResultSet().last();
    }

    public int getRow() throws SQLException {
        return this.getResultSet().getRow();
    }

    public boolean absolute(int row) throws SQLException {
        return this.getResultSet().absolute(row);
    }

    public boolean relative(int rows) throws SQLException {
        return this.getResultSet().relative(rows);
    }

    public boolean previous() throws SQLException {
        if (this.updated) {
            this.getResultSet().updateRow();
            this.updated = false;
        }
        return this.getResultSet().previous();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.getResultSet().setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this.getResultSet().getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.getResultSet().setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.getResultSet().getFetchSize();
    }

    public int getType() throws SQLException {
        return this.getResultSet().getType();
    }

    public int getConcurrency() throws SQLException {
        return this.getResultSet().getConcurrency();
    }

    public boolean rowUpdated() throws SQLException {
        return this.getResultSet().rowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        return this.getResultSet().rowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        return this.getResultSet().rowDeleted();
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.getResultSet().updateNull(columnIndex);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.getResultSet().updateBoolean(columnIndex, x);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.getResultSet().updateByte(columnIndex, x);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.getResultSet().updateShort(columnIndex, x);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.getResultSet().updateInt(columnIndex, x);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.getResultSet().updateLong(columnIndex, x);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.getResultSet().updateFloat(columnIndex, x);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.getResultSet().updateDouble(columnIndex, x);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.getResultSet().updateBigDecimal(columnIndex, x);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.getResultSet().updateString(columnIndex, x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.getResultSet().updateBytes(columnIndex, x);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.getResultSet().updateDate(columnIndex, x);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.getResultSet().updateTime(columnIndex, x);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.getResultSet().updateTimestamp(columnIndex, x);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.getResultSet().updateAsciiStream(columnIndex, x, length);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.getResultSet().updateBinaryStream(columnIndex, x, length);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.getResultSet().updateCharacterStream(columnIndex, x, length);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.getResultSet().updateObject(columnIndex, x, scale);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.getResultSet().updateObject(columnIndex, x);
    }

    public void updateNull(String columnName) throws SQLException {
        this.getResultSet().updateNull(columnName);
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.getResultSet().updateBoolean(columnName, x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.getResultSet().updateByte(columnName, x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.getResultSet().updateShort(columnName, x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.getResultSet().updateInt(columnName, x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.getResultSet().updateLong(columnName, x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.getResultSet().updateFloat(columnName, x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.getResultSet().updateDouble(columnName, x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.getResultSet().updateBigDecimal(columnName, x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.getResultSet().updateString(columnName, x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.getResultSet().updateBytes(columnName, x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.getResultSet().updateDate(columnName, x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.getResultSet().updateTime(columnName, x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.getResultSet().updateTimestamp(columnName, x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.getResultSet().updateAsciiStream(columnName, x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.getResultSet().updateBinaryStream(columnName, x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.getResultSet().updateCharacterStream(columnName, reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.getResultSet().updateObject(columnName, x, scale);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.getResultSet().updateObject(columnName, x);
    }

    public void insertRow() throws SQLException {
        this.getResultSet().insertRow();
    }

    public void updateRow() throws SQLException {
        this.getResultSet().updateRow();
    }

    public void deleteRow() throws SQLException {
        this.getResultSet().deleteRow();
    }

    public void refreshRow() throws SQLException {
        this.getResultSet().refreshRow();
    }

    public void cancelRowUpdates() throws SQLException {
        this.getResultSet().cancelRowUpdates();
    }

    public void moveToInsertRow() throws SQLException {
        this.getResultSet().moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.getResultSet().moveToCurrentRow();
    }

    public Statement getStatement() throws SQLException {
        return this.getResultSet().getStatement();
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this.getResultSet().getObject(i, map);
    }

    public Ref getRef(int i) throws SQLException {
        return this.getResultSet().getRef(i);
    }

    public Blob getBlob(int i) throws SQLException {
        return this.getResultSet().getBlob(i);
    }

    public Clob getClob(int i) throws SQLException {
        return this.getResultSet().getClob(i);
    }

    public Array getArray(int i) throws SQLException {
        return this.getResultSet().getArray(i);
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getResultSet().getObject(colName, map);
    }

    public Ref getRef(String colName) throws SQLException {
        return this.getResultSet().getRef(colName);
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getResultSet().getBlob(colName);
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getResultSet().getClob(colName);
    }

    public Array getArray(String colName) throws SQLException {
        return this.getResultSet().getArray(colName);
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getResultSet().getDate(columnIndex, cal);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getResultSet().getDate(columnName, cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getResultSet().getTime(columnIndex, cal);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getResultSet().getTime(columnName, cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getResultSet().getTimestamp(columnIndex, cal);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getResultSet().getTimestamp(columnName, cal);
    }

    public URL getURL(int columnIndex) throws SQLException {
        return this.getResultSet().getURL(columnIndex);
    }

    public URL getURL(String columnName) throws SQLException {
        return this.getResultSet().getURL(columnName);
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.getResultSet().updateRef(columnIndex, x);
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        this.getResultSet().updateRef(columnName, x);
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.getResultSet().updateBlob(columnIndex, x);
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.getResultSet().updateBlob(columnName, x);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.getResultSet().updateClob(columnIndex, x);
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        this.getResultSet().updateClob(columnName, x);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.getResultSet().updateArray(columnIndex, x);
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        this.getResultSet().updateArray(columnName, x);
    }
}

