/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.DefaultResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;

public class PreResolvedResolvableArtifact
implements ResolvableArtifact,
ResolvedArtifact {
    private final ModuleVersionIdentifier owner;
    private final IvyArtifactName artifact;
    private final ComponentArtifactIdentifier artifactId;
    private final File file;
    private final TaskDependencyContainer builtBy;

    public PreResolvedResolvableArtifact(@Nullable ModuleVersionIdentifier owner, IvyArtifactName artifact, ComponentArtifactIdentifier artifactId, File file, TaskDependencyContainer builtBy) {
        this.owner = owner;
        this.artifact = artifact;
        this.artifactId = artifactId;
        this.file = file;
        this.builtBy = builtBy;
    }

    public String toString() {
        return this.artifactId.getDisplayName();
    }

    @Override
    public ComponentArtifactIdentifier getId() {
        return this.artifactId;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public ResolvedArtifact toPublicView() {
        return this;
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        this.builtBy.visitDependencies(context);
    }

    @Override
    public boolean isResolveSynchronously() {
        return true;
    }

    public ResolvedModuleVersion getModuleVersion() {
        if (this.owner == null) {
            throw new UnsupportedOperationException();
        }
        return new DefaultResolvedModuleVersion(this.owner);
    }

    @Override
    public ResolvableArtifact transformedTo(File file) {
        DefaultIvyArtifactName artifactName = DefaultIvyArtifactName.forFile(file, this.getClassifier());
        ComponentFileArtifactIdentifier newId = new ComponentFileArtifactIdentifier(this.artifactId.getComponentIdentifier(), artifactName);
        return new PreResolvedResolvableArtifact(this.owner, artifactName, newId, file, this.builtBy);
    }

    public String getName() {
        return this.artifact.getName();
    }

    public String getType() {
        return this.artifact.getType();
    }

    public String getExtension() {
        return this.artifact.getType();
    }

    @Nullable
    public String getClassifier() {
        return this.artifact.getClassifier();
    }
}

