/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.one.util.streamex;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.jetbrains.kotlin.one.util.streamex.AbstractStreamEx;
import org.jetbrains.kotlin.one.util.streamex.StreamContext;

public class StreamEx<T>
extends AbstractStreamEx<T, StreamEx<T>> {
    StreamEx(Stream<? extends T> stream, StreamContext context2) {
        super(stream, context2);
    }

    StreamEx(Spliterator<? extends T> spliterator, StreamContext context2) {
        super(spliterator, context2);
    }

    @Override
    StreamEx<T> supply(Stream<T> stream) {
        return new StreamEx<T>(stream, this.context);
    }

    public <TT> StreamEx<TT> select(Class<TT> clazz) {
        return (StreamEx)this.filter(clazz::isInstance);
    }

    public <A> A[] toArray(A[] emptyArray) {
        if (emptyArray.length != 0) {
            throw new IllegalArgumentException("Empty array must be supplied");
        }
        return ((Stream)this.stream()).toArray(size -> size == 0 ? emptyArray : (Object[])Array.newInstance(emptyArray.getClass().getComponentType(), size));
    }

    @SafeVarargs
    public static <T> StreamEx<T> of(T ... elements) {
        return StreamEx.of(Arrays.spliterator(elements));
    }

    public static <T> StreamEx<T> of(Collection<? extends T> collection) {
        return StreamEx.of(collection.spliterator());
    }

    public static <T> StreamEx<T> of(Spliterator<? extends T> spliterator) {
        return new StreamEx<T>(spliterator, StreamContext.SEQUENTIAL);
    }
}

