/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStatementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiImportStatementStubImpl
extends StubBase<PsiImportStatementBase>
implements PsiImportStatementStub {
    private final byte myFlags;
    private final String myText;
    private SoftReference<PsiJavaCodeReferenceElement> myReference;

    public PsiImportStatementStubImpl(StubElement parent2, String text2, byte flags) {
        super(parent2, PsiImportStatementStubImpl.isStatic(flags) ? JavaStubElementTypes.IMPORT_STATIC_STATEMENT : JavaStubElementTypes.IMPORT_STATEMENT);
        this.myText = text2;
        this.myFlags = flags;
    }

    @Override
    public boolean isStatic() {
        return PsiImportStatementStubImpl.isStatic(this.myFlags);
    }

    private static boolean isStatic(byte flags) {
        return BitUtil.isSet((int)flags, 2);
    }

    @Override
    public boolean isOnDemand() {
        return BitUtil.isSet((int)this.myFlags, 1);
    }

    public byte getFlags() {
        return this.myFlags;
    }

    @Override
    public String getImportReferenceText() {
        return this.myText;
    }

    @Override
    @Nullable
    public PsiJavaCodeReferenceElement getReference() {
        PsiJavaCodeReferenceElement ref = SoftReference.dereference(this.myReference);
        if (ref == null) {
            ref = this.isStatic() ? this.getStaticReference() : this.getRegularReference();
            this.myReference = new SoftReference<PsiJavaCodeReferenceElement>(ref);
        }
        return ref;
    }

    public static byte packFlags(boolean isOnDemand, boolean isStatic) {
        byte flags = 0;
        if (isOnDemand) {
            flags = (byte)(flags | 1);
        }
        if (isStatic) {
            flags = (byte)(flags | 2);
        }
        return flags;
    }

    @Nullable
    private PsiJavaCodeReferenceElement getStaticReference() {
        PsiJavaCodeReferenceElement refElement = this.createReference();
        if (refElement == null) {
            return null;
        }
        if (this.isOnDemand() && refElement instanceof PsiJavaCodeReferenceElementImpl) {
            ((PsiJavaCodeReferenceElementImpl)refElement).setKindWhenDummy(PsiJavaCodeReferenceElementImpl.Kind.CLASS_FQ_NAME_KIND);
        }
        return refElement;
    }

    @Nullable
    private PsiJavaCodeReferenceElement getRegularReference() {
        PsiJavaCodeReferenceElement refElement = this.createReference();
        if (refElement == null) {
            return null;
        }
        ((PsiJavaCodeReferenceElementImpl)refElement).setKindWhenDummy(this.isOnDemand() ? PsiJavaCodeReferenceElementImpl.Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND : PsiJavaCodeReferenceElementImpl.Kind.CLASS_FQ_NAME_KIND);
        return refElement;
    }

    @Nullable
    private PsiJavaCodeReferenceElement createReference() {
        String refText = this.getImportReferenceText();
        if (refText == null) {
            return null;
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
        try {
            return parserFacade.createReferenceFromText(refText, (PsiElement)this.getPsi());
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiImportStatementStub[");
        if (this.isStatic()) {
            builder.append("static ");
        }
        builder.append(this.getImportReferenceText());
        if (this.isOnDemand()) {
            builder.append(".*");
        }
        builder.append("]");
        return builder.toString();
    }
}

