#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for junos_bgp_address_family
"""

from __future__ import absolute_import, division, print_function

__metaclass__ = type

ANSIBLE_METADATA = {
    "metadata_version": "1.1",
    "status": ["preview"],
    "supported_by": "network",
}

DOCUMENTATION = """
---
module: junos_bgp_address_family
version_added: 1.3.0
short_description: Manage BGP Address Family attributes of interfaces on Junos devices.
description: Manage BGP Address Family attributes of interfaces on Junos network devices.
author: Rohit Thakur (@rohitthakur2590)
requirements:
  - ncclient (>=v0.6.4)
  - xmltodict (>=0.12.0)
notes:
  - This module requires the netconf system service be enabled on the device being managed.
  - This module works with connection C(netconf). See L(the Junos OS Platform Options,../network/user_guide/platform_junos.html).
  - Tested against JunOS v18.4R1
options:
  running_config:
    description:
      - This option is used only with state I(parsed).
      - The value of this option should be the output received from the Junos device
        by executing the command B(show protocols bgp).
      - The state I(parsed) reads the configuration from C(running_config) option and
        transforms it into Ansible structured data as per the resource module's argspec
        and the value is then returned in the I(parsed) key within the result
    type: str
  config:
    description: The provided link BGP address family dictionary.
    type: dict
    suboptions:
      address_family: &address_family
        description: Enable address family and enter its config mode.
        type: list
        elements: dict
        suboptions:
          afi:
            description: address family.
            type: str
            choices:
              - evpn
              - inet
              - inet-mdt
              - inet-mvpn
              - inet-vpn
              - inet6
              - inet6-mvpn
              - inet6-vpn
              - iso-vpn
              - l2vpn
              - route-target
              - traffic-engineering
          af_type:
            description: Address family type for ipv4.
            type: list
            elements: dict
            suboptions:
              type:
                description: Specify type of NLRI.
                type: str
                choices:
                  - any
                  - flow
                  - labeled-unicast
                  - multicast
                  - segment-routing-te
                  - unicast
                  - signaling
                  - auto-discovery-mspw
                  - auto-discovery-only
              set:
                description: Set NLRI.
                type: bool
              accepted_prefix_limit:
                description: Specify limit for maximum number of prefixes accepted from a peer.
                type: dict
                suboptions:
                  maximum:
                    description: Specify maximum number of prefixes accepted from a peer.
                    type: int
                  teardown:
                    description: Clear peer connection on reaching limit.
                    type: bool
                  limit_threshold:
                    description: Specify teardown percentage of prefix-limit to start warnings.
                    type: int
                  idle_timeout:
                    description: Set idle timeout node.
                    type: bool
                  idle_timeout_value:
                    description: Specify timeout before attempting to restart peer.
                    type: int
                  forever:
                    description: Idle the peer until the user intervenes.
                    type: bool
              add_path:
                description: Advertise multiple paths to peer.
                type: dict
                suboptions:
                  receive:
                    description: Receive multiple paths from peer.
                    type: bool
                  send:
                    description: Send multiple paths to peer.
                    type: dict
                    suboptions:
                      include_backup_path:
                        description: Specify number of backup paths to advertise.
                        type: int
                      multipath:
                        description: Include only multipath contributor routes.
                        type: bool
                      path_count:
                        description: Include only multipath contributor routes.
                        type: int
                        required: true
                      path_selection_mode:
                        description: Configure how to select add-path routes.
                        type: dict
                        suboptions:
                          all_paths:
                            description: Advertise all paths allowed by path count.
                            type: bool
                          equal_cost_paths:
                            description: Advertise equal cost paths.
                            type: bool
                      prefix_policy:
                        description: Perform add-path only for prefixes that match policy.
                        type: str
              aggregate_label:
                description: Aggregate labels of incoming routes with the same FEC.
                type: dict
                suboptions:
                  set:
                    description: Set Aggregate labels of incoming routes with the same FEC
                    type: bool
                  community:
                    description: Community to identify the FEC of incoming routesC.
                    type: str
              aigp:
                description: Allow sending and receiving of AIGP attribute.
                type: dict
                suboptions:
                  set:
                    description: Set AIGP.
                    type: bool
                  disable:
                    description: Dn not allow sending and receiving of AIGP attribute.
                    type: bool
              damping:
                description: Enable route flap damping.
                type: bool
              defer_initial_multipath_build:
                description: Defer initial multipath build until EOR is received.
                type: dict
                suboptions:
                  set:
                    description: Set defer initial multipath build.
                    type: bool
                  maximum_delay:
                     description:  Max delay(sec) multipath build after peer is up.
                     type: int
              delay_route_advertisements:
                description: Delay route updates for this family until FIB-sync.
                type: dict
                suboptions:
                  set:
                    description: Set delay route advertisements.
                    type: bool
                  max_delay_route_age:
                    description: Set max delay advertisement route age.
                    type: int
                  max_delay_routing_uptime:
                    description: Set max delay advertisement route age.
                    type: int
                  min_delay_inbound_convergence:
                    description: Set min delayadvertisement after source-peer sent all routes.
                    type: int
                  min_delay_routing_uptime:
                    description: Set min delay advertisement route age.
                    type: int
              entropy_label:
                description: Use entropy label for entropy label capable BGP LSPs.
                type: dict
                suboptions:
                  set:
                    description: Set entropy-label attribute.
                    type: bool
                  import:
                    description: Policy to select BGP LSPs to use entropy label.
                    type: str
                  no_next_hop_validation:
                    description: Don't validate next hop field against route next hop.
                    type: bool
              explicit_null:
                description: Advertise explicit null.
                type: dict
                suboptions:
                  set:
                    description: Set explicit-null attribute.
                    type: bool
                  connected_only:
                    description: Advertise explicit null only for connected routes.
                    type: bool
              extended_nexthop:
                description: Enable extended nexthop encoding.
                type: bool
              extended_nexthop_color:
                description: Resolve using extended color nexthop.
                type: bool
              graceful_restart_forwarding_state_bit:
                description: Specify BGP graceful restart options.
                type: str
                choices: ['from-fib', 'set']
              local_ipv4_address:
                description: Specify local IPv4 address.
                type: str
              legacy_redirect_ip_action:
                description: Configure legacy redirect to IP support.
                type: dict
                suboptions:
                  set:
                    description: Set the legacy-redirect-ip-action.
                    type: bool
                  send:
                    description: Advertise Redirect action as legacy redirect attribute.
                    type: bool
                  receive:
                    description: Accept legacy encoded redirect-to-ip action attribute
                    type: bool
              loops:
                description: Allow local AS in received AS paths.
                type: int
              no_install:
                description: Dont install received routes in forwarding.
                type: bool
              no_validate:
                description: Bypass validation procedure for routes that match policy.
                type: str
              output_queue_priority_expedited:
                description: Expedited queue; highest priority.
                type: bool
              output_queue_priority_priority:
                description: Output queue priority; higher is better.
                type: int
              per_group_label:
                description: Advertise prefixes with unique labels per group.
                type: bool
              per_prefix_label:
                description: Allocate a unique label to each advertised prefix.
                type: bool
              prefix_limit:
                description: Limit maximum number of prefixes from a peer.
                type: dict
                suboptions:
                  maximum:
                    description: Specify maximum number of prefixes from a peer.
                    type: int
                  teardown:
                    description: Clear peer connection on reaching limit.
                    type: bool
                  limit_threshold:
                    description: Percentage of prefix-limit to start warnings.
                    type: int
                  idle_timeout:
                    description: Set idle timeout node.
                    type: bool
                  idle_timeout_value:
                    description: Specify timeout before attempting to restart peer.
                    type: int
                  forever:
                    description: Idle the peer until the user intervenes.
                    type: bool
              resolve_vpn:
                description: Install received NLRI in inet.3 also.
                type: bool
              rib:
                description: Select table used by labeled unicast routes.
                type: str
                choices: ['inet.3']
              ribgroup_name:
                description: Name of the routing table group.
                type: str
              route_refresh_priority_expedited:
                description: Expedited queue; highest priority.
                type: bool
              route_refresh_priority_priority:
                description: Output queue priority; higher is better.
                type: int
              secondary_independent_resolution:
                description: Resolve FLOW routes in VRF table independent of VPN FLOW route.
                type: bool
              topology:
                description: Multi topology routing tables.
                type: list
                elements: dict
                suboptions:
                  name:
                    description: Specify topology name.
                    type: str
                  community:
                    description: Community to identify multi topology routes.
                    type: list
                    elements: str
              withdraw_priority_expedited:
                description: Expedited queue; highest priority.
                type: bool
              withdraw_priority_priority:
                description: Output queue priority; higher is better.
                type: int
              strip_nexthop:
                description: Strip the next-hop from the outgoing flow update.
                type: bool
              traffic_statistics:
                description: Collect statistics for BGP label-switched paths
                type: dict
                suboptions:
                  set:
                    description: Set traffic-statistics.
                    type: bool
                  interval:
                    description: Time to collect statistics (seconds).
                    type: int
                  labeled_path:
                    description: Enable ingress labeled path statistics.
                    type: bool
                  file:
                    description: Statistics file options.
                    type: dict
                    suboptions:
                      filename:
                        description: Name of file in which to write trace information.
                        type: str
                      files:
                        description: Maximum number of trace files.
                        type: int
                      no_world_readable:
                        description: Don't allow any user to read the log file.
                        type: bool
                      size:
                        description: Maximum trace file size.
                        type: int
                      world_readable:
                        description: Don't allow any user to read the log file.
                        type: bool
      groups:
        description: Specify address family config for groups.
        type: list
        elements: dict
        suboptions:
          name:
            description: Specify name of the group
            type: str
          address_family: *address_family
          neighbors:
            description: Specify address family config per neighbor.
            type: list
            elements: dict
            suboptions:
              neighbor_address:
                description: Specify neighbor address.
                type: str
              address_family: *address_family
  state:
    description:
    - The state the configuration should be left in.
    - State I(deleted) only removes BGP address family attributes that this modules
      manages and does not negate the BGP neighbor address family completely. Thereby, preserving
      address-family related configurations under BGP group neighbor context.
    - To delete the address family associated to neighbor use M(junipernetworks.junos.junos_bgp_neighbor_address_family)
      modules for prior cleanup.
    - Refer to examples for more details.
    type: str
    choices:
    - merged
    - replaced
    - overridden
    - deleted
    - parsed
    - gathered
    - rendered
    default: merged
"""
EXAMPLES = """
# Using merged
#
# Before state
# ------------
#
# admin# show protocols bgp
#
# [edit]

- name: Merge Junos BGP address family configuration
  junipernetworks.junos.junos_bgp_address_family:
    config:
      address_family:
        - afi: 'evpn'
          af_type:
            - type: 'signaling'
              accepted_prefix_limit:
                maximum: 20
                limit_threshold: 98
                idle_timeout_value: 2001
              damping: true
              defer_initial_multipath_build:
                maximum_delay: 2
        - afi: 'inet'
          af_type:
            - type: 'flow'
              legacy_redirect_ip_action:
                send: true
                receive: true
              loops: 4
              no_install: true
              output_queue_priority_expedited: true
              secondary_independent_resolution: true

            - type: 'unicast'
              extended_nexthop: true
              extended_nexthop_color: true
              local_ipv4_address: '9.9.9.9'

            - type: 'labeled-unicast'
              entropy_label:
                no_next_hop_validation: true
              explicit_null:
                connected_only: true
              per_prefix_label: true
              per_group_label: true
              prefix_limit:
                maximum: 20
                limit_threshold: 99
                forever: true
              resolve_vpn: true
              rib: 'inet.3'
              route_refresh_priority_expedited: true
              route_refresh_priority_priority: 3

            - type: 'any'
              accepted_prefix_limit:
                maximum: 20
                limit_threshold: 99
                idle_timeout_value: 2000
              damping: true
              defer_initial_multipath_build:
                maximum_delay: 2
              delay_route_advertisements:
                max_delay_route_age: 20
                max_delay_routing_uptime: 32000
                min_delay_inbound_convergence: 32000
                min_delay_routing_uptime: 23000
              graceful_restart_forwarding_state_bit: 'from-fib'
    state: merged

# After state
# -----------
#
# admin# show protocols bgp
# family inet {
#     unicast {
#         local-ipv4-address 9.9.9.9;
#         extended-nexthop;
#         extended-nexthop-color;
#     }
#     flow {
#         loops 4;
#         no-install;
#         output-queue-priority expedited;
#         legacy-redirect-ip-action {
#             receive;
#             send;
#         }
#         secondary-independent-resolution;
#     }
#     any {
#         accepted-prefix-limit {
#             maximum 20;
#             teardown 99 idle-timeout 2000;
#         }
#         damping;
#         delay-route-advertisements {
#             minimum-delay {
#                 routing-uptime 23000;
#                 inbound-convergence 32000;
#             }
#             maximum-delay {
#                 route-age 20;
#                 routing-uptime 32000;
#             }
#         }
#         defer-initial-multipath-build {
#             maximum-delay 2;
#         }
#         graceful-restart {
#             forwarding-state-bit from-fib;
#         }
#     }
#     labeled-unicast {
#         prefix-limit {
#             maximum 20;
#             teardown 99 idle-timeout forever;
#         }
#         route-refresh-priority priority 3;
#         per-prefix-label;
#         per-group-label;
#         rib {
#             inet.3;
#         }
#         explicit-null connected-only;
#         resolve-vpn;
#         entropy-label {
#             no-next-hop-validation;
#         }
#     }
# }
# family evpn {
#     signaling {
#         accepted-prefix-limit {
#             maximum 20;
#             teardown 98 idle-timeout 2001;
#         }
#         damping;
#         defer-initial-multipath-build {
#             maximum-delay 2;
#         }
#     }
# }
# Using replaced
#
# Before state
# ------------
#
# admin# show protocols bgp
# preference 2;
# hold-time 5;
# advertise-inactive;
# out-delay 10;
# bgp-error-tolerance {
#     malformed-route-limit 40000000;
# }
# authentication-algorithm md5;
# advertise-bgp-static {
#     policy static-to-bgp;
# }
# family inet {
#     unicast {
#         local-ipv4-address 9.9.9.9;
#         extended-nexthop;
#         extended-nexthop-color;
#     }
#     flow {
#         loops 4;
#         no-install;
#         output-queue-priority expedited;
#         legacy-redirect-ip-action {
#             receive;
#             send;
#         }
#         secondary-independent-resolution;
#     }
#     any {
#         accepted-prefix-limit {
#             maximum 20;
#             teardown 99 idle-timeout 2000;
#         }
#         damping;
#         delay-route-advertisements {
#             minimum-delay {
#                 routing-uptime 23000;
#                 inbound-convergence 32000;
#             }
#             maximum-delay {
#                 route-age 20;
#                 routing-uptime 32000;
#             }
#         }
#         defer-initial-multipath-build {
#             maximum-delay 2;
#         }
#         graceful-restart {
#             forwarding-state-bit from-fib;
#         }
#     }
#     labeled-unicast {
#         prefix-limit {
#             maximum 20;
#             teardown 99 idle-timeout forever;
#         }
#         route-refresh-priority priority 3;
#         per-prefix-label;
#         per-group-label;
#         rib {
#             inet.3;
#         }
#         explicit-null connected-only;
#         resolve-vpn;
#         entropy-label {
#             no-next-hop-validation;
#         }
#     }
# }
# family evpn {
#     signaling {
#         accepted-prefix-limit {
#             maximum 20;
#             teardown 98 idle-timeout 2001;
#         }
#         damping;
#         defer-initial-multipath-build {
#             maximum-delay 2;
#         }
#     }
# }

- name: Replace existing Junos BGP address family config with provided config
  junipernetworks.junos.junos_bgp_address_family:
   config:
     address_family:
       - afi: 'evpn'
         af_type:
           - type: 'signaling'
             accepted_prefix_limit:
               maximum: 21
               limit_threshold: 99
               idle_timeout_value: 2002
             delay_route_advertisements:
               max_delay_route_age: 20
               max_delay_routing_uptime: 32000
               min_delay_inbound_convergence: 32000
               min_delay_routing_uptime: 23000
             damping: true
   state: replaced

# After state
# -----------
#
# admin# show protocols bgp
# preference 2;
# hold-time 5;
# advertise-inactive;
# out-delay 10;
# bgp-error-tolerance {
#     malformed-route-limit 40000000;
# }
# authentication-algorithm md5;
# advertise-bgp-static {
#     policy static-to-bgp;
# }
# family inet {
#     unicast {
#         local-ipv4-address 9.9.9.9;
#         extended-nexthop;
#         extended-nexthop-color;
#     }
#     flow {
#         loops 4;
#         no-install;
#         output-queue-priority expedited;
#         legacy-redirect-ip-action {
#             receive;
#             send;
#         }
#         secondary-independent-resolution;
#     }
#     any {
#         accepted-prefix-limit {
#             maximum 20;
#             teardown 99 idle-timeout 2000;
#         }
#         damping;
#         delay-route-advertisements {
#             minimum-delay {
#                 routing-uptime 23000;
#                 inbound-convergence 32000;
#             }
#             maximum-delay {
#                 route-age 20;
#                 routing-uptime 32000;
#             }
#         }
#         defer-initial-multipath-build {
#             maximum-delay 2;
#         }
#         graceful-restart {
#             forwarding-state-bit from-fib;
#         }
#     }
#     labeled-unicast {
#         prefix-limit {
#             maximum 20;
#             teardown 99 idle-timeout forever;
#         }
#         route-refresh-priority priority 3;
#         per-prefix-label;
#         per-group-label;
#         rib {
#             inet.3;
#         }
#         explicit-null connected-only;
#         resolve-vpn;
#         entropy-label {
#             no-next-hop-validation;
#         }
#     }
# }
# family evpn {
#     signaling {
#         accepted-prefix-limit {
#             maximum 21;
#             teardown 99 idle-timeout 2002;
#         }
#         damping;
#         delay-route-advertisements {
#             minimum-delay {
#                 routing-uptime 23000;
#                 inbound-convergence 32000;
#             }
#             maximum-delay {
#                 route-age 20;
#                 routing-uptime 32000;
#             }
#         }
#     }
# }
# Using overridden
#
# Before state
# ------------
#
# admin# show protocols bgp
# family inet {
#     unicast {
#         local-ipv4-address 9.9.9.9;
#         extended-nexthop;
#         extended-nexthop-color;
#     }
#     flow {
#         loops 4;
#         no-install;
#         output-queue-priority expedited;
#         legacy-redirect-ip-action {
#             receive;
#             send;
#         }
#         secondary-independent-resolution;
#     }
#     any {
#         accepted-prefix-limit {
#             maximum 20;
#             teardown 99 idle-timeout 2000;
#         }
#         damping;
#         delay-route-advertisements {
#             minimum-delay {
#                 routing-uptime 23000;
#                 inbound-convergence 32000;
#             }
#             maximum-delay {
#                 route-age 20;
#                 routing-uptime 32000;
#             }
#         }
#         defer-initial-multipath-build {
#             maximum-delay 2;
#         }
#         graceful-restart {
#             forwarding-state-bit from-fib;
#         }
#     }
#     labeled-unicast {
#         prefix-limit {
#             maximum 20;
#             teardown 99 idle-timeout forever;
#         }
#         route-refresh-priority priority 3;
#         per-prefix-label;
#         per-group-label;
#         rib {
#             inet.3;
#         }
#         explicit-null connected-only;
#         resolve-vpn;
#         entropy-label {
#             no-next-hop-validation;
#         }
#     }
# }
# family evpn {
#     signaling {
#         accepted-prefix-limit {
#             maximum 20;
#             teardown 98 idle-timeout 2001;
#         }
#         damping;
#         defer-initial-multipath-build {
#             maximum-delay 2;
#         }
#     }
# }

- name: Override Junos BGP address family config
  junipernetworks.junos.junos_bgp_address_family:
   config:
     address_family:
       - afi: 'evpn'
         af_type:
           - type: 'signaling'
             accepted_prefix_limit:
               maximum: 21
               limit_threshold: 99
               idle_timeout_value: 2002
             delay_route_advertisements:
               max_delay_route_age: 20
               max_delay_routing_uptime: 32000
               min_delay_inbound_convergence: 32000
               min_delay_routing_uptime: 23000
             damping: true
   state: overridden

# After state
# -----------
#
# admin# show protocols bgp
# family evpn {
#     signaling {
#         accepted-prefix-limit {
#             maximum 21;
#             teardown 99 idle-timeout 2002;
#         }
#         damping;
#         delay-route-advertisements {
#             minimum-delay {
#                 routing-uptime 23000;
#                 inbound-convergence 32000;
#             }
#             maximum-delay {
#                 route-age 20;
#                 routing-uptime 32000;
#             }
#         }
#     }
# }

# Using deleted
#
# Before state
# ------------
#
# admin# show protocols bgp
# preference 2;
# hold-time 5;
# advertise-inactive;
# out-delay 10;
# family inet {
#     unicast {
#         local-ipv4-address 9.9.9.9;
#         extended-nexthop;
#         extended-nexthop-color;
#     }
#     flow {
#         loops 4;
#         no-install;
#         output-queue-priority expedited;
#         legacy-redirect-ip-action {
#             receive;
#             send;
#         }
#         secondary-independent-resolution;
#     }
#     any {
#         accepted-prefix-limit {
#             maximum 20;
#             teardown 99 idle-timeout 2000;
#         }
#         damping;
#         delay-route-advertisements {
#             minimum-delay {
#                 routing-uptime 23000;
#                 inbound-convergence 32000;
#             }
#             maximum-delay {
#                 route-age 20;
#                 routing-uptime 32000;
#             }
#         }
#         defer-initial-multipath-build {
#             maximum-delay 2;
#         }
#         graceful-restart {
#             forwarding-state-bit from-fib;
#         }
#     }
#     labeled-unicast {
#         prefix-limit {
#             maximum 20;
#             teardown 99 idle-timeout forever;
#         }
#         route-refresh-priority priority 3;
#         per-prefix-label;
#         per-group-label;
#         rib {
#             inet.3;
#         }
#         explicit-null connected-only;
#         resolve-vpn;
#         entropy-label {
#             no-next-hop-validation;
#         }
#     }
# }
# family evpn {
#     signaling {
#         accepted-prefix-limit {
#             maximum 20;
#             teardown 98 idle-timeout 2001;
#         }
#         damping;
#         defer-initial-multipath-build {
#             maximum-delay 2;
#         }
#     }
# }

- name: Delete Junos BGP address family config based on the afi
  junipernetworks.junos.junos_bgp_address_family:
   config:
    address_family:
      - afi: 'inet'
   state: deleted

# After state
# -----------
#
# admin# show protocols bgp
# preference 2;
# hold-time 5;
# advertise-inactive;
# out-delay 10;
# family evpn {
#     signaling {
#         accepted-prefix-limit {
#             maximum 20;
#             teardown 98 idle-timeout 2001;
#         }
#         damping;
#         defer-initial-multipath-build {
#             maximum-delay 2;
#         }
#     }
# }

# Using deleted
#
# Before state
# ------------
#
# admin# show protocols bgp
# preference 2;
# hold-time 5;
# advertise-inactive;
# out-delay 10;
# family inet {
#     unicast {
#         local-ipv4-address 9.9.9.9;
#         extended-nexthop;
#         extended-nexthop-color;
#     }
#     flow {
#         loops 4;
#         no-install;
#         output-queue-priority expedited;
#         legacy-redirect-ip-action {
#             receive;
#             send;
#         }
#         secondary-independent-resolution;
#     }
#     any {
#         accepted-prefix-limit {
#             maximum 20;
#             teardown 99 idle-timeout 2000;
#         }
#         damping;
#         delay-route-advertisements {
#             minimum-delay {
#                 routing-uptime 23000;
#                 inbound-convergence 32000;
#             }
#             maximum-delay {
#                 route-age 20;
#                 routing-uptime 32000;
#             }
#         }
#         defer-initial-multipath-build {
#             maximum-delay 2;
#         }
#         graceful-restart {
#             forwarding-state-bit from-fib;
#         }
#     }
#     labeled-unicast {
#         prefix-limit {
#             maximum 20;
#             teardown 99 idle-timeout forever;
#         }
#         route-refresh-priority priority 3;
#         per-prefix-label;
#         per-group-label;
#         rib {
#             inet.3;
#         }
#         explicit-null connected-only;
#         resolve-vpn;
#         entropy-label {
#             no-next-hop-validation;
#         }
#     }
# }
# family evpn {
#     signaling {
#         accepted-prefix-limit {
#             maximum 20;
#             teardown 98 idle-timeout 2001;
#         }
#         damping;
#         defer-initial-multipath-build {
#             maximum-delay 2;
#         }
#     }
# }

- name: Delete complete Junos BGP address family config
  junipernetworks.junos.junos_bgp_address_family:
   config:
   state: deleted

# After state
# -----------
#
# admin# show protocols bgp
# preference 2;
# hold-time 5;
# advertise-inactive;
# out-delay 10;


# Using gathered
#
# Before state
# ------------
#
# admin# show protocols bgp
# preference 2;
# hold-time 5;
# advertise-inactive;
# out-delay 10;
# family inet {
#     unicast {
#         local-ipv4-address 9.9.9.9;
#         extended-nexthop;
#         extended-nexthop-color;
#     }
#     flow {
#         loops 4;
#         no-install;
#         output-queue-priority expedited;
#         legacy-redirect-ip-action {
#             receive;
#             send;
#         }
#         secondary-independent-resolution;
#     }
#     any {
#         accepted-prefix-limit {
#             maximum 20;
#             teardown 99 idle-timeout 2000;
#         }
#         damping;
#         delay-route-advertisements {
#             minimum-delay {
#                 routing-uptime 23000;
#                 inbound-convergence 32000;
#             }
#             maximum-delay {
#                 route-age 20;
#                 routing-uptime 32000;
#             }
#         }
#         defer-initial-multipath-build {
#             maximum-delay 2;
#         }
#         graceful-restart {
#             forwarding-state-bit from-fib;
#         }
#     }
#     labeled-unicast {
#         prefix-limit {
#             maximum 20;
#             teardown 99 idle-timeout forever;
#         }
#         route-refresh-priority priority 3;
#         per-prefix-label;
#         per-group-label;
#         rib {
#             inet.3;
#         }
#         explicit-null connected-only;
#         resolve-vpn;
#         entropy-label {
#             no-next-hop-validation;
#         }
#     }
# }
# family evpn {
#     signaling {
#         accepted-prefix-limit {
#             maximum 20;
#             teardown 98 idle-timeout 2001;
#         }
#         damping;
#         defer-initial-multipath-build {
#             maximum-delay 2;
#         }
#     }
# }

- name: Gather Junos BGP address family config
  junipernetworks.junos.junos_bgp_address_family:
    config:
    state: gathered
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#    "gathered": {
#         "address_family": [
#             {
#                 "af_type": [
#                     {
#                         "accepted_prefix_limit": {
#                             "idle_timeout_value": 2001,
#                             "limit_threshold": 98,
#                             "maximum": 20
#                         },
#                         "damping": true,
#                         "defer_initial_multipath_build": {
#                             "maximum_delay": 2
#                         },
#                         "type": "signaling"
#                     }
#                 ],
#                 "afi": "evpn"
#             },
#             {
#                 "af_type": [
#                     {
#                         "accepted_prefix_limit": {
#                             "idle_timeout_value": 2000,
#                             "limit_threshold": 99,
#                             "maximum": 20
#                         },
#                         "damping": true,
#                         "defer_initial_multipath_build": {
#                             "maximum_delay": 2
#                         },
#                         "delay_route_advertisements": {
#                             "max_delay_route_age": 20,
#                             "max_delay_routing_uptime": 32000,
#                             "min_delay_inbound_convergence": 32000,
#                             "min_delay_routing_uptime": 23000
#                         },
#                         "graceful_restart_forwarding_state_bit": "from-fib",
#                         "type": "any"
#                     },
#                     {
#                         "legacy_redirect_ip_action": {
#                             "receive": true,
#                             "send": true
#                         },
#                         "loops": 4,
#                         "no_install": true,
#                         "output_queue_priority_expedited": true,
#                         "secondary_independent_resolution": true,
#                         "type": "flow"
#                     },
#                     {
#                         "entropy_label": {
#                             "no_next_hop_validation": true
#                         },
#                         "explicit_null": {
#                             "connected_only": true
#                         },
#                         "per_group_label": true,
#                         "per_prefix_label": true,
#                         "prefix_limit": {
#                             "forever": true,
#                             "limit_threshold": 99,
#                             "maximum": 20
#                         },
#                         "resolve_vpn": true,
#                         "rib": "inet.3",
#                         "route_refresh_priority_priority": 3,
#                         "type": "labeled-unicast"
#                     },
#                     {
#                         "extended_nexthop": true,
#                         "extended_nexthop_color": true,
#                         "local_ipv4_address": "9.9.9.9",
#                         "type": "unicast"
#                     }
#                 ],
#                 "afi": "inet"
#             }
#         ]
#     }
#
# Using parsed
# parsed.cfg
# ------------
# <?xml version="1.0" encoding="UTF-8"?>
# <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
#     <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
#         <version>18.4R1-S2.4</version>
#         <protocols>
#             <bgp>
#                 <preference>2</preference>
#                 <hold-time>5</hold-time>
#                 <advertise-inactive/>
#                 <out-delay>10</out-delay>
#                 <family>
#                     <inet>
#                         <unicast>
#                             <local-ipv4-address>9.9.9.9</local-ipv4-address>
#                             <extended-nexthop/>
#                             <extended-nexthop-color/>
#                         </unicast>
#                         <flow>
#                             <loops>
#                                 <loops>4</loops>
#                             </loops>
#                             <no-install/>
#                             <output-queue-priority>
#                                 <expedited/>
#                             </output-queue-priority>
#                             <legacy-redirect-ip-action>
#                                 <receive/>
#                                 <send/>
#                             </legacy-redirect-ip-action>
#                             <secondary-independent-resolution/>
#                         </flow>
#                         <any>
#                             <accepted-prefix-limit>
#                                 <maximum>20</maximum>
#                                 <teardown>
#                                     <limit-threshold>99</limit-threshold>
#                                     <idle-timeout>
#                                         <timeout>2000</timeout>
#                                     </idle-timeout>
#                                 </teardown>
#                             </accepted-prefix-limit>
#                             <damping/>
#                             <delay-route-advertisements>
#                                 <minimum-delay>
#                                     <routing-uptime>23000</routing-uptime>
#                                     <inbound-convergence>32000</inbound-convergence>
#                                 </minimum-delay>
#                                 <maximum-delay>
#                                     <route-age>20</route-age>
#                                     <routing-uptime>32000</routing-uptime>
#                                 </maximum-delay>
#                             </delay-route-advertisements>
#                             <defer-initial-multipath-build>
#                                 <maximum-delay>2</maximum-delay>
#                             </defer-initial-multipath-build>
#                             <graceful-restart>
#                                 <forwarding-state-bit>from-fib</forwarding-state-bit>
#                             </graceful-restart>
#                         </any>
#                         <labeled-unicast>
#                             <prefix-limit>
#                                 <maximum>20</maximum>
#                                 <teardown>
#                                     <limit-threshold>99</limit-threshold>
#                                     <idle-timeout>
#                                         <forever/>
#                                     </idle-timeout>
#                                 </teardown>
#                             </prefix-limit>
#                             <route-refresh-priority>
#                                 <priority>3</priority>
#                             </route-refresh-priority>
#                             <per-prefix-label/>
#                             <per-group-label/>
#                             <rib>
#                                 <inet.3/>
#                             </rib>
#                             <explicit-null>
#                                 <connected-only/>
#                             </explicit-null>
#                             <resolve-vpn/>
#                             <entropy-label>
#                                 <no-next-hop-validation/>
#                             </entropy-label>
#                         </labeled-unicast>
#                     </inet>
#                     <evpn>
#                         <signaling>
#                             <accepted-prefix-limit>
#                                 <maximum>20</maximum>
#                                 <teardown>
#                                     <limit-threshold>98</limit-threshold>
#                                     <idle-timeout>
#                                         <timeout>2001</timeout>
#                                     </idle-timeout>
#                                 </teardown>
#                             </accepted-prefix-limit>
#                             <damping/>
#                             <defer-initial-multipath-build>
#                                 <maximum-delay>2</maximum-delay>
#                             </defer-initial-multipath-build>
#                         </signaling>
#                     </evpn>
#                 </family>
#             </bgp>
#             <ospf3>
#                 <area>
#                     <name>0.0.0.100</name>
#                     <stub>
#                         <default-metric>200</default-metric>
#                     </stub>
#                     <interface>
#                         <name>so-0/0/0.0</name>
#                         <metric>5</metric>
#                         <priority>3</priority>
#                     </interface>
#                 </area>
#             </ospf3>
#         </protocols>
#         <routing-options>
#             <static>
#                 <route>
#                     <name>172.16.17.0/24</name>
#                     <discard />
#                 </route>
#             </static>
#             <router-id>10.200.16.75</router-id>
#             <autonomous-system>
#                 <as-number>65432</as-number>
#             </autonomous-system>
#         </routing-options>
#     </configuration>
# </rpc-reply>


- name: Parsed the bgp address family running config to get the facts
  junipernetworks.junos.junos_bgp_address_family:
    running_config: "{{ lookup('file', './parsed.cfg') }}"
    state: parsed
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "parsed":  {
#         "address_family": [
#             {
#                 "af_type": [
#                     {
#                         "accepted_prefix_limit": {
#                             "idle_timeout_value": 2001,
#                             "limit_threshold": 98,
#                             "maximum": 20
#                         },
#                         "damping": true,
#                         "defer_initial_multipath_build": {
#                             "maximum_delay": 2
#                         },
#                         "type": "signaling"
#                     }
#                 ],
#                 "afi": "evpn"
#             },
#             {
#                 "af_type": [
#                     {
#                         "accepted_prefix_limit": {
#                             "idle_timeout_value": 2000,
#                             "limit_threshold": 99,
#                             "maximum": 20
#                         },
#                         "damping": true,
#                         "defer_initial_multipath_build": {
#                             "maximum_delay": 2
#                         },
#                         "delay_route_advertisements": {
#                             "max_delay_route_age": 20,
#                             "max_delay_routing_uptime": 32000,
#                             "min_delay_inbound_convergence": 32000,
#                             "min_delay_routing_uptime": 23000
#                         },
#                         "graceful_restart_forwarding_state_bit": "from-fib",
#                         "type": "any"
#                     },
#                     {
#                         "legacy_redirect_ip_action": {
#                             "receive": true,
#                             "send": true
#                         },
#                         "loops": 4,
#                         "no_install": true,
#                         "output_queue_priority_expedited": true,
#                         "secondary_independent_resolution": true,
#                         "type": "flow"
#                     },
#                     {
#                         "entropy_label": {
#                             "no_next_hop_validation": true
#                         },
#                         "explicit_null": {
#                             "connected_only": true
#                         },
#                         "per_group_label": true,
#                         "per_prefix_label": true,
#                         "prefix_limit": {
#                             "forever": true,
#                             "limit_threshold": 99,
#                             "maximum": 20
#                         },
#                         "resolve_vpn": true,
#                         "rib": "inet.3",
#                         "route_refresh_priority_priority": 3,
#                         "type": "labeled-unicast"
#                     },
#                     {
#                         "extended_nexthop": true,
#                         "extended_nexthop_color": true,
#                         "local_ipv4_address": "9.9.9.9",
#                         "type": "unicast"
#                     }
#                 ],
#                 "afi": "inet"
#             }
#         ]
#     }
# Using rendered
#
#
- name: Render the commands for provided  configuration
  junipernetworks.junos.junos_bgp_address_family:
    config:
      address_family:
        - afi: 'evpn'
          af_type:
            - type: 'signaling'
              accepted_prefix_limit:
                maximum: 20
                limit_threshold: 98
                idle_timeout_value: 2001
              damping: true
              defer_initial_multipath_build:
                maximum_delay: 2
        - afi: 'inet'
          af_type:
            - type: 'flow'
              legacy_redirect_ip_action:
                send: true
                receive: true
              loops: 4
              no_install: true
              output_queue_priority_expedited: true
              secondary_independent_resolution: true

            - type: 'unicast'
              extended_nexthop: true
              extended_nexthop_color: true
              local_ipv4_address: '9.9.9.9'

            - type: 'labeled-unicast'
              entropy_label:
                no_next_hop_validation: true
              explicit_null:
                connected_only: true
              per_prefix_label: true
              per_group_label: true
              prefix_limit:
                maximum: 20
                limit_threshold: 99
                forever: true
              resolve_vpn: true
              rib: 'inet.3'
              route_refresh_priority_expedited: true
              route_refresh_priority_priority: 3

            - type: 'any'
              accepted_prefix_limit:
                maximum: 20
                limit_threshold: 99
                idle_timeout_value: 2000
              damping: true
              defer_initial_multipath_build:
                maximum_delay: 2
              delay_route_advertisements:
                max_delay_route_age: 20
                max_delay_routing_uptime: 32000
                min_delay_inbound_convergence: 32000
                min_delay_routing_uptime: 23000
              graceful_restart_forwarding_state_bit: 'from-fib'
    state: rendered

#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "rendered": "<nc:protocols xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">
# <nc:bgp><nc:family><nc:evpn><nc:signaling><nc:accepted-prefix-limit><nc:maximum>20</nc:maximum>
# <nc:teardown><nc:limit-threshold>98</nc:limit-threshold><nc:idle-timeout><nc:timeout>2001</nc:timeout>
# </nc:idle-timeout></nc:teardown></nc:accepted-prefix-limit><nc:damping/><nc:defer-initial-multipath-build>
# <nc:maximum-delay>2</nc:maximum-delay></nc:defer-initial-multipath-build></nc:signaling>
# </nc:evpn><nc:inet><nc:flow><nc:legacy-redirect-ip-action><nc:send/><nc:receive/>
# </nc:legacy-redirect-ip-action><nc:loops>4</nc:loops><nc:no-install/>
# <nc:output-queue-priority><nc:expedited/></nc:output-queue-priority>
# <nc:secondary-independent-resolution/></nc:flow><nc:unicast><nc:extended-nexthop/>
# <nc:extended-nexthop-color/><nc:local-ipv4-address>9.9.9.9</nc:local-ipv4-address>
# </nc:unicast><nc:labeled-unicast><nc:entropy-label><nc:no-next-hop-validation/>
# </nc:entropy-label><nc:explicit-null><nc:connected-only/></nc:explicit-null>
# <nc:per-prefix-label/><nc:per-group-label/><nc:prefix-limit><nc:maximum>20</nc:maximum>
# <nc:teardown>99<nc:idle-timeout><nc:forever/></nc:idle-timeout></nc:teardown>
# </nc:prefix-limit><nc:resolve-vpn/><nc:rib><nc:inet.3/></nc:rib><nc:route-refresh-priority>
# <nc:expedited/><nc:priority>3</nc:priority></nc:route-refresh-priority></nc:labeled-unicast>
# <nc:any><nc:accepted-prefix-limit><nc:maximum>20</nc:maximum><nc:teardown>
# <nc:limit-threshold>99</nc:limit-threshold><nc:idle-timeout><nc:timeout>2000</nc:timeout>
# </nc:idle-timeout></nc:teardown></nc:accepted-prefix-limit><nc:damping/>
# <nc:defer-initial-multipath-build><nc:maximum-delay>2</nc:maximum-delay>
# </nc:defer-initial-multipath-build><nc:delay-route-advertisements>
# <nc:maximum-delay><nc:route-age>20</nc:route-age><nc:routing-uptime>32000</nc:routing-uptime>
# </nc:maximum-delay><nc:minimum-delay><nc:inbound-convergence>32000</nc:inbound-convergence>
# <nc:routing-uptime>23000</nc:routing-uptime></nc:minimum-delay></nc:delay-route-advertisements>
# <nc:graceful-restart><nc:forwarding-state-bit>from-fib</nc:forwarding-state-bit>
# </nc:graceful-restart></nc:any></nc:inet></nc:family></nc:bgp></nc:protocols>"

"""
RETURN = """
before:
  description: The configuration prior to the model invocation.
  returned: always
  type: dict
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
after:
  description: The resulting configuration model invocation.
  returned: when changed
  type: dict
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['<nc:protocols xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">
  <nc:bgp><nc:family><nc:evpn><nc:signaling><nc:accepted-prefix-limit>
  <nc:maximum>21</nc:maximum><nc:teardown><nc:limit-threshold>99</nc:limit-threshold>
  <nc:idle-timeout><nc:timeout>2002</nc:timeout></nc:idle-timeout>
  </nc:teardown></nc:accepted-prefix-limit><nc:damping/>
  <nc:delay-route-advertisements><nc:maximum-delay>
  <nc:route-age>20</nc:route-age><nc:routing-uptime>32000</nc:routing-uptime>
  </nc:maximum-delay><nc:minimum-delay><nc:inbound-convergence>32000</nc:inbound-convergence>
  <nc:routing-uptime>23000</nc:routing-uptime></nc:minimum-delay></nc:delay-route-advertisements>
  </nc:signaling></nc:evpn></nc:family></nc:bgp></nc:protocols>', 'xml 2', 'xml 3']
"""


from ansible.module_utils.basic import AnsibleModule
from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.argspec.bgp_address_family.bgp_address_family import (
    Bgp_address_familyArgs,
)
from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.bgp_address_family.bgp_address_family import (
    Bgp_address_family,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    module = AnsibleModule(
        argument_spec=Bgp_address_familyArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
    )
    result = Bgp_address_family(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
