/*
 * Decompiled with CFR 0.152.
 */
package com.concurrent_ruby.ext.jsr166e.nounsafe;

import com.concurrent_ruby.ext.jsr166e.ConcurrentHashMap;
import com.concurrent_ruby.ext.jsr166e.nounsafe.LongAdder;
import com.concurrent_ruby.ext.jsr166y.ThreadLocalRandom;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ConcurrentHashMapV8<K, V>
implements ConcurrentMap<K, V>,
Serializable,
ConcurrentHashMap<K, V> {
    private static final long serialVersionUID = 7249069246763182397L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int DEFAULT_CAPACITY = 16;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int TRANSFER_BUFFER_SIZE = 32;
    private static final int TREE_THRESHOLD = 16;
    static final int MOVED = Integer.MIN_VALUE;
    static final int LOCKED = 0x40000000;
    static final int WAITING = -1073741824;
    static final int HASH_BITS = 0x3FFFFFFF;
    volatile transient AtomicReferenceArray<Node> table;
    private transient LongAdder counter;
    private volatile transient int sizeCtl;
    private transient KeySetView<K, V> keySet;
    private transient ValuesView<K, V> values;
    private transient EntrySetView<K, V> entrySet;
    private Segment<K, V>[] segments;
    static AtomicIntegerFieldUpdater SIZE_CTRL_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ConcurrentHashMapV8.class, "sizeCtl");

    static final Node tabAt(AtomicReferenceArray<Node> atomicReferenceArray, int n) {
        return atomicReferenceArray.get(n);
    }

    private static final boolean casTabAt(AtomicReferenceArray<Node> atomicReferenceArray, int n, Node node, Node node2) {
        return atomicReferenceArray.compareAndSet(n, node, node2);
    }

    private static final void setTabAt(AtomicReferenceArray<Node> atomicReferenceArray, int n, Node node) {
        atomicReferenceArray.set(n, node);
    }

    private static final int spread(int n) {
        n ^= n >>> 18 ^ n >>> 12;
        return (n ^ n >>> 10) & 0x3FFFFFFF;
    }

    private final void replaceWithTreeBin(AtomicReferenceArray<Node> atomicReferenceArray, int n, Object object) {
        if (object instanceof Comparable && (atomicReferenceArray.length() >= 0x40000000 || this.counter.sum() < (long)this.sizeCtl)) {
            TreeBin treeBin = new TreeBin();
            Node node = ConcurrentHashMapV8.tabAt(atomicReferenceArray, n);
            while (node != null) {
                treeBin.putTreeNode(node.hash & 0x3FFFFFFF, node.key, node.val);
                node = node.next;
            }
            ConcurrentHashMapV8.setTabAt(atomicReferenceArray, n, new Node(Integer.MIN_VALUE, treeBin, null, null));
        }
    }

    private final Object internalGet(Object object) {
        int n = ConcurrentHashMapV8.spread(object.hashCode());
        AtomicReferenceArray atomicReferenceArray = this.table;
        block0: while (atomicReferenceArray != null) {
            Node node = ConcurrentHashMapV8.tabAt(atomicReferenceArray, atomicReferenceArray.length() - 1 & n);
            while (node != null) {
                Object object2;
                Object object3;
                int n2 = node.hash;
                if (n2 == Integer.MIN_VALUE) {
                    object3 = node.key;
                    if (object3 instanceof TreeBin) {
                        return ((TreeBin)object3).getValue(n, object);
                    }
                    atomicReferenceArray = (AtomicReferenceArray)object3;
                    continue block0;
                }
                if ((n2 & 0x3FFFFFFF) == n && (object2 = node.val) != null && ((object3 = node.key) == object || object.equals(object3))) {
                    return object2;
                }
                node = node.next;
            }
            break block0;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object internalReplace(Object object, Object object2, Object object3) {
        int n;
        Node node;
        int n2 = ConcurrentHashMapV8.spread(object.hashCode());
        Object object4 = null;
        AtomicReferenceArray atomicReferenceArray = this.table;
        while (atomicReferenceArray != null && (node = ConcurrentHashMapV8.tabAt(atomicReferenceArray, n = atomicReferenceArray.length() - 1 & n2)) != null) {
            boolean bl;
            boolean bl2;
            block28: {
                Object object5;
                Node node2;
                int n3 = node.hash;
                if (n3 == Integer.MIN_VALUE) {
                    Object object6 = node.key;
                    if (object6 instanceof TreeBin) {
                        TreeBin treeBin = (TreeBin)object6;
                        bl2 = false;
                        boolean bl3 = false;
                        treeBin.acquire(0);
                        try {
                            if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n) == node) {
                                bl2 = true;
                                node2 = treeBin.getTreeNode(n2, object, treeBin.root);
                                if (node2 != null) {
                                    object5 = node2.val;
                                    if (object3 == null || object3 == object5 || object3.equals(object5)) {
                                        object4 = object5;
                                        node2.val = object2;
                                        if (node2.val == null) {
                                            bl3 = true;
                                            treeBin.deleteTreeNode((TreeNode)node2);
                                        }
                                    }
                                }
                            }
                        }
                        finally {
                            treeBin.release(0);
                        }
                        if (!bl2) continue;
                        if (!bl3) break;
                        this.counter.add(-1L);
                        break;
                    }
                    atomicReferenceArray = (AtomicReferenceArray)object6;
                    continue;
                }
                if ((n3 & 0x3FFFFFFF) != n2 && node.next == null) break;
                if ((n3 & 0x40000000) != 0) {
                    this.checkForResize();
                    node.tryAwaitLock(atomicReferenceArray, n);
                    continue;
                }
                if (!node.casHash(n3, n3 | 0x40000000)) continue;
                bl = false;
                bl2 = false;
                try {
                    if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n) != node) break block28;
                    bl = true;
                    Node node3 = node;
                    node2 = null;
                    do {
                        Object object7;
                        if ((node3.hash & 0x3FFFFFFF) == n2 && (object7 = node3.val) != null && ((object5 = node3.key) == object || object.equals(object5))) {
                            if (object3 == null || object3 == object7 || object3.equals(object7)) {
                                object4 = object7;
                                node3.val = object2;
                                if (node3.val == null) {
                                    bl2 = true;
                                    Node node4 = node3.next;
                                    if (node2 != null) {
                                        node2.next = node4;
                                    } else {
                                        ConcurrentHashMapV8.setTabAt(atomicReferenceArray, n, node4);
                                    }
                                }
                            }
                            break;
                        }
                        node2 = node3;
                    } while ((node3 = node3.next) != null);
                }
                finally {
                    if (!node.casHash(n3 | 0x40000000, n3)) {
                        node.hash = n3;
                        Node node5 = node;
                        synchronized (node5) {
                            node.notifyAll();
                        }
                    }
                }
            }
            if (!bl) continue;
            if (!bl2) break;
            this.counter.add(-1L);
            break;
        }
        return object4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object internalPut(Object object, Object object2) {
        int n;
        block29: {
            Object object3;
            int n2 = ConcurrentHashMapV8.spread(object.hashCode());
            n = 0;
            AtomicReferenceArray atomicReferenceArray = this.table;
            while (true) {
                block31: {
                    Object object4;
                    Object object5;
                    if (atomicReferenceArray == null) {
                        atomicReferenceArray = this.initTable();
                        continue;
                    }
                    int n3 = atomicReferenceArray.length() - 1 & n2;
                    Node node = ConcurrentHashMapV8.tabAt(atomicReferenceArray, n3);
                    if (node == null) {
                        if (!ConcurrentHashMapV8.casTabAt(atomicReferenceArray, n3, null, new Node(n2, object, object2, null))) continue;
                        break block29;
                    }
                    int n4 = node.hash;
                    if (n4 == Integer.MIN_VALUE) {
                        Object object6 = node.key;
                        if (object6 instanceof TreeBin) {
                            object3 = (TreeBin)object6;
                            object5 = null;
                            ((AbstractQueuedSynchronizer)object3).acquire(0);
                            try {
                                if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n3) == node) {
                                    n = 2;
                                    object4 = ((TreeBin)object3).putTreeNode(n2, object, object2);
                                    if (object4 != null) {
                                        object5 = ((TreeNode)object4).val;
                                        ((TreeNode)object4).val = object2;
                                    }
                                }
                            }
                            finally {
                                ((AbstractQueuedSynchronizer)object3).release(0);
                            }
                            if (n == 0) continue;
                            if (object5 != null) {
                                return object5;
                            }
                            break block29;
                        }
                        atomicReferenceArray = (AtomicReferenceArray)object6;
                        continue;
                    }
                    if ((n4 & 0x40000000) != 0) {
                        this.checkForResize();
                        node.tryAwaitLock(atomicReferenceArray, n3);
                        continue;
                    }
                    if (!node.casHash(n4, n4 | 0x40000000)) continue;
                    object3 = null;
                    try {
                        if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n3) != node) break block31;
                        n = 1;
                        object5 = node;
                        while (true) {
                            Object object7;
                            if ((((Node)object5).hash & 0x3FFFFFFF) == n2 && (object7 = ((Node)object5).val) != null && ((object4 = ((Node)object5).key) == object || object.equals(object4))) {
                                object3 = object7;
                                ((Node)object5).val = object2;
                                break;
                            }
                            Node node2 = object5;
                            object5 = ((Node)object5).next;
                            if (object5 == null) {
                                node2.next = new Node(n2, object, object2, null);
                                if (n >= 16) {
                                    this.replaceWithTreeBin(atomicReferenceArray, n3, object);
                                }
                                break;
                            }
                            ++n;
                        }
                    }
                    finally {
                        if (!node.casHash(n4 | 0x40000000, n4)) {
                            node.hash = n4;
                            object5 = node;
                            synchronized (object5) {
                                node.notifyAll();
                            }
                        }
                    }
                }
                if (n != 0) break;
            }
            if (object3 != null) {
                return object3;
            }
            if (atomicReferenceArray.length() <= 64) {
                n = 2;
            }
        }
        this.counter.add(1L);
        if (n > 1) {
            this.checkForResize();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object internalPutIfAbsent(Object object, Object object2) {
        int n;
        block32: {
            Object object3;
            int n2 = ConcurrentHashMapV8.spread(object.hashCode());
            n = 0;
            AtomicReferenceArray atomicReferenceArray = this.table;
            while (true) {
                block34: {
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    Object object8;
                    if (atomicReferenceArray == null) {
                        atomicReferenceArray = this.initTable();
                        continue;
                    }
                    int n3 = atomicReferenceArray.length() - 1 & n2;
                    Node node = ConcurrentHashMapV8.tabAt(atomicReferenceArray, n3);
                    if (node == null) {
                        if (!ConcurrentHashMapV8.casTabAt(atomicReferenceArray, n3, null, new Node(n2, object, object2, null))) continue;
                        break block32;
                    }
                    int n4 = node.hash;
                    if (n4 == Integer.MIN_VALUE) {
                        object8 = node.key;
                        if (object8 instanceof TreeBin) {
                            object7 = (TreeBin)object8;
                            object3 = null;
                            ((AbstractQueuedSynchronizer)object7).acquire(0);
                            try {
                                if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n3) == node) {
                                    n = 2;
                                    object6 = ((TreeBin)object7).putTreeNode(n2, object, object2);
                                    if (object6 != null) {
                                        object3 = ((TreeNode)object6).val;
                                    }
                                }
                            }
                            finally {
                                ((AbstractQueuedSynchronizer)object7).release(0);
                            }
                            if (n == 0) continue;
                            if (object3 != null) {
                                return object3;
                            }
                            break block32;
                        }
                        atomicReferenceArray = (AtomicReferenceArray)object8;
                        continue;
                    }
                    if ((n4 & 0x3FFFFFFF) == n2 && (object5 = node.val) != null && ((object8 = node.key) == object || object.equals(object8))) {
                        return object5;
                    }
                    object7 = node.next;
                    if (object7 != null) {
                        object3 = object7;
                        do {
                            if ((((Node)object3).hash & 0x3FFFFFFF) != n2 || (object4 = ((Node)object3).val) == null || (object6 = ((Node)object3).key) != object && !object.equals(object6)) continue;
                            return object4;
                        } while ((object3 = ((Node)object3).next) != null);
                        this.checkForResize();
                    }
                    if (((n4 = node.hash) & 0x40000000) != 0) {
                        this.checkForResize();
                        node.tryAwaitLock(atomicReferenceArray, n3);
                        continue;
                    }
                    if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n3) != node || !node.casHash(n4, n4 | 0x40000000)) continue;
                    object3 = null;
                    try {
                        if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n3) != node) break block34;
                        n = 1;
                        object6 = node;
                        while (true) {
                            Object object9;
                            if ((((Node)object6).hash & 0x3FFFFFFF) == n2 && (object9 = ((Node)object6).val) != null && ((object4 = ((Node)object6).key) == object || object.equals(object4))) {
                                object3 = object9;
                                break;
                            }
                            Object object10 = object6;
                            object6 = ((Node)object6).next;
                            if (object6 == null) {
                                ((Node)object10).next = new Node(n2, object, object2, null);
                                if (n >= 16) {
                                    this.replaceWithTreeBin(atomicReferenceArray, n3, object);
                                }
                                break;
                            }
                            ++n;
                        }
                    }
                    finally {
                        if (!node.casHash(n4 | 0x40000000, n4)) {
                            node.hash = n4;
                            object6 = node;
                            synchronized (object6) {
                                node.notifyAll();
                            }
                        }
                    }
                }
                if (n != 0) break;
            }
            if (object3 != null) {
                return object3;
            }
            if (atomicReferenceArray.length() <= 64) {
                n = 2;
            }
        }
        this.counter.add(1L);
        if (n > 1) {
            this.checkForResize();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object internalComputeIfAbsent(K k, ConcurrentHashMap.Fun<? super K, ?> fun) {
        int n;
        Object object;
        block50: {
            boolean bl;
            int n2 = ConcurrentHashMapV8.spread(k.hashCode());
            object = null;
            n = 0;
            AtomicReferenceArray atomicReferenceArray = this.table;
            while (true) {
                block52: {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    int n3;
                    if (atomicReferenceArray == null) {
                        atomicReferenceArray = this.initTable();
                        continue;
                    }
                    int n4 = atomicReferenceArray.length() - 1 & n2;
                    Node node = ConcurrentHashMapV8.tabAt(atomicReferenceArray, n4);
                    if (node == null) {
                        n3 = n2 | 0x40000000;
                        object6 = new Node(n3, k, null, null);
                        if (ConcurrentHashMapV8.casTabAt(atomicReferenceArray, n4, null, (Node)object6)) {
                            n = 1;
                            try {
                                Object obj = fun.apply(k);
                                object = obj;
                                if (obj != null) {
                                    ((Node)object6).val = object;
                                }
                            }
                            finally {
                                if (object == null) {
                                    ConcurrentHashMapV8.setTabAt(atomicReferenceArray, n4, null);
                                }
                                if (!((Node)object6).casHash(n3, n2)) {
                                    ((Node)object6).hash = n2;
                                    Object object7 = object6;
                                    synchronized (object7) {
                                        object6.notifyAll();
                                    }
                                }
                            }
                        }
                        if (n == 0) continue;
                        break block50;
                    }
                    n3 = node.hash;
                    if (n3 == Integer.MIN_VALUE) {
                        object5 = node.key;
                        if (object5 instanceof TreeBin) {
                            object6 = (TreeBin)object5;
                            boolean bl2 = false;
                            ((AbstractQueuedSynchronizer)object6).acquire(0);
                            try {
                                if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n4) == node) {
                                    n = 1;
                                    object4 = ((TreeBin)object6).getTreeNode(n2, k, ((TreeBin)object6).root);
                                    if (object4 != null) {
                                        object = ((TreeNode)object4).val;
                                    } else {
                                        object = fun.apply(k);
                                        if (object != null) {
                                            bl2 = true;
                                            n = 2;
                                            ((TreeBin)object6).putTreeNode(n2, k, object);
                                        }
                                    }
                                }
                            }
                            finally {
                                ((AbstractQueuedSynchronizer)object6).release(0);
                            }
                            if (n == 0) continue;
                            if (!bl2) {
                                return object;
                            }
                            break block50;
                        }
                        atomicReferenceArray = (AtomicReferenceArray)object5;
                        continue;
                    }
                    if ((n3 & 0x3FFFFFFF) == n2 && (object3 = node.val) != null && ((object5 = node.key) == k || k.equals(object5))) {
                        return object3;
                    }
                    object6 = node.next;
                    if (object6 != null) {
                        Object object8 = object6;
                        do {
                            if ((((Node)object8).hash & 0x3FFFFFFF) != n2 || (object2 = ((Node)object8).val) == null || (object4 = ((Node)object8).key) != k && !k.equals(object4)) continue;
                            return object2;
                        } while ((object8 = ((Node)object8).next) != null);
                        this.checkForResize();
                    }
                    if (((n3 = node.hash) & 0x40000000) != 0) {
                        this.checkForResize();
                        node.tryAwaitLock(atomicReferenceArray, n4);
                        continue;
                    }
                    if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n4) != node || !node.casHash(n3, n3 | 0x40000000)) continue;
                    bl = false;
                    try {
                        if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n4) != node) break block52;
                        n = 1;
                        object4 = node;
                        while (true) {
                            Object object9;
                            if ((((Node)object4).hash & 0x3FFFFFFF) == n2 && (object9 = ((Node)object4).val) != null && ((object2 = ((Node)object4).key) == k || k.equals(object2))) {
                                object = object9;
                                break;
                            }
                            Object object10 = object4;
                            object4 = ((Node)object4).next;
                            if (object4 == null) {
                                object = fun.apply(k);
                                if (object != null) {
                                    bl = true;
                                    ((Node)object10).next = new Node(n2, k, object, null);
                                    if (n >= 16) {
                                        this.replaceWithTreeBin(atomicReferenceArray, n4, k);
                                    }
                                }
                                break;
                            }
                            ++n;
                        }
                    }
                    finally {
                        if (!node.casHash(n3 | 0x40000000, n3)) {
                            node.hash = n3;
                            object4 = node;
                            synchronized (object4) {
                                node.notifyAll();
                            }
                        }
                    }
                }
                if (n != 0) break;
            }
            if (!bl) {
                return object;
            }
            if (atomicReferenceArray.length() <= 64) {
                n = 2;
            }
        }
        if (object != null) {
            this.counter.add(1L);
            if (n > 1) {
                this.checkForResize();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object internalCompute(K k, boolean bl, ConcurrentHashMap.BiFun<? super K, ? super V, ? extends V> biFun) {
        int n;
        int n2;
        Object var5_5;
        block53: {
            int n3 = ConcurrentHashMapV8.spread(k.hashCode());
            var5_5 = null;
            n2 = 0;
            n = 0;
            AtomicReferenceArray atomicReferenceArray = this.table;
            while (true) {
                block56: {
                    Object object;
                    Object object2;
                    Object object3;
                    int n4;
                    if (atomicReferenceArray == null) {
                        atomicReferenceArray = this.initTable();
                        continue;
                    }
                    int n5 = atomicReferenceArray.length() - 1 & n3;
                    Node node = ConcurrentHashMapV8.tabAt(atomicReferenceArray, n5);
                    if (node == null) {
                        if (bl) break block53;
                        n4 = n3 | 0x40000000;
                        object3 = new Node(n4, k, null, null);
                        if (ConcurrentHashMapV8.casTabAt(atomicReferenceArray, n5, null, (Node)object3)) {
                            try {
                                n = 1;
                                V v = biFun.apply(k, null);
                                var5_5 = v;
                                if (v != null) {
                                    ((Node)object3).val = var5_5;
                                    n2 = 1;
                                }
                            }
                            finally {
                                if (n2 == 0) {
                                    ConcurrentHashMapV8.setTabAt(atomicReferenceArray, n5, null);
                                }
                                if (!((Node)object3).casHash(n4, n3)) {
                                    ((Node)object3).hash = n3;
                                    object2 = object3;
                                    synchronized (object2) {
                                        object3.notifyAll();
                                    }
                                }
                            }
                        }
                        if (n == 0) continue;
                        break block53;
                    }
                    n4 = node.hash;
                    if (n4 == Integer.MIN_VALUE) {
                        Object object4 = node.key;
                        if (object4 instanceof TreeBin) {
                            block55: {
                                object3 = (TreeBin)object4;
                                ((AbstractQueuedSynchronizer)object3).acquire(0);
                                try {
                                    if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n5) != node) break block55;
                                    n = 1;
                                    object2 = ((TreeBin)object3).getTreeNode(n3, k, ((TreeBin)object3).root);
                                    if (object2 == null) {
                                        if (bl) break block53;
                                        object = null;
                                    } else {
                                        object = ((TreeNode)object2).val;
                                    }
                                    V v = biFun.apply(k, object);
                                    var5_5 = v;
                                    if (v != null) {
                                        if (object2 != null) {
                                            ((TreeNode)object2).val = var5_5;
                                        } else {
                                            n = 2;
                                            n2 = 1;
                                            ((TreeBin)object3).putTreeNode(n3, k, var5_5);
                                        }
                                    } else if (object2 != null) {
                                        n2 = -1;
                                        ((TreeBin)object3).deleteTreeNode((TreeNode)object2);
                                    }
                                }
                                finally {
                                    ((AbstractQueuedSynchronizer)object3).release(0);
                                }
                            }
                            if (n == 0) continue;
                            break block53;
                        }
                        atomicReferenceArray = (AtomicReferenceArray)object4;
                        continue;
                    }
                    if ((n4 & 0x40000000) != 0) {
                        this.checkForResize();
                        node.tryAwaitLock(atomicReferenceArray, n5);
                        continue;
                    }
                    if (!node.casHash(n4, n4 | 0x40000000)) continue;
                    try {
                        if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n5) != node) break block56;
                        n = 1;
                        object3 = node;
                        object2 = null;
                        while (true) {
                            Object object5;
                            if ((((Node)object3).hash & 0x3FFFFFFF) == n3 && (object5 = ((Node)object3).val) != null && ((object = ((Node)object3).key) == k || k.equals(object))) {
                                var5_5 = biFun.apply(k, object5);
                                if (var5_5 != null) {
                                    ((Node)object3).val = var5_5;
                                } else {
                                    n2 = -1;
                                    Node node2 = ((Node)object3).next;
                                    if (object2 != null) {
                                        ((Node)object2).next = node2;
                                    } else {
                                        ConcurrentHashMapV8.setTabAt(atomicReferenceArray, n5, node2);
                                    }
                                }
                                break;
                            }
                            object2 = object3;
                            object3 = ((Node)object3).next;
                            if (object3 == null) {
                                if (!bl) {
                                    V v = biFun.apply(k, null);
                                    var5_5 = v;
                                    if (v != null) {
                                        ((Node)object2).next = new Node(n3, k, var5_5, null);
                                        n2 = 1;
                                        if (n >= 16) {
                                            this.replaceWithTreeBin(atomicReferenceArray, n5, k);
                                        }
                                    }
                                }
                                break;
                            }
                            ++n;
                        }
                    }
                    finally {
                        if (!node.casHash(n4 | 0x40000000, n4)) {
                            node.hash = n4;
                            object3 = node;
                            synchronized (object3) {
                                node.notifyAll();
                            }
                        }
                    }
                }
                if (n != 0) break;
            }
            if (atomicReferenceArray.length() <= 64) {
                n = 2;
            }
        }
        if (n2 != 0) {
            this.counter.add(n2);
            if (n > 1) {
                this.checkForResize();
            }
        }
        return var5_5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object internalMerge(K k, V v, ConcurrentHashMap.BiFun<? super V, ? super V, ? extends V> biFun) {
        int n;
        int n2;
        Object var5_5;
        block36: {
            int n3 = ConcurrentHashMapV8.spread(k.hashCode());
            var5_5 = null;
            n2 = 0;
            n = 0;
            AtomicReferenceArray atomicReferenceArray = this.table;
            while (true) {
                block38: {
                    Object object;
                    Object object2;
                    if (atomicReferenceArray == null) {
                        atomicReferenceArray = this.initTable();
                        continue;
                    }
                    int n4 = atomicReferenceArray.length() - 1 & n3;
                    Node node = ConcurrentHashMapV8.tabAt(atomicReferenceArray, n4);
                    if (node == null) {
                        if (!ConcurrentHashMapV8.casTabAt(atomicReferenceArray, n4, null, new Node(n3, k, v, null))) continue;
                        n2 = 1;
                        var5_5 = v;
                        break block36;
                    }
                    int n5 = node.hash;
                    if (n5 == Integer.MIN_VALUE) {
                        Object object3 = node.key;
                        if (object3 instanceof TreeBin) {
                            object2 = (TreeBin)object3;
                            ((AbstractQueuedSynchronizer)object2).acquire(0);
                            try {
                                if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n4) == node) {
                                    n = 1;
                                    object = ((TreeBin)object2).getTreeNode(n3, k, ((TreeBin)object2).root);
                                    var5_5 = (object == null ? v : biFun.apply(((TreeNode)object).val, v));
                                    if (var5_5 != null) {
                                        if (object != null) {
                                            ((TreeNode)object).val = var5_5;
                                        } else {
                                            n = 2;
                                            n2 = 1;
                                            ((TreeBin)object2).putTreeNode(n3, k, var5_5);
                                        }
                                    } else if (object != null) {
                                        n2 = -1;
                                        ((TreeBin)object2).deleteTreeNode((TreeNode)object);
                                    }
                                }
                            }
                            finally {
                                ((AbstractQueuedSynchronizer)object2).release(0);
                            }
                            if (n == 0) continue;
                            break block36;
                        }
                        atomicReferenceArray = (AtomicReferenceArray)object3;
                        continue;
                    }
                    if ((n5 & 0x40000000) != 0) {
                        this.checkForResize();
                        node.tryAwaitLock(atomicReferenceArray, n4);
                        continue;
                    }
                    if (!node.casHash(n5, n5 | 0x40000000)) continue;
                    try {
                        if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n4) != node) break block38;
                        n = 1;
                        object2 = node;
                        object = null;
                        while (true) {
                            Object object4;
                            Object object5;
                            if ((((Node)object2).hash & 0x3FFFFFFF) == n3 && (object5 = ((Node)object2).val) != null && ((object4 = ((Node)object2).key) == k || k.equals(object4))) {
                                var5_5 = biFun.apply(object5, v);
                                if (var5_5 != null) {
                                    ((Node)object2).val = var5_5;
                                } else {
                                    n2 = -1;
                                    Node node2 = ((Node)object2).next;
                                    if (object != null) {
                                        ((Node)object).next = node2;
                                    } else {
                                        ConcurrentHashMapV8.setTabAt(atomicReferenceArray, n4, node2);
                                    }
                                }
                                break;
                            }
                            object = object2;
                            object2 = ((Node)object2).next;
                            if (object2 == null) {
                                var5_5 = v;
                                ((Node)object).next = new Node(n3, k, var5_5, null);
                                n2 = 1;
                                if (n >= 16) {
                                    this.replaceWithTreeBin(atomicReferenceArray, n4, k);
                                }
                                break;
                            }
                            ++n;
                        }
                    }
                    finally {
                        if (!node.casHash(n5 | 0x40000000, n5)) {
                            node.hash = n5;
                            object2 = node;
                            synchronized (object2) {
                                node.notifyAll();
                            }
                        }
                    }
                }
                if (n != 0) break;
            }
            if (atomicReferenceArray.length() <= 64) {
                n = 2;
            }
        }
        if (n2 != 0) {
            this.counter.add(n2);
            if (n > 1) {
                this.checkForResize();
            }
        }
        return var5_5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void internalPutAll(Map<?, ?> map) {
        this.tryPresize(map.size());
        long l = 0L;
        boolean bl = false;
        try {
            block15: for (Map.Entry<?, ?> entry : map.entrySet()) {
                int n;
                Object obj;
                Object obj2;
                if (entry == null || (obj2 = entry.getKey()) == null || (obj = entry.getValue()) == null) {
                    bl = true;
                    break;
                }
                int n2 = ConcurrentHashMapV8.spread(obj2.hashCode());
                AtomicReferenceArray atomicReferenceArray = this.table;
                while (true) {
                    block35: {
                        Object object;
                        if (atomicReferenceArray == null) {
                            atomicReferenceArray = this.initTable();
                            continue;
                        }
                        int n3 = atomicReferenceArray.length() - 1 & n2;
                        Node node = ConcurrentHashMapV8.tabAt(atomicReferenceArray, n3);
                        if (node == null) {
                            if (!ConcurrentHashMapV8.casTabAt(atomicReferenceArray, n3, null, new Node(n2, obj2, obj, null))) continue;
                            ++l;
                            continue block15;
                        }
                        int n4 = node.hash;
                        if (n4 == Integer.MIN_VALUE) {
                            Object object2 = node.key;
                            if (object2 instanceof TreeBin) {
                                TreeBin treeBin = (TreeBin)object2;
                                boolean bl2 = false;
                                treeBin.acquire(0);
                                try {
                                    if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n3) == node) {
                                        bl2 = true;
                                        object = treeBin.getTreeNode(n2, obj2, treeBin.root);
                                        if (object != null) {
                                            ((TreeNode)object).val = obj;
                                        } else {
                                            treeBin.putTreeNode(n2, obj2, obj);
                                            ++l;
                                        }
                                    }
                                }
                                finally {
                                    treeBin.release(0);
                                }
                                if (!bl2) continue;
                                continue block15;
                            }
                            atomicReferenceArray = (AtomicReferenceArray)object2;
                            continue;
                        }
                        if ((n4 & 0x40000000) != 0) {
                            this.counter.add(l);
                            l = 0L;
                            this.checkForResize();
                            node.tryAwaitLock(atomicReferenceArray, n3);
                            continue;
                        }
                        if (!node.casHash(n4, n4 | 0x40000000)) continue;
                        n = 0;
                        try {
                            if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n3) != node) break block35;
                            n = 1;
                            Node node2 = node;
                            while (true) {
                                Object object3;
                                if ((node2.hash & 0x3FFFFFFF) == n2 && (object3 = node2.val) != null && ((object = node2.key) == obj2 || obj2.equals(object))) {
                                    node2.val = obj;
                                    break;
                                }
                                Node node3 = node2;
                                node2 = node2.next;
                                if (node2 == null) {
                                    ++l;
                                    node3.next = new Node(n2, obj2, obj, null);
                                    if (n >= 16) {
                                        this.replaceWithTreeBin(atomicReferenceArray, n3, obj2);
                                    }
                                    break;
                                }
                                ++n;
                            }
                        }
                        finally {
                            if (!node.casHash(n4 | 0x40000000, n4)) {
                                node.hash = n4;
                                Node node4 = node;
                                synchronized (node4) {
                                    node.notifyAll();
                                }
                            }
                        }
                    }
                    if (n != 0) break;
                }
                if (n <= true) continue;
                this.counter.add(l);
                l = 0L;
                this.checkForResize();
            }
        }
        finally {
            if (l != 0L) {
                this.counter.add(l);
            }
        }
        if (bl) {
            throw new NullPointerException();
        }
    }

    private static final int tableSizeFor(int n) {
        int n2 = n - 1;
        n2 |= n2 >>> 1;
        n2 |= n2 >>> 2;
        n2 |= n2 >>> 4;
        n2 |= n2 >>> 8;
        return (n2 |= n2 >>> 16) < 0 ? 1 : (n2 >= 0x40000000 ? 0x40000000 : n2 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AtomicReferenceArray<Node> initTable() {
        AtomicReferenceArray<Node> atomicReferenceArray;
        while ((atomicReferenceArray = this.table) == null) {
            int n = this.sizeCtl;
            if (n < 0) {
                Thread.yield();
                continue;
            }
            if (!SIZE_CTRL_UPDATER.compareAndSet(this, n, -1)) continue;
            try {
                atomicReferenceArray = this.table;
                if (atomicReferenceArray != null) break;
                int n2 = n > 0 ? n : 16;
                atomicReferenceArray = this.table = new AtomicReferenceArray(n2);
                n = n2 - (n2 >>> 2);
                break;
            }
            finally {
                this.sizeCtl = n;
            }
        }
        return atomicReferenceArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkForResize() {
        int n;
        int n2;
        AtomicReferenceArray<Node> atomicReferenceArray;
        while ((atomicReferenceArray = this.table) != null && (n2 = atomicReferenceArray.length()) < 0x40000000 && (n = this.sizeCtl) >= 0 && this.counter.sum() >= (long)n && SIZE_CTRL_UPDATER.compareAndSet(this, n, -1)) {
            try {
                if (atomicReferenceArray != this.table) continue;
                this.table = ConcurrentHashMapV8.rebuild(atomicReferenceArray);
                n = (n2 << 1) - (n2 >>> 1);
            }
            finally {
                this.sizeCtl = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryPresize(int n) {
        int n2;
        int n3;
        int n4 = n3 = n >= 0x20000000 ? 0x40000000 : ConcurrentHashMapV8.tableSizeFor(n + (n >>> 1) + 1);
        while ((n2 = this.sizeCtl) >= 0) {
            int n5;
            AtomicReferenceArray<Node> atomicReferenceArray = this.table;
            if (atomicReferenceArray == null || (n5 = atomicReferenceArray.length()) == 0) {
                int n6 = n5 = n2 > n3 ? n2 : n3;
                if (!SIZE_CTRL_UPDATER.compareAndSet(this, n2, -1)) continue;
                try {
                    if (this.table != atomicReferenceArray) continue;
                    this.table = new AtomicReferenceArray(n5);
                    n2 = n5 - (n5 >>> 2);
                    continue;
                }
                finally {
                    this.sizeCtl = n2;
                    continue;
                }
            }
            if (n3 <= n2 || n5 >= 0x40000000) break;
            if (!SIZE_CTRL_UPDATER.compareAndSet(this, n2, -1)) continue;
            try {
                if (this.table != atomicReferenceArray) continue;
                this.table = ConcurrentHashMapV8.rebuild(atomicReferenceArray);
                n2 = (n5 << 1) - (n5 >>> 1);
            }
            finally {
                this.sizeCtl = n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final AtomicReferenceArray<Node> rebuild(AtomicReferenceArray<Node> atomicReferenceArray) {
        int n;
        int n2 = atomicReferenceArray.length();
        AtomicReferenceArray<Node> atomicReferenceArray2 = new AtomicReferenceArray<Node>(n2 << 1);
        Node node = new Node(Integer.MIN_VALUE, atomicReferenceArray2, null, null);
        int[] nArray = null;
        Node node2 = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = n = n2 - 1;
        while (true) {
            Object object;
            Object object2;
            Node node3;
            if ((node3 = ConcurrentHashMapV8.tabAt(atomicReferenceArray, n5)) == null) {
                if (n >= 0) {
                    if (!ConcurrentHashMapV8.casTabAt(atomicReferenceArray, n5, node3, node)) {
                        continue;
                    }
                } else {
                    object2 = new Node(-1073741824, atomicReferenceArray2, null, null);
                    if (!ConcurrentHashMapV8.casTabAt(atomicReferenceArray, n5, node3, (Node)object2)) continue;
                    ConcurrentHashMapV8.setTabAt(atomicReferenceArray2, n5, null);
                    ConcurrentHashMapV8.setTabAt(atomicReferenceArray2, n5 + n2, null);
                    ConcurrentHashMapV8.setTabAt(atomicReferenceArray, n5, node);
                    if (!((Node)object2).casHash(-1073741824, Integer.MIN_VALUE)) {
                        ((Node)object2).hash = Integer.MIN_VALUE;
                        object = object2;
                        synchronized (object) {
                            object2.notifyAll();
                        }
                    }
                }
            } else {
                int n6 = node3.hash;
                if (n6 == Integer.MIN_VALUE) {
                    object2 = node3.key;
                    if (object2 instanceof TreeBin) {
                        object = (TreeBin)object2;
                        boolean bl = false;
                        ((AbstractQueuedSynchronizer)object).acquire(0);
                        try {
                            if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n5) == node3) {
                                bl = true;
                                ConcurrentHashMapV8.splitTreeBin(atomicReferenceArray2, n5, (TreeBin)object);
                                ConcurrentHashMapV8.setTabAt(atomicReferenceArray, n5, node);
                            }
                        }
                        finally {
                            ((AbstractQueuedSynchronizer)object).release(0);
                        }
                        if (!bl) {
                            continue;
                        }
                    }
                } else if ((n6 & 0x40000000) == 0 && node3.casHash(n6, n6 | 0x40000000)) {
                    boolean bl = false;
                    try {
                        if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n5) == node3) {
                            bl = true;
                            ConcurrentHashMapV8.splitBin(atomicReferenceArray2, n5, node3);
                            ConcurrentHashMapV8.setTabAt(atomicReferenceArray, n5, node);
                        }
                    }
                    finally {
                        if (!node3.casHash(n6 | 0x40000000, n6)) {
                            node3.hash = n6;
                            object = node3;
                            synchronized (object) {
                                node3.notifyAll();
                            }
                        }
                    }
                    if (!bl) {
                        continue;
                    }
                } else {
                    if (nArray == null) {
                        nArray = new int[32];
                    }
                    if (n < 0 && n4 > 0) {
                        int n7 = nArray[--n4];
                        nArray[n4] = n5;
                        n5 = n7;
                        continue;
                    }
                    if (n < 0 || n3 >= 32) {
                        node3.tryAwaitLock(atomicReferenceArray, n5);
                        continue;
                    }
                    if (node2 == null) {
                        node2 = new Node(Integer.MIN_VALUE, atomicReferenceArray, null, null);
                    }
                    if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n5) != node3 || (node3.hash & 0x40000000) == 0) continue;
                    nArray[n3++] = n5;
                    ConcurrentHashMapV8.setTabAt(atomicReferenceArray2, n5, node2);
                    ConcurrentHashMapV8.setTabAt(atomicReferenceArray2, n5 + n2, node2);
                }
            }
            if (n > 0) {
                n5 = --n;
                continue;
            }
            if (nArray == null || n3 <= 0) break;
            n = -1;
            n4 = --n3;
            n5 = nArray[n4];
        }
        return atomicReferenceArray2;
    }

    private static void splitBin(AtomicReferenceArray<Node> atomicReferenceArray, int n, Node node) {
        int n2;
        int n3 = atomicReferenceArray.length() >>> 1;
        int n4 = node.hash & n3;
        Node node2 = node;
        Node node3 = null;
        Node node4 = null;
        Node node5 = node.next;
        while (node5 != null) {
            n2 = node5.hash & n3;
            if (n2 != n4) {
                n4 = n2;
                node2 = node5;
            }
            node5 = node5.next;
        }
        if (n4 == 0) {
            node3 = node2;
        } else {
            node4 = node2;
        }
        node5 = node;
        while (node5 != node2) {
            n2 = node5.hash & 0x3FFFFFFF;
            Object object = node5.key;
            Object object2 = node5.val;
            if ((n2 & n3) == 0) {
                node3 = new Node(n2, object, object2, node3);
            } else {
                node4 = new Node(n2, object, object2, node4);
            }
            node5 = node5.next;
        }
        ConcurrentHashMapV8.setTabAt(atomicReferenceArray, n, node3);
        ConcurrentHashMapV8.setTabAt(atomicReferenceArray, n + n3, node4);
    }

    private static void splitTreeBin(AtomicReferenceArray<Node> atomicReferenceArray, int n, TreeBin treeBin) {
        Node node;
        Object object;
        int n2 = atomicReferenceArray.length() >>> 1;
        TreeBin treeBin2 = new TreeBin();
        TreeBin treeBin3 = new TreeBin();
        int n3 = 0;
        int n4 = 0;
        Node node2 = treeBin.first;
        while (node2 != null) {
            int n5 = node2.hash & 0x3FFFFFFF;
            object = node2.key;
            Object object2 = node2.val;
            if ((n5 & n2) == 0) {
                ++n3;
                treeBin2.putTreeNode(n5, object, object2);
            } else {
                ++n4;
                treeBin3.putTreeNode(n5, object, object2);
            }
            node2 = node2.next;
        }
        if (n3 <= 8) {
            node2 = null;
            object = treeBin2.first;
            while (object != null) {
                node2 = new Node(((Node)object).hash, ((Node)object).key, ((Node)object).val, node2);
                object = ((Node)object).next;
            }
        } else {
            node2 = new Node(Integer.MIN_VALUE, treeBin2, null, null);
        }
        ConcurrentHashMapV8.setTabAt(atomicReferenceArray, n, node2);
        if (n4 <= 8) {
            node = null;
            object = treeBin3.first;
            while (object != null) {
                node = new Node(((Node)object).hash, ((Node)object).key, ((Node)object).val, node);
                object = ((Node)object).next;
            }
        } else {
            node = new Node(Integer.MIN_VALUE, treeBin3, null, null);
        }
        ConcurrentHashMapV8.setTabAt(atomicReferenceArray, n + n2, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void internalClear() {
        long l = 0L;
        int n = 0;
        AtomicReferenceArray atomicReferenceArray = this.table;
        while (atomicReferenceArray != null && n < atomicReferenceArray.length()) {
            Object object;
            Node node = ConcurrentHashMapV8.tabAt(atomicReferenceArray, n);
            if (node == null) {
                ++n;
                continue;
            }
            int n2 = node.hash;
            if (n2 == Integer.MIN_VALUE) {
                Object object2 = node.key;
                if (object2 instanceof TreeBin) {
                    object = (TreeBin)object2;
                    ((AbstractQueuedSynchronizer)object).acquire(0);
                    try {
                        if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n) != node) continue;
                        Node node2 = ((TreeBin)object).first;
                        while (node2 != null) {
                            if (node2.val != null) {
                                node2.val = null;
                                --l;
                            }
                            node2 = node2.next;
                        }
                        ((TreeBin)object).first = null;
                        ((TreeBin)object).root = null;
                        ++n;
                        continue;
                    }
                    finally {
                        ((AbstractQueuedSynchronizer)object).release(0);
                        continue;
                    }
                }
                atomicReferenceArray = (AtomicReferenceArray)object2;
                continue;
            }
            if ((n2 & 0x40000000) != 0) {
                this.counter.add(l);
                l = 0L;
                node.tryAwaitLock(atomicReferenceArray, n);
                continue;
            }
            if (!node.casHash(n2, n2 | 0x40000000)) continue;
            try {
                if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n) != node) continue;
                object = node;
                while (object != null) {
                    if (((Node)object).val != null) {
                        ((Node)object).val = null;
                        --l;
                    }
                    object = ((Node)object).next;
                }
                ConcurrentHashMapV8.setTabAt(atomicReferenceArray, n, null);
                ++n;
            }
            finally {
                if (node.casHash(n2 | 0x40000000, n2)) continue;
                node.hash = n2;
                object = node;
                synchronized (object) {
                    node.notifyAll();
                }
            }
        }
        if (l != 0L) {
            this.counter.add(l);
        }
    }

    public ConcurrentHashMapV8() {
        this.counter = new LongAdder();
    }

    public ConcurrentHashMapV8(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = n >= 0x20000000 ? 0x40000000 : ConcurrentHashMapV8.tableSizeFor(n + (n >>> 1) + 1);
        this.counter = new LongAdder();
        this.sizeCtl = n2;
    }

    public ConcurrentHashMapV8(Map<? extends K, ? extends V> map) {
        this.counter = new LongAdder();
        this.sizeCtl = 16;
        this.internalPutAll(map);
    }

    public ConcurrentHashMapV8(int n, float f) {
        this(n, f, 1);
    }

    public ConcurrentHashMapV8(int n, float f, int n2) {
        long l;
        if (!(f > 0.0f) || n < 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n < n2) {
            n = n2;
        }
        int n3 = (l = (long)(1.0 + (double)((float)n / f))) >= 0x40000000L ? 0x40000000 : ConcurrentHashMapV8.tableSizeFor((int)l);
        this.counter = new LongAdder();
        this.sizeCtl = n3;
    }

    public static <K> KeySetView<K, Boolean> newKeySet() {
        return new KeySetView<K, Boolean>(new ConcurrentHashMapV8(), Boolean.TRUE);
    }

    public static <K> KeySetView<K, Boolean> newKeySet(int n) {
        return new KeySetView<K, Boolean>(new ConcurrentHashMapV8(n), Boolean.TRUE);
    }

    @Override
    public boolean isEmpty() {
        return this.counter.sum() <= 0L;
    }

    @Override
    public int size() {
        long l = this.counter.sum();
        return l < 0L ? 0 : (l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l);
    }

    public long mappingCount() {
        long l = this.counter.sum();
        return l < 0L ? 0L : l;
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return (V)this.internalGet(object);
    }

    @Override
    public V getValueOrDefault(Object object, V v) {
        if (object == null) {
            throw new NullPointerException();
        }
        Object object2 = this.internalGet(object);
        return (V)(object2 == null ? v : object2);
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return this.internalGet(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        Object v;
        if (object == null) {
            throw new NullPointerException();
        }
        Traverser traverser = new Traverser(this);
        while ((v = traverser.advance()) != null) {
            if (v != object && !object.equals(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public K findKey(Object object) {
        Object v;
        if (object == null) {
            throw new NullPointerException();
        }
        Traverser traverser = new Traverser(this);
        while ((v = traverser.advance()) != null) {
            if (v != object && !object.equals(v)) continue;
            return traverser.nextKey;
        }
        return null;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public V put(K k, V v) {
        if (k == null || v == null) {
            throw new NullPointerException();
        }
        return (V)this.internalPut(k, v);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        if (k == null || v == null) {
            throw new NullPointerException();
        }
        return (V)this.internalPutIfAbsent(k, v);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.internalPutAll(map);
    }

    @Override
    public V computeIfAbsent(K k, ConcurrentHashMap.Fun<? super K, ? extends V> fun) {
        if (k == null || fun == null) {
            throw new NullPointerException();
        }
        return (V)this.internalComputeIfAbsent(k, fun);
    }

    @Override
    public V computeIfPresent(K k, ConcurrentHashMap.BiFun<? super K, ? super V, ? extends V> biFun) {
        if (k == null || biFun == null) {
            throw new NullPointerException();
        }
        return (V)this.internalCompute(k, true, biFun);
    }

    @Override
    public V compute(K k, ConcurrentHashMap.BiFun<? super K, ? super V, ? extends V> biFun) {
        if (k == null || biFun == null) {
            throw new NullPointerException();
        }
        return (V)this.internalCompute(k, false, biFun);
    }

    @Override
    public V merge(K k, V v, ConcurrentHashMap.BiFun<? super V, ? super V, ? extends V> biFun) {
        if (k == null || v == null || biFun == null) {
            throw new NullPointerException();
        }
        return (V)this.internalMerge(k, v, biFun);
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return (V)this.internalReplace(object, null, null);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object2 == null) {
            return false;
        }
        return this.internalReplace(object, null, object2) != null;
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        if (k == null || v == null || v2 == null) {
            throw new NullPointerException();
        }
        return this.internalReplace(k, v2, v) != null;
    }

    @Override
    public V replace(K k, V v) {
        if (k == null || v == null) {
            throw new NullPointerException();
        }
        return (V)this.internalReplace(k, v, null);
    }

    @Override
    public void clear() {
        this.internalClear();
    }

    public KeySetView<K, V> keySet() {
        KeySetView<K, V> keySetView = this.keySet;
        return keySetView != null ? keySetView : (this.keySet = new KeySetView(this, null));
    }

    public KeySetView<K, V> keySet(V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        return new KeySetView(this, v);
    }

    public ValuesView<K, V> values() {
        ValuesView<K, V> valuesView = this.values;
        return valuesView != null ? valuesView : (this.values = new ValuesView(this));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySetView<K, V> entrySetView = this.entrySet;
        return entrySetView != null ? entrySetView : (this.entrySet = new EntrySetView(this));
    }

    public Enumeration<K> keys() {
        return new KeyIterator(this);
    }

    public Enumeration<V> elements() {
        return new ValueIterator(this);
    }

    public Spliterator<K> keySpliterator() {
        return new KeyIterator(this);
    }

    public Spliterator<V> valueSpliterator() {
        return new ValueIterator(this);
    }

    public Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return new EntryIterator(this);
    }

    @Override
    public int hashCode() {
        Object v;
        int n = 0;
        Traverser traverser = new Traverser(this);
        while ((v = traverser.advance()) != null) {
            n += traverser.nextKey.hashCode() ^ v.hashCode();
        }
        return n;
    }

    public String toString() {
        Traverser traverser = new Traverser(this);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        Object v = traverser.advance();
        if (v != null) {
            while (true) {
                Object k;
                stringBuilder.append((Object)((k = traverser.nextKey) == this ? "(this Map)" : k));
                stringBuilder.append('=');
                stringBuilder.append((Object)(v == this ? "(this Map)" : v));
                v = traverser.advance();
                if (v == null) break;
                stringBuilder.append(',').append(' ');
            }
        }
        return stringBuilder.append('}').toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object != this) {
            Object v;
            if (!(object instanceof Map)) {
                return false;
            }
            Map map = (Map)object;
            Traverser traverser = new Traverser(this);
            while ((v = traverser.advance()) != null) {
                Iterator iterator = map.get(traverser.nextKey);
                if (iterator != null && (iterator == v || iterator.equals(v))) continue;
                return false;
            }
            for (Map.Entry entry : map.entrySet()) {
                Object object2;
                Object v2;
                Object k = entry.getKey();
                if (k != null && (v2 = entry.getValue()) != null && (object2 = this.internalGet(k)) != null && (v2 == object2 || v2.equals(object2))) continue;
                return false;
            }
        }
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object v;
        if (this.segments == null) {
            this.segments = new Segment[16];
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i] = new Segment(0.75f);
            }
        }
        objectOutputStream.defaultWriteObject();
        Traverser traverser = new Traverser(this);
        while ((v = traverser.advance()) != null) {
            objectOutputStream.writeObject(traverser.nextKey);
            objectOutputStream.writeObject(v);
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
        this.segments = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        objectInputStream.defaultReadObject();
        this.segments = null;
        this.counter = new LongAdder();
        long l = 0L;
        Node node = null;
        while (true) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (object == null || object2 == null) break;
            n = ConcurrentHashMapV8.spread(object.hashCode());
            node = new Node(n, object, object2, node);
            ++l;
        }
        if (node != null) {
            int n2;
            boolean bl = false;
            if (l >= 0x20000000L) {
                n2 = 0x40000000;
            } else {
                n = (int)l;
                n2 = ConcurrentHashMapV8.tableSizeFor(n + (n >>> 1) + 1);
            }
            n = this.sizeCtl;
            boolean bl2 = false;
            if (n2 > n && SIZE_CTRL_UPDATER.compareAndSet(this, n, -1)) {
                Node node2;
                int n3;
                int n4;
                AtomicReferenceArray<Object> atomicReferenceArray;
                try {
                    if (this.table == null) {
                        bl = true;
                        atomicReferenceArray = new AtomicReferenceArray(n2);
                        n4 = n2 - 1;
                        while (node != null) {
                            n3 = node.hash & n4;
                            node2 = node.next;
                            Node node3 = node.next = ConcurrentHashMapV8.tabAt(atomicReferenceArray, n3);
                            ConcurrentHashMapV8.setTabAt(atomicReferenceArray, n3, node);
                            if (!bl2 && node3 != null && node3.hash == node.hash) {
                                bl2 = true;
                            }
                            node = node2;
                        }
                        this.table = atomicReferenceArray;
                        this.counter.add(l);
                        n = n2 - (n2 >>> 2);
                    }
                }
                finally {
                    this.sizeCtl = n;
                }
                if (bl2) {
                    atomicReferenceArray = this.table;
                    block5: for (n4 = 0; n4 < atomicReferenceArray.length(); ++n4) {
                        n3 = 0;
                        node2 = ConcurrentHashMapV8.tabAt(atomicReferenceArray, n4);
                        while (node2 != null) {
                            if (++n3 > 16 && node2.key instanceof Comparable) {
                                this.replaceWithTreeBin(atomicReferenceArray, n4, node2.key);
                                continue block5;
                            }
                            node2 = node2.next;
                        }
                    }
                }
            }
            if (!bl) {
                while (node != null) {
                    this.internalPut(node.key, node.val);
                    node = node.next;
                }
            }
        }
    }

    public static final class EntrySetView<K, V>
    extends CHMView<K, V>
    implements Set<Map.Entry<K, V>> {
        EntrySetView(ConcurrentHashMapV8<K, V> concurrentHashMapV8) {
            super(concurrentHashMapV8);
        }

        @Override
        public final boolean contains(Object object) {
            Object v;
            Object v2;
            Map.Entry entry;
            Object k;
            return object instanceof Map.Entry && (k = (entry = (Map.Entry)object).getKey()) != null && (v2 = this.map.get(k)) != null && (v = entry.getValue()) != null && (v == v2 || v.equals(v2));
        }

        @Override
        public final boolean remove(Object object) {
            Object v;
            Map.Entry entry;
            Object k;
            return object instanceof Map.Entry && (k = (entry = (Map.Entry)object).getKey()) != null && (v = entry.getValue()) != null && this.map.remove(k, v);
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.map);
        }

        @Override
        public final boolean add(Map.Entry<K, V> entry) {
            K k = entry.getKey();
            V v = entry.getValue();
            if (k == null || v == null) {
                throw new NullPointerException();
            }
            return this.map.internalPut(k, v) == null;
        }

        @Override
        public final boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
            boolean bl = false;
            for (Map.Entry<K, V> entry : collection) {
                if (!this.add(entry)) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean equals(Object object) {
            Set set;
            return object instanceof Set && ((set = (Set)object) == this || this.containsAll(set) && set.containsAll(this));
        }
    }

    public static final class ValuesView<K, V>
    extends CHMView<K, V>
    implements Collection<V> {
        ValuesView(ConcurrentHashMapV8<K, V> concurrentHashMapV8) {
            super(concurrentHashMapV8);
        }

        @Override
        public final boolean contains(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        public final boolean remove(Object object) {
            if (object != null) {
                ValueIterator valueIterator = new ValueIterator(this.map);
                while (valueIterator.hasNext()) {
                    if (!object.equals(valueIterator.next())) continue;
                    valueIterator.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator(this.map);
        }

        @Override
        public final boolean add(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends V> collection) {
            throw new UnsupportedOperationException();
        }
    }

    public static class KeySetView<K, V>
    extends CHMView<K, V>
    implements Set<K>,
    Serializable {
        private static final long serialVersionUID = 7249069246763182397L;
        private final V value;

        KeySetView(ConcurrentHashMapV8<K, V> concurrentHashMapV8, V v) {
            super(concurrentHashMapV8);
            this.value = v;
        }

        public V getMappedValue() {
            return this.value;
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.map.remove(object) != null;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(this.map);
        }

        @Override
        public boolean add(K k) {
            V v = this.value;
            if (v == null) {
                throw new UnsupportedOperationException();
            }
            if (k == null) {
                throw new NullPointerException();
            }
            return this.map.internalPutIfAbsent(k, v) == null;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            boolean bl = false;
            V v = this.value;
            if (v == null) {
                throw new UnsupportedOperationException();
            }
            for (K k : collection) {
                if (k == null) {
                    throw new NullPointerException();
                }
                if (this.map.internalPutIfAbsent(k, v) != null) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean equals(Object object) {
            Set set;
            return object instanceof Set && ((set = (Set)object) == this || this.containsAll(set) && set.containsAll(this));
        }
    }

    static abstract class CHMView<K, V> {
        final ConcurrentHashMapV8<K, V> map;
        private static final String oomeMsg = "Required array size too large";

        CHMView(ConcurrentHashMapV8<K, V> concurrentHashMapV8) {
            this.map = concurrentHashMapV8;
        }

        public ConcurrentHashMapV8<K, V> getMap() {
            return this.map;
        }

        public final int size() {
            return this.map.size();
        }

        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        public final void clear() {
            this.map.clear();
        }

        public abstract Iterator<?> iterator();

        public abstract boolean contains(Object var1);

        public abstract boolean remove(Object var1);

        public final Object[] toArray() {
            long l = this.map.mappingCount();
            if (l > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(oomeMsg);
            }
            int n = (int)l;
            Object[] objectArray = new Object[n];
            int n2 = 0;
            Iterator<?> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (n2 == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(oomeMsg);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    objectArray = Arrays.copyOf(objectArray, n);
                }
                objectArray[n2++] = iterator.next();
            }
            return n2 == n ? objectArray : Arrays.copyOf(objectArray, n2);
        }

        public final <T> T[] toArray(T[] TArray) {
            long l = this.map.mappingCount();
            if (l > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(oomeMsg);
            }
            int n = (int)l;
            T[] TArray2 = TArray.length >= n ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
            int n2 = TArray2.length;
            int n3 = 0;
            Iterator<?> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (n3 == n2) {
                    if (n2 >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(oomeMsg);
                    }
                    n2 = n2 >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n2 += (n2 >>> 1) + 1);
                    TArray2 = Arrays.copyOf(TArray2, n2);
                }
                TArray2[n3++] = iterator.next();
            }
            if (TArray == TArray2 && n3 < n2) {
                TArray2[n3] = null;
                return TArray2;
            }
            return n3 == n2 ? TArray2 : Arrays.copyOf(TArray2, n3);
        }

        public final int hashCode() {
            int n = 0;
            Iterator<?> iterator = this.iterator();
            while (iterator.hasNext()) {
                n += iterator.next().hashCode();
            }
            return n;
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            Iterator<?> iterator = this.iterator();
            if (iterator.hasNext()) {
                while (true) {
                    Object obj;
                    stringBuilder.append((Object)((obj = iterator.next()) == this ? "(this Collection)" : obj));
                    if (!iterator.hasNext()) break;
                    stringBuilder.append(',').append(' ');
                }
            }
            return stringBuilder.append(']').toString();
        }

        public final boolean containsAll(Collection<?> collection) {
            if (collection != this) {
                for (Object obj : collection) {
                    if (obj != null && this.contains(obj)) continue;
                    return false;
                }
            }
            return true;
        }

        public final boolean removeAll(Collection<?> collection) {
            boolean bl = false;
            Iterator<?> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        public final boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Iterator<?> iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }
    }

    public static interface IntByIntToInt {
        public int apply(int var1, int var2);
    }

    public static interface LongByLongToLong {
        public long apply(long var1, long var3);
    }

    public static interface DoubleByDoubleToDouble {
        public double apply(double var1, double var3);
    }

    public static interface IntToInt {
        public int apply(int var1);
    }

    public static interface LongToLong {
        public long apply(long var1);
    }

    public static interface DoubleToDouble {
        public double apply(double var1);
    }

    public static interface ObjectByObjectToInt<A, B> {
        public int apply(A var1, B var2);
    }

    public static interface ObjectByObjectToLong<A, B> {
        public long apply(A var1, B var2);
    }

    public static interface ObjectByObjectToDouble<A, B> {
        public double apply(A var1, B var2);
    }

    public static interface ObjectToInt<A> {
        public int apply(A var1);
    }

    public static interface ObjectToLong<A> {
        public long apply(A var1);
    }

    public static interface ObjectToDouble<A> {
        public double apply(A var1);
    }

    public static interface Generator<T> {
        public T apply();
    }

    public static interface BiAction<A, B> {
        public void apply(A var1, B var2);
    }

    public static interface Action<A> {
        public void apply(A var1);
    }

    static class Segment<K, V>
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        final float loadFactor;

        Segment(float f) {
            this.loadFactor = f;
        }
    }

    static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V val;
        final ConcurrentHashMapV8<K, V> map;

        MapEntry(K k, V v, ConcurrentHashMapV8<K, V> concurrentHashMapV8) {
            this.key = k;
            this.val = v;
            this.map = concurrentHashMapV8;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.val;
        }

        @Override
        public final int hashCode() {
            return this.key.hashCode() ^ this.val.hashCode();
        }

        public final String toString() {
            return this.key + "=" + this.val;
        }

        @Override
        public final boolean equals(Object object) {
            Object v;
            Map.Entry entry;
            Object k;
            return !(!(object instanceof Map.Entry) || (k = (entry = (Map.Entry)object).getKey()) == null || (v = entry.getValue()) == null || k != this.key && !k.equals(this.key) || v != this.val && !v.equals(this.val));
        }

        @Override
        public final V setValue(V v) {
            if (v == null) {
                throw new NullPointerException();
            }
            V v2 = this.val;
            this.val = v;
            this.map.put(this.key, v);
            return v2;
        }
    }

    static final class EntryIterator<K, V>
    extends Traverser<K, V, Object>
    implements Spliterator<Map.Entry<K, V>> {
        EntryIterator(ConcurrentHashMapV8<K, V> concurrentHashMapV8) {
            super(concurrentHashMapV8);
        }

        EntryIterator(Traverser<K, V, Object> traverser) {
            super(traverser);
        }

        public EntryIterator<K, V> split() {
            if (this.nextKey != null) {
                throw new IllegalStateException();
            }
            return new EntryIterator<K, V>(this);
        }

        @Override
        public final Map.Entry<K, V> next() {
            Object object = this.nextVal;
            if (object == null && (object = this.advance()) == null) {
                throw new NoSuchElementException();
            }
            Object object2 = this.nextKey;
            this.nextVal = null;
            return new MapEntry<Object, Object>(object2, object, this.map);
        }
    }

    static final class ValueIterator<K, V>
    extends Traverser<K, V, Object>
    implements Spliterator<V>,
    Enumeration<V> {
        ValueIterator(ConcurrentHashMapV8<K, V> concurrentHashMapV8) {
            super(concurrentHashMapV8);
        }

        ValueIterator(Traverser<K, V, Object> traverser) {
            super(traverser);
        }

        public ValueIterator<K, V> split() {
            if (this.nextKey != null) {
                throw new IllegalStateException();
            }
            return new ValueIterator<K, V>(this);
        }

        @Override
        public final V next() {
            Object object = this.nextVal;
            if (object == null && (object = this.advance()) == null) {
                throw new NoSuchElementException();
            }
            this.nextVal = null;
            return (V)object;
        }

        @Override
        public final V nextElement() {
            return this.next();
        }
    }

    static final class KeyIterator<K, V>
    extends Traverser<K, V, Object>
    implements Spliterator<K>,
    Enumeration<K> {
        KeyIterator(ConcurrentHashMapV8<K, V> concurrentHashMapV8) {
            super(concurrentHashMapV8);
        }

        KeyIterator(Traverser<K, V, Object> traverser) {
            super(traverser);
        }

        public KeyIterator<K, V> split() {
            if (this.nextKey != null) {
                throw new IllegalStateException();
            }
            return new KeyIterator<K, V>(this);
        }

        @Override
        public final K next() {
            if (this.nextVal == null && this.advance() == null) {
                throw new NoSuchElementException();
            }
            Object object = this.nextKey;
            this.nextVal = null;
            return (K)object;
        }

        @Override
        public final K nextElement() {
            return this.next();
        }
    }

    static class Traverser<K, V, R> {
        final ConcurrentHashMapV8<K, V> map;
        Node next;
        K nextKey;
        V nextVal;
        AtomicReferenceArray<Node> tab;
        int index;
        int baseIndex;
        int baseLimit;
        int baseSize;

        Traverser(ConcurrentHashMapV8<K, V> concurrentHashMapV8) {
            this.map = concurrentHashMapV8;
        }

        Traverser(Traverser<K, V, ?> traverser) {
            AtomicReferenceArray<Node> atomicReferenceArray;
            ConcurrentHashMapV8<K, V> concurrentHashMapV8 = this.map = traverser.map;
            if (this.map == null) {
                atomicReferenceArray = null;
            } else {
                atomicReferenceArray = traverser.tab;
                if (atomicReferenceArray == null) {
                    atomicReferenceArray = traverser.tab = concurrentHashMapV8.table;
                    if (traverser.tab != null) {
                        traverser.baseLimit = traverser.baseSize = atomicReferenceArray.length();
                    }
                }
            }
            this.tab = atomicReferenceArray;
            this.baseSize = traverser.baseSize;
            this.baseLimit = traverser.baseLimit;
            this.index = this.baseIndex = this.baseLimit + traverser.baseIndex + 1 >>> 1;
            traverser.baseLimit = this.baseIndex;
        }

        final V advance() {
            Node node = this.next;
            Object object = null;
            block0: do {
                if (node != null) {
                    node = node.next;
                }
                while (node == null) {
                    int n;
                    int n2;
                    int n3;
                    AtomicReferenceArray<Node> atomicReferenceArray = this.tab;
                    if (atomicReferenceArray != null) {
                        n3 = atomicReferenceArray.length();
                    } else {
                        ConcurrentHashMapV8<K, V> concurrentHashMapV8 = this.map;
                        if (concurrentHashMapV8 == null) break block0;
                        atomicReferenceArray = this.tab = concurrentHashMapV8.table;
                        if (this.tab == null) break block0;
                        this.baseLimit = this.baseSize = atomicReferenceArray.length();
                        n3 = this.baseSize;
                    }
                    int n4 = this.baseIndex;
                    if (n4 >= this.baseLimit || (n2 = this.index) < 0 || n2 >= n3) break block0;
                    node = ConcurrentHashMapV8.tabAt(atomicReferenceArray, n2);
                    if (node != null && node.hash == Integer.MIN_VALUE) {
                        Object object2 = node.key;
                        if (object2 instanceof TreeBin) {
                            node = ((TreeBin)object2).first;
                        } else {
                            this.tab = (AtomicReferenceArray)object2;
                            continue;
                        }
                    }
                    if ((n2 += this.baseSize) < n3) {
                        n = n2;
                    } else {
                        n = n4 + 1;
                        this.baseIndex = this.baseIndex;
                    }
                    this.index = n;
                }
                this.nextKey = node.key;
            } while ((object = node.val) == null);
            this.next = node;
            this.nextVal = object;
            return this.nextVal;
        }

        public final void remove() {
            K k = this.nextKey;
            if (k == null && (this.advance() == null || (k = this.nextKey) == null)) {
                throw new IllegalStateException();
            }
            ((ConcurrentHashMapV8)this.map).internalReplace(k, null, null);
        }

        public final boolean hasNext() {
            return this.nextVal != null || this.advance() != null;
        }

        public final boolean hasMoreElements() {
            return this.hasNext();
        }

        public final void setRawResult(Object object) {
        }

        public R getRawResult() {
            return null;
        }

        public boolean exec() {
            return true;
        }
    }

    static final class TreeBin
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 2249069246763182397L;
        transient TreeNode root;
        transient TreeNode first;

        TreeBin() {
        }

        @Override
        public final boolean isHeldExclusively() {
            return this.getState() > 0;
        }

        @Override
        public final boolean tryAcquire(int n) {
            if (this.compareAndSetState(0, 1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        public final boolean tryRelease(int n) {
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        @Override
        public final int tryAcquireShared(int n) {
            int n2;
            do {
                if ((n2 = this.getState()) <= 0) continue;
                return -1;
            } while (!this.compareAndSetState(n2, n2 - 1));
            return 1;
        }

        @Override
        public final boolean tryReleaseShared(int n) {
            int n2;
            while (!this.compareAndSetState(n2 = this.getState(), n2 + 1)) {
            }
            return n2 == -1;
        }

        private void rotateLeft(TreeNode treeNode) {
            if (treeNode != null) {
                TreeNode treeNode2 = treeNode.right;
                TreeNode treeNode3 = treeNode.right = treeNode2.left;
                if (treeNode.right != null) {
                    treeNode3.parent = treeNode;
                }
                TreeNode treeNode4 = treeNode2.parent = treeNode.parent;
                if (treeNode2.parent == null) {
                    this.root = treeNode2;
                } else if (treeNode4.left == treeNode) {
                    treeNode4.left = treeNode2;
                } else {
                    treeNode4.right = treeNode2;
                }
                treeNode2.left = treeNode;
                treeNode.parent = treeNode2;
            }
        }

        private void rotateRight(TreeNode treeNode) {
            if (treeNode != null) {
                TreeNode treeNode2 = treeNode.left;
                TreeNode treeNode3 = treeNode.left = treeNode2.right;
                if (treeNode.left != null) {
                    treeNode3.parent = treeNode;
                }
                TreeNode treeNode4 = treeNode2.parent = treeNode.parent;
                if (treeNode2.parent == null) {
                    this.root = treeNode2;
                } else if (treeNode4.right == treeNode) {
                    treeNode4.right = treeNode2;
                } else {
                    treeNode4.left = treeNode2;
                }
                treeNode2.right = treeNode;
                treeNode.parent = treeNode2;
            }
        }

        final TreeNode getTreeNode(int n, Object object, TreeNode treeNode) {
            return this.getTreeNode(n, (RubyObject)object, treeNode);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final TreeNode getTreeNode(int n, RubyObject rubyObject, TreeNode treeNode) {
            boolean bl;
            RubyClass rubyClass = rubyObject.getMetaClass();
            boolean bl2 = bl = !rubyObject.respondsTo("<=>");
            while (treeNode != null) {
                int n2;
                int n3 = treeNode.hash;
                if (n3 == n) {
                    RubyObject rubyObject2 = (RubyObject)treeNode.key;
                    if (rubyObject2 == rubyObject || rubyObject.equals((Object)rubyObject2)) {
                        return treeNode;
                    }
                    RubyClass rubyClass2 = rubyObject2.getMetaClass();
                    if (rubyClass != rubyClass2 || bl || (n2 = this.rubyCompare(rubyObject, rubyObject2)) == 0) {
                        int n4 = n2 = rubyClass == rubyClass2 ? 0 : rubyClass.getName().compareTo(rubyClass2.getName());
                        if (n2 == 0) {
                            TreeNode treeNode2 = null;
                            TreeNode treeNode3 = treeNode.right;
                            if (treeNode3 != null && n >= treeNode3.hash && (treeNode2 = this.getTreeNode(n, rubyObject, treeNode3)) != null) {
                                return treeNode2;
                            }
                            TreeNode treeNode4 = treeNode.left;
                            if (treeNode4 == null || n > treeNode4.hash) return null;
                            n2 = -1;
                        }
                    }
                } else {
                    n2 = n < n3 ? -1 : 1;
                }
                treeNode = n2 > 0 ? treeNode.right : treeNode.left;
            }
            return null;
        }

        int rubyCompare(RubyObject rubyObject, RubyObject rubyObject2) {
            IRubyObject iRubyObject;
            ThreadContext threadContext = rubyObject.getMetaClass().getRuntime().getCurrentContext();
            try {
                iRubyObject = rubyObject.callMethod(threadContext, "<=>", (IRubyObject)rubyObject2);
            }
            catch (RaiseException raiseException) {
                if (threadContext.runtime.getNoMethodError().isInstance((IRubyObject)raiseException.getException())) {
                    return 0;
                }
                throw raiseException;
            }
            return iRubyObject.isNil() ? 0 : RubyNumeric.num2int((IRubyObject)iRubyObject.convertToInteger());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Object getValue(int n, Object object) {
            TreeNode treeNode = null;
            int n2 = this.getState();
            Node node = this.first;
            while (node != null) {
                if (n2 <= 0 && this.compareAndSetState(n2, n2 - 1)) {
                    try {
                        treeNode = this.getTreeNode(n, object, this.root);
                        break;
                    }
                    finally {
                        this.releaseShared(0);
                    }
                }
                if ((node.hash & 0x3FFFFFFF) == n && object.equals(node.key)) {
                    treeNode = node;
                    break;
                }
                n2 = this.getState();
                node = node.next;
            }
            return treeNode == null ? null : treeNode.val;
        }

        final TreeNode putTreeNode(int n, Object object, Object object2) {
            return this.putTreeNode(n, (RubyObject)object, object2);
        }

        final TreeNode putTreeNode(int n, RubyObject rubyObject, Object object) {
            TreeNode treeNode;
            TreeNode treeNode2;
            Object object2;
            Object object3;
            RubyClass rubyClass = rubyObject.getMetaClass();
            boolean bl = !rubyObject.respondsTo("<=>");
            TreeNode treeNode3 = this.root;
            TreeNode treeNode4 = null;
            int n2 = 0;
            while (treeNode3 != null) {
                treeNode4 = treeNode3;
                int n3 = treeNode4.hash;
                if (n3 == n) {
                    object3 = (RubyObject)treeNode4.key;
                    if (object3 == rubyObject || rubyObject.equals(object3)) {
                        return treeNode4;
                    }
                    object2 = object3.getMetaClass();
                    if (rubyClass != object2 || bl || (n2 = this.rubyCompare(rubyObject, (RubyObject)object3)) == 0) {
                        int n4 = n2 = rubyClass == object2 ? 0 : rubyClass.getName().compareTo(object2.getName());
                        if (n2 == 0) {
                            treeNode2 = null;
                            treeNode = treeNode4.right;
                            if (treeNode != null && n >= treeNode.hash && (treeNode2 = this.getTreeNode(n, rubyObject, treeNode)) != null) {
                                return treeNode2;
                            }
                            n2 = -1;
                        }
                    }
                } else {
                    n2 = n < n3 ? -1 : 1;
                }
                treeNode3 = n2 > 0 ? treeNode4.right : treeNode4.left;
            }
            TreeNode treeNode5 = this.first;
            this.first = new TreeNode(n, rubyObject, object, treeNode5, treeNode4);
            object3 = this.first;
            if (treeNode4 == null) {
                this.root = object3;
            } else {
                if (treeNode5 != null) {
                    treeNode5.prev = object3;
                }
                if (n2 <= 0) {
                    treeNode4.left = object3;
                } else {
                    treeNode4.right = object3;
                }
                object3.red = true;
                while (object3 != null && (object2 = object3.parent) != null && object2.red && (treeNode2 = object2.parent) != null) {
                    TreeNode treeNode6;
                    treeNode = treeNode2.left;
                    if (object2 == treeNode) {
                        treeNode6 = treeNode2.right;
                        if (treeNode6 != null && treeNode6.red) {
                            treeNode6.red = false;
                            object2.red = false;
                            treeNode2.red = true;
                            object3 = treeNode2;
                            continue;
                        }
                        if (object3 == object2.right) {
                            object3 = object2;
                            this.rotateLeft((TreeNode)object3);
                            object2 = object3.parent;
                            TreeNode treeNode7 = treeNode2 = object2 == null ? null : object2.parent;
                        }
                        if (object2 == null) continue;
                        object2.red = false;
                        if (treeNode2 == null) continue;
                        treeNode2.red = true;
                        this.rotateRight(treeNode2);
                        continue;
                    }
                    treeNode6 = treeNode;
                    if (treeNode6 != null && treeNode6.red) {
                        treeNode6.red = false;
                        object2.red = false;
                        treeNode2.red = true;
                        object3 = treeNode2;
                        continue;
                    }
                    if (object3 == object2.left) {
                        object3 = object2;
                        this.rotateRight((TreeNode)object3);
                        object2 = object3.parent;
                        TreeNode treeNode8 = treeNode2 = object2 == null ? null : object2.parent;
                    }
                    if (object2 == null) continue;
                    object2.red = false;
                    if (treeNode2 == null) continue;
                    treeNode2.red = true;
                    this.rotateLeft(treeNode2);
                }
                treeNode = this.root;
                if (treeNode != null && treeNode.red) {
                    treeNode.red = false;
                }
            }
            return null;
        }

        final void deleteTreeNode(TreeNode treeNode) {
            TreeNode treeNode2;
            TreeNode treeNode3;
            TreeNode treeNode4;
            TreeNode treeNode5;
            TreeNode treeNode6;
            TreeNode treeNode7;
            TreeNode treeNode8 = (TreeNode)treeNode.next;
            TreeNode treeNode9 = treeNode.prev;
            if (treeNode9 == null) {
                this.first = treeNode8;
            } else {
                treeNode9.next = treeNode8;
            }
            if (treeNode8 != null) {
                treeNode8.prev = treeNode9;
            }
            TreeNode treeNode10 = treeNode.left;
            TreeNode treeNode11 = treeNode.right;
            if (treeNode10 != null && treeNode11 != null) {
                treeNode7 = treeNode11;
                while ((treeNode6 = treeNode7.left) != null) {
                    treeNode7 = treeNode6;
                }
                boolean bl = treeNode7.red;
                treeNode7.red = treeNode.red;
                treeNode.red = bl;
                treeNode5 = treeNode7.right;
                treeNode4 = treeNode.parent;
                if (treeNode7 == treeNode11) {
                    treeNode.parent = treeNode7;
                    treeNode7.right = treeNode;
                } else {
                    treeNode3 = treeNode7.parent;
                    treeNode.parent = treeNode3;
                    if (treeNode.parent != null) {
                        if (treeNode7 == treeNode3.left) {
                            treeNode3.left = treeNode;
                        } else {
                            treeNode3.right = treeNode;
                        }
                    }
                    if ((treeNode7.right = treeNode11) != null) {
                        treeNode11.parent = treeNode7;
                    }
                }
                treeNode.left = null;
                treeNode.right = treeNode5;
                if (treeNode.right != null) {
                    treeNode5.parent = treeNode;
                }
                if ((treeNode7.left = treeNode10) != null) {
                    treeNode10.parent = treeNode7;
                }
                if ((treeNode7.parent = treeNode4) == null) {
                    this.root = treeNode7;
                } else if (treeNode == treeNode4.left) {
                    treeNode4.left = treeNode7;
                } else {
                    treeNode4.right = treeNode7;
                }
                treeNode2 = treeNode5;
            } else {
                treeNode2 = treeNode10 != null ? treeNode10 : treeNode11;
            }
            treeNode7 = treeNode.parent;
            if (treeNode2 == null) {
                if (treeNode7 == null) {
                    this.root = null;
                    return;
                }
                treeNode2 = treeNode;
            } else {
                treeNode2.parent = treeNode7;
                if (treeNode7 == null) {
                    this.root = treeNode2;
                } else if (treeNode == treeNode7.left) {
                    treeNode7.left = treeNode2;
                } else {
                    treeNode7.right = treeNode2;
                }
                treeNode.parent = null;
                treeNode.right = null;
                treeNode.left = null;
            }
            if (!treeNode.red) {
                treeNode6 = treeNode2;
                while (treeNode6 != null) {
                    TreeNode treeNode12;
                    TreeNode treeNode13;
                    if (treeNode6.red || (treeNode13 = treeNode6.parent) == null) {
                        treeNode6.red = false;
                        break;
                    }
                    treeNode5 = treeNode13.left;
                    if (treeNode6 == treeNode5) {
                        treeNode4 = treeNode13.right;
                        if (treeNode4 != null && treeNode4.red) {
                            treeNode4.red = false;
                            treeNode13.red = true;
                            this.rotateLeft(treeNode13);
                            treeNode13 = treeNode6.parent;
                            TreeNode treeNode14 = treeNode4 = treeNode13 == null ? null : treeNode13.right;
                        }
                        if (treeNode4 == null) {
                            treeNode6 = treeNode13;
                            continue;
                        }
                        treeNode3 = treeNode4.left;
                        treeNode12 = treeNode4.right;
                        if (!(treeNode12 != null && treeNode12.red || treeNode3 != null && treeNode3.red)) {
                            treeNode4.red = true;
                            treeNode6 = treeNode13;
                            continue;
                        }
                        if (treeNode12 == null || !treeNode12.red) {
                            if (treeNode3 != null) {
                                treeNode3.red = false;
                            }
                            treeNode4.red = true;
                            this.rotateRight(treeNode4);
                            treeNode13 = treeNode6.parent;
                            TreeNode treeNode15 = treeNode4 = treeNode13 == null ? null : treeNode13.right;
                        }
                        if (treeNode4 != null) {
                            treeNode4.red = treeNode13 == null ? false : treeNode13.red;
                            treeNode12 = treeNode4.right;
                            if (treeNode12 != null) {
                                treeNode12.red = false;
                            }
                        }
                        if (treeNode13 != null) {
                            treeNode13.red = false;
                            this.rotateLeft(treeNode13);
                        }
                        treeNode6 = this.root;
                        continue;
                    }
                    treeNode4 = treeNode5;
                    if (treeNode4 != null && treeNode4.red) {
                        treeNode4.red = false;
                        treeNode13.red = true;
                        this.rotateRight(treeNode13);
                        treeNode13 = treeNode6.parent;
                        TreeNode treeNode16 = treeNode4 = treeNode13 == null ? null : treeNode13.left;
                    }
                    if (treeNode4 == null) {
                        treeNode6 = treeNode13;
                        continue;
                    }
                    treeNode3 = treeNode4.left;
                    treeNode12 = treeNode4.right;
                    if (!(treeNode3 != null && treeNode3.red || treeNode12 != null && treeNode12.red)) {
                        treeNode4.red = true;
                        treeNode6 = treeNode13;
                        continue;
                    }
                    if (treeNode3 == null || !treeNode3.red) {
                        if (treeNode12 != null) {
                            treeNode12.red = false;
                        }
                        treeNode4.red = true;
                        this.rotateLeft(treeNode4);
                        treeNode13 = treeNode6.parent;
                        TreeNode treeNode17 = treeNode4 = treeNode13 == null ? null : treeNode13.left;
                    }
                    if (treeNode4 != null) {
                        treeNode4.red = treeNode13 == null ? false : treeNode13.red;
                        treeNode3 = treeNode4.left;
                        if (treeNode3 != null) {
                            treeNode3.red = false;
                        }
                    }
                    if (treeNode13 != null) {
                        treeNode13.red = false;
                        this.rotateRight(treeNode13);
                    }
                    treeNode6 = this.root;
                }
            }
            if (treeNode == treeNode2 && (treeNode7 = treeNode.parent) != null) {
                if (treeNode == treeNode7.left) {
                    treeNode7.left = null;
                } else if (treeNode == treeNode7.right) {
                    treeNode7.right = null;
                }
                treeNode.parent = null;
            }
        }
    }

    static final class TreeNode
    extends Node {
        TreeNode parent;
        TreeNode left;
        TreeNode right;
        TreeNode prev;
        boolean red;

        TreeNode(int n, Object object, Object object2, Node node, TreeNode treeNode) {
            super(n, object, object2, node);
            this.parent = treeNode;
        }
    }

    static class Node {
        volatile int hash;
        final Object key;
        volatile Object val;
        volatile Node next;
        static AtomicIntegerFieldUpdater HASH_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Node.class, "hash");
        static final int MAX_SPINS = Runtime.getRuntime().availableProcessors() > 1 ? 64 : 1;

        Node(int n, Object object, Object object2, Node node) {
            this.hash = n;
            this.key = object;
            this.val = object2;
            this.next = node;
        }

        final boolean casHash(int n, int n2) {
            return HASH_UPDATER.compareAndSet(this, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void tryAwaitLock(AtomicReferenceArray<Node> atomicReferenceArray, int n) {
            if (atomicReferenceArray != null && n >= 0 && n < atomicReferenceArray.length()) {
                int n2;
                int n3 = ThreadLocalRandom.current().nextInt();
                int n4 = MAX_SPINS;
                while (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n) == this && ((n2 = this.hash) & 0x40000000) != 0) {
                    if (n4 >= 0) {
                        n3 ^= n3 << 1;
                        n3 ^= n3 >>> 3;
                        if ((n3 ^= n3 << 10) < 0 || --n4 != 0) continue;
                        Thread.yield();
                        continue;
                    }
                    if (!this.casHash(n2, n2 | 0xC0000000)) continue;
                    Node node = this;
                    synchronized (node) {
                        if (ConcurrentHashMapV8.tabAt(atomicReferenceArray, n) == this && (this.hash & 0xC0000000) == -1073741824) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                        } else {
                            this.notifyAll();
                        }
                        break;
                    }
                }
            }
        }
    }

    public static interface Spliterator<T>
    extends Iterator<T> {
        public Spliterator<T> split();
    }
}

