/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableWindow;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.logical.LogicalWindow;

class EnumerableWindowRule
extends ConverterRule {
    EnumerableWindowRule() {
        super(LogicalWindow.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableWindowRule");
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalWindow winAgg = (LogicalWindow)rel;
        RelTraitSet traitSet = winAgg.getTraitSet().replace(EnumerableConvention.INSTANCE);
        RelNode child = winAgg.getInput();
        RelNode convertedChild = EnumerableWindowRule.convert(child, child.getTraitSet().replace(EnumerableConvention.INSTANCE));
        return new EnumerableWindow(rel.getCluster(), traitSet, convertedChild, winAgg.getConstants(), winAgg.getRowType(), (List<Window.Group>)winAgg.groups);
    }
}

