/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io;

import java.util.HashMap;
import java.util.Map;

public class ClassificationEvaluation {
    private long truePositive;
    private long falsePositive;
    private long trueNegative;
    private long falseNegative;

    public void count(int actual, int predicted) {
        if (predicted == 1) {
            if (actual == 1) {
                ++this.truePositive;
            } else {
                ++this.falsePositive;
            }
        } else if (actual == 0) {
            ++this.trueNegative;
        } else {
            ++this.falseNegative;
        }
    }

    public void putToMap(Map map) {
        map.put("truePositive_i", this.truePositive);
        map.put("trueNegative_i", this.trueNegative);
        map.put("falsePositive_i", this.falsePositive);
        map.put("falseNegative_i", this.falseNegative);
    }

    public Map toMap() {
        HashMap map = new HashMap();
        this.putToMap(map);
        return map;
    }

    public static ClassificationEvaluation create(Map map) {
        ClassificationEvaluation evaluation = new ClassificationEvaluation();
        evaluation.addEvaluation(map);
        return evaluation;
    }

    public void addEvaluation(Map map) {
        this.truePositive += ((Long)map.get("truePositive_i")).longValue();
        this.trueNegative += ((Long)map.get("trueNegative_i")).longValue();
        this.falsePositive += ((Long)map.get("falsePositive_i")).longValue();
        this.falseNegative += ((Long)map.get("falseNegative_i")).longValue();
    }

    public double getPrecision() {
        if (this.truePositive + this.falsePositive == 0L) {
            return 0.0;
        }
        return (double)this.truePositive / (double)(this.truePositive + this.falsePositive);
    }

    public double getRecall() {
        if (this.truePositive + this.falseNegative == 0L) {
            return 0.0;
        }
        return (double)this.truePositive / (double)(this.truePositive + this.falseNegative);
    }

    public double getF1() {
        double recall;
        double precision = this.getPrecision();
        if (precision + (recall = this.getRecall()) == 0.0) {
            return 0.0;
        }
        return 2.0 * (precision * recall) / (precision + recall);
    }

    public double getAccuracy() {
        return (double)(this.truePositive + this.trueNegative) / (double)(this.truePositive + this.trueNegative + this.falseNegative + this.falsePositive);
    }
}

