/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.secret.store.backend;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileLock;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.secret.SecretIdentifier;
import org.logstash.secret.store.SecretStore;
import org.logstash.secret.store.SecretStoreException;
import org.logstash.secret.store.SecretStoreFactory;
import org.logstash.secret.store.SecretStoreUtil;
import org.logstash.secret.store.SecureConfig;

public final class JavaKeyStore
implements SecretStore {
    private static final String KEYSTORE_TYPE = "pkcs12";
    private static final Logger LOGGER = LogManager.getLogger(JavaKeyStore.class);
    private static final String PATH_KEY = "keystore.file";
    private final CharsetEncoder asciiEncoder = StandardCharsets.US_ASCII.newEncoder();
    private KeyStore keyStore;
    private char[] keyStorePass;
    private Path keyStorePath;
    private KeyStore.ProtectionParameter protectionParameter;
    private Lock lock;
    private boolean useDefaultPass = false;
    static String filePermissions = "rw-r--r--";
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");

    @Override
    public JavaKeyStore create(SecureConfig config) {
        if (this.exists(config)) {
            throw new SecretStoreException.AlreadyExistsException(String.format("Logstash keystore at %s already exists.", new String(config.getPlainText(PATH_KEY))));
        }
        try {
            this.init(config);
            this.lock.lock();
            LOGGER.debug("Creating new keystore at {}.", (Object)this.keyStorePath.toAbsolutePath());
            String keyStorePermissions = filePermissions;
            Files.createFile(this.keyStorePath, new FileAttribute[0]);
            try {
                this.keyStore = KeyStore.Builder.newInstance(KEYSTORE_TYPE, null, this.protectionParameter).getKeyStore();
                SecretKeyFactory factory = SecretKeyFactory.getInstance("PBE");
                byte[] base64 = SecretStoreUtil.base64Encode(SecretStoreFactory.LOGSTASH_MARKER.getKey().getBytes(StandardCharsets.UTF_8));
                SecretKey secretKey = factory.generateSecret(new PBEKeySpec(SecretStoreUtil.asciiBytesToChar(base64)));
                this.keyStore.setEntry(SecretStoreFactory.LOGSTASH_MARKER.toExternalForm(), new KeyStore.SecretKeyEntry(secretKey), this.protectionParameter);
                this.saveKeyStore();
                PosixFileAttributeView attrs = Files.getFileAttributeView(this.keyStorePath, PosixFileAttributeView.class, new LinkOption[0]);
                if (attrs != null) {
                    attrs.setPermissions(PosixFilePermissions.fromString(keyStorePermissions));
                }
                LOGGER.info("Created Logstash keystore at {}", (Object)this.keyStorePath.toAbsolutePath());
                JavaKeyStore javaKeyStore = this;
                return javaKeyStore;
            }
            catch (Exception e) {
                try {
                    throw new SecretStoreException.CreateException("Failed to create Logstash keystore.", e);
                }
                catch (SecretStoreException sse) {
                    throw sse;
                }
                catch (AccessDeniedException | NoSuchFileException fe) {
                    throw new SecretStoreException.CreateException("Error while trying to create the Logstash keystore. Please ensure that path to " + this.keyStorePath.toAbsolutePath() + " exists and is writable", fe);
                }
                catch (Exception e2) {
                    throw new SecretStoreException.UnknownException("Error while trying to create the Logstash keystore. ", e2);
                }
            }
        }
        finally {
            this.releaseLock(this.lock);
            config.clearValues();
        }
    }

    @Override
    public void delete(SecureConfig config) {
        try {
            this.initLocks();
            this.lock.lock();
            if (this.exists(config)) {
                Files.delete(Paths.get(new String(config.getPlainText(PATH_KEY)), new String[0]));
            }
        }
        catch (SecretStoreException sse) {
            throw sse;
        }
        catch (Exception e) {
            throw new SecretStoreException.UnknownException("Error while trying to delete the Logstash keystore", e);
        }
        finally {
            this.releaseLock(this.lock);
            config.clearValues();
        }
    }

    @Override
    public boolean exists(SecureConfig config) {
        char[] path = config.getPlainText(PATH_KEY);
        if (!this.valid(path)) {
            LOGGER.warn("keystore.file configuration is not defined");
            return false;
        }
        return new File(new String(path)).exists();
    }

    protected void finalize() throws Throwable {
        SecretStoreUtil.clearChars(this.keyStorePass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private char[] getKeyStorePassword(SecureConfig config) throws IOException {
        char[] plainText = config.getPlainText("keystore.pass");
        boolean existing = this.exists(config);
        if (config.has("keystore.pass") && (plainText == null || plainText.length == 0)) {
            String message = String.format("Empty keystore passwords are not allowed. Please ensure configured password is not empty for Logstash keystore %s.", this.keyStorePath.toAbsolutePath());
            if (!existing) throw new SecretStoreException.CreateException(message);
            throw new SecretStoreException.AccessException(message);
        }
        boolean bl = this.useDefaultPass = !config.has("keystore.pass");
        if (!this.useDefaultPass) return this.asciiEncoder.canEncode((CharSequence)CharBuffer.wrap(plainText)) ? plainText : SecretStoreUtil.base64Encode(plainText);
        if (existing) {
            SeekableByteChannel byteChannel = Files.newByteChannel(this.keyStorePath, StandardOpenOption.READ);
            if (byteChannel.size() <= 1L) throw new SecretStoreException.AccessException(String.format("Could not determine keystore password. Please ensure the file at %s is a valid Logstash keystore", this.keyStorePath.toAbsolutePath()));
            byteChannel.position(byteChannel.size() - 1L);
            ByteBuffer byteBuffer = ByteBuffer.allocate(1);
            byteChannel.read(byteBuffer);
            int size = byteBuffer.array()[0] & 0xFF;
            if (size <= 0 || byteChannel.size() < (long)(size + 1)) throw new SecretStoreException.AccessException(String.format("Could not determine keystore password. Please ensure the file at %s is a valid Logstash keystore", this.keyStorePath.toAbsolutePath()));
            byteBuffer = ByteBuffer.allocate(size);
            byteChannel.position(byteChannel.size() - (long)size - 1L);
            byteChannel.read(byteBuffer);
            return SecretStoreUtil.deObfuscate(SecretStoreUtil.asciiBytesToChar(byteBuffer.array()));
        }
        byte[] randomBytes = new byte[32];
        new Random().nextBytes(randomBytes);
        return SecretStoreUtil.base64EncodeToChars(randomBytes);
    }

    private void init(SecureConfig config) throws IOException, KeyStoreException {
        char[] path = config.getPlainText(PATH_KEY);
        if (!this.valid(path)) {
            throw new IllegalArgumentException("Logstash keystore path must be defined");
        }
        this.keyStorePath = Paths.get(new String(path), new String[0]);
        this.keyStorePass = this.getKeyStorePassword(config);
        this.keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        this.protectionParameter = new KeyStore.PasswordProtection(this.keyStorePass);
        this.initLocks();
    }

    private void initLocks() {
        this.lock = new ReentrantLock();
    }

    @Override
    public Collection<SecretIdentifier> list() {
        HashSet<SecretIdentifier> identifiers = new HashSet<SecretIdentifier>();
        try {
            this.lock.lock();
            this.loadKeyStore();
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                identifiers.add(SecretIdentifier.fromExternalForm(alias));
            }
        }
        catch (Exception e) {
            throw new SecretStoreException.ListException(e);
        }
        finally {
            this.releaseLock(this.lock);
        }
        return identifiers;
    }

    /*
     * Exception decompiling
     */
    @Override
    public JavaKeyStore load(SecureConfig config) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadKeyStore() throws CertificateException, NoSuchAlgorithmException, IOException {
        try (InputStream is = Files.newInputStream(this.keyStorePath, new OpenOption[0]);){
            this.keyStore.load(is, this.keyStorePass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistSecret(SecretIdentifier identifier, byte[] secret) {
        try {
            this.lock.lock();
            this.loadKeyStore();
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBE");
            byte[] base64 = SecretStoreUtil.base64Encode(secret);
            PBEKeySpec passwordBasedKeySpec = new PBEKeySpec(SecretStoreUtil.asciiBytesToChar(base64));
            SecretKey secretKey = factory.generateSecret(passwordBasedKeySpec);
            this.keyStore.setEntry(identifier.toExternalForm(), new KeyStore.SecretKeyEntry(secretKey), this.protectionParameter);
            try {
                this.saveKeyStore();
            }
            finally {
                passwordBasedKeySpec.clearPassword();
                SecretStoreUtil.clearBytes(secret);
            }
            LOGGER.debug("persisted secret {}", (Object)identifier.toExternalForm());
        }
        catch (Exception e) {
            throw new SecretStoreException.PersistException(identifier, (Throwable)e);
        }
        finally {
            this.releaseLock(this.lock);
        }
    }

    @Override
    public void purgeSecret(SecretIdentifier identifier) {
        try {
            this.lock.lock();
            this.loadKeyStore();
            this.keyStore.deleteEntry(identifier.toExternalForm());
            this.saveKeyStore();
            LOGGER.debug("purged secret {}", (Object)identifier.toExternalForm());
        }
        catch (Exception e) {
            throw new SecretStoreException.PurgeException(identifier, (Throwable)e);
        }
        finally {
            this.releaseLock(this.lock);
        }
    }

    private void releaseLock(Lock lock) {
        if (lock != null) {
            lock.unlock();
        }
    }

    @Override
    public byte[] retrieveSecret(SecretIdentifier identifier) {
        if (identifier != null && identifier.getKey() != null && !identifier.getKey().isEmpty()) {
            try {
                this.lock.lock();
                this.loadKeyStore();
                SecretKeyFactory factory = SecretKeyFactory.getInstance("PBE");
                KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)this.keyStore.getEntry(identifier.toExternalForm(), this.protectionParameter);
                if (secretKeyEntry == null) {
                    LOGGER.debug("requested secret {} not found", (Object)identifier.toExternalForm());
                    byte[] byArray = null;
                    return byArray;
                }
                PBEKeySpec passwordBasedKeySpec = (PBEKeySpec)factory.getKeySpec(secretKeyEntry.getSecretKey(), PBEKeySpec.class);
                char[] base64secret = passwordBasedKeySpec.getPassword();
                byte[] secret = SecretStoreUtil.base64Decode(base64secret);
                passwordBasedKeySpec.clearPassword();
                LOGGER.debug("retrieved secret {}", (Object)identifier.toExternalForm());
                byte[] byArray = secret;
                return byArray;
            }
            catch (Exception e) {
                throw new SecretStoreException.RetrievalException(identifier, (Throwable)e);
            }
            finally {
                this.releaseLock(this.lock);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveKeyStore() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        FileLock fileLock = null;
        try (FileOutputStream appendOs = new FileOutputStream(this.keyStorePath.toFile(), true);){
            if (!IS_WINDOWS && (fileLock = appendOs.getChannel().tryLock()) == null) {
                throw new IllegalStateException("Can not save Logstash keystore. Some other process has locked on the file: " + this.keyStorePath.toAbsolutePath());
            }
            try (OutputStream os = Files.newOutputStream(this.keyStorePath, StandardOpenOption.WRITE);){
                this.keyStore.store(os, this.keyStorePass);
            }
            if (this.useDefaultPass) {
                byte[] obfuscatedPass = SecretStoreUtil.asciiCharToBytes(SecretStoreUtil.obfuscate((char[])this.keyStorePass.clone()));
                DataOutputStream dataOutputStream = new DataOutputStream(appendOs);
                appendOs.write(obfuscatedPass);
                dataOutputStream.write(obfuscatedPass.length);
            }
        }
        finally {
            if (fileLock != null && fileLock.isValid()) {
                fileLock.release();
            }
        }
    }

    private boolean valid(char[] chars) {
        return chars != null && chars.length != 0;
    }
}

