/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.logstash.Event;
import org.logstash.KeyNode;
import org.logstash.ObjectMappers;
import org.logstash.Timestamp;

public final class StringInterpolation {
    private static final ThreadLocal<StringBuilder> STRING_BUILDER = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }

        @Override
        public StringBuilder get() {
            StringBuilder b = (StringBuilder)super.get();
            b.setLength(0);
            return b;
        }
    };

    private StringInterpolation() {
    }

    public static String evaluate(co.elastic.logstash.api.Event event, String template) throws JsonProcessingException {
        if (event instanceof Event) {
            return StringInterpolation.evaluate((Event)event, template);
        }
        throw new IllegalStateException("Unknown event concrete class: " + event.getClass().getName());
    }

    public static String evaluate(Event event, String template) throws JsonProcessingException {
        int open = template.indexOf("%{");
        int close = template.indexOf(125, open);
        if (open == -1 || close == -1) {
            return template;
        }
        StringBuilder builder = STRING_BUILDER.get();
        int pos = 0;
        while (open > -1 && close > -1) {
            Timestamp t;
            if (open > 0) {
                builder.append(template, pos, open);
            }
            if (template.regionMatches(open + 2, "+%s", 0, close - open - 2)) {
                t = event.getTimestamp();
                builder.append(t == null ? "" : Long.valueOf(t.getTime().getMillis() / 1000L));
            } else if (template.charAt(open + 2) == '+') {
                t = event.getTimestamp();
                builder.append(t != null ? event.getTimestamp().getTime().toString(DateTimeFormat.forPattern((String)template.substring(open + 3, close)).withZone(DateTimeZone.UTC)) : "");
            } else {
                String found = template.substring(open + 2, close);
                Object value = event.getField(found);
                if (value != null) {
                    if (value instanceof List) {
                        builder.append(KeyNode.join((List)value, ","));
                    } else if (value instanceof Map) {
                        builder.append(ObjectMappers.JSON_MAPPER.writeValueAsString(value));
                    } else {
                        builder.append(value.toString());
                    }
                } else {
                    builder.append("%{").append(found).append('}');
                }
            }
            pos = close + 1;
            open = template.indexOf("%{", pos);
            close = template.indexOf(125, open);
        }
        int len = template.length();
        if (pos < len) {
            builder.append(template, pos, len);
        }
        return builder.toString();
    }
}

