/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceIDProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEVICEUUID;
    public static final int DRIVERUUID;
    public static final int DEVICELUID;
    public static final int DEVICENODEMASK;
    public static final int DEVICELUIDVALID;

    public VkPhysicalDeviceIDProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPhysicalDeviceIDProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceIDProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceIDProperties.npNext(this.address());
    }

    @NativeType(value="uint8_t[VK_UUID_SIZE]")
    public ByteBuffer deviceUUID() {
        return VkPhysicalDeviceIDProperties.ndeviceUUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte deviceUUID(int index) {
        return VkPhysicalDeviceIDProperties.ndeviceUUID(this.address(), index);
    }

    @NativeType(value="uint8_t[VK_UUID_SIZE]")
    public ByteBuffer driverUUID() {
        return VkPhysicalDeviceIDProperties.ndriverUUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte driverUUID(int index) {
        return VkPhysicalDeviceIDProperties.ndriverUUID(this.address(), index);
    }

    @NativeType(value="uint8_t[VK_LUID_SIZE]")
    public ByteBuffer deviceLUID() {
        return VkPhysicalDeviceIDProperties.ndeviceLUID(this.address());
    }

    @NativeType(value="uint8_t")
    public byte deviceLUID(int index) {
        return VkPhysicalDeviceIDProperties.ndeviceLUID(this.address(), index);
    }

    @NativeType(value="uint32_t")
    public int deviceNodeMask() {
        return VkPhysicalDeviceIDProperties.ndeviceNodeMask(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean deviceLUIDValid() {
        return VkPhysicalDeviceIDProperties.ndeviceLUIDValid(this.address()) != 0;
    }

    public VkPhysicalDeviceIDProperties sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceIDProperties.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceIDProperties pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceIDProperties.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceIDProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceIDProperties set(VkPhysicalDeviceIDProperties src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceIDProperties malloc() {
        return (VkPhysicalDeviceIDProperties)VkPhysicalDeviceIDProperties.wrap(VkPhysicalDeviceIDProperties.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPhysicalDeviceIDProperties calloc() {
        return (VkPhysicalDeviceIDProperties)VkPhysicalDeviceIDProperties.wrap(VkPhysicalDeviceIDProperties.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPhysicalDeviceIDProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPhysicalDeviceIDProperties)VkPhysicalDeviceIDProperties.wrap(VkPhysicalDeviceIDProperties.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPhysicalDeviceIDProperties create(long address) {
        return (VkPhysicalDeviceIDProperties)VkPhysicalDeviceIDProperties.wrap(VkPhysicalDeviceIDProperties.class, (long)address);
    }

    @Nullable
    public static VkPhysicalDeviceIDProperties createSafe(long address) {
        return address == 0L ? null : (VkPhysicalDeviceIDProperties)VkPhysicalDeviceIDProperties.wrap(VkPhysicalDeviceIDProperties.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPhysicalDeviceIDProperties.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceIDProperties.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPhysicalDeviceIDProperties.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceIDProperties.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPhysicalDeviceIDProperties.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPhysicalDeviceIDProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPhysicalDeviceIDProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkPhysicalDeviceIDProperties mallocStack() {
        return VkPhysicalDeviceIDProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceIDProperties callocStack() {
        return VkPhysicalDeviceIDProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceIDProperties mallocStack(MemoryStack stack) {
        return (VkPhysicalDeviceIDProperties)VkPhysicalDeviceIDProperties.wrap(VkPhysicalDeviceIDProperties.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceIDProperties callocStack(MemoryStack stack) {
        return (VkPhysicalDeviceIDProperties)VkPhysicalDeviceIDProperties.wrap(VkPhysicalDeviceIDProperties.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceIDProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceIDProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceIDProperties.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceIDProperties.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static ByteBuffer ndeviceUUID(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DEVICEUUID), (int)16);
    }

    public static byte ndeviceUUID(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DEVICEUUID + Checks.check((int)index, (int)16) * 1L);
    }

    public static ByteBuffer ndriverUUID(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DRIVERUUID), (int)16);
    }

    public static byte ndriverUUID(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DRIVERUUID + Checks.check((int)index, (int)16) * 1L);
    }

    public static ByteBuffer ndeviceLUID(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DEVICELUID), (int)8);
    }

    public static byte ndeviceLUID(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DEVICELUID + Checks.check((int)index, (int)8) * 1L);
    }

    public static int ndeviceNodeMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICENODEMASK);
    }

    public static int ndeviceLUIDValid(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICELUIDVALID);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceIDProperties.__struct((Struct.Member[])new Struct.Member[]{VkPhysicalDeviceIDProperties.__member((int)4), VkPhysicalDeviceIDProperties.__member((int)POINTER_SIZE), VkPhysicalDeviceIDProperties.__array((int)1, (int)16), VkPhysicalDeviceIDProperties.__array((int)1, (int)16), VkPhysicalDeviceIDProperties.__array((int)1, (int)8), VkPhysicalDeviceIDProperties.__member((int)4), VkPhysicalDeviceIDProperties.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEVICEUUID = layout.offsetof(2);
        DRIVERUUID = layout.offsetof(3);
        DEVICELUID = layout.offsetof(4);
        DEVICENODEMASK = layout.offsetof(5);
        DEVICELUIDVALID = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceIDProperties, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceIDProperties ELEMENT_FACTORY = VkPhysicalDeviceIDProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPhysicalDeviceIDProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceIDProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceIDProperties.npNext(this.address());
        }

        @NativeType(value="uint8_t[VK_UUID_SIZE]")
        public ByteBuffer deviceUUID() {
            return VkPhysicalDeviceIDProperties.ndeviceUUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte deviceUUID(int index) {
            return VkPhysicalDeviceIDProperties.ndeviceUUID(this.address(), index);
        }

        @NativeType(value="uint8_t[VK_UUID_SIZE]")
        public ByteBuffer driverUUID() {
            return VkPhysicalDeviceIDProperties.ndriverUUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte driverUUID(int index) {
            return VkPhysicalDeviceIDProperties.ndriverUUID(this.address(), index);
        }

        @NativeType(value="uint8_t[VK_LUID_SIZE]")
        public ByteBuffer deviceLUID() {
            return VkPhysicalDeviceIDProperties.ndeviceLUID(this.address());
        }

        @NativeType(value="uint8_t")
        public byte deviceLUID(int index) {
            return VkPhysicalDeviceIDProperties.ndeviceLUID(this.address(), index);
        }

        @NativeType(value="uint32_t")
        public int deviceNodeMask() {
            return VkPhysicalDeviceIDProperties.ndeviceNodeMask(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean deviceLUIDValid() {
            return VkPhysicalDeviceIDProperties.ndeviceLUIDValid(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceIDProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceIDProperties.npNext(this.address(), value);
            return this;
        }
    }
}

