/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryGetFdInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORY;
    public static final int HANDLETYPE;

    public VkMemoryGetFdInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryGetFdInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryGetFdInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryGetFdInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkMemoryGetFdInfoKHR.nmemory(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagBits")
    public int handleType() {
        return VkMemoryGetFdInfoKHR.nhandleType(this.address());
    }

    public VkMemoryGetFdInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryGetFdInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkMemoryGetFdInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkMemoryGetFdInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkMemoryGetFdInfoKHR memory(@NativeType(value="VkDeviceMemory") long value) {
        VkMemoryGetFdInfoKHR.nmemory(this.address(), value);
        return this;
    }

    public VkMemoryGetFdInfoKHR handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagBits") int value) {
        VkMemoryGetFdInfoKHR.nhandleType(this.address(), value);
        return this;
    }

    public VkMemoryGetFdInfoKHR set(int sType, long pNext, long memory, int handleType) {
        this.sType(sType);
        this.pNext(pNext);
        this.memory(memory);
        this.handleType(handleType);
        return this;
    }

    public VkMemoryGetFdInfoKHR set(VkMemoryGetFdInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryGetFdInfoKHR malloc() {
        return (VkMemoryGetFdInfoKHR)VkMemoryGetFdInfoKHR.wrap(VkMemoryGetFdInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkMemoryGetFdInfoKHR calloc() {
        return (VkMemoryGetFdInfoKHR)VkMemoryGetFdInfoKHR.wrap(VkMemoryGetFdInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkMemoryGetFdInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkMemoryGetFdInfoKHR)VkMemoryGetFdInfoKHR.wrap(VkMemoryGetFdInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkMemoryGetFdInfoKHR create(long address) {
        return (VkMemoryGetFdInfoKHR)VkMemoryGetFdInfoKHR.wrap(VkMemoryGetFdInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkMemoryGetFdInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkMemoryGetFdInfoKHR)VkMemoryGetFdInfoKHR.wrap(VkMemoryGetFdInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkMemoryGetFdInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkMemoryGetFdInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkMemoryGetFdInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryGetFdInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkMemoryGetFdInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkMemoryGetFdInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkMemoryGetFdInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkMemoryGetFdInfoKHR mallocStack() {
        return VkMemoryGetFdInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryGetFdInfoKHR callocStack() {
        return VkMemoryGetFdInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryGetFdInfoKHR mallocStack(MemoryStack stack) {
        return (VkMemoryGetFdInfoKHR)VkMemoryGetFdInfoKHR.wrap(VkMemoryGetFdInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryGetFdInfoKHR callocStack(MemoryStack stack) {
        return (VkMemoryGetFdInfoKHR)VkMemoryGetFdInfoKHR.wrap(VkMemoryGetFdInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryGetFdInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryGetFdInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkMemoryGetFdInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkMemoryGetFdInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nmemory(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORY);
    }

    public static int nhandleType(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDLETYPE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nmemory(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORY, value);
    }

    public static void nhandleType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDLETYPE, value);
    }

    static {
        Struct.Layout layout = VkMemoryGetFdInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkMemoryGetFdInfoKHR.__member((int)4), VkMemoryGetFdInfoKHR.__member((int)POINTER_SIZE), VkMemoryGetFdInfoKHR.__member((int)8), VkMemoryGetFdInfoKHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORY = layout.offsetof(2);
        HANDLETYPE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryGetFdInfoKHR, Buffer>
    implements NativeResource {
        private static final VkMemoryGetFdInfoKHR ELEMENT_FACTORY = VkMemoryGetFdInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkMemoryGetFdInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryGetFdInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryGetFdInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkMemoryGetFdInfoKHR.nmemory(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagBits")
        public int handleType() {
            return VkMemoryGetFdInfoKHR.nhandleType(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryGetFdInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryGetFdInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkMemoryGetFdInfoKHR.nmemory(this.address(), value);
            return this;
        }

        public Buffer handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagBits") int value) {
            VkMemoryGetFdInfoKHR.nhandleType(this.address(), value);
            return this;
        }
    }
}

