/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkInputAttachmentAspectReference
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SUBPASS;
    public static final int INPUTATTACHMENTINDEX;
    public static final int ASPECTMASK;

    public VkInputAttachmentAspectReference(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkInputAttachmentAspectReference.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int subpass() {
        return VkInputAttachmentAspectReference.nsubpass(this.address());
    }

    @NativeType(value="uint32_t")
    public int inputAttachmentIndex() {
        return VkInputAttachmentAspectReference.ninputAttachmentIndex(this.address());
    }

    @NativeType(value="VkImageAspectFlags")
    public int aspectMask() {
        return VkInputAttachmentAspectReference.naspectMask(this.address());
    }

    public VkInputAttachmentAspectReference subpass(@NativeType(value="uint32_t") int value) {
        VkInputAttachmentAspectReference.nsubpass(this.address(), value);
        return this;
    }

    public VkInputAttachmentAspectReference inputAttachmentIndex(@NativeType(value="uint32_t") int value) {
        VkInputAttachmentAspectReference.ninputAttachmentIndex(this.address(), value);
        return this;
    }

    public VkInputAttachmentAspectReference aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkInputAttachmentAspectReference.naspectMask(this.address(), value);
        return this;
    }

    public VkInputAttachmentAspectReference set(int subpass, int inputAttachmentIndex, int aspectMask) {
        this.subpass(subpass);
        this.inputAttachmentIndex(inputAttachmentIndex);
        this.aspectMask(aspectMask);
        return this;
    }

    public VkInputAttachmentAspectReference set(VkInputAttachmentAspectReference src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkInputAttachmentAspectReference malloc() {
        return (VkInputAttachmentAspectReference)VkInputAttachmentAspectReference.wrap(VkInputAttachmentAspectReference.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkInputAttachmentAspectReference calloc() {
        return (VkInputAttachmentAspectReference)VkInputAttachmentAspectReference.wrap(VkInputAttachmentAspectReference.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkInputAttachmentAspectReference create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkInputAttachmentAspectReference)VkInputAttachmentAspectReference.wrap(VkInputAttachmentAspectReference.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkInputAttachmentAspectReference create(long address) {
        return (VkInputAttachmentAspectReference)VkInputAttachmentAspectReference.wrap(VkInputAttachmentAspectReference.class, (long)address);
    }

    @Nullable
    public static VkInputAttachmentAspectReference createSafe(long address) {
        return address == 0L ? null : (VkInputAttachmentAspectReference)VkInputAttachmentAspectReference.wrap(VkInputAttachmentAspectReference.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkInputAttachmentAspectReference.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkInputAttachmentAspectReference.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkInputAttachmentAspectReference.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkInputAttachmentAspectReference.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkInputAttachmentAspectReference.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkInputAttachmentAspectReference.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkInputAttachmentAspectReference.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkInputAttachmentAspectReference mallocStack() {
        return VkInputAttachmentAspectReference.mallocStack(MemoryStack.stackGet());
    }

    public static VkInputAttachmentAspectReference callocStack() {
        return VkInputAttachmentAspectReference.callocStack(MemoryStack.stackGet());
    }

    public static VkInputAttachmentAspectReference mallocStack(MemoryStack stack) {
        return (VkInputAttachmentAspectReference)VkInputAttachmentAspectReference.wrap(VkInputAttachmentAspectReference.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkInputAttachmentAspectReference callocStack(MemoryStack stack) {
        return (VkInputAttachmentAspectReference)VkInputAttachmentAspectReference.wrap(VkInputAttachmentAspectReference.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkInputAttachmentAspectReference.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkInputAttachmentAspectReference.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkInputAttachmentAspectReference.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkInputAttachmentAspectReference.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsubpass(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBPASS);
    }

    public static int ninputAttachmentIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)INPUTATTACHMENTINDEX);
    }

    public static int naspectMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)ASPECTMASK);
    }

    public static void nsubpass(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBPASS, value);
    }

    public static void ninputAttachmentIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INPUTATTACHMENTINDEX, value);
    }

    public static void naspectMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ASPECTMASK, value);
    }

    static {
        Struct.Layout layout = VkInputAttachmentAspectReference.__struct((Struct.Member[])new Struct.Member[]{VkInputAttachmentAspectReference.__member((int)4), VkInputAttachmentAspectReference.__member((int)4), VkInputAttachmentAspectReference.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SUBPASS = layout.offsetof(0);
        INPUTATTACHMENTINDEX = layout.offsetof(1);
        ASPECTMASK = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkInputAttachmentAspectReference, Buffer>
    implements NativeResource {
        private static final VkInputAttachmentAspectReference ELEMENT_FACTORY = VkInputAttachmentAspectReference.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkInputAttachmentAspectReference getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int subpass() {
            return VkInputAttachmentAspectReference.nsubpass(this.address());
        }

        @NativeType(value="uint32_t")
        public int inputAttachmentIndex() {
            return VkInputAttachmentAspectReference.ninputAttachmentIndex(this.address());
        }

        @NativeType(value="VkImageAspectFlags")
        public int aspectMask() {
            return VkInputAttachmentAspectReference.naspectMask(this.address());
        }

        public Buffer subpass(@NativeType(value="uint32_t") int value) {
            VkInputAttachmentAspectReference.nsubpass(this.address(), value);
            return this;
        }

        public Buffer inputAttachmentIndex(@NativeType(value="uint32_t") int value) {
            VkInputAttachmentAspectReference.ninputAttachmentIndex(this.address(), value);
            return this;
        }

        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkInputAttachmentAspectReference.naspectMask(this.address(), value);
            return this;
        }
    }
}

