/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class AscEvaluator
extends RecursiveObjectEvaluator
implements OneValueWorker {
    private static final long serialVersionUID = 1L;

    public AscEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (null == value) {
            return value;
        }
        if (!(value instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for value, expecting a List", this.toExpression(this.constructingFactory), value.getClass().getSimpleName()));
        }
        List list = (List)value;
        if (0 == list.size()) {
            return list;
        }
        Object checkingObject = list.get(0);
        for (int idx = 0; idx < list.size(); ++idx) {
            Object item = list.get(0);
            if (null == item) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found null value", this.toExpression(this.constructingFactory)));
            }
            if (!(item instanceof Comparable)) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found non-comparable value %s of type %s", this.toExpression(this.constructingFactory), item.toString(), item.getClass().getSimpleName()));
            }
            if (item.getClass().getCanonicalName().equals(checkingObject.getClass().getCanonicalName())) continue;
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - value %s is of type %s but we are expeting type %s", this.toExpression(this.constructingFactory), item.toString(), item.getClass().getSimpleName(), checkingObject.getClass().getCanonicalName()));
        }
        return list.stream().sorted((left, right) -> ((Comparable)left).compareTo((Comparable)right)).collect(Collectors.toList());
    }
}

