/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Platform;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;

public final class ObjectArrays {
    public static Object[] newArray(Object[] objectArray, int n) {
        return Platform.newArray(objectArray, n);
    }

    static Object[] toArrayImpl(Collection collection, Object[] objectArray) {
        int n = collection.size();
        if (objectArray.length < n) {
            objectArray = ObjectArrays.newArray(objectArray, n);
        }
        ObjectArrays.fillArray(collection, objectArray);
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    static Object[] toArrayImpl(Object[] objectArray, int n, int n2, Object[] objectArray2) {
        Preconditions.checkPositionIndexes(n, n + n2, objectArray.length);
        if (objectArray2.length < n2) {
            objectArray2 = ObjectArrays.newArray(objectArray2, n2);
        } else if (objectArray2.length > n2) {
            objectArray2[n2] = null;
        }
        System.arraycopy(objectArray, n, objectArray2, 0, n2);
        return objectArray2;
    }

    static Object[] copyAsObjectArray(Object[] objectArray, int n, int n2) {
        Preconditions.checkPositionIndexes(n, n + n2, objectArray.length);
        if (n2 == 0) {
            return new Object[0];
        }
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, n, objectArray2, 0, n2);
        return objectArray2;
    }

    @CanIgnoreReturnValue
    private static Object[] fillArray(Iterable iterable, Object[] objectArray) {
        int n = 0;
        for (Object t : iterable) {
            objectArray[n++] = t;
        }
        return objectArray;
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object ... objectArray) {
        return ObjectArrays.checkElementsNotNull(objectArray, objectArray.length);
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object[] objectArray, int n) {
        for (int i = 0; i < n; ++i) {
            ObjectArrays.checkElementNotNull(objectArray[i], i);
        }
        return objectArray;
    }

    @CanIgnoreReturnValue
    static Object checkElementNotNull(Object object, int n) {
        if (object == null) {
            throw new NullPointerException("at index " + n);
        }
        return object;
    }
}

