/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.model.Position;

public class PstProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_STATUS = 5;

    public PstProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Date readDate(ByteBuf buf) {
        long value = buf.readUnsignedInt();
        return new DateBuilder().setYear((int)BitUtil.between(value, 26, 32)).setMonth((int)BitUtil.between(value, 22, 26)).setDay((int)BitUtil.between(value, 17, 22)).setHour((int)BitUtil.between(value, 12, 17)).setMinute((int)BitUtil.between(value, 6, 12)).setSecond((int)BitUtil.between(value, 0, 6)).getDate();
    }

    private double readCoordinate(ByteBuf buf) {
        long value = buf.readUnsignedInt();
        int sign = BitUtil.check(value, 31) ? -1 : 1;
        value = BitUtil.to(value, 31);
        return (double)sign * ((double)BitUtil.from(value, 16) + (double)BitUtil.to(value, 16) * 1.0E-5) / 60.0;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        String id = String.valueOf(buf.readUnsignedInt());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        buf.readUnsignedByte();
        buf.readUnsignedInt();
        short type = buf.readUnsignedByte();
        if (type == 5) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setDeviceTime(this.readDate(buf));
            buf.readUnsignedByte();
            int count = buf.readUnsignedByte();
            block4: for (int i = 0; i < count; ++i) {
                short tag = buf.readUnsignedByte();
                short length = buf.readUnsignedByte();
                switch (tag) {
                    case 13: {
                        short battery = buf.readUnsignedByte();
                        if (battery > 20) continue block4;
                        position.set("batteryLevel", buf.readUnsignedByte() * 5);
                        continue block4;
                    }
                    case 16: {
                        position.setFixTime(this.readDate(buf));
                        position.setLatitude(this.readCoordinate(buf));
                        position.setLongitude(this.readCoordinate(buf));
                        position.setSpeed(buf.readUnsignedByte());
                        position.setCourse(buf.readUnsignedByte() * 2);
                        position.setAltitude(buf.readShort());
                        buf.readUnsignedInt();
                        continue block4;
                    }
                    default: {
                        buf.skipBytes((int)length);
                    }
                }
            }
            return position.getFixTime() != null ? position : null;
        }
        return null;
    }
}

