/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class GenxProtocolDecoder
extends BaseProtocolDecoder {
    private int[] reportColumns;

    public GenxProtocolDecoder(Protocol protocol) {
        super(protocol);
        this.setReportColumns(Context.getConfig().getString(this.getProtocolName() + ".reportColumns", "1,2,3,4"));
    }

    public void setReportColumns(String format) {
        String[] columns = format.split(",");
        this.reportColumns = new int[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.reportColumns[i] = Integer.parseInt(columns[i]);
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String[] values = ((String)msg).split(",");
        Position position = new Position(this.getProtocolName());
        position.setValid(true);
        block12: for (int i = 0; i < Math.min(values.length, this.reportColumns.length); ++i) {
            switch (this.reportColumns[i]) {
                case 1: 
                case 28: {
                    DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, values[i]);
                    if (deviceSession == null) continue block12;
                    position.setDeviceId(deviceSession.getDeviceId());
                    continue block12;
                }
                case 2: {
                    position.setTime(new SimpleDateFormat("MM/dd/yy HH:mm:ss").parse(values[i]));
                    continue block12;
                }
                case 3: {
                    position.setLatitude(Double.parseDouble(values[i]));
                    continue block12;
                }
                case 4: {
                    position.setLongitude(Double.parseDouble(values[i]));
                    continue block12;
                }
                case 11: {
                    position.set("ignition", values[i].equals("ON"));
                    continue block12;
                }
                case 13: {
                    position.setSpeed(UnitsConverter.knotsFromKph(Integer.parseInt(values[i])));
                    continue block12;
                }
                case 17: {
                    position.setCourse(Integer.parseInt(values[i]));
                    continue block12;
                }
                case 23: {
                    position.set("odometer", Double.parseDouble(values[i]) * 1000.0);
                    continue block12;
                }
                case 27: {
                    position.setAltitude(UnitsConverter.metersFromFeet(Integer.parseInt(values[i])));
                    continue block12;
                }
                case 46: {
                    position.set("sat", Integer.parseInt(values[i]));
                    continue block12;
                }
            }
        }
        return position.getDeviceId() != 0L ? position : null;
    }
}

