/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;

public class CarscopProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("*").any().number("(dd)(dd)(dd)").expression("([AV])").number("(dd)(dd.dddd)").expression("([NS])").number("(ddd)(dd.dddd)").expression("([EW])").number("(ddd.d)").number("(dd)(dd)(dd)").number("(ddd.dd)").groupBegin().number("(d{8})").number("L(d{6})").groupEnd("?").compile();

    public CarscopProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        DeviceSession deviceSession;
        String sentence = (String)msg;
        int index = sentence.indexOf("UB05");
        if (index != -1) {
            String imei = sentence.substring(index + 4, index + 4 + 15);
            deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        } else {
            deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        }
        if (deviceSession == null) {
            return null;
        }
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble(0.0));
        dateBuilder.setDate(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setTime(dateBuilder.getDate());
        position.setCourse(parser.nextDouble(0.0));
        if (parser.hasNext(2)) {
            position.set("status", parser.next());
            position.set("odometer", parser.nextInt(0));
        }
        return position;
    }
}

