/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util.codec;

import com.cloudhopper.commons.util.codec.URLCodec;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class URLEncoder
implements Appendable,
Flushable,
Closeable {
    protected static final int DEFAULT_BUFFER_SIZE = 1024;
    protected final Appendable out;
    protected final Charset charset;
    protected final CharBuffer singleCharBuffer = CharBuffer.allocate(1);
    protected final CharsetEncoder ce;
    protected final CharBuffer cb;
    protected final ByteBuffer bb;

    public URLEncoder(Appendable out) {
        this(out, 1024, URLCodec.UTF_8);
    }

    public URLEncoder(Appendable out, int bufferSize) {
        this(out, bufferSize, URLCodec.UTF_8);
    }

    public URLEncoder(Appendable out, int bufferSize, Charset charset) {
        this.out = out;
        this.charset = charset;
        this.ce = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.cb = CharBuffer.allocate(bufferSize);
        this.bb = ByteBuffer.allocate((int)Math.ceil((float)bufferSize * this.ce.maxBytesPerChar()));
    }

    @Override
    public Appendable append(CharSequence in) throws IOException {
        int read;
        int len = in.length();
        for (int start = 0; start < len; start += read) {
            read = Math.min(this.cb.remaining(), len - start);
            this.cb.append(in, start, start + read);
            if (this.cb.hasRemaining()) continue;
            this.flush(false);
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.singleCharBuffer.put(0, c);
        return this.append(this.singleCharBuffer);
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        return this.append(csq.subSequence(start, end));
    }

    protected void flush(boolean endOfInput) throws IOException {
        this.cb.flip();
        CoderResult cr = this.ce.encode(this.cb, this.bb, endOfInput);
        if (!cr.isUnderflow()) {
            throw new IOException("Unexpected: " + cr);
        }
        this.bb.flip();
        URLCodec.encode(this.bb, this.out);
        this.cb.clear();
        if (endOfInput) {
            cr = this.ce.flush(this.bb);
            if (!cr.isUnderflow()) {
                throw new IOException("Unexpected: " + cr);
            }
            this.bb.flip();
            URLCodec.encode(this.bb, this.out);
            this.ce.reset();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(true);
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }
}

