/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.simulator;

import com.cloudhopper.smpp.simulator.SmppSimulatorServerHandler;
import com.cloudhopper.smpp.simulator.SmppSimulatorSessionHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppSimulatorServer {
    private static final Logger logger = LoggerFactory.getLogger(SmppSimulatorServer.class);
    public static final String PIPELINE_SESSION_NAME = "session";
    private Channel serverChannel;
    private ChannelGroup sessionChannels = new DefaultChannelGroup("simulatorServer", (EventExecutor)GlobalEventExecutor.INSTANCE);
    private EventLoopGroup bossGroup = new NioEventLoopGroup();
    private EventLoopGroup workerGroup = new NioEventLoopGroup();
    private ServerBootstrap serverBootstrap = new ServerBootstrap();
    private final SmppSimulatorServerHandler serverHandler;

    public SmppSimulatorServer() {
        this.serverBootstrap.channel(NioServerSocketChannel.class);
        this.serverBootstrap.group(this.bossGroup, this.workerGroup);
        this.serverHandler = new SmppSimulatorServerHandler(this.sessionChannels);
        this.serverBootstrap.childHandler((ChannelHandler)this.serverHandler);
        this.serverBootstrap.handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                SmppSimulatorServer.this.serverHandler.channelRead(ctx, msg);
            }
        });
    }

    public void start(int port) {
        logger.info("Simulator server starting on port " + port + "...");
        ChannelFuture f = this.serverBootstrap.bind((SocketAddress)new InetSocketAddress(port)).syncUninterruptibly();
        this.serverChannel = f.channel();
        logger.info("Simulator server started");
    }

    public void stop() {
        try {
            logger.info("Closing all server session channels...");
            this.sessionChannels.close().sync();
            logger.info("Closing server channel...");
            this.serverChannel.close().sync();
            this.serverBootstrap = null;
        }
        catch (InterruptedException e) {
            logger.warn("Thread interrupted closing server channel.", (Throwable)e);
        }
        finally {
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
            try {
                this.bossGroup.terminationFuture().sync();
                this.workerGroup.terminationFuture().sync();
            }
            catch (InterruptedException e) {
                logger.warn("Thread interrupted closing executors.", (Throwable)e);
            }
        }
        logger.info("Simulator server stopped");
    }

    public SmppSimulatorServerHandler getHandler() {
        return this.serverHandler;
    }

    public SmppSimulatorSessionHandler pollNextSession(long timeoutInMillis) throws Exception {
        SmppSimulatorSessionHandler session = this.serverHandler.getSessionQueue().poll(timeoutInMillis, TimeUnit.MILLISECONDS);
        if (session == null) {
            throw new Exception("No session created within timeout");
        }
        return session;
    }
}

