/*
 * Decompiled with CFR 0.152.
 */
package tr.model;

import tr.model.Data;
import tr.model.context.Context;
import tr.model.future.Future;
import tr.model.information.Information;
import tr.model.thought.Thought;
import tr.model.topic.Topic;

public class DataUpgrade3to4 {
    private static int OLD_VERSION = 3;
    private static int NEW_VERSION = 4;

    public static void process(Data data) {
        if (data.version == OLD_VERSION) {
            DataUpgrade3to4.upgrade(data);
            data.version = NEW_VERSION;
        }
    }

    private static void upgrade(Data data) {
        System.out.print("Upgrading data from version " + OLD_VERSION + " to version " + NEW_VERSION + " ... ");
        DataUpgrade3to4.upgradeThoughts(data);
        DataUpgrade3to4.upgradeContexts(data);
        DataUpgrade3to4.upgradeTopics(data);
        DataUpgrade3to4.upgradeFuture(data);
        DataUpgrade3to4.upgradeInformation(data);
        System.out.println("Done");
    }

    private static void upgradeThoughts(Data data) {
        for (Thought thought : data.getThoughtManager().list()) {
            thought.initID(data.getNextID());
        }
    }

    private static void upgradeContexts(Data data) {
        for (Context context : data.getContextManager().list()) {
            context.initID(data.getNextID());
        }
    }

    private static void upgradeTopics(Data data) {
        for (Topic topic : data.getTopicManager().list()) {
            topic.initID(data.getNextID());
        }
    }

    private static void upgradeFuture(Data data) {
        for (Future future : data.getFutureManager().list()) {
            future.initID(data.getNextID());
        }
    }

    private static void upgradeInformation(Data data) {
        for (Information info : data.getInformationManager().list()) {
            info.initID(data.getNextID());
        }
    }
}

