/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.diagnostic.Logger;
import git4idea.repo.GitConfigHelperKt;
import git4idea.repo.GitSubmoduleInfo;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgit4idea/repo/GitModulesFileReader;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MODULE_SECTION", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "read", "", "Lgit4idea/repo/GitSubmoduleInfo;", "file", "Ljava/io/File;", "ModuleBean", "intellij.vcs.git"})
public final class GitModulesFileReader {
    private final Logger LOG;
    private final Pattern MODULE_SECTION;

    @NotNull
    public final Collection<GitSubmoduleInfo> read(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!file.exists()) {
            return CollectionsKt.emptyList();
        }
        Ini ini = null;
        try {
            ini = GitConfigHelperKt.loadIniFile(file);
        }
        catch (IOException e) {
            return CollectionsKt.emptyList();
        }
        ClassLoader classLoader = GitConfigHelperKt.findClassLoader();
        Set modules = new LinkedHashSet();
        Map map2 = (Map)ini;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            String sectionName = (String)entry2.getKey();
            entry2 = entry;
            Profile.Section section = (Profile.Section)entry2.getValue();
            Matcher matcher = this.MODULE_SECTION.matcher(sectionName);
            if (!matcher.matches() || matcher.groupCount() != 1) continue;
            ModuleBean bean = (ModuleBean)section.as(ModuleBean.class, classLoader);
            String path = bean.getPath();
            String url = bean.getUrl();
            if (path == null || url == null) {
                this.LOG.warn("Partially defined submodule: " + section.toString());
                continue;
            }
            GitSubmoduleInfo module = new GitSubmoduleInfo(path, url);
            this.LOG.debug("Found submodule " + module);
            modules.add(module);
        }
        return modules;
    }

    public GitModulesFileReader() {
        Logger logger;
        GitModulesFileReader gitModulesFileReader = this;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(GitModulesFileReader.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        gitModulesFileReader.LOG = logger = logger2;
        this.MODULE_SECTION = Pattern.compile("submodule \"(.*)\"", 2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bb\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0003H&\u00a8\u0006\u0005"}, d2={"Lgit4idea/repo/GitModulesFileReader$ModuleBean;", "", "getPath", "", "getUrl", "intellij.vcs.git"})
    private static interface ModuleBean {
        @Nullable
        public String getPath();

        @Nullable
        public String getUrl();
    }
}

