/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.rebase.GitAbortRebaseProcess;
import git4idea.rebase.GitRebaseProcess;
import git4idea.rebase.GitRebaseResumeMode;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitRepository;
import git4idea.stash.GitChangesSaver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseUtils {
    public static final String CONTINUE_PROGRESS_TITLE = "Continue Rebase Process...";
    private static final Logger LOG = Logger.getInstance((String)GitRebaseUtils.class.getName());

    private GitRebaseUtils() {
    }

    public static void rebase(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull GitRebaseParams params, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(0);
        }
        if (repositories == null) {
            GitRebaseUtils.$$$reportNull$$$0(1);
        }
        if (params == null) {
            GitRebaseUtils.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            GitRebaseUtils.$$$reportNull$$$0(3);
        }
        if (!GitRebaseUtils.isRebaseAllowed(project, repositories)) {
            return;
        }
        new GitRebaseProcess(project, GitRebaseSpec.forNewRebase(project, params, repositories, indicator), null).rebase();
    }

    public static void continueRebase(@NotNull Project project) {
        GitRebaseSpec spec;
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(4);
        }
        if ((spec = GitUtil.getRepositoryManager(project).getOngoingRebaseSpec()) != null) {
            new GitRebaseProcess(project, spec, GitRebaseResumeMode.CONTINUE).rebase();
        } else {
            LOG.warn("Refusing to continue: no rebase spec");
            VcsNotifier.getInstance((Project)project).notifyError("Can't Continue Rebase", "No rebase in progress");
        }
    }

    public static void continueRebase(@NotNull Project project, @NotNull GitRepository repository, @NotNull ProgressIndicator indicator) {
        GitRebaseSpec spec;
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(5);
        }
        if (repository == null) {
            GitRebaseUtils.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            GitRebaseUtils.$$$reportNull$$$0(7);
        }
        if ((spec = GitRebaseSpec.forResumeInSingleRepository(project, repository, indicator)) != null) {
            new GitRebaseProcess(project, spec, GitRebaseResumeMode.CONTINUE).rebase();
        } else {
            LOG.warn("Refusing to continue: no rebase spec");
            VcsNotifier.getInstance((Project)project).notifyError("Can't Continue Rebase", "No rebase in progress");
        }
    }

    public static void skipRebase(@NotNull Project project) {
        GitRebaseSpec spec;
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(8);
        }
        if ((spec = GitUtil.getRepositoryManager(project).getOngoingRebaseSpec()) != null) {
            new GitRebaseProcess(project, spec, GitRebaseResumeMode.SKIP).rebase();
        } else {
            LOG.warn("Refusing to skip: no rebase spec");
            VcsNotifier.getInstance((Project)project).notifyError("Can't Continue Rebase", "No rebase in progress");
        }
    }

    public static void skipRebase(@NotNull Project project, @NotNull GitRepository repository, @NotNull ProgressIndicator indicator) {
        GitRebaseSpec spec;
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(9);
        }
        if (repository == null) {
            GitRebaseUtils.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            GitRebaseUtils.$$$reportNull$$$0(11);
        }
        if ((spec = GitRebaseSpec.forResumeInSingleRepository(project, repository, indicator)) != null) {
            new GitRebaseProcess(project, spec, GitRebaseResumeMode.SKIP).rebase();
        } else {
            LOG.warn("Refusing to skip: no rebase spec");
            VcsNotifier.getInstance((Project)project).notifyError("Can't Continue Rebase", "No rebase in progress");
        }
    }

    public static void abort(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        GitRebaseSpec spec;
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(12);
        }
        if (indicator == null) {
            GitRebaseUtils.$$$reportNull$$$0(13);
        }
        if ((spec = GitUtil.getRepositoryManager(project).getOngoingRebaseSpec()) != null) {
            new GitAbortRebaseProcess(project, spec.getOngoingRebase(), spec.getHeadPositionsToRollback(), spec.getInitialBranchNames(), indicator, spec.getSaver(), true).abortWithConfirmation();
        } else {
            LOG.warn("Refusing to abort: no rebase spec");
            VcsNotifier.getInstance((Project)project).notifyError("Can't Abort Rebase", "No rebase in progress");
        }
    }

    public static void abort(@NotNull Project project, @Nullable GitRepository repository, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(14);
        }
        if (indicator == null) {
            GitRebaseUtils.$$$reportNull$$$0(15);
        }
        new GitAbortRebaseProcess(project, repository, Collections.emptyMap(), Collections.emptyMap(), indicator, null, true).abortWithConfirmation();
    }

    private static boolean isRebaseAllowed(@NotNull Project project, @NotNull Collection<GitRepository> repositories) {
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(16);
        }
        if (repositories == null) {
            GitRebaseUtils.$$$reportNull$$$0(17);
        }
        for (GitRepository repository : repositories) {
            Repository.State state = repository.getState();
            String in = GitUtil.mention(repository);
            String message = null;
            switch (state) {
                case NORMAL: {
                    if (!repository.isFresh()) break;
                    message = "Repository" + in + " is empty.";
                    break;
                }
                case MERGING: {
                    message = "There is an unfinished merge process" + in + ".<br/>You should complete the merge before starting a rebase";
                    break;
                }
                case REBASING: {
                    message = "There is an unfinished rebase process" + in + ".<br/>You should complete it before starting another rebase";
                    break;
                }
                case GRAFTING: {
                    message = "There is an unfinished cherry-pick process" + in + ".<br/>You should finish it before starting a rebase.";
                    break;
                }
                case DETACHED: {
                    message = "You are in the detached HEAD state" + in + ".<br/>Rebase is not possible.";
                    break;
                }
                default: {
                    LOG.error("Unknown state [" + state.name() + "]");
                    message = "Rebase is not possible" + in;
                }
            }
            if (message == null) continue;
            VcsNotifier.getInstance((Project)project).notifyError("Rebase not Allowed", message);
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean isRebaseInTheProgress(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(18);
        }
        if (root == null) {
            GitRebaseUtils.$$$reportNull$$$0(19);
        }
        return GitRebaseUtils.getRebaseDir(project, root) != null;
    }

    @Nullable
    public static File getRebaseDir(@NotNull Project project, @NotNull VirtualFile root) {
        GitRepository repository;
        File f;
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(20);
        }
        if (root == null) {
            GitRebaseUtils.$$$reportNull$$$0(21);
        }
        if ((f = (repository = (GitRepository)ObjectUtils.assertNotNull((Object)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root))).getRepositoryFiles().getRebaseApplyDir()).exists()) {
            return f;
        }
        f = repository.getRepositoryFiles().getRebaseMergeDir();
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public static boolean isInteractiveRebaseInProgress(@NotNull GitRepository repository) {
        File rebaseDir;
        if (repository == null) {
            GitRebaseUtils.$$$reportNull$$$0(22);
        }
        return (rebaseDir = GitRebaseUtils.getRebaseDir(repository.getProject(), repository.getRoot())) != null && new File(rebaseDir, "interactive").exists();
    }

    @Nullable
    public static CommitInfo getCurrentRebaseCommit(@NotNull Project project, @NotNull VirtualFile root) {
        int next;
        File rebaseDir;
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(23);
        }
        if (root == null) {
            GitRebaseUtils.$$$reportNull$$$0(24);
        }
        if ((rebaseDir = GitRebaseUtils.getRebaseDir(project, root)) == null) {
            LOG.warn("No rebase dir found for " + root.getPath());
            return null;
        }
        File nextFile = new File(rebaseDir, "next");
        try {
            next = Integer.parseInt(FileUtil.loadFile((File)nextFile, (Charset)CharsetToolkit.UTF8_CHARSET).trim());
        }
        catch (Exception e) {
            LOG.warn("Failed to load next commit number from file " + nextFile.getPath(), (Throwable)e);
            return null;
        }
        File commitFile = new File(rebaseDir, String.format("%04d", next));
        String hash = null;
        String subject = null;
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(commitFile), CharsetToolkit.UTF8_CHARSET));){
            String line;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("From ")) {
                    hash = line.substring(5, 45);
                }
                if (line.startsWith("Subject: ")) {
                    subject = line.substring("Subject: ".length());
                }
                if (hash == null || subject == null) continue;
                break;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to load next commit number from file " + commitFile, (Throwable)e);
            return null;
        }
        if (subject == null || hash == null) {
            LOG.info("Unable to extract information from " + commitFile + " " + hash + ": " + subject);
            return null;
        }
        return new CommitInfo(new GitRevisionNumber(hash), subject);
    }

    @NotNull
    static String mentionLocalChangesRemainingInStash(@Nullable GitChangesSaver saver) {
        String string = saver != null && saver.wereChangesSaved() ? "<br/>Local changes were " + GitRebaseUtils.toPast(saver.getOperationName()) + " before rebase." : "";
        if (string == null) {
            GitRebaseUtils.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private static String toPast(@NotNull String word) {
        if (word == null) {
            GitRebaseUtils.$$$reportNull$$$0(26);
        }
        String string = word.endsWith("e") ? word + "d" : word + "ed";
        if (string == null) {
            GitRebaseUtils.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static Collection<GitRepository> getRebasingRepositories(@NotNull Project project) {
        if (project == null) {
            GitRebaseUtils.$$$reportNull$$$0(28);
        }
        List list = ContainerUtil.filter(GitUtil.getRepositories(project), repository -> repository.getState() == Repository.State.REBASING);
        if (list == null) {
            GitRebaseUtils.$$$reportNull$$$0(29);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 25: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 25: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: 
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitRebaseUtils";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitRebaseUtils";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "mentionLocalChangesRemainingInStash";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "toPast";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getRebasingRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rebase";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "continueRebase";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "skipRebase";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "abort";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isRebaseAllowed";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isRebaseInTheProgress";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRebaseDir";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isInteractiveRebaseInProgress";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRebaseCommit";
                break;
            }
            case 25: 
            case 27: 
            case 29: {
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "toPast";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRebasingRepositories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 25: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CommitInfo {
        public final GitRevisionNumber revision;
        public final String subject;

        public CommitInfo(GitRevisionNumber revision, String subject) {
            this.revision = revision;
            this.subject = subject;
        }

        public String toString() {
            return this.revision.toString();
        }
    }
}

