/*
 * Decompiled with CFR 0.152.
 */
package git4idea.fetch;

import com.intellij.dvcs.MultiMessage;
import com.intellij.dvcs.MultiRootMessage;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitImpl;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitRestrictingAuthenticationGate;
import git4idea.config.GitConfigUtil;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.fetch.GitFetchSupportImpl;
import git4idea.fetch.GitFetchSupportImplKt;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u00043456B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\u00180\u0017H\u0002J\u0016\u0010\u0019\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0016J\u0016\u0010\u001c\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0016J(\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00172\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\u00180\u0017H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010 \u001a\u00020!2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\"\u001a\u00020!H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020$H\u0002J\u0016\u0010&\u001a\u00020'2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0002J\u001a\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010)2\u0006\u0010+\u001a\u00020\rH\u0002J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0017H\u0002J!\u0010.\u001a\u0002H/\"\u0004\b\u0000\u0010/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H/01H\u0002\u00a2\u0006\u0002\u00102R\u000e\u0010\u0002\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl;", "Lgit4idea/fetch/GitFetchSupport;", "git", "Lgit4idea/commands/Git;", "project", "Lcom/intellij/openapi/project/Project;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "vcsNotifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "(Lgit4idea/commands/Git;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressManager;Lcom/intellij/openapi/vcs/VcsNotifier;)V", "Lgit4idea/commands/GitImpl;", "doFetch", "Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "authenticationGate", "Lgit4idea/commands/GitAuthenticationGate;", "fetch", "Lgit4idea/fetch/GitFetchResult;", "remotes", "", "Lkotlin/Pair;", "fetchAllRemotes", "repositories", "", "fetchDefaultRemote", "fetchInParallel", "Lgit4idea/fetch/GitFetchSupportImpl$FetchTask;", "getDefaultRemoteToFetch", "getMaxThreads", "", "numberOfRemotes", "getPrunedRef", "", "line", "isStoreCredentialsHelperUsed", "", "mergeRepoResults", "Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "firstResult", "secondResult", "waitForFetchTasks", "tasks", "withIndicator", "T", "operation", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "FetchResultImpl", "FetchTask", "RepoResult", "SingleRemoteResult", "intellij.vcs.git"})
public final class GitFetchSupportImpl
implements GitFetchSupport {
    private final GitImpl git;
    private final Project project;
    private final ProgressManager progressManager;
    private final VcsNotifier vcsNotifier;

    @Override
    @Nullable
    public GitRemote getDefaultRemoteToFetch(@NotNull GitRepository repository) {
        Comparable<GitReference> comparable;
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Collection<GitRemote> collection = repository.getRemotes();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"repository.remotes");
        Collection<GitRemote> remotes = collection;
        if (remotes.isEmpty()) {
            comparable = null;
        } else if (remotes.size() == 1) {
            comparable = (GitRemote)CollectionsKt.first((Iterable)remotes);
        } else {
            comparable = repository.getCurrentBranch();
            if (comparable == null || (comparable = ((GitLocalBranch)comparable).findTrackedBranch(repository)) == null || (comparable = ((GitRemoteBranch)comparable).getRemote()) == null) {
                comparable = GitUtil.findRemoteByName(repository, "origin");
            }
        }
        return comparable;
    }

    @NotNull
    public GitFetchResult fetchDefaultRemote(@NotNull Collection<? extends GitRepository> repositories) {
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        List remotesToFetch = new ArrayList();
        for (GitRepository gitRepository : repositories) {
            GitRemote remote = this.getDefaultRemoteToFetch(gitRepository);
            if (remote != null) {
                remotesToFetch.add(TuplesKt.to((Object)gitRepository, (Object)remote));
                continue;
            }
            GitFetchSupportImplKt.access$getLOG$p().info("No remote to fetch found in " + gitRepository);
        }
        return this.fetch(remotesToFetch);
    }

    @NotNull
    public GitFetchResult fetchAllRemotes(@NotNull Collection<? extends GitRepository> repositories) {
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        List remotesToFetch = new ArrayList();
        for (GitRepository gitRepository : repositories) {
            if (gitRepository.getRemotes().isEmpty()) {
                GitFetchSupportImplKt.access$getLOG$p().info("No remote to fetch found in " + gitRepository);
                continue;
            }
            for (GitRemote remote : gitRepository.getRemotes()) {
                remotesToFetch.add(TuplesKt.to((Object)gitRepository, (Object)remote));
            }
        }
        return this.fetch(remotesToFetch);
    }

    @Override
    @NotNull
    public GitFetchResult fetch(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)remote, (String)"remote");
        return this.fetch(CollectionsKt.listOf((Object)TuplesKt.to((Object)repository, (Object)remote)));
    }

    private final GitFetchResult fetch(List<? extends Pair<? extends GitRepository, GitRemote>> remotes) {
        return (GitFetchResult)this.withIndicator((Function0)new Function0<FetchResultImpl>(this, remotes){
            final /* synthetic */ GitFetchSupportImpl this$0;
            final /* synthetic */ List $remotes;

            @NotNull
            public final FetchResultImpl invoke() {
                List tasks = GitFetchSupportImpl.access$fetchInParallel(this.this$0, this.$remotes);
                List results = GitFetchSupportImpl.access$waitForFetchTasks(this.this$0, tasks);
                Map mergedResults = new LinkedHashMap<K, V>();
                for (SingleRemoteResult result2 : results) {
                    RepoResult res = (RepoResult)mergedResults.get(result2.getRepository());
                    Map map2 = mergedResults;
                    GitRepository gitRepository = result2.getRepository();
                    RepoResult repoResult = GitFetchSupportImpl.access$mergeRepoResults(this.this$0, res, result2);
                    map2.put(gitRepository, repoResult);
                }
                return new FetchResultImpl(GitFetchSupportImpl.access$getProject$p(this.this$0), GitFetchSupportImpl.access$getVcsNotifier$p(this.this$0), mergedResults);
            }
            {
                this.this$0 = gitFetchSupportImpl;
                this.$remotes = list;
                super(0);
            }
        });
    }

    private final RepoResult mergeRepoResults(RepoResult firstResult, SingleRemoteResult secondResult) {
        if (firstResult == null) {
            return new RepoResult(MapsKt.mapOf((Pair)TuplesKt.to((Object)secondResult.getRemote(), (Object)secondResult)));
        }
        return new RepoResult(MapsKt.plus(firstResult.getResults(), (Pair)TuplesKt.to((Object)secondResult.getRemote(), (Object)secondResult)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<FetchTask> fetchInParallel(List<? extends Pair<? extends GitRepository, GitRemote>> remotes) {
        void var13_13;
        void destination$iv;
        void $receiver$iv;
        List tasks = new ArrayList();
        Iterable iterable = remotes;
        Collection collection = new HashSet();
        GitFetchSupportImpl gitFetchSupportImpl = this;
        for (Object pair : $receiver$iv) {
            void it;
            Pair pair2 = (Pair)pair;
            var13_13 = destination$iv;
            boolean bl = false;
            GitRepository gitRepository = (GitRepository)it.getFirst();
            var13_13.add(gitRepository);
        }
        var13_13 = destination$iv;
        int maxThreads = gitFetchSupportImpl.getMaxThreads((Collection<? extends GitRepository>)var13_13, remotes.size());
        GitFetchSupportImplKt.access$getLOG$p().debug("Fetching " + remotes + " using " + maxThreads + " threads");
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"GitFetch pool", (int)maxThreads);
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"AppExecutorUtil.createBo\u2026tFetch pool\", maxThreads)");
        ExecutorService executor = executorService;
        ProgressIndicator progressIndicator = this.progressManager.getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator commonIndicator = progressIndicator;
        GitRestrictingAuthenticationGate authenticationGate = new GitRestrictingAuthenticationGate();
        for (Pair pair : remotes) {
            Future<SingleRemoteResult> future2;
            GitRepository repository = (GitRepository)pair.component1();
            GitRemote remote = (GitRemote)pair.component2();
            GitFetchSupportImplKt.access$getLOG$p().debug("Fetching " + remote + " in " + repository);
            Intrinsics.checkExpressionValueIsNotNull(executor.submit((Callable)new Callable<SingleRemoteResult>(this, commonIndicator, repository, remote, authenticationGate){
                final /* synthetic */ GitFetchSupportImpl this$0;
                final /* synthetic */ ProgressIndicator $commonIndicator;
                final /* synthetic */ GitRepository $repository;
                final /* synthetic */ GitRemote $remote;
                final /* synthetic */ GitRestrictingAuthenticationGate $authenticationGate;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final SingleRemoteResult call() {
                    void result2;
                    this.$commonIndicator.checkCanceled();
                    Ref.ObjectRef objectRef = new Ref.ObjectRef();
                    objectRef.element = null;
                    ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(this, (Ref.ObjectRef)result2){
                        final /* synthetic */ fetchInParallel.future.1 this$0;
                        final /* synthetic */ Ref.ObjectRef $result;

                        public final void run() {
                            this.this$0.$commonIndicator.checkCanceled();
                            this.$result.element = GitFetchSupportImpl.access$doFetch(this.this$0.this$0, this.this$0.$repository, this.this$0.$remote, this.this$0.$authenticationGate);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$result = objectRef;
                        }
                    }, this.$commonIndicator);
                    Object object = result2.element;
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"result");
                    }
                    return (SingleRemoteResult)object;
                }
                {
                    this.this$0 = gitFetchSupportImpl;
                    this.$commonIndicator = progressIndicator;
                    this.$repository = gitRepository;
                    this.$remote = gitRemote;
                    this.$authenticationGate = gitRestrictingAuthenticationGate;
                }
            }), (String)"executor.submit<SingleRe\u2026r)\n        result\n      }");
            tasks.add(new FetchTask(repository, remote, future2));
        }
        return tasks;
    }

    private final int getMaxThreads(Collection<? extends GitRepository> repositories, int numberOfRemotes) {
        int maxThreads;
        int config = Registry.intValue((String)"git.parallel.fetch.threads");
        int n = config > 0 ? config : (config == -1 ? Runtime.getRuntime().availableProcessors() : (config == -2 ? numberOfRemotes : (maxThreads = config == -3 ? Math.min(numberOfRemotes, Runtime.getRuntime().availableProcessors() * 2) : 1)));
        if (this.isStoreCredentialsHelperUsed(repositories)) {
            return 1;
        }
        return Math.min(maxThreads, 10);
    }

    private final boolean isStoreCredentialsHelperUsed(Collection<? extends GitRepository> repositories) {
        boolean bl;
        block3: {
            Iterable $receiver$iv = repositories;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    GitRepository it = (GitRepository)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)GitConfigUtil.getValue(this.project, it.getRoot(), "credential.helper"), (String)"store", (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final List<SingleRemoteResult> waitForFetchTasks(List<FetchTask> tasks) {
        List results = new ArrayList();
        for (FetchTask task : tasks) {
            try {
                SingleRemoteResult singleRemoteResult = task.getFuture().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)singleRemoteResult, (String)"task.future.get()");
                results.add(singleRemoteResult);
            }
            catch (CancellationException e) {
                throw (Throwable)new ProcessCanceledException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw (Throwable)new ProcessCanceledException((Throwable)e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ProcessCanceledException) {
                    Throwable throwable = e.getCause();
                    if (throwable == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.progress.ProcessCanceledException");
                    }
                    throw (Throwable)((ProcessCanceledException)throwable);
                }
                GitRepository gitRepository = task.getRepository();
                GitRemote gitRemote = task.getRemote();
                Object object = e.getCause();
                if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                    object = "Error";
                }
                results.add(new SingleRemoteResult(gitRepository, gitRemote, (String)object, CollectionsKt.emptyList()));
                GitFetchSupportImplKt.access$getLOG$p().error((Throwable)e);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withIndicator(Function0<? extends T> operation) {
        ProgressIndicator indicator;
        ProgressIndicator progressIndicator = indicator = this.progressManager.getProgressIndicator();
        String prevText = progressIndicator != null ? progressIndicator.getText() : null;
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText("Fetching");
        }
        try {
            Object object = operation.invoke();
            return (T)object;
        }
        finally {
            block4: {
                ProgressIndicator progressIndicator3 = indicator;
                if (progressIndicator3 == null) break block4;
                progressIndicator3.setText(prevText);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SingleRemoteResult doFetch(GitRepository repository, GitRemote remote, GitAuthenticationGate authenticationGate) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        GitCommandResult gitCommandResult = this.git.fetch(repository, remote, (List<GitLineHandlerListener>)CollectionsKt.emptyList(), authenticationGate, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)gitCommandResult, (String)"git.fetch(repository, re\u2026st(), authenticationGate)");
        GitCommandResult result2 = gitCommandResult;
        List<String> list = result2.getOutput();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"result.output");
        Iterable iterable = $receiver$iv = (Iterable)list;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            String it = (String)element$iv$iv;
            boolean bl = false;
            String string2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
            if (this.getPrunedRef(string2) == null) continue;
            String it$iv$iv = string;
            destination$iv$iv.add(it$iv$iv);
        }
        List pruned = (List)destination$iv$iv;
        if (result2.success()) {
            ((GitAuthenticationListener)BackgroundTaskUtil.syncPublisher((Project)repository.getProject(), GitAuthenticationListener.GIT_AUTHENTICATION_SUCCESS)).authenticationSucceeded(repository, remote);
            repository.update();
        }
        String error = result2.success() ? null : result2.getErrorOutputAsJoinedString();
        return new SingleRemoteResult(repository, remote, error, pruned);
    }

    static /* synthetic */ SingleRemoteResult doFetch$default(GitFetchSupportImpl gitFetchSupportImpl, GitRepository gitRepository, GitRemote gitRemote, GitAuthenticationGate gitAuthenticationGate, int n, Object object) {
        if ((n & 4) != 0) {
            gitAuthenticationGate = null;
        }
        return gitFetchSupportImpl.doFetch(gitRepository, gitRemote, gitAuthenticationGate);
    }

    private final String getPrunedRef(String line) {
        Matcher matcher = GitFetchSupportImplKt.access$getPRUNE_PATTERN$p().matcher(line);
        return matcher.matches() ? matcher.group(1) : null;
    }

    public GitFetchSupportImpl(@NotNull Git git, @NotNull Project project, @NotNull ProgressManager progressManager, @NotNull VcsNotifier vcsNotifier) {
        Intrinsics.checkParameterIsNotNull((Object)git, (String)"git");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)progressManager, (String)"progressManager");
        Intrinsics.checkParameterIsNotNull((Object)vcsNotifier, (String)"vcsNotifier");
        this.project = project;
        this.progressManager = progressManager;
        this.vcsNotifier = vcsNotifier;
        this.git = (GitImpl)git;
    }

    public static final /* synthetic */ List access$fetchInParallel(GitFetchSupportImpl $this, List remotes) {
        return $this.fetchInParallel(remotes);
    }

    public static final /* synthetic */ List access$waitForFetchTasks(GitFetchSupportImpl $this, List tasks) {
        return $this.waitForFetchTasks(tasks);
    }

    public static final /* synthetic */ RepoResult access$mergeRepoResults(GitFetchSupportImpl $this, RepoResult firstResult, SingleRemoteResult secondResult) {
        return $this.mergeRepoResults(firstResult, secondResult);
    }

    public static final /* synthetic */ Project access$getProject$p(GitFetchSupportImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ VcsNotifier access$getVcsNotifier$p(GitFetchSupportImpl $this) {
        return $this.vcsNotifier;
    }

    public static final /* synthetic */ SingleRemoteResult access$doFetch(GitFetchSupportImpl $this, GitRepository repository, GitRemote remote, GitAuthenticationGate authenticationGate) {
        return $this.doFetch(repository, remote, authenticationGate);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$FetchTask;", "", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "future", "Ljava/util/concurrent/Future;", "Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;Ljava/util/concurrent/Future;)V", "getFuture", "()Ljava/util/concurrent/Future;", "getRemote", "()Lgit4idea/repo/GitRemote;", "getRepository", "()Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
    private static final class FetchTask {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final GitRemote remote;
        @NotNull
        private final Future<SingleRemoteResult> future;

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final GitRemote getRemote() {
            return this.remote;
        }

        @NotNull
        public final Future<SingleRemoteResult> getFuture() {
            return this.future;
        }

        public FetchTask(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull Future<SingleRemoteResult> future2) {
            Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
            Intrinsics.checkParameterIsNotNull((Object)remote, (String)"remote");
            Intrinsics.checkParameterIsNotNull(future2, (String)"future");
            this.repository = repository;
            this.remote = remote;
            this.future = future2;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\u000eR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "", "results", "", "Lgit4idea/repo/GitRemote;", "Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "(Ljava/util/Map;)V", "getResults", "()Ljava/util/Map;", "error", "", "multiRemoteMessage", "Lcom/intellij/dvcs/MultiMessage;", "remoteInPrefix", "", "prunedRefs", "totallySuccessful", "intellij.vcs.git"})
    private static final class RepoResult {
        @NotNull
        private final Map<GitRemote, SingleRemoteResult> results;

        public final boolean totallySuccessful() {
            boolean bl;
            block3: {
                Iterable $receiver$iv = this.results.values();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        SingleRemoteResult it = (SingleRemoteResult)element$iv;
                        boolean bl2 = false;
                        if (it.success()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        @Nullable
        public final String error() {
            MultiMessage<GitRemote> errorMessage = this.multiRemoteMessage(true);
            Map<GitRemote, SingleRemoteResult> map2 = this.results;
            Iterator<Map.Entry<GitRemote, SingleRemoteResult>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<GitRemote, SingleRemoteResult> entry;
                Map.Entry<GitRemote, SingleRemoteResult> entry2 = entry = iterator.next();
                GitRemote remote = entry2.getKey();
                entry2 = entry;
                SingleRemoteResult result2 = entry2.getValue();
                if (result2.getError() == null) continue;
                errorMessage.append((Object)remote, result2.getError());
            }
            return errorMessage.asString();
        }

        @NotNull
        public final String prunedRefs() {
            MultiMessage<GitRemote> prunedRefs = this.multiRemoteMessage(false);
            Map<GitRemote, SingleRemoteResult> map2 = this.results;
            for (Map.Entry<GitRemote, SingleRemoteResult> entry : map2.entrySet()) {
                Object object = entry;
                GitRemote remote = object.getKey();
                object = entry;
                SingleRemoteResult result2 = object.getValue();
                if (!(!(object = (Collection)result2.getPrunedRefs()).isEmpty())) continue;
                prunedRefs.append((Object)remote, CollectionsKt.joinToString$default((Iterable)result2.getPrunedRefs(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
            return prunedRefs.asString();
        }

        private final MultiMessage<GitRemote> multiRemoteMessage(boolean remoteInPrefix) {
            return new MultiMessage((Collection)this.results.keySet(), (Function1)multiRemoteMessage.1.INSTANCE, (Function1)multiRemoteMessage.2.INSTANCE, remoteInPrefix, false, 16, null);
        }

        @NotNull
        public final Map<GitRemote, SingleRemoteResult> getResults() {
            return this.results;
        }

        public RepoResult(@NotNull Map<GitRemote, SingleRemoteResult> results) {
            Intrinsics.checkParameterIsNotNull(results, (String)"results");
            this.results = results;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0013\u001a\u00020\u0014R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$SingleRemoteResult;", "", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "error", "", "prunedRefs", "", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;Ljava/lang/String;Ljava/util/List;)V", "getError", "()Ljava/lang/String;", "getPrunedRefs", "()Ljava/util/List;", "getRemote", "()Lgit4idea/repo/GitRemote;", "getRepository", "()Lgit4idea/repo/GitRepository;", "success", "", "intellij.vcs.git"})
    private static final class SingleRemoteResult {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final GitRemote remote;
        @Nullable
        private final String error;
        @NotNull
        private final List<String> prunedRefs;

        public final boolean success() {
            return this.error == null;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final GitRemote getRemote() {
            return this.remote;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        @NotNull
        public final List<String> getPrunedRefs() {
            return this.prunedRefs;
        }

        public SingleRemoteResult(@NotNull GitRepository repository, @NotNull GitRemote remote, @Nullable String error, @NotNull List<String> prunedRefs) {
            Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
            Intrinsics.checkParameterIsNotNull((Object)remote, (String)"remote");
            Intrinsics.checkParameterIsNotNull(prunedRefs, (String)"prunedRefs");
            this.repository = repository;
            this.remote = remote;
            this.error = error;
            this.prunedRefs = prunedRefs;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lgit4idea/fetch/GitFetchSupportImpl$FetchResultImpl;", "Lgit4idea/fetch/GitFetchResult;", "project", "Lcom/intellij/openapi/project/Project;", "vcsNotifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "results", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/fetch/GitFetchSupportImpl$RepoResult;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/VcsNotifier;Ljava/util/Map;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getResults", "()Ljava/util/Map;", "getVcsNotifier", "()Lcom/intellij/openapi/vcs/VcsNotifier;", "doShowNotification", "", "failureTitle", "", "prefixWithBr", "text", "showNotification", "showNotificationIfFailed", "", "title", "intellij.vcs.git"})
    private static final class FetchResultImpl
    implements GitFetchResult {
        @NotNull
        private final Project project;
        @NotNull
        private final VcsNotifier vcsNotifier;
        @NotNull
        private final Map<GitRepository, RepoResult> results;

        @Override
        public void showNotification() {
            FetchResultImpl.doShowNotification$default(this, null, 1, null);
        }

        @Override
        public boolean showNotificationIfFailed() {
            return this.showNotificationIfFailed("Fetch Failed");
        }

        @Override
        public boolean showNotificationIfFailed(@NotNull String title) {
            boolean failure;
            block4: {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
                Iterable $receiver$iv = this.results.values();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        RepoResult it = (RepoResult)element$iv;
                        boolean bl2 = false;
                        if (!(!it.totallySuccessful())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = failure = false;
                }
            }
            if (failure) {
                this.doShowNotification(title);
            }
            return !failure;
        }

        /*
         * WARNING - void declaration
         */
        private final void doShowNotification(String failureTitle) {
            String string;
            NotificationType type;
            RepoResult result2;
            Object repo;
            Map failed;
            Map.Entry<GitRepository, RepoResult> entry$iv2;
            Map it;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)this.results.keySet();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                GitRepository gitRepository = (GitRepository)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile = it.getRoot();
                collection.add(virtualFile);
            }
            List roots = (List)destination$iv$iv;
            MultiRootMessage errorMessage = new MultiRootMessage(this.project, (Collection)roots, true, false, 8, null);
            MultiRootMessage prunedRefs = new MultiRootMessage(this.project, (Collection)roots, false, false, 12, null);
            Map.Entry<GitRepository, RepoResult> $receiver$iv2 = this.results;
            Iterator<Map.Entry<GitRepository, RepoResult>> result$iv = new LinkedHashMap();
            it = $receiver$iv2;
            for (Map.Entry<GitRepository, RepoResult> entry$iv2 : it.entrySet()) {
                RepoResult it2 = entry$iv2.getValue();
                boolean bl = false;
                if (!(!it2.totallySuccessful())) continue;
                ((HashMap)((Object)result$iv)).put(entry$iv2.getKey(), entry$iv2.getValue());
            }
            it = failed = (Map)((Object)result$iv);
            result$iv = it.entrySet().iterator();
            while (result$iv.hasNext()) {
                entry$iv2 = $receiver$iv2 = (Map.Entry)result$iv.next();
                repo = (GitRepository)entry$iv2.getKey();
                entry$iv2 = $receiver$iv2;
                result2 = (RepoResult)entry$iv2.getValue();
                if (result2.error() == null) continue;
                VirtualFile virtualFile = repo.getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"repo.root");
                String string2 = result2.error();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                errorMessage.append((Object)virtualFile, string2);
            }
            repo = this.results;
            result$iv = repo.entrySet().iterator();
            while (result$iv.hasNext()) {
                entry$iv2 = $receiver$iv2 = result$iv.next();
                repo = entry$iv2.getKey();
                entry$iv2 = $receiver$iv2;
                result2 = entry$iv2.getValue();
                VirtualFile virtualFile = repo.getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"repo.root");
                prunedRefs.append((Object)virtualFile, result2.prunedRefs());
            }
            NotificationType notificationType = type = failed.isEmpty() ? NotificationType.INFORMATION : NotificationType.ERROR;
            if (failed.size() == roots.size()) {
                string = "";
            } else {
                String string3 = GitUtil.mention(failed.keySet());
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"mention(failed.keys)");
            }
            String mentionFailedRepos = string;
            String title = failed.isEmpty() ? "<b>Fetch Successful</b>" : "<b>" + failureTitle + "</b>" + mentionFailedRepos;
            String message = title + this.prefixWithBr(errorMessage.asString()) + this.prefixWithBr(prunedRefs.asString());
            Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification("", message, type, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)notification, (String)"STANDARD_NOTIFICATION.cr\u2026(\"\", message, type, null)");
            Notification notification2 = notification;
            this.vcsNotifier.notify(notification2);
        }

        static /* synthetic */ void doShowNotification$default(FetchResultImpl fetchResultImpl, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "Fetch Failed";
            }
            fetchResultImpl.doShowNotification(string);
        }

        private final String prefixWithBr(String text) {
            CharSequence charSequence = text;
            return charSequence.length() > 0 ? "<br/>" + text : "";
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VcsNotifier getVcsNotifier() {
            return this.vcsNotifier;
        }

        @NotNull
        public final Map<GitRepository, RepoResult> getResults() {
            return this.results;
        }

        public FetchResultImpl(@NotNull Project project, @NotNull VcsNotifier vcsNotifier, @NotNull Map<GitRepository, RepoResult> results) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)vcsNotifier, (String)"vcsNotifier");
            Intrinsics.checkParameterIsNotNull(results, (String)"results");
            this.project = project;
            this.vcsNotifier = vcsNotifier;
            this.results = results;
        }
    }
}

