/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.containers.ContainerUtil;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitAuthenticationGatesKt;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J!\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgit4idea/commands/GitRestrictingAuthenticationGate;", "Lgit4idea/commands/GitAuthenticationGate;", "()V", "cancelled", "", "inputData", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "semaphore", "Ljava/util/concurrent/Semaphore;", "cancel", "", "getSavedInput", "key", "saveInput", "value", "waitAndCompute", "T", "operation", "Ljava/util/function/Supplier;", "(Ljava/util/function/Supplier;)Ljava/lang/Object;", "intellij.vcs.git"})
public final class GitRestrictingAuthenticationGate
implements GitAuthenticationGate {
    private final Semaphore semaphore = new Semaphore(1);
    private volatile boolean cancelled;
    private final ConcurrentMap<String, String> inputData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T waitAndCompute(@NotNull Supplier<T> operation) {
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        try {
            GitAuthenticationGatesKt.access$getLOG$p().debug("Entered waitAndCompute");
            this.semaphore.acquire();
            GitAuthenticationGatesKt.access$getLOG$p().debug("Acquired permission");
            if (this.cancelled) {
                GitAuthenticationGatesKt.access$getLOG$p().debug("Authentication Gate has already been cancelled");
                throw (Throwable)new ProcessCanceledException();
            }
            T t = operation.get();
            return t;
        }
        catch (InterruptedException e) {
            GitAuthenticationGatesKt.access$getLOG$p().warn((Throwable)e);
            throw (Throwable)new ProcessCanceledException((Throwable)e);
        }
        finally {
            this.semaphore.release();
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    @Nullable
    public String getSavedInput(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return (String)this.inputData.get(key);
    }

    @Override
    public void saveInput(@NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Map map2 = this.inputData;
        String string = value;
        map2.put(key, string);
    }

    public GitRestrictingAuthenticationGate() {
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"newConcurrentMap<String, String>()");
        this.inputData = concurrentMap;
    }
}

