/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import groovy.lang.GroovySystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.Main;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineConverter;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.SystemPropertiesCommandLineConverter;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.initialization.LayoutCommandLineConverter;
import org.gradle.initialization.ParallelismConfigurationCommandLineConverter;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.Actions;
import org.gradle.internal.buildevents.BuildExceptionReporter;
import org.gradle.internal.concurrent.DefaultParallelismConfiguration;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.CachingJvmVersionDetector;
import org.gradle.internal.jvm.inspection.DefaultJvmVersionDetector;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.internal.logging.DefaultLoggingConfiguration;
import org.gradle.internal.logging.LoggingCommandLineConverter;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.LoggingOutputInternal;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.launcher.cli.BuildActionsFactory;
import org.gradle.launcher.cli.CommandLineAction;
import org.gradle.launcher.cli.ExceptionReportingAction;
import org.gradle.launcher.cli.KotlinDslVersion;
import org.gradle.launcher.cli.Parameters;
import org.gradle.launcher.cli.ParametersConverter;
import org.gradle.launcher.cli.converter.LayoutToPropertiesConverter;
import org.gradle.launcher.cli.converter.PropertiesToLogLevelConfigurationConverter;
import org.gradle.launcher.cli.converter.PropertiesToParallelismConfigurationConverter;
import org.gradle.process.internal.DefaultExecActionFactory;
import org.gradle.process.internal.ExecHandleFactory;
import org.gradle.util.GFileUtils;
import org.gradle.util.GradleVersion;

public class CommandLineActionFactory {
    public static final String WELCOME_MESSAGE_ENABLED_SYSTEM_PROPERTY = "org.gradle.internal.launcher.welcomeMessageEnabled";
    private static final String HELP = "h";
    private static final String VERSION = "v";
    private final BuildLayoutFactory buildLayoutFactory = new BuildLayoutFactory();

    public Action<ExecutionListener> convert(List<String> args) {
        ServiceRegistry loggingServices = this.createLoggingServices();
        DefaultLoggingConfiguration loggingConfiguration = new DefaultLoggingConfiguration();
        return new WithLogging(loggingServices, this.buildLayoutFactory, args, (LoggingConfiguration)loggingConfiguration, new ParseAndBuildAction(loggingServices, args), (Action<Throwable>)new BuildExceptionReporter((StyledTextOutputFactory)loggingServices.get(StyledTextOutputFactory.class), (LoggingConfiguration)loggingConfiguration, (BuildClientMetaData)CommandLineActionFactory.clientMetaData()));
    }

    protected void createActionFactories(ServiceRegistry loggingServices, Collection<CommandLineAction> actions) {
        actions.add(new BuildActionsFactory(loggingServices, (CommandLineConverter<Parameters>)new ParametersConverter(this.buildLayoutFactory), (JvmVersionDetector)new CachingJvmVersionDetector((JvmVersionDetector)new DefaultJvmVersionDetector((ExecHandleFactory)new DefaultExecActionFactory((FileResolver)new IdentityFileResolver())))));
    }

    private static GradleLauncherMetaData clientMetaData() {
        return new GradleLauncherMetaData();
    }

    public ServiceRegistry createLoggingServices() {
        return LoggingServiceRegistry.newCommandLineProcessLogging();
    }

    private static void showUsage(PrintStream out, CommandLineParser parser) {
        out.println();
        out.print("USAGE: ");
        CommandLineActionFactory.clientMetaData().describeCommand((Appendable)out, new String[]{"[option...]", "[task...]"});
        out.println();
        out.println();
        parser.printUsage((Appendable)out);
        out.println();
    }

    private class ParseAndBuildAction
    implements Action<ExecutionListener> {
        private final ServiceRegistry loggingServices;
        private final List<String> args;

        private ParseAndBuildAction(ServiceRegistry loggingServices, List<String> args) {
            this.loggingServices = loggingServices;
            this.args = args;
        }

        public void execute(ExecutionListener executionListener) {
            Action<? super ExecutionListener> action;
            ArrayList<CommandLineAction> actions = new ArrayList<CommandLineAction>();
            actions.add(new BuiltInActions());
            CommandLineActionFactory.this.createActionFactories(this.loggingServices, actions);
            CommandLineParser parser = new CommandLineParser();
            for (CommandLineAction action2 : actions) {
                action2.configureCommandLineParser(parser);
            }
            try {
                ParsedCommandLine commandLine = parser.parse(this.args);
                action = this.createAction(actions, parser, commandLine);
            }
            catch (CommandLineArgumentException e) {
                action = new Action<ExecutionListener>(parser, (Exception)((Object)e));
            }
            action.execute((Object)executionListener);
        }

        private Action<? super ExecutionListener> createAction(Iterable<CommandLineAction> factories, CommandLineParser parser, ParsedCommandLine commandLine) {
            for (CommandLineAction factory : factories) {
                Runnable action = factory.createAction(parser, commandLine);
                if (action == null) continue;
                return Actions.toAction((Runnable)action);
            }
            throw new UnsupportedOperationException("No action factory for specified command-line arguments.");
        }
    }

    private static class WithLogging
    implements Action<ExecutionListener> {
        private final ServiceRegistry loggingServices;
        private final BuildLayoutFactory buildLayoutFactory;
        private final List<String> args;
        private final LoggingConfiguration loggingConfiguration;
        private final Action<ExecutionListener> action;
        private final Action<Throwable> reporter;

        WithLogging(ServiceRegistry loggingServices, BuildLayoutFactory buildLayoutFactory, List<String> args, LoggingConfiguration loggingConfiguration, Action<ExecutionListener> action, Action<Throwable> reporter) {
            this.loggingServices = loggingServices;
            this.buildLayoutFactory = buildLayoutFactory;
            this.args = args;
            this.loggingConfiguration = loggingConfiguration;
            this.action = action;
            this.reporter = reporter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(ExecutionListener executionListener) {
            LoggingCommandLineConverter loggingConfigurationConverter = new LoggingCommandLineConverter();
            LayoutCommandLineConverter buildLayoutConverter = new LayoutCommandLineConverter();
            ParallelismConfigurationCommandLineConverter parallelConverter = new ParallelismConfigurationCommandLineConverter();
            SystemPropertiesCommandLineConverter systemPropertiesCommandLineConverter = new SystemPropertiesCommandLineConverter();
            LayoutToPropertiesConverter layoutToPropertiesConverter = new LayoutToPropertiesConverter(this.buildLayoutFactory);
            BuildLayoutParameters buildLayout = new BuildLayoutParameters();
            DefaultParallelismConfiguration parallelismConfiguration = new DefaultParallelismConfiguration();
            CommandLineParser parser = new CommandLineParser();
            loggingConfigurationConverter.configure(parser);
            buildLayoutConverter.configure(parser);
            parallelConverter.configure(parser);
            systemPropertiesCommandLineConverter.configure(parser);
            parser.allowUnknownOptions();
            parser.allowMixedSubcommandsAndOptions();
            try {
                ParsedCommandLine parsedCommandLine = parser.parse(this.args);
                buildLayoutConverter.convert(parsedCommandLine, (Object)buildLayout);
                HashMap<String, String> properties = new HashMap<String, String>();
                layoutToPropertiesConverter.convert(buildLayout, properties);
                systemPropertiesCommandLineConverter.convert(parsedCommandLine, properties);
                PropertiesToLogLevelConfigurationConverter propertiesToLogLevelConfigurationConverter = new PropertiesToLogLevelConfigurationConverter();
                propertiesToLogLevelConfigurationConverter.convert(properties, this.loggingConfiguration);
                loggingConfigurationConverter.convert(parsedCommandLine, (Object)this.loggingConfiguration);
                PropertiesToParallelismConfigurationConverter propertiesToParallelismConfigurationConverter = new PropertiesToParallelismConfigurationConverter();
                propertiesToParallelismConfigurationConverter.convert(properties, (ParallelismConfiguration)parallelismConfiguration);
                parallelConverter.convert(parsedCommandLine, (Object)parallelismConfiguration);
            }
            catch (CommandLineArgumentException parsedCommandLine) {
                // empty catch block
            }
            LoggingManagerInternal loggingManager = (LoggingManagerInternal)this.loggingServices.getFactory(LoggingManagerInternal.class).create();
            loggingManager.setLevelInternal(this.loggingConfiguration.getLogLevel());
            loggingManager.start();
            ExceptionReportingAction exceptionReportingAction = new ExceptionReportingAction(this.action, this.reporter, (LoggingOutputInternal)loggingManager);
            try {
                NativeServices.initialize((File)buildLayout.getGradleUserHomeDir());
                loggingManager.attachProcessConsole(this.loggingConfiguration.getConsoleOutput());
                new WelcomeMessageAction(buildLayout).execute(System.out);
                exceptionReportingAction.execute(executionListener);
            }
            finally {
                loggingManager.stop();
            }
        }
    }

    private static class ShowVersionAction
    implements Runnable {
        private ShowVersionAction() {
        }

        @Override
        public void run() {
            GradleVersion currentVersion = GradleVersion.current();
            KotlinDslVersion currentKotlinDslVersion = KotlinDslVersion.current();
            StringBuilder sb = new StringBuilder();
            sb.append("%n------------------------------------------------------------%nGradle ");
            sb.append(currentVersion.getVersion());
            sb.append("%n------------------------------------------------------------%n%nBuild time:   ");
            sb.append(currentVersion.getBuildTime());
            sb.append("%nRevision:     ");
            sb.append(currentVersion.getRevision());
            sb.append("%n%nKotlin DSL:   ");
            sb.append(currentKotlinDslVersion.getProviderVersion());
            sb.append("%nKotlin:       ");
            sb.append(currentKotlinDslVersion.getKotlinVersion());
            sb.append("%nGroovy:       ");
            sb.append(GroovySystem.getVersion());
            sb.append("%nAnt:          ");
            sb.append(Main.getAntVersion());
            sb.append("%nJVM:          ");
            sb.append(Jvm.current());
            sb.append("%nOS:           ");
            sb.append(OperatingSystem.current());
            sb.append("%n");
            System.out.println(String.format(sb.toString(), new Object[0]));
        }
    }

    private static class ShowUsageAction
    implements Runnable {
        private final CommandLineParser parser;

        public ShowUsageAction(CommandLineParser parser) {
            this.parser = parser;
        }

        @Override
        public void run() {
            CommandLineActionFactory.showUsage(System.out, this.parser);
        }
    }

    private static class CommandLineParseFailureAction
    implements Action<ExecutionListener> {
        private final Exception e;
        private final CommandLineParser parser;

        public CommandLineParseFailureAction(CommandLineParser parser, Exception e) {
            this.parser = parser;
            this.e = e;
        }

        public void execute(ExecutionListener executionListener) {
            System.err.println();
            System.err.println(this.e.getMessage());
            CommandLineActionFactory.showUsage(System.err, this.parser);
            executionListener.onFailure(this.e);
        }
    }

    private static class BuiltInActions
    implements CommandLineAction {
        private BuiltInActions() {
        }

        @Override
        public void configureCommandLineParser(CommandLineParser parser) {
            parser.option(new String[]{CommandLineActionFactory.HELP, "?", "help"}).hasDescription("Shows this help message.");
            parser.option(new String[]{CommandLineActionFactory.VERSION, "version"}).hasDescription("Print version info.");
        }

        @Override
        public Runnable createAction(CommandLineParser parser, ParsedCommandLine commandLine) {
            if (commandLine.hasOption(CommandLineActionFactory.HELP)) {
                return new ShowUsageAction(parser);
            }
            if (commandLine.hasOption(CommandLineActionFactory.VERSION)) {
                return new ShowVersionAction();
            }
            return null;
        }
    }

    static class WelcomeMessageAction
    implements Action<PrintStream> {
        private final BuildLayoutParameters buildLayoutParameters;
        private final GradleVersion gradleVersion;
        private final Function<String, InputStream> inputStreamProvider;

        WelcomeMessageAction(BuildLayoutParameters buildLayoutParameters) {
            this(buildLayoutParameters, GradleVersion.current(), new Function<String, InputStream>(){

                @Nullable
                public InputStream apply(@Nullable String input) {
                    return this.getClass().getClassLoader().getResourceAsStream(input);
                }
            });
        }

        @VisibleForTesting
        WelcomeMessageAction(BuildLayoutParameters buildLayoutParameters, GradleVersion gradleVersion, Function<String, InputStream> inputStreamProvider) {
            this.buildLayoutParameters = buildLayoutParameters;
            this.gradleVersion = gradleVersion;
            this.inputStreamProvider = inputStreamProvider;
        }

        public void execute(PrintStream out) {
            File markerFile;
            if (this.isWelcomeMessageEnabled() && !(markerFile = this.getMarkerFile()).exists()) {
                out.println();
                out.print("Welcome to Gradle " + this.gradleVersion.getVersion() + "!");
                String featureList = this.readReleaseFeatures();
                if (StringUtils.isNotBlank((String)featureList)) {
                    out.println();
                    out.println();
                    out.println("Here are the highlights of this release:");
                    out.print(featureList);
                }
                if (!this.gradleVersion.isSnapshot()) {
                    out.println();
                    out.println("For more details see https://docs.gradle.org/" + this.gradleVersion.getVersion() + "/release-notes.html");
                }
                out.println();
                this.writeMarkerFile(markerFile);
            }
        }

        private boolean isWelcomeMessageEnabled() {
            String messageEnabled = System.getProperty(CommandLineActionFactory.WELCOME_MESSAGE_ENABLED_SYSTEM_PROPERTY);
            if (messageEnabled == null) {
                return true;
            }
            return Boolean.parseBoolean(messageEnabled);
        }

        private File getMarkerFile() {
            File gradleUserHomeDir = this.buildLayoutParameters.getGradleUserHomeDir();
            File notificationsDir = new File(gradleUserHomeDir, "notifications");
            File versionedNotificationsDir = new File(notificationsDir, this.gradleVersion.getVersion());
            return new File(versionedNotificationsDir, "release-features.rendered");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readReleaseFeatures() {
            InputStream inputStream = (InputStream)this.inputStreamProvider.apply((Object)"release-features.txt");
            if (inputStream != null) {
                StringWriter writer = new StringWriter();
                try {
                    IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)"UTF-8");
                    String string = writer.toString();
                    return string;
                }
                catch (IOException iOException) {
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
            return null;
        }

        private void writeMarkerFile(File markerFile) {
            GFileUtils.mkdirs((File)markerFile.getParentFile());
            GFileUtils.touch((File)markerFile);
        }
    }
}

