/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.extensions.impl.XmlExtensionAdapter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.containers.StringInterner;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;

public abstract class ExtensionPointImpl<T>
implements ExtensionPoint<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.extensions.impl.ExtensionPointImpl");
    private static Set<ExtensionPointImpl<?>> POINTS_IN_READONLY_MODE;
    private final String myName;
    private final String myClassName;
    private volatile List<T> myExtensionsCache;
    @Nullable
    private volatile T[] myExtensionsCacheAsArray;
    protected final ExtensionsAreaImpl myOwner;
    private final PluginDescriptor myDescriptor;
    @NotNull
    protected List<ExtensionComponentAdapter> myAdapters;
    @NotNull
    private List<ExtensionComponentAdapter> myLoadedAdapters;
    @NotNull
    private ExtensionPointListener<T>[] myListeners;
    @Nullable
    protected Class<T> myExtensionClass;
    private static final StringInterner INTERNER;
    private boolean processingAdaptersNow;
    static Runnable CHECK_CANCELED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtensionPointImpl(@NotNull String name, @NotNull String className, @NotNull ExtensionsAreaImpl owner, @NotNull PluginDescriptor pluginDescriptor) {
        if (name == null) {
            ExtensionPointImpl.$$$reportNull$$$0(0);
        }
        if (className == null) {
            ExtensionPointImpl.$$$reportNull$$$0(1);
        }
        if (owner == null) {
            ExtensionPointImpl.$$$reportNull$$$0(2);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(3);
        }
        this.myAdapters = Collections.emptyList();
        this.myLoadedAdapters = Collections.emptyList();
        this.myListeners = ExtensionPointListener.EMPTY_ARRAY;
        StringInterner stringInterner = INTERNER;
        synchronized (stringInterner) {
            this.myName = (String)INTERNER.intern((Object)name);
        }
        this.myClassName = className;
        this.myOwner = owner;
        this.myDescriptor = pluginDescriptor;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ExtensionPointImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public AreaInstance getArea() {
        return this.myOwner.getAreaInstance();
    }

    @Override
    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            ExtensionPointImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public void registerExtension(@NotNull T extension) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(6);
        }
        this.registerExtension(extension, LoadingOrder.ANY, null);
    }

    @Override
    public void registerExtension(@NotNull T extension, @NotNull LoadingOrder order) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(7);
        }
        if (order == null) {
            ExtensionPointImpl.$$$reportNull$$$0(8);
        }
        this.registerExtension(extension, order, null);
    }

    @Override
    public void registerExtension(@NotNull T extension, @NotNull Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(9);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(10);
        }
        this.registerExtension(extension, LoadingOrder.ANY, parentDisposable);
    }

    @NotNull
    final PluginDescriptor getDescriptor() {
        PluginDescriptor pluginDescriptor = this.myDescriptor;
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(11);
        }
        return pluginDescriptor;
    }

    @Override
    public synchronized void registerExtension(final @NotNull T extension, @NotNull LoadingOrder order, @Nullable Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(12);
        }
        if (order == null) {
            ExtensionPointImpl.$$$reportNull$$$0(13);
        }
        this.checkReadOnlyMode();
        for (ExtensionComponentAdapter adapter : this.myLoadedAdapters) {
            if (!(adapter instanceof ObjectComponentAdapter) || ((ObjectComponentAdapter)adapter).myComponentInstance != extension) continue;
            LOG.error("Extension was already added: " + extension);
            return;
        }
        final ObjectComponentAdapter adapter = new ObjectComponentAdapter(extension, order);
        if (LoadingOrder.ANY == order) {
            this.registerExtension(extension, adapter, this.findInsertionIndexForAnyOrder(), true);
        } else {
            this.registerExtensionAdapter(adapter);
            this.getExtensionList();
        }
        if (parentDisposable == null) {
            return;
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                ExtensionPointImpl extensionPointImpl = ExtensionPointImpl.this;
                synchronized (extensionPointImpl) {
                    List<ExtensionComponentAdapter> list = ExtensionPointImpl.this.myLoadedAdapters;
                    int index = ContainerUtil.indexOfIdentity((List)list, (Object)adapter);
                    if (index < 0) {
                        list = ExtensionPointImpl.this.myAdapters;
                        index = ContainerUtil.indexOfIdentity(list, (Object)adapter);
                    }
                    if (index < 0) {
                        LOG.error("Extension to be removed not found: " + extension);
                    }
                    list.remove(index);
                    ExtensionPointImpl.this.clearCache();
                    ExtensionPointImpl.this.notifyListenersOnRemove(extension, adapter.getPluginDescriptor(), ExtensionPointImpl.this.myListeners);
                }
            }
        });
    }

    public synchronized void registerExtensions(@NotNull List<? extends T> extensions) {
        int firstIndex;
        if (extensions == null) {
            ExtensionPointImpl.$$$reportNull$$$0(14);
        }
        for (ExtensionComponentAdapter adapter : this.myLoadedAdapters) {
            Iterator<T> instance;
            if (!(adapter instanceof ObjectComponentAdapter) || !ContainerUtil.containsIdentity(extensions, instance = ((ObjectComponentAdapter)adapter).myComponentInstance)) continue;
            LOG.error("Extension was already added: " + instance);
            return;
        }
        int index = firstIndex = this.findInsertionIndexForAnyOrder();
        if (this.myLoadedAdapters == Collections.emptyList()) {
            this.myLoadedAdapters = new ArrayList<ExtensionComponentAdapter>();
        }
        for (T extension : extensions) {
            this.myLoadedAdapters.add(index++, new ObjectComponentAdapter(extension, LoadingOrder.ANY));
        }
        this.clearCache();
        for (int i = firstIndex; i < index; ++i) {
            this.notifyListenersOnAdd(((ObjectComponentAdapter)this.myLoadedAdapters.get(i)).myComponentInstance, null, this.myListeners);
        }
    }

    private synchronized int findInsertionIndexForAnyOrder() {
        ExtensionComponentAdapter lastAdapter;
        int index;
        for (index = this.myLoadedAdapters.size(); index > 0 && (lastAdapter = this.myLoadedAdapters.get(index - 1)).getOrder() == LoadingOrder.LAST; --index) {
        }
        return index;
    }

    private synchronized void registerExtension(@NotNull T extension, @NotNull ExtensionComponentAdapter adapter, int index, boolean runNotifications) {
        Class<T> extensionClass;
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(15);
        }
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(16);
        }
        if (!(extensionClass = this.getExtensionClass()).isInstance(extension)) {
            throw new RuntimeException("Extension " + extension.getClass() + " does not implement " + extensionClass + ". It came from " + adapter);
        }
        if (this.myLoadedAdapters == Collections.emptyList()) {
            this.myLoadedAdapters = new ArrayList<ExtensionComponentAdapter>();
        }
        if (index == -1) {
            this.myLoadedAdapters.add(adapter);
        } else {
            this.myLoadedAdapters.add(index, adapter);
        }
        if (runNotifications) {
            this.clearCache();
            if (!adapter.isNotificationSent()) {
                this.notifyListenersOnAdd(extension, adapter.getPluginDescriptor(), this.myListeners);
                adapter.setNotificationSent();
            }
        }
    }

    private void notifyListenersOnAdd(@NotNull T extension, @Nullable PluginDescriptor pluginDescriptor, @NotNull ExtensionPointListener<T>[] listeners) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(17);
        }
        if (listeners == null) {
            ExtensionPointImpl.$$$reportNull$$$0(18);
        }
        for (ExtensionPointListener<T> listener : listeners) {
            try {
                listener.extensionAdded(extension, pluginDescriptor);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<T> getExtensionList() {
        ImmutableList result = this.myExtensionsCache;
        if (result == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                result = this.myExtensionsCache;
                if (result == null) {
                    Object[] array = this.processAdapters();
                    this.myExtensionsCacheAsArray = array;
                    this.myExtensionsCache = result = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList((Object[])array);
                }
            }
        }
        ImmutableList immutableList = result;
        if (immutableList == null) {
            ExtensionPointImpl.$$$reportNull$$$0(19);
        }
        return immutableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public T[] getExtensions() {
        Object[] array = this.myExtensionsCacheAsArray;
        if (array == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                array = this.myExtensionsCacheAsArray;
                if (array == null) {
                    array = this.processAdapters();
                    this.myExtensionsCacheAsArray = array;
                    this.myExtensionsCache = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList((Object[])array);
                }
            }
        }
        Object[] objectArray = array.length == 0 ? array : (Object[])array.clone();
        if (objectArray == null) {
            ExtensionPointImpl.$$$reportNull$$$0(20);
        }
        return objectArray;
    }

    @Override
    @NotNull
    public Stream<T> extensions() {
        Stream stream = this.getExtensionList().stream();
        if (stream == null) {
            ExtensionPointImpl.$$$reportNull$$$0(21);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAnyExtensions() {
        List<T> cache = this.myExtensionsCache;
        if (cache != null) {
            return !cache.isEmpty();
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            return this.myAdapters.size() + this.myLoadedAdapters.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private synchronized T[] processAdapters() {
        Object[] objectArray;
        block15: {
            if (this.processingAdaptersNow) {
                throw new IllegalStateException("Recursive processAdapters() detected. You must have called 'getExtensions()' from within your extension constructor - don't. Either pass extension via constructor parameter or call getExtensions() later.");
            }
            this.checkReadOnlyMode();
            int totalSize = this.myAdapters.size() + this.myLoadedAdapters.size();
            Class<T> extensionClass = this.getExtensionClass();
            Object[] result = (Object[])Array.newInstance(extensionClass, totalSize);
            if (totalSize == 0) {
                if (result == null) {
                    ExtensionPointImpl.$$$reportNull$$$0(22);
                }
                return result;
            }
            CHECK_CANCELED.run();
            this.processingAdaptersNow = true;
            Object[] adapters = this.myAdapters.toArray(new ExtensionComponentAdapter[totalSize]);
            ArrayUtil.copy(this.myLoadedAdapters, (Object[])adapters, (int)this.myAdapters.size());
            LoadingOrder.sort((LoadingOrder.Orderable[])adapters);
            Set loaded = ContainerUtil.newHashOrEmptySet(this.myLoadedAdapters);
            OpenTHashSet duplicates = new OpenTHashSet(adapters.length);
            this.myLoadedAdapters = Collections.emptyList();
            this.myAdapters = Collections.emptyList();
            int extensionIndex = 0;
            for (int i = 0; i < adapters.length; ++i) {
                Object adapter = adapters[i];
                try {
                    Object extension = ((ExtensionComponentAdapter)adapter).createInstance((PicoContainer)this.myOwner.getPicoContainer());
                    if (!duplicates.add(extension)) {
                        Object duplicate = duplicates.get(extension);
                        LOG.error("Duplicate extension found: " + extension + ";  Prev extension:  " + duplicate + ";\n Adapter:         " + adapter + ";\n Extension class: " + this.getExtensionClass() + ";\n result:" + Arrays.asList(result));
                        continue;
                    }
                    this.registerExtension(extension, (ExtensionComponentAdapter)adapter, -1, !loaded.contains(adapter));
                    result[extensionIndex++] = extension;
                    continue;
                }
                catch (ExtensionNotApplicableException ignore) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(adapter + " not loaded because it reported that not applicable");
                    continue;
                }
                catch (ProcessCanceledException e) {
                    this.addBackNotLoadedAdapters((ExtensionComponentAdapter[])adapters, i);
                    throw e;
                }
                catch (Throwable e) {
                    try {
                        LOG.error(e);
                        continue;
                    }
                    catch (Throwable testError) {
                        this.addBackNotLoadedAdapters((ExtensionComponentAdapter[])adapters, i);
                        throw testError;
                    }
                }
            }
            if (extensionIndex != result.length) {
                result = Arrays.copyOf(result, extensionIndex);
            }
            objectArray = result;
            if (objectArray != null) break block15;
            ExtensionPointImpl.$$$reportNull$$$0(23);
        }
        return objectArray;
        finally {
            this.processingAdaptersNow = false;
        }
    }

    private synchronized void addBackNotLoadedAdapters(@NotNull ExtensionComponentAdapter[] allAdapters, int failedIndex) {
        if (allAdapters == null) {
            ExtensionPointImpl.$$$reportNull$$$0(24);
        }
        ArrayList<ExtensionComponentAdapter> adapters = new ArrayList<ExtensionComponentAdapter>(allAdapters.length - failedIndex);
        for (int i = failedIndex; i < allAdapters.length; ++i) {
            adapters.add(allAdapters[i]);
        }
        this.myAdapters = adapters;
    }

    public synchronized void removeUnloadableExtensions() {
        ExtensionComponentAdapter[] adapters;
        for (ExtensionComponentAdapter adapter : adapters = this.myAdapters.toArray(ExtensionComponentAdapter.EMPTY_ARRAY)) {
            try {
                adapter.getImplementationClass();
            }
            catch (Throwable e) {
                this.unregisterExtensionAdapter(adapter);
            }
        }
    }

    @Override
    @Nullable
    public T getExtension() {
        List<T> extensions = this.getExtensionList();
        return extensions.isEmpty() ? null : (T)extensions.get(0);
    }

    @Override
    public synchronized boolean hasExtension(@NotNull T extension) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(25);
        }
        return ContainerUtil.containsIdentity(this.getExtensionList(), extension);
    }

    public synchronized void maskAll(final @NotNull List<T> list, @NotNull Disposable parentDisposable) {
        if (list == null) {
            ExtensionPointImpl.$$$reportNull$$$0(26);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(27);
        }
        if (POINTS_IN_READONLY_MODE == null) {
            POINTS_IN_READONLY_MODE = ContainerUtil.newIdentityTroveSet();
        } else {
            this.checkReadOnlyMode();
        }
        final List<T> oldList = this.myExtensionsCache;
        final Object[] oldArray = this.myExtensionsCacheAsArray;
        this.myExtensionsCache = list;
        this.myExtensionsCacheAsArray = list.toArray((Object[])Array.newInstance(this.getExtensionClass(), 0));
        POINTS_IN_READONLY_MODE.add(this);
        if (oldList != null) {
            for (Object object : oldList) {
                this.notifyListenersOnRemove(object, null, this.myListeners);
            }
        }
        for (Object object : list) {
            this.notifyListenersOnAdd(object, null, this.myListeners);
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    POINTS_IN_READONLY_MODE.remove(ExtensionPointImpl.this);
                    ExtensionPointImpl.this.myExtensionsCache = oldList;
                    ExtensionPointImpl.access$902(ExtensionPointImpl.this, oldArray);
                    for (Object extension : list) {
                        ExtensionPointImpl.this.notifyListenersOnRemove(extension, null, ExtensionPointImpl.this.myListeners);
                    }
                    if (oldList != null) {
                        for (Object extension : oldList) {
                            ExtensionPointImpl.this.notifyListenersOnAdd(extension, null, ExtensionPointImpl.this.myListeners);
                        }
                    }
                }
            }
        });
    }

    @Override
    public synchronized void unregisterExtensions(@NotNull Predicate<T> filter) {
        if (filter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(28);
        }
        List<T> extensions = this.getExtensionList();
        List<ExtensionComponentAdapter> loadedAdapters = this.myLoadedAdapters;
        for (int i = loadedAdapters.size() - 1; i >= 0; --i) {
            T extension = extensions.get(i);
            if (filter.test(extension)) continue;
            ExtensionComponentAdapter adapter = loadedAdapters.remove(i);
            this.notifyListenersOnRemove(extension, adapter.getPluginDescriptor(), this.myListeners);
        }
        this.clearCache();
    }

    @Override
    public synchronized void unregisterExtension(@NotNull T extension) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(29);
        }
        T[] extensions = this.myExtensionsCacheAsArray;
        List<ExtensionComponentAdapter> loadedAdapters = this.myLoadedAdapters;
        for (int i = 0; i < loadedAdapters.size(); ++i) {
            ExtensionComponentAdapter adapter = loadedAdapters.get(i);
            if (adapter instanceof ObjectComponentAdapter ? ((ObjectComponentAdapter)adapter).myComponentInstance != extension : extensions == null || extensions[i] != extension) continue;
            loadedAdapters.remove(i);
            this.clearCache();
            this.notifyListenersOnRemove(extension, adapter.getPluginDescriptor(), this.myListeners);
            return;
        }
        LOG.warn("Extension to be removed not found: " + extension);
    }

    @Override
    public void unregisterExtension(@NotNull Class<? extends T> extensionClass) {
        String classNameToUnregister;
        if (extensionClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(30);
        }
        if (!this.unregisterExtensions((arg_0, arg_1) -> ExtensionPointImpl.lambda$unregisterExtension$0(classNameToUnregister = extensionClass.getCanonicalName(), arg_0, arg_1), true)) {
            LOG.warn("Extension to be removed not found: " + extensionClass);
        }
    }

    @Override
    public synchronized boolean unregisterExtensions(@NotNull BiPredicate<String, ExtensionComponentAdapter> extensionClassFilter, boolean stopAfterFirstMatch) {
        if (extensionClassFilter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(31);
        }
        boolean found = false;
        for (ExtensionComponentAdapter adapter : ContainerUtil.concat(this.myAdapters, this.myLoadedAdapters)) {
            if (extensionClassFilter.test(adapter.getAssignableToClassName(), adapter)) continue;
            this.unregisterExtensionAdapter(adapter);
            if (stopAfterFirstMatch) {
                return true;
            }
            found = true;
        }
        return found;
    }

    private void notifyListenersOnRemove(@NotNull T extensionObject, @Nullable PluginDescriptor pluginDescriptor, @NotNull ExtensionPointListener<T>[] listeners) {
        if (extensionObject == null) {
            ExtensionPointImpl.$$$reportNull$$$0(32);
        }
        if (listeners == null) {
            ExtensionPointImpl.$$$reportNull$$$0(33);
        }
        for (ExtensionPointListener<T> listener : listeners) {
            try {
                listener.extensionRemoved(extensionObject, pluginDescriptor);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    @Override
    public synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener, boolean invokeForLoadedExtensions, @Nullable Disposable parentDisposable) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(34);
        }
        if (invokeForLoadedExtensions) {
            this.addExtensionPointListener(listener);
        } else {
            this.addListener(listener);
        }
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> this.removeExtensionPointListener(listener));
        }
    }

    private synchronized boolean addListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(35);
        }
        if (ArrayUtil.indexOf((Object[])this.myListeners, listener) != -1) {
            return false;
        }
        this.myListeners = (ExtensionPointListener[])ArrayUtil.append((Object[])this.myListeners, listener, n -> n == 0 ? ExtensionPointListener.EMPTY_ARRAY : new ExtensionPointListener[n]);
        return true;
    }

    private synchronized boolean removeListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(36);
        }
        if (ArrayUtil.indexOf((Object[])this.myListeners, listener) == -1) {
            return false;
        }
        this.myListeners = (ExtensionPointListener[])ArrayUtil.remove((Object[])this.myListeners, listener, n -> n == 0 ? ExtensionPointListener.EMPTY_ARRAY : new ExtensionPointListener[n]);
        return true;
    }

    @Override
    public synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(37);
        }
        this.getExtensionList();
        if (this.addListener(listener)) {
            this.notifyListenersAboutLoadedExtensions(this.myLoadedAdapters, listener, false);
        }
    }

    @Override
    public void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(38);
        }
        this.removeListener(listener);
    }

    @Override
    public synchronized void reset() {
        List<ExtensionComponentAdapter> loadedAdapters = this.myLoadedAdapters;
        this.myLoadedAdapters = Collections.emptyList();
        this.myAdapters = Collections.emptyList();
        this.notifyListenersAboutLoadedExtensions(loadedAdapters, null, true);
        this.clearCache();
    }

    private synchronized void notifyListenersAboutLoadedExtensions(@NotNull List<ExtensionComponentAdapter> loadedAdapters, @Nullable ExtensionPointListener<T> onlyListener, boolean isRemoved) {
        ExtensionPointListener<T>[] listeners;
        if (loadedAdapters == null) {
            ExtensionPointImpl.$$$reportNull$$$0(39);
        }
        if ((listeners = this.myListeners).length == 0) {
            return;
        }
        T[] extensions = this.myExtensionsCacheAsArray;
        int size = loadedAdapters.size();
        for (int i = 0; i < size; ++i) {
            Object extension;
            ExtensionComponentAdapter adapter = loadedAdapters.get(i);
            if (adapter instanceof ObjectComponentAdapter) {
                extension = ((ObjectComponentAdapter)adapter).myComponentInstance;
            } else {
                if (extensions == null) continue;
                extension = extensions[i];
            }
            if (isRemoved) {
                if (onlyListener == null) {
                    this.notifyListenersOnRemove(extension, adapter.getPluginDescriptor(), listeners);
                    continue;
                }
                onlyListener.extensionRemoved(extension, adapter.getPluginDescriptor());
                continue;
            }
            if (onlyListener == null) {
                this.notifyListenersOnAdd(extension, adapter.getPluginDescriptor(), listeners);
                continue;
            }
            onlyListener.extensionAdded(extension, adapter.getPluginDescriptor());
        }
    }

    @Override
    @NotNull
    public Class<T> getExtensionClass() {
        Class<Object> extensionClass = this.myExtensionClass;
        if (extensionClass == null) {
            try {
                ClassLoader pluginClassLoader = this.myDescriptor.getPluginClassLoader();
                Class<?> extClass = pluginClassLoader == null ? Class.forName(this.myClassName) : Class.forName(this.myClassName, true, pluginClassLoader);
                this.myExtensionClass = extensionClass = extClass;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        Class<T> clazz = extensionClass;
        if (clazz == null) {
            ExtensionPointImpl.$$$reportNull$$$0(40);
        }
        return clazz;
    }

    public String toString() {
        return this.getName();
    }

    synchronized void registerExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(41);
        }
        if (this.myAdapters == Collections.emptyList()) {
            this.myAdapters = new ArrayList<ExtensionComponentAdapter>();
        }
        this.myAdapters.add(adapter);
        this.clearCache();
    }

    private synchronized void clearCache() {
        this.myExtensionsCache = null;
        this.myExtensionsCacheAsArray = null;
        this.checkReadOnlyMode();
    }

    private void checkReadOnlyMode() {
        if (this.isInReadOnlyMode()) {
            throw new IllegalStateException(this + " in a read-only mode and cannot be modified");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void unregisterExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(42);
        }
        try {
            Object extensionInstance;
            if (!this.myAdapters.isEmpty() && this.myAdapters.remove(adapter)) {
                return;
            }
            int index = ContainerUtil.indexOfIdentity(this.myLoadedAdapters, (Object)adapter);
            if (index == -1) {
                return;
            }
            if (adapter instanceof ComponentAdapter) {
                this.myOwner.getPicoContainer().unregisterComponent(((ComponentAdapter)adapter).getComponentKey());
            }
            this.myLoadedAdapters.remove(index);
            if (adapter instanceof ObjectComponentAdapter) {
                extensionInstance = ((ObjectComponentAdapter)adapter).myComponentInstance;
            } else {
                T[] array = this.myExtensionsCacheAsArray;
                if (array == null) {
                    return;
                }
                extensionInstance = array[index];
            }
            this.notifyListenersOnRemove(extensionInstance, adapter.getPluginDescriptor(), this.myListeners);
        }
        finally {
            this.clearCache();
        }
    }

    @NotNull
    protected abstract ExtensionComponentAdapter createAdapter(@NotNull Element var1, @NotNull PluginDescriptor var2);

    @NotNull
    ExtensionComponentAdapter createAndRegisterAdapter(@NotNull Element extensionElement, @NotNull PluginDescriptor pluginDescriptor) {
        if (extensionElement == null) {
            ExtensionPointImpl.$$$reportNull$$$0(43);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(44);
        }
        ExtensionComponentAdapter adapter = this.createAdapter(extensionElement, pluginDescriptor);
        this.registerExtensionAdapter(adapter);
        ExtensionComponentAdapter extensionComponentAdapter = adapter;
        if (extensionComponentAdapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(45);
        }
        return extensionComponentAdapter;
    }

    @NotNull
    protected static ExtensionComponentAdapter doCreateAdapter(@NotNull String implementationClassName, @NotNull Element extensionElement, boolean isNeedToDeserialize, @NotNull PluginDescriptor pluginDescriptor, boolean isConstructorInjectionSupported) {
        Element effectiveElement;
        if (implementationClassName == null) {
            ExtensionPointImpl.$$$reportNull$$$0(46);
        }
        if (extensionElement == null) {
            ExtensionPointImpl.$$$reportNull$$$0(47);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(48);
        }
        String orderId = extensionElement.getAttributeValue("id");
        LoadingOrder order = LoadingOrder.readOrder(extensionElement.getAttributeValue("order"));
        Object object = effectiveElement = isNeedToDeserialize ? extensionElement : null;
        if (isConstructorInjectionSupported) {
            XmlExtensionAdapter.ConstructorInjectionAdapter constructorInjectionAdapter = new XmlExtensionAdapter.ConstructorInjectionAdapter(implementationClassName, pluginDescriptor, orderId, order, effectiveElement);
            if (constructorInjectionAdapter == null) {
                ExtensionPointImpl.$$$reportNull$$$0(49);
            }
            return constructorInjectionAdapter;
        }
        XmlExtensionAdapter xmlExtensionAdapter = new XmlExtensionAdapter(implementationClassName, pluginDescriptor, orderId, order, effectiveElement);
        if (xmlExtensionAdapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(50);
        }
        return xmlExtensionAdapter;
    }

    final synchronized void notifyAreaReplaced(@NotNull ExtensionsArea oldArea) {
        if (oldArea == null) {
            ExtensionPointImpl.$$$reportNull$$$0(51);
        }
        for (ExtensionPointListener<T> listener : this.myListeners) {
            if (!(listener instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener).areaReplaced(oldArea);
        }
    }

    public synchronized boolean isInReadOnlyMode() {
        return POINTS_IN_READONLY_MODE != null && POINTS_IN_READONLY_MODE.contains(this);
    }

    public static void setCheckCanceledAction(Runnable checkCanceled) {
        CHECK_CANCELED = () -> {
            block2: {
                try {
                    checkCanceled.run();
                }
                catch (ProcessCanceledException e) {
                    if (ExtensionPointImpl.isInsideClassInitializer(e.getStackTrace())) break block2;
                    throw e;
                }
            }
        };
    }

    private static boolean isInsideClassInitializer(StackTraceElement[] trace) {
        return Arrays.stream(trace).anyMatch(s -> "<clinit>".equals(s.getMethodName()));
    }

    private static /* synthetic */ boolean lambda$unregisterExtension$0(String classNameToUnregister, String className, ExtensionComponentAdapter adapter) {
        return !className.equals(classNameToUnregister);
    }

    static /* synthetic */ Object[] access$902(ExtensionPointImpl x0, Object[] x1) {
        x0.myExtensionsCacheAsArray = x1;
        return x1;
    }

    static {
        INTERNER = new StringInterner();
        CHECK_CANCELED = EmptyRunnable.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 40: 
            case 45: 
            case 49: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 40: 
            case 45: 
            case 49: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 40: 
            case 45: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 10: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 16: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 18: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allAdapters";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClassFilter";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionObject";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedAdapters";
                break;
            }
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElement";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementationClassName";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionList";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "extensions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "processAdapters";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionClass";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndRegisterAdapter";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 40: 
            case 45: 
            case 49: 
            case 50: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersOnAdd";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addBackNotLoadedAdapters";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasExtension";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "maskAll";
                break;
            }
            case 28: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensions";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtension";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersOnRemove";
                break;
            }
            case 34: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionPointListener";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "removeExtensionPointListener";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersAboutLoadedExtensions";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionAdapter";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensionAdapter";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createAndRegisterAdapter";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "doCreateAdapter";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "notifyAreaReplaced";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 40: 
            case 45: 
            case 49: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ObjectComponentAdapter<T>
    extends ExtensionComponentAdapter {
        private final T myComponentInstance;

        private ObjectComponentAdapter(@NotNull T extension, @NotNull LoadingOrder loadingOrder) {
            if (extension == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(0);
            }
            if (loadingOrder == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(1);
            }
            super(extension.getClass().getName(), null, null, loadingOrder);
            this.myComponentInstance = extension;
        }

        @NotNull
        public T createInstance(@Nullable PicoContainer container) {
            T t = this.myComponentInstance;
            if (t == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(2);
            }
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loadingOrder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

