/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class AssertTrueOrFalsePredicate
implements PsiElementPredicate {
    AssertTrueOrFalsePredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression expression2 = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = expression2.getArgumentList();
        int numExpressions = argumentList.getExpressionCount();
        if (numExpressions < 1 || numExpressions > 2) {
            return false;
        }
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"assertTrue".equals(methodName) && !"assertFalse".equals(methodName)) {
            return false;
        }
        PsiMethod method = expression2.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass targetClass = method.getContainingClass();
        if (targetClass == null) {
            return false;
        }
        String qualifiedName = targetClass.getQualifiedName();
        if (!"junit.framework.Assert".equals(qualifiedName) && !"org.junit.Assert".equals(qualifiedName)) {
            return false;
        }
        return !ErrorUtil.containsError(element);
    }
}

