/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.threading.ThreadingUtils;
import org.jetbrains.annotations.NotNull;

public class AwaitWithoutCorrespondingSignalInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("await.without.corresponding.signal.display.name", new Object[0]);
        if (string == null) {
            AwaitWithoutCorrespondingSignalInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("await.without.corresponding.signal.problem.descriptor", new Object[0]);
        if (string == null) {
            AwaitWithoutCorrespondingSignalInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AwaitWithoutCorrespondingSignalVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/AwaitWithoutCorrespondingSignalInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ContainsSignalVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiField target;
        private boolean containsSignal;

        ContainsSignalVisitor(PsiField target) {
            this.target = target;
        }

        public void visitElement(PsiElement element) {
            if (this.containsSignal) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!ThreadingUtils.isSignalOrSignalAllCall(expression2)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (referent == null) {
                return;
            }
            if (!this.target.equals(referent)) {
                return;
            }
            this.containsSignal = true;
        }

        boolean containsSignal() {
            return this.containsSignal;
        }
    }

    private static class AwaitWithoutCorrespondingSignalVisitor
    extends BaseInspectionVisitor {
        private AwaitWithoutCorrespondingSignalVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                AwaitWithoutCorrespondingSignalVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            if (!ThreadingUtils.isAwaitCall(expression2)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            PsiClass fieldClass = field.getContainingClass();
            if (fieldClass == null) {
                return;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)fieldClass, (PsiElement)expression2, (boolean)true)) {
                return;
            }
            if (AwaitWithoutCorrespondingSignalVisitor.containsSignalCall(fieldClass, field)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static boolean containsSignalCall(PsiClass fieldClass, PsiField field) {
            ContainsSignalVisitor visitor = new ContainsSignalVisitor(field);
            fieldClass.accept((PsiElementVisitor)visitor);
            return visitor.containsSignal();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/AwaitWithoutCorrespondingSignalInspection$AwaitWithoutCorrespondingSignalVisitor", "visitMethodCallExpression"));
        }
    }
}

