/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.redundancy;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantCollectionOperationInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    private static final CallMatcher TO_ARRAY = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "toArray").parameterCount(0), CallMatcher.instanceCall("java.util.Collection", "toArray").parameterTypes("T[]"));
    private static final CallMatcher SUBLIST = CallMatcher.instanceCall("java.util.List", "subList").parameterTypes("int", "int");
    private static final CallMatcher AS_LIST = CallMatcher.staticCall("java.util.Arrays", "asList").parameterCount(1);
    private static final CallMatcher SINGLETON = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Collections", "singleton", "singletonList").parameterCount(1), CallMatcher.staticCall("java.util.List", "of").parameterTypes("E"), CallMatcher.staticCall("java.util.Set", "of").parameterTypes("E"));
    private static final CallMatcher EMPTY_COLLECTION = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Collections", "emptyList", "emptySet").parameterCount(0), CallMatcher.staticCall("java.util.List", "of").parameterCount(0), CallMatcher.staticCall("java.util.Set", "of").parameterCount(0));
    private static final CallMatcher CONTAINS_ALL = CallMatcher.instanceCall("java.util.Collection", "containsAll").parameterTypes("java.util.Collection");
    private static final CallMatcher CONTAINS = CallMatcher.instanceCall("java.util.Collection", "contains").parameterTypes("java.lang.Object");
    private static final CallMatcher CONTAINS_KEY = CallMatcher.instanceCall("java.util.Map", "containsKey").parameterTypes("java.lang.Object");
    private static final CallMatcher COLLECTION_REMOVE = CallMatcher.instanceCall("java.util.Collection", "remove").parameterTypes("java.lang.Object");
    private static final CallMatcher MAP_REMOVE = CallMatcher.instanceCall("java.util.Map", "remove").parameterTypes("java.lang.Object");
    private static final CallMatcher SET_ADD = CallMatcher.instanceCall("java.util.Set", "add").parameterTypes("E");
    private static final CallMatcher REMOVE_BY_INDEX = CallMatcher.instanceCall("java.util.List", "remove").parameterTypes("int");
    private static final CallMatcher INDEX_OF = CallMatcher.instanceCall("java.util.List", "indexOf").parameterTypes("java.lang.Object");
    private static final CallMatcher COLLECTIONS_SORT = CallMatcher.staticCall("java.util.Collections", "sort");
    private static final CallMatcher LIST_SORT = CallMatcher.instanceCall("java.util.List", "sort").parameterTypes("java.util.Comparator");
    private static final CallMatcher ITERABLE_ITERATOR = CallMatcher.instanceCall("java.lang.Iterable", "iterator").parameterCount(0);
    private static final CallMapper<RedundantCollectionOperationHandler> HANDLERS = new CallMapper<Function<PsiMethodCallExpression, RedundantCollectionOperationHandler>>().register(TO_ARRAY, AsListToArrayHandler::handler).register(CONTAINS_ALL, ContainsAllSingletonHandler::handler).register(CONTAINS, SingletonContainsHandler::handler).register(CallMatcher.anyOf(CONTAINS, CONTAINS_KEY), ContainsBeforeAddRemoveHandler::handler).register(REMOVE_BY_INDEX, RedundantIndexOfHandler::handler).register(AS_LIST, RedundantAsListForIterationHandler::handler).register(AS_LIST, RedundantSortAsListHandler::handler).register(ITERABLE_ITERATOR, RedundantEmptyIteratorHandler::handler);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantCollectionOperationInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel6OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                RedundantCollectionOperationInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                RedundantCollectionOperationHandler handler = (RedundantCollectionOperationHandler)HANDLERS.mapFirst(call);
                if (handler == null) {
                    return;
                }
                holder.registerProblem(nameElement, handler.getProblemName(), new LocalQuickFix[]{new RedundantCollectionOperationFix(handler)});
            }
        };
        if (javaElementVisitor == null) {
            RedundantCollectionOperationInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RedundantCollectionOperationFix
    implements LocalQuickFix {
        private final RedundantCollectionOperationHandler myHandler;

        RedundantCollectionOperationFix(RedundantCollectionOperationHandler handler) {
            this.myHandler = handler;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myHandler.getFixName();
            if (string == null) {
                RedundantCollectionOperationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.redundant.collection.operation.fix.family.name", new Object[0]);
            if (string == null) {
                RedundantCollectionOperationFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call;
            if (project == null) {
                RedundantCollectionOperationFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RedundantCollectionOperationFix.$$$reportNull$$$0(3);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class)) == null) {
                return;
            }
            this.myHandler.performFix(project, call);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$RedundantCollectionOperationFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$RedundantCollectionOperationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RedundantEmptyIteratorHandler
    implements RedundantCollectionOperationHandler {
        private RedundantEmptyIteratorHandler() {
        }

        @Override
        public void performFix(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            if (project == null) {
                RedundantEmptyIteratorHandler.$$$reportNull$$$0(0);
            }
            if (call == null) {
                RedundantEmptyIteratorHandler.$$$reportNull$$$0(1);
            }
            PsiType type2 = call.getType();
            PsiType elementType = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Iterator", (int)0, (boolean)false);
            elementType = GenericsUtil.getVariableTypeByExpressionType((PsiType)elementType);
            String replacement = "java.util.Collections." + (elementType == null ? "" : "<" + elementType.getCanonicalText() + ">") + "emptyIterator()";
            PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)call, replacement);
            RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments(result);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
        }

        @Override
        @NotNull
        public String getReplacement() {
            if ("Collections.emptyIterator()" == null) {
                RedundantEmptyIteratorHandler.$$$reportNull$$$0(2);
            }
            return "Collections.emptyIterator()";
        }

        static RedundantEmptyIteratorHandler handler(PsiMethodCallExpression call) {
            if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)call)) {
                return null;
            }
            PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression());
            if (!EMPTY_COLLECTION.matches(qualifier) && !ConstructionUtils.isEmptyCollectionInitializer(qualifier)) {
                return null;
            }
            return new RedundantEmptyIteratorHandler();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$RedundantEmptyIteratorHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$RedundantEmptyIteratorHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReplacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "performFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RedundantSortAsListHandler
    implements RedundantCollectionOperationHandler {
        private final boolean myCollectionsSort;

        RedundantSortAsListHandler(boolean collectionsSort) {
            this.myCollectionsSort = collectionsSort;
        }

        @Override
        public void performFix(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiExpression[] args;
            if (project == null) {
                RedundantSortAsListHandler.$$$reportNull$$$0(0);
            }
            if (call == null) {
                RedundantSortAsListHandler.$$$reportNull$$$0(1);
            }
            if ((args = call.getArgumentList().getExpressions()).length != 1) {
                return;
            }
            PsiExpression array = args[0];
            String sortMethod = "java.util.Arrays.sort";
            if (this.myCollectionsSort) {
                PsiMethodCallExpression outerCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethodCallExpression.class);
                if (outerCall == null) {
                    return;
                }
                new CommentTracker().replaceAndRestoreComments((PsiElement)call, (PsiElement)array);
                CommentTracker ct = new CommentTracker();
                ct.replaceAndRestoreComments((PsiElement)outerCall, sortMethod + ct.text((PsiElement)outerCall.getArgumentList()));
            } else {
                PsiMethodCallExpression chainedCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
                if (chainedCall == null) {
                    return;
                }
                PsiExpression[] chainedCallArgs = chainedCall.getArgumentList().getExpressions();
                if (chainedCallArgs.length != 1) {
                    return;
                }
                PsiExpression comparator = chainedCallArgs[0];
                CommentTracker ct = new CommentTracker();
                ct.replaceAndRestoreComments((PsiElement)chainedCall, sortMethod + "(" + ct.text((PsiElement)array) + "," + ct.text((PsiElement)comparator) + ")");
            }
        }

        @Override
        @NotNull
        public String getReplacement() {
            if ("Arrays.sort()" == null) {
                RedundantSortAsListHandler.$$$reportNull$$$0(2);
            }
            return "Arrays.sort()";
        }

        static RedundantSortAsListHandler handler(PsiMethodCallExpression call) {
            if (MethodCallUtils.isVarArgCall((PsiCall)call)) {
                return null;
            }
            PsiExpression arg = call.getArgumentList().getExpressions()[0];
            if (!(arg.getType() instanceof PsiArrayType)) {
                return null;
            }
            PsiExpressionList parent = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiExpressionList.class);
            if (parent != null) {
                PsiMethodCallExpression outerCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
                if (COLLECTIONS_SORT.test(outerCall) && PsiTreeUtil.isAncestor((PsiElement)parent.getExpressions()[0], (PsiElement)call, (boolean)false)) {
                    return new RedundantSortAsListHandler(true);
                }
            } else {
                PsiMethodCallExpression chainedCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
                if (LIST_SORT.test(chainedCall)) {
                    return new RedundantSortAsListHandler(false);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$RedundantSortAsListHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$RedundantSortAsListHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReplacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "performFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RedundantAsListForIterationHandler
    implements RedundantCollectionOperationHandler {
        private RedundantAsListForIterationHandler() {
        }

        @Override
        public String getProblemName() {
            return "Unnecessary 'Arrays.asList' call";
        }

        @Override
        @NotNull
        public String getFixName() {
            if ("Unwrap" == null) {
                RedundantAsListForIterationHandler.$$$reportNull$$$0(0);
            }
            return "Unwrap";
        }

        @Override
        public void performFix(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiTypeElement typeElement;
            PsiExpression[] args;
            if (project == null) {
                RedundantAsListForIterationHandler.$$$reportNull$$$0(1);
            }
            if (call == null) {
                RedundantAsListForIterationHandler.$$$reportNull$$$0(2);
            }
            if ((args = call.getArgumentList().getExpressions()).length != 1) {
                return;
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
            CommentTracker ct = new CommentTracker();
            if (parent instanceof PsiLocalVariable && !(typeElement = ((PsiLocalVariable)parent).getTypeElement()).isInferredType()) {
                PsiType varType = ((PsiLocalVariable)parent).getType();
                PsiType elementType = PsiUtil.substituteTypeParameter((PsiType)varType, (String)"java.lang.Iterable", (int)0, (boolean)false);
                if (elementType == null) {
                    PsiType type2 = args[0].getType();
                    if (!(type2 instanceof PsiArrayType)) {
                        return;
                    }
                    elementType = ((PsiArrayType)type2).getComponentType();
                }
                if (elementType instanceof PsiWildcardType) {
                    elementType = ((PsiWildcardType)elementType).getExtendsBound();
                }
                typeElement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createTypeElement((PsiType)elementType.createArrayType()));
            }
            ct.replaceAndRestoreComments((PsiElement)call, (PsiElement)args[0]);
        }

        static RedundantAsListForIterationHandler handler(PsiMethodCallExpression call) {
            if (MethodCallUtils.isVarArgCall((PsiCall)call)) {
                return null;
            }
            PsiExpression arg = call.getArgumentList().getExpressions()[0];
            if (!(arg.getType() instanceof PsiArrayType)) {
                return null;
            }
            if (RedundantAsListForIterationHandler.isAllowedContext((PsiExpression)call)) {
                return new RedundantAsListForIterationHandler();
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
            if (parent instanceof PsiLocalVariable) {
                PsiLocalVariable localVariable = (PsiLocalVariable)parent;
                if (!(localVariable.getParent() instanceof PsiDeclarationStatement) || ((PsiDeclarationStatement)localVariable.getParent()).getDeclaredElements().length != 1) {
                    return null;
                }
                PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)localVariable, PsiCodeBlock.class);
                List<PsiReferenceExpression> references = VariableAccessUtils.getVariableReferences((PsiVariable)localVariable, (PsiElement)block);
                if (!references.isEmpty() && references.stream().allMatch(RedundantAsListForIterationHandler::isAllowedContext)) {
                    return new RedundantAsListForIterationHandler();
                }
            }
            return null;
        }

        private static boolean isAllowedContext(PsiExpression expression2) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
            return parent instanceof PsiForeachStatement && PsiTreeUtil.isAncestor((PsiElement)((PsiForeachStatement)parent).getIteratedValue(), (PsiElement)expression2, (boolean)false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$RedundantAsListForIterationHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFixName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$RedundantAsListForIterationHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "performFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SingletonContainsHandler
    implements RedundantCollectionOperationHandler {
        private SingletonContainsHandler() {
        }

        @Override
        @NotNull
        public String getReplacement() {
            if ("Objects.equals" == null) {
                SingletonContainsHandler.$$$reportNull$$$0(0);
            }
            return "Objects.equals";
        }

        @Override
        public void performFix(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiMethodCallExpression qualifierCall;
            if (project == null) {
                SingletonContainsHandler.$$$reportNull$$$0(1);
            }
            if (call == null) {
                SingletonContainsHandler.$$$reportNull$$$0(2);
            }
            if ((qualifierCall = MethodCallUtils.getQualifierMethodCall(call)) == null) {
                return;
            }
            PsiExpression left = (PsiExpression)ArrayUtil.getFirstElement((Object[])qualifierCall.getArgumentList().getExpressions());
            PsiExpression right = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
            if (left == null || right == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            PsiElement element = ct.replaceAndRestoreComments((PsiElement)call, "java.util.Objects.equals(" + ct.text((PsiElement)left) + "," + ct.text((PsiElement)right) + ")");
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(element);
        }

        static RedundantCollectionOperationHandler handler(PsiMethodCallExpression call) {
            if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)call)) {
                return null;
            }
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
            if (!SINGLETON.test(qualifierCall)) {
                return null;
            }
            return new SingletonContainsHandler();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$SingletonContainsHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReplacement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$SingletonContainsHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "performFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ContainsAllSingletonHandler
    implements RedundantCollectionOperationHandler {
        private ContainsAllSingletonHandler() {
        }

        @Override
        @NotNull
        public String getReplacement() {
            if ("contains" == null) {
                ContainsAllSingletonHandler.$$$reportNull$$$0(0);
            }
            return "contains";
        }

        @Override
        public void performFix(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiExpression arg;
            if (project == null) {
                ContainsAllSingletonHandler.$$$reportNull$$$0(1);
            }
            if (call == null) {
                ContainsAllSingletonHandler.$$$reportNull$$$0(2);
            }
            if ((arg = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions())) == null) {
                return;
            }
            PsiMethodCallExpression singleton = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)arg), PsiMethodCallExpression.class);
            if (singleton == null) {
                return;
            }
            PsiExpression singletonArg = (PsiExpression)ArrayUtil.getFirstElement((Object[])singleton.getArgumentList().getExpressions());
            if (singletonArg == null) {
                return;
            }
            ExpressionUtils.bindCallTo(call, "contains");
            new CommentTracker().replaceAndRestoreComments((PsiElement)arg, (PsiElement)singletonArg);
        }

        public static RedundantCollectionOperationHandler handler(PsiMethodCallExpression call) {
            PsiExpression containsAllArg = call.getArgumentList().getExpressions()[0];
            PsiMethodCallExpression maybeSingleton = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)containsAllArg), PsiMethodCallExpression.class);
            if (!SINGLETON.test(maybeSingleton)) {
                return null;
            }
            return new ContainsAllSingletonHandler();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$ContainsAllSingletonHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReplacement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$ContainsAllSingletonHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "performFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AsListToArrayHandler
    implements RedundantCollectionOperationHandler {
        private final String myReplacementMethod;
        @NotNull
        private final SmartPsiElementPointer<PsiExpression> myArrayPtr;
        private final SmartPsiElementPointer<PsiExpression> myFromPtr;
        private final SmartPsiElementPointer<PsiExpression> myToPtr;
        @NotNull
        private final String mySourceComponentType;
        @NotNull
        private final String myTargetComponentType;

        private AsListToArrayHandler(PsiExpression from, PsiExpression to, @NotNull PsiExpression array, @NotNull String sourceComponentType, @NotNull String targetComponentType) {
            if (array == null) {
                AsListToArrayHandler.$$$reportNull$$$0(0);
            }
            if (sourceComponentType == null) {
                AsListToArrayHandler.$$$reportNull$$$0(1);
            }
            if (targetComponentType == null) {
                AsListToArrayHandler.$$$reportNull$$$0(2);
            }
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)array.getProject());
            this.myArrayPtr = manager.createSmartPsiElementPointer((PsiElement)array);
            this.myFromPtr = from == null ? null : manager.createSmartPsiElementPointer((PsiElement)from);
            this.myToPtr = to == null ? null : manager.createSmartPsiElementPointer((PsiElement)to);
            this.mySourceComponentType = sourceComponentType;
            this.myTargetComponentType = targetComponentType;
            this.myReplacementMethod = from == null && to == null ? "clone()" : (ExpressionUtils.isZero(from) ? "Arrays.copyOf" : "Arrays.copyOfRange");
        }

        @Override
        public String getProblemName() {
            return InspectionGadgetsBundle.message("inspection.redundant.collection.operation.problem.arraycopy", new Object[0]);
        }

        @Override
        @NotNull
        public String getReplacement() {
            String string = this.myReplacementMethod;
            if (string == null) {
                AsListToArrayHandler.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public void performFix(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiExpression to;
            PsiExpression array;
            if (project == null) {
                AsListToArrayHandler.$$$reportNull$$$0(4);
            }
            if (call == null) {
                AsListToArrayHandler.$$$reportNull$$$0(5);
            }
            if ((array = (PsiExpression)this.myArrayPtr.getElement()) == null) {
                return;
            }
            PsiExpression from = this.myFromPtr == null ? null : (PsiExpression)this.myFromPtr.getElement();
            if (from == null != ((to = this.myToPtr == null ? null : (PsiExpression)this.myToPtr.getElement()) == null)) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String suffix = "";
            if (!this.mySourceComponentType.equals(this.myTargetComponentType)) {
                suffix = "," + this.myTargetComponentType + "[].class";
            }
            String replacement = from == null ? ParenthesesUtils.getText(ct.markUnchanged(array), 2) + ".clone()" : (ExpressionUtils.isZero(from) ? "java.util.Arrays.copyOf(" + ct.text((PsiElement)array) + "," + ct.text((PsiElement)to) + suffix + ")" : "java.util.Arrays.copyOfRange(" + ct.text((PsiElement)array) + "," + ct.text((PsiElement)from) + "," + ct.text((PsiElement)to) + suffix + ")");
            ct.replaceAndRestoreComments((PsiElement)call, replacement);
        }

        public static RedundantCollectionOperationHandler handler(PsiMethodCallExpression call) {
            String targetComponentType;
            PsiExpression arg = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
            PsiExpression arrayLength = null;
            if (arg != null) {
                if (!(arg instanceof PsiNewExpression)) {
                    return null;
                }
                PsiJavaCodeReferenceElement classRef = ((PsiNewExpression)arg).getClassReference();
                if (classRef == null) {
                    return null;
                }
                targetComponentType = classRef.getQualifiedName();
                PsiExpression[] dimensions = ((PsiNewExpression)arg).getArrayDimensions();
                if (dimensions.length != 1) {
                    return null;
                }
                if (!ExpressionUtils.isZero(dimensions[0])) {
                    arrayLength = dimensions[0];
                }
            } else {
                targetComponentType = "java.lang.Object";
            }
            PsiExpression from = null;
            PsiExpression to = null;
            PsiMethodCallExpression qualifier = MethodCallUtils.getQualifierMethodCall(call);
            if (SUBLIST.test(qualifier)) {
                PsiExpression[] subListArgs = qualifier.getArgumentList().getExpressions();
                from = subListArgs[0];
                to = subListArgs[1];
                qualifier = MethodCallUtils.getQualifierMethodCall(qualifier);
            }
            if (!AS_LIST.test(qualifier) || MethodCallUtils.isVarArgCall((PsiCall)qualifier)) {
                return null;
            }
            PsiExpression array = qualifier.getArgumentList().getExpressions()[0];
            PsiArrayType sourceArrayType = (PsiArrayType)ObjectUtils.tryCast((Object)array.getType(), PsiArrayType.class);
            if (sourceArrayType == null) {
                return null;
            }
            PsiClass componentClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)sourceArrayType.getComponentType());
            if (componentClass == null) {
                return null;
            }
            String sourceComponentType = componentClass.getQualifiedName();
            if (sourceComponentType == null) {
                return null;
            }
            if (from != null && to != null) {
                if (arrayLength != null && !ExpressionUtils.isDifference(from, to, arrayLength)) {
                    return null;
                }
            } else {
                PsiExpression arrayFromLength;
                if (!sourceComponentType.equals(targetComponentType)) {
                    return null;
                }
                if (!(arrayLength == null || (arrayFromLength = ExpressionUtils.getArrayFromLengthExpression(arrayLength)) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)array, (PsiElement)arrayFromLength))) {
                    return null;
                }
            }
            return new AsListToArrayHandler(from, to, array, sourceComponentType, targetComponentType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceComponentType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetComponentType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$AsListToArrayHandler";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$AsListToArrayHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReplacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "performFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ContainsBeforeAddRemoveHandler
    implements RedundantCollectionOperationHandler {
        private final String myName;

        ContainsBeforeAddRemoveHandler(String name) {
            this.myName = name;
        }

        @Override
        public String getProblemName() {
            return InspectionGadgetsBundle.message("inspection.redundant.collection.unnecessary.contains.problem", this.myName);
        }

        @Override
        @NotNull
        public String getFixName() {
            String string = InspectionGadgetsBundle.message("inspection.redundant.collection.unnecessary.contains.fix", this.myName);
            if (string == null) {
                ContainsBeforeAddRemoveHandler.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void performFix(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiElement parent;
            if (project == null) {
                ContainsBeforeAddRemoveHandler.$$$reportNull$$$0(1);
            }
            if (call == null) {
                ContainsBeforeAddRemoveHandler.$$$reportNull$$$0(2);
            }
            if ((parent = PsiTreeUtil.getParentOfType((PsiElement)call, (Class[])new Class[]{PsiIfStatement.class, PsiPolyadicExpression.class})) == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            if (parent instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression conjunction = (PsiPolyadicExpression)parent;
                PsiExpression[] conjuncts = conjunction.getOperands();
                if (conjuncts.length == 2) {
                    ct.replaceAndRestoreComments(parent, (PsiElement)conjuncts[0]);
                } else {
                    PsiExpression lastConjunct = conjuncts[conjuncts.length - 1];
                    PsiJavaToken token = conjunction.getTokenBeforeOperand(lastConjunct);
                    if (token != null) {
                        ct.delete((PsiElement)token);
                    }
                    ct.deleteAndRestoreComments((PsiElement)lastConjunct);
                }
            } else {
                PsiIfStatement ifStatement = (PsiIfStatement)parent;
                PsiExpressionStatement thenBody = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getThenBranch()), PsiExpressionStatement.class);
                if (thenBody == null) {
                    return;
                }
                ct.replaceAndRestoreComments((PsiElement)ifStatement, (PsiElement)thenBody);
            }
        }

        public static RedundantCollectionOperationHandler handler(PsiMethodCallExpression call) {
            PsiIfStatement ifStatement;
            PsiExpression qualifier1 = call.getMethodExpression().getQualifierExpression();
            if (qualifier1 == null) {
                return null;
            }
            CallMatcher wantedMethod = CallMatcher.anyOf(COLLECTION_REMOVE, MAP_REMOVE);
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
            if (parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent)) {
                wantedMethod = SET_ADD;
                parent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
            }
            if (parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.ANDAND) && PsiTreeUtil.isAncestor((PsiElement)((PsiElement)ArrayUtil.getLastElement((Object[])((PsiPolyadicExpression)parent).getOperands())), (PsiElement)call, (boolean)false)) {
                parent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
            }
            if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)parent, PsiIfStatement.class)) == null) {
                return null;
            }
            if (ifStatement.getElseBranch() != null) {
                return null;
            }
            PsiExpressionStatement thenBody = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getThenBranch()), PsiExpressionStatement.class);
            if (thenBody == null) {
                return null;
            }
            PsiMethodCallExpression thenCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)thenBody.getExpression(), PsiMethodCallExpression.class);
            if (!wantedMethod.test(thenCall)) {
                return null;
            }
            PsiExpression qualifier2 = thenCall.getMethodExpression().getQualifierExpression();
            if (qualifier2 == null || !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier1, (PsiElement)qualifier2)) {
                return null;
            }
            if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)call.getArgumentList(), (PsiElement)thenCall.getArgumentList())) {
                return null;
            }
            return new ContainsBeforeAddRemoveHandler(call.getMethodExpression().getReferenceName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$ContainsBeforeAddRemoveHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFixName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$ContainsBeforeAddRemoveHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "performFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RedundantIndexOfHandler
    implements RedundantCollectionOperationHandler {
        private RedundantIndexOfHandler() {
        }

        @Override
        public String getProblemName() {
            return InspectionGadgetsBundle.message("inspection.redundant.collection.removal.by.index.problem", new Object[0]);
        }

        @Override
        @NotNull
        public String getFixName() {
            String string = InspectionGadgetsBundle.message("inspection.redundant.collection.removal.by.index.fix", new Object[0]);
            if (string == null) {
                RedundantIndexOfHandler.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void performFix(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiExpression arg;
            PsiMethodCallExpression removeArg;
            if (project == null) {
                RedundantIndexOfHandler.$$$reportNull$$$0(1);
            }
            if (call == null) {
                RedundantIndexOfHandler.$$$reportNull$$$0(2);
            }
            if ((removeArg = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)ExpressionUtils.resolveExpression(arg = call.getArgumentList().getExpressions()[0]), PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiExpression indexOfArg = (PsiExpression)ArrayUtil.getFirstElement((Object[])removeArg.getArgumentList().getExpressions());
            if (indexOfArg == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String text2 = ct.text((PsiElement)indexOfArg);
            if (PsiType.INT.equals((Object)indexOfArg.getType())) {
                text2 = "(java.lang.Integer)" + text2;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)call, (PsiElement)removeArg, (boolean)false)) {
                PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)removeArg, PsiDeclarationStatement.class);
                if (declaration2 == null) {
                    return;
                }
                ct.delete((PsiElement)declaration2);
            }
            ct.replaceAndRestoreComments((PsiElement)arg, text2);
        }

        public static RedundantCollectionOperationHandler handler(PsiMethodCallExpression call) {
            PsiExpressionStatement statement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)call.getParent(), PsiExpressionStatement.class);
            if (statement == null) {
                return null;
            }
            PsiMethodCallExpression arg = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)ExpressionUtils.resolveExpression(call.getArgumentList().getExpressions()[0]), PsiMethodCallExpression.class);
            if (!INDEX_OF.test(arg)) {
                return null;
            }
            PsiExpression qualifier1 = call.getMethodExpression().getQualifierExpression();
            PsiExpression qualifier2 = arg.getMethodExpression().getQualifierExpression();
            if (qualifier1 == null || qualifier2 == null || !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier1, (PsiElement)qualifier2)) {
                return null;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)arg, (boolean)true)) {
                PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)arg, PsiDeclarationStatement.class);
                if (declaration2 == null || declaration2.getDeclaredElements().length != 1) {
                    return null;
                }
                if (PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)declaration2) != statement) {
                    return null;
                }
            }
            return new RedundantIndexOfHandler();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$RedundantIndexOfHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFixName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$RedundantIndexOfHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "performFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static interface RedundantCollectionOperationHandler {
        default public String getProblemName() {
            return InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", this.getReplacement());
        }

        public void performFix(@NotNull Project var1, @NotNull PsiMethodCallExpression var2);

        @NotNull
        default public String getReplacement() {
            throw new UnsupportedOperationException("Either getFixName or getReplacement must be defined in subclass: " + this.getClass());
        }

        @NotNull
        default public String getFixName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.getReplacement()});
            if (string == null) {
                RedundantCollectionOperationHandler.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/redundancy/RedundantCollectionOperationInspection$RedundantCollectionOperationHandler", "getFixName"));
        }
    }
}

