/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UninitializedReadCollector {
    private final Set<PsiExpression> uninitializedReads = new HashSet<PsiExpression>();
    private int counter = 0;

    @NotNull
    public PsiExpression[] getUninitializedReads() {
        PsiExpression[] psiExpressionArray = this.uninitializedReads.toArray(PsiExpression.EMPTY_ARRAY);
        if (psiExpressionArray == null) {
            UninitializedReadCollector.$$$reportNull$$$0(0);
        }
        return psiExpressionArray;
    }

    public boolean blockAssignsVariable(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable) {
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(1);
        }
        return this.blockAssignsVariable(block, variable, this.counter, new HashSet<MethodSignature>());
    }

    private boolean blockAssignsVariable(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiStatement[] statements;
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(2);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(3);
        }
        if (this.counter != stamp) {
            return true;
        }
        if (block == null) {
            return false;
        }
        for (PsiStatement statement : statements = block.getStatements()) {
            if (this.statementAssignsVariable(statement, variable, stamp, checkedMethods)) {
                return true;
            }
            if (this.counter == stamp) continue;
            return true;
        }
        return false;
    }

    private boolean statementAssignsVariable(@Nullable PsiStatement statement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(4);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(5);
        }
        if (statement == null) {
            return false;
        }
        if (ExceptionUtils.statementThrowsException(statement)) {
            return true;
        }
        if (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiAssertStatement || statement instanceof PsiEmptyStatement) {
            return false;
        }
        if (statement instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            return this.expressionAssignsVariable(returnValue, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)statement;
            PsiExpression exception = throwStatement.getException();
            return this.expressionAssignsVariable(exception, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiExpressionListStatement) {
            PsiExpression[] expressions2;
            PsiExpressionListStatement list = (PsiExpressionListStatement)statement;
            PsiExpressionList expressionList = list.getExpressionList();
            for (PsiExpression expression2 : expressions2 = expressionList.getExpressions()) {
                if (!this.expressionAssignsVariable(expression2, variable, stamp, checkedMethods)) continue;
                return true;
            }
            return false;
        }
        if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression3 = expressionStatement.getExpression();
            return this.expressionAssignsVariable(expression3, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            return this.declarationStatementAssignsVariable(declarationStatement, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)statement;
            return this.forStatementAssignsVariable(forStatement, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiForeachStatement) {
            PsiForeachStatement foreachStatement = (PsiForeachStatement)statement;
            return this.foreachStatementAssignsVariable(foreachStatement, variable);
        }
        if (statement instanceof PsiWhileStatement) {
            PsiWhileStatement whileStatement = (PsiWhileStatement)statement;
            return this.whileStatementAssignsVariable(whileStatement, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiDoWhileStatement) {
            PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)statement;
            return this.doWhileAssignsVariable(doWhileStatement, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement;
            PsiCodeBlock body2 = synchronizedStatement.getBody();
            return this.blockAssignsVariable(body2, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            return this.blockAssignsVariable(codeBlock, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement;
            PsiStatement statementLabeled = labeledStatement.getStatement();
            return this.statementAssignsVariable(statementLabeled, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            return this.ifStatementAssignsVariable(ifStatement, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement;
            return this.tryStatementAssignsVariable(tryStatement, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiSwitchStatement) {
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)statement;
            return this.switchBlockAssignsVariable((PsiSwitchBlock)switchStatement, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiSwitchLabelStatement) {
            return false;
        }
        if (statement instanceof PsiSwitchLabeledRuleStatement) {
            PsiSwitchLabeledRuleStatement switchLabeledRuleStatement = (PsiSwitchLabeledRuleStatement)statement;
            PsiStatement body3 = switchLabeledRuleStatement.getBody();
            return this.statementAssignsVariable(body3, variable, stamp, checkedMethods);
        }
        assert (false) : "unknown statement: " + statement;
        return false;
    }

    private boolean switchBlockAssignsVariable(@NotNull PsiSwitchBlock switchBlock, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpression expression2;
        if (switchBlock == null) {
            UninitializedReadCollector.$$$reportNull$$$0(6);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(7);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(8);
        }
        if (this.expressionAssignsVariable(expression2 = switchBlock.getExpression(), variable, stamp, checkedMethods)) {
            return true;
        }
        PsiCodeBlock body2 = switchBlock.getBody();
        if (body2 == null) {
            return false;
        }
        PsiStatement[] statements = body2.getStatements();
        boolean containsDefault = false;
        boolean assigns = false;
        for (int i = 0; i < statements.length; ++i) {
            PsiStatement statement = statements[i];
            if (statement instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)statement;
                if (i == statements.length - 1) {
                    return false;
                }
                if (labelStatement.isDefaultCase()) {
                    containsDefault = true;
                }
                assigns = false;
                continue;
            }
            if (statement instanceof PsiBreakStatement) {
                PsiBreakStatement breakStatement = (PsiBreakStatement)statement;
                PsiExpression valueExpression2 = breakStatement.getValueExpression();
                if (this.expressionAssignsVariable(valueExpression2, variable, stamp, checkedMethods)) {
                    assigns = true;
                }
                if (breakStatement.getLabelIdentifier() == null && assigns) continue;
                return false;
            }
            if (i != statements.length - 1 || (assigns |= this.statementAssignsVariable(statement, variable, stamp, checkedMethods))) continue;
            return false;
        }
        return assigns && (containsDefault || switchBlock instanceof PsiSwitchExpression);
    }

    private boolean declarationStatementAssignsVariable(@NotNull PsiDeclarationStatement declarationStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiElement[] elements;
        if (declarationStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(9);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(10);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(11);
        }
        for (PsiElement element : elements = declarationStatement.getDeclaredElements()) {
            PsiVariable variableElement;
            PsiExpression initializer;
            if (!(element instanceof PsiVariable) || !this.expressionAssignsVariable(initializer = (variableElement = (PsiVariable)element).getInitializer(), variable, stamp, checkedMethods)) continue;
            return true;
        }
        return false;
    }

    private boolean tryStatementAssignsVariable(@NotNull PsiTryStatement tryStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiCodeBlock[] catchBlocks;
        PsiResourceList resourceList;
        if (tryStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(12);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(13);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(14);
        }
        if ((resourceList = tryStatement.getResourceList()) != null) {
            for (PsiResourceListElement resource : resourceList) {
                PsiExpression initializer;
                if (!(resource instanceof PsiResourceVariable) || !this.expressionAssignsVariable(initializer = ((PsiResourceVariable)resource).getInitializer(), variable, stamp, checkedMethods)) continue;
                return true;
            }
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        boolean initializedInTryOrCatch = this.blockAssignsVariable(tryBlock, variable, stamp, checkedMethods);
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            initializedInTryOrCatch &= this.blockAssignsVariable(catchBlock, variable, stamp, checkedMethods);
        }
        if (initializedInTryOrCatch) {
            return true;
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        return this.blockAssignsVariable(finallyBlock, variable, stamp, checkedMethods);
    }

    private boolean ifStatementAssignsVariable(@NotNull PsiIfStatement ifStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpression condition2;
        if (ifStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(15);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(16);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(17);
        }
        if (this.expressionAssignsVariable(condition2 = ifStatement.getCondition(), variable, stamp, checkedMethods)) {
            return true;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        return this.statementAssignsVariable(thenBranch, variable, stamp, checkedMethods) && this.statementAssignsVariable(elseBranch, variable, stamp, checkedMethods);
    }

    private boolean doWhileAssignsVariable(@NotNull PsiDoWhileStatement doWhileStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (doWhileStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(18);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(19);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(20);
        }
        PsiExpression condition2 = doWhileStatement.getCondition();
        PsiStatement body2 = doWhileStatement.getBody();
        return this.statementAssignsVariable(body2, variable, stamp, checkedMethods) || this.expressionAssignsVariable(condition2, variable, stamp, checkedMethods);
    }

    private boolean whileStatementAssignsVariable(@NotNull PsiWhileStatement whileStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiStatement body2;
        PsiExpression condition2;
        if (whileStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(21);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(22);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(23);
        }
        if (this.expressionAssignsVariable(condition2 = whileStatement.getCondition(), variable, stamp, checkedMethods)) {
            return true;
        }
        return BoolUtils.isTrue(condition2) && this.statementAssignsVariable(body2 = whileStatement.getBody(), variable, stamp, checkedMethods);
    }

    private boolean forStatementAssignsVariable(@NotNull PsiForStatement forStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiStatement initialization;
        if (forStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(24);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(25);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(26);
        }
        if (this.statementAssignsVariable(initialization = forStatement.getInitialization(), variable, stamp, checkedMethods)) {
            return true;
        }
        PsiExpression condition2 = forStatement.getCondition();
        if (this.expressionAssignsVariable(condition2, variable, stamp, checkedMethods)) {
            return true;
        }
        if (BoolUtils.isTrue(condition2)) {
            PsiStatement body2 = forStatement.getBody();
            if (this.statementAssignsVariable(body2, variable, stamp, checkedMethods)) {
                return true;
            }
            PsiStatement update2 = forStatement.getUpdate();
            if (this.statementAssignsVariable(update2, variable, stamp, checkedMethods)) {
                return true;
            }
        }
        return false;
    }

    private boolean foreachStatementAssignsVariable(PsiForeachStatement forStatement, PsiVariable variable) {
        return false;
    }

    private boolean expressionAssignsVariable(@Nullable PsiExpression expression2, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(27);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(28);
        }
        if (this.counter != stamp) {
            return true;
        }
        if (expression2 == null) {
            return false;
        }
        if (expression2 instanceof PsiThisExpression || expression2 instanceof PsiLiteralExpression || expression2 instanceof PsiSuperExpression || expression2 instanceof PsiClassObjectAccessExpression || expression2 instanceof PsiLambdaExpression) {
            return false;
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            return this.referenceExpressionAssignsVariable(referenceExpression, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression2;
            return this.methodCallAssignsVariable(callExpression, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression2;
            return this.newExpressionAssignsVariable(newExpression, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiArrayInitializerExpression) {
            PsiExpression[] initializers;
            PsiArrayInitializerExpression array = (PsiArrayInitializerExpression)expression2;
            for (PsiExpression initializer : initializers = array.getInitializers()) {
                if (!this.expressionAssignsVariable(initializer, variable, stamp, checkedMethods)) continue;
                return true;
            }
            return false;
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCast = (PsiTypeCastExpression)expression2;
            PsiExpression operand2 = typeCast.getOperand();
            return this.expressionAssignsVariable(operand2, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression accessExpression = (PsiArrayAccessExpression)expression2;
            PsiExpression arrayExpression = accessExpression.getArrayExpression();
            PsiExpression indexExpression = accessExpression.getIndexExpression();
            return this.expressionAssignsVariable(arrayExpression, variable, stamp, checkedMethods) || this.expressionAssignsVariable(indexExpression, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiUnaryExpression) {
            PsiUnaryExpression unaryExpression = (PsiUnaryExpression)expression2;
            PsiExpression operand3 = unaryExpression.getOperand();
            return this.expressionAssignsVariable(operand3, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiExpression[] operands2;
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            for (PsiExpression operand4 : operands2 = polyadicExpression.getOperands()) {
                if (!this.expressionAssignsVariable(operand4, variable, stamp, checkedMethods)) continue;
                return true;
            }
            return false;
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression2;
            PsiExpression condition2 = conditional.getCondition();
            if (this.expressionAssignsVariable(condition2, variable, stamp, checkedMethods)) {
                return true;
            }
            PsiExpression thenExpression2 = conditional.getThenExpression();
            PsiExpression elseExpression2 = conditional.getElseExpression();
            return this.expressionAssignsVariable(thenExpression2, variable, stamp, checkedMethods) && this.expressionAssignsVariable(elseExpression2, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression2;
            return this.assignmentExpressionAssignsVariable(assignment, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression innerExpression = parenthesizedExpression.getExpression();
            return this.expressionAssignsVariable(innerExpression, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression2;
            PsiExpression operand5 = instanceOfExpression.getOperand();
            return this.expressionAssignsVariable(operand5, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiSwitchExpression) {
            PsiSwitchExpression switchExpression = (PsiSwitchExpression)expression2;
            return this.switchBlockAssignsVariable((PsiSwitchBlock)switchExpression, variable, stamp, checkedMethods);
        }
        return false;
    }

    private boolean assignmentExpressionAssignsVariable(@NotNull PsiAssignmentExpression assignment, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiElement element;
        PsiExpression lhs;
        if (assignment == null) {
            UninitializedReadCollector.$$$reportNull$$$0(29);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(30);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(31);
        }
        if (this.expressionAssignsVariable(lhs = ParenthesesUtils.stripParentheses(assignment.getLExpression()), variable, stamp, checkedMethods)) {
            return true;
        }
        PsiExpression rhs = assignment.getRExpression();
        if (this.expressionAssignsVariable(rhs, variable, stamp, checkedMethods)) {
            return true;
        }
        return lhs instanceof PsiReferenceExpression && (element = ((PsiReference)lhs).resolve()) != null && element.equals(variable);
    }

    private boolean referenceExpressionAssignsVariable(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpression qualifierExpression2;
        if (referenceExpression == null) {
            UninitializedReadCollector.$$$reportNull$$$0(32);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(33);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(34);
        }
        if (this.expressionAssignsVariable(qualifierExpression2 = referenceExpression.getQualifierExpression(), variable, stamp, checkedMethods)) {
            return true;
        }
        if (variable.equals(referenceExpression.resolve())) {
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)referenceExpression);
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiExpression rhs = assignmentExpression.getRExpression();
                if (rhs != null && rhs.equals(referenceExpression)) {
                    this.checkReferenceExpression(referenceExpression, variable, qualifierExpression2);
                }
            } else if (!(parent instanceof PsiExpression) || !ComparisonUtils.isNullComparison((PsiExpression)parent)) {
                this.checkReferenceExpression(referenceExpression, variable, qualifierExpression2);
            }
        }
        return false;
    }

    private void checkReferenceExpression(PsiReferenceExpression referenceExpression, PsiVariable variable, PsiExpression qualifierExpression2) {
        PsiReferenceExpression reference;
        PsiElement target;
        if (!referenceExpression.isQualified() || qualifierExpression2 instanceof PsiThisExpression) {
            this.uninitializedReads.add((PsiExpression)referenceExpression);
            ++this.counter;
        } else if (variable.hasModifierProperty("static") && qualifierExpression2 instanceof PsiReferenceExpression && (target = (reference = (PsiReferenceExpression)qualifierExpression2).resolve()) instanceof PsiClass && target.equals(PsiTreeUtil.getParentOfType((PsiElement)variable, PsiClass.class))) {
            this.uninitializedReads.add((PsiExpression)referenceExpression);
            ++this.counter;
        }
    }

    private boolean newExpressionAssignsVariable(@NotNull PsiNewExpression newExpression, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpression[] arrayDimensions;
        PsiArrayInitializerExpression arrayInitializer;
        PsiExpressionList argumentList;
        if (newExpression == null) {
            UninitializedReadCollector.$$$reportNull$$$0(35);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(36);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(37);
        }
        if ((argumentList = newExpression.getArgumentList()) != null) {
            PsiExpression[] args;
            for (PsiExpression arg : args = argumentList.getExpressions()) {
                if (!this.expressionAssignsVariable(arg, variable, stamp, checkedMethods)) continue;
                return true;
            }
        }
        if (this.expressionAssignsVariable((PsiExpression)(arrayInitializer = newExpression.getArrayInitializer()), variable, stamp, checkedMethods)) {
            return true;
        }
        for (PsiExpression dim : arrayDimensions = newExpression.getArrayDimensions()) {
            if (!this.expressionAssignsVariable(dim, variable, stamp, checkedMethods)) continue;
            return true;
        }
        return false;
    }

    private boolean methodCallAssignsVariable(@NotNull PsiMethodCallExpression callExpression, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpression[] arguments;
        PsiReferenceExpression methodExpression;
        if (callExpression == null) {
            UninitializedReadCollector.$$$reportNull$$$0(38);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(39);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(40);
        }
        if (this.expressionAssignsVariable((PsiExpression)(methodExpression = callExpression.getMethodExpression()), variable, stamp, checkedMethods)) {
            return true;
        }
        PsiExpressionList argumentList = callExpression.getArgumentList();
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            if (!this.expressionAssignsVariable(argument, variable, stamp, checkedMethods)) continue;
            return true;
        }
        PsiMethod method = callExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
        if (!checkedMethods.add(methodSignature)) {
            return false;
        }
        PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)callExpression);
        PsiClass calledClass = method.getContainingClass();
        if (calledClass == null || !calledClass.equals(containingClass)) {
            return false;
        }
        if (method.hasModifierProperty("static") || method.isConstructor() || method.hasModifierProperty("private") || method.hasModifierProperty("final") || calledClass.hasModifierProperty("final")) {
            PsiCodeBlock body2 = method.getBody();
            return this.blockAssignsVariable(body2, variable, stamp, checkedMethods);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/UninitializedReadCollector";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 31: 
            case 34: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedMethods";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlock";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationStatement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doWhileStatement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whileStatement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUninitializedReads";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/UninitializedReadCollector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "blockAssignsVariable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "statementAssignsVariable";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "switchBlockAssignsVariable";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "declarationStatementAssignsVariable";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryStatementAssignsVariable";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "ifStatementAssignsVariable";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doWhileAssignsVariable";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "whileStatementAssignsVariable";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "forStatementAssignsVariable";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "expressionAssignsVariable";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "assignmentExpressionAssignsVariable";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "referenceExpressionAssignsVariable";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "newExpressionAssignsVariable";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "methodCallAssignsVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

