/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.IntArrayList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaUnfriendlyMethodOverloadInspection
extends BaseInspection {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        if (method.isConstructor()) {
            return null;
        }
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("lambda.unfriendly.method.overload.display.name", new Object[0]);
        if (string == null) {
            LambdaUnfriendlyMethodOverloadInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        String string = InspectionGadgetsBundle.message(method.isConstructor() ? "lambda.unfriendly.constructor.overload.problem.descriptor" : "lambda.unfriendly.method.overload.problem.descriptor", new Object[0]);
        if (string == null) {
            LambdaUnfriendlyMethodOverloadInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LambdaUnfriendlyMethodOverloadVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/naming/LambdaUnfriendlyMethodOverloadInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class LambdaUnfriendlyMethodOverloadVisitor
    extends BaseInspectionVisitor {
        private LambdaUnfriendlyMethodOverloadVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiParameterList parameterList = method.getParameterList();
            int parametersCount = parameterList.getParametersCount();
            if (parametersCount == 0) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            IntArrayList functionalIndices = new IntArrayList(2);
            for (int i = 0; i < parameters2.length; ++i) {
                PsiParameter parameter2 = parameters2[i];
                if (!LambdaUtil.isFunctionalType((PsiType)parameter2.getType())) continue;
                functionalIndices.add(i);
            }
            if (functionalIndices.isEmpty()) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            String name = method.getName();
            block1: for (PsiMethod sameNameMethod : containingClass.findMethodsByName(name, true)) {
                PsiParameter[] otherParameters;
                PsiParameterList otherParameterList;
                if (method.equals(sameNameMethod) || PsiSuperMethodUtil.isSuperMethod((PsiMethod)method, (PsiMethod)sameNameMethod) || parametersCount != (otherParameterList = sameNameMethod.getParameterList()).getParametersCount() || !LambdaUnfriendlyMethodOverloadVisitor.areOtherParameterTypesConvertible(parameters2, otherParameters = otherParameterList.getParameters(), functionalIndices)) continue;
                int max = functionalIndices.size();
                boolean equalTypes = true;
                for (int i = 0; i < max; ++i) {
                    PsiType functionalType;
                    int index = functionalIndices.get(i);
                    PsiType otherFunctionalType = otherParameters[index].getType();
                    if (!LambdaUtil.isFunctionalType((PsiType)otherFunctionalType) || !LambdaUnfriendlyMethodOverloadVisitor.areSameShapeFunctionalTypes(functionalType = parameters2[index].getType(), otherFunctionalType)) continue block1;
                    equalTypes &= Objects.equals(TypeConversionUtil.erasure((PsiType)functionalType), TypeConversionUtil.erasure((PsiType)otherFunctionalType));
                }
                if (equalTypes) continue;
                this.registerMethodError(method, method);
                return;
            }
        }

        private static boolean areSameShapeFunctionalTypes(PsiType one, PsiType two) {
            PsiMethod method1 = LambdaUtil.getFunctionalInterfaceMethod((PsiType)one);
            PsiMethod method2 = LambdaUtil.getFunctionalInterfaceMethod((PsiType)two);
            if (method1 == null || method2 == null) {
                return false;
            }
            PsiType returnType1 = method1.getReturnType();
            PsiType returnType2 = method2.getReturnType();
            if (PsiType.VOID.equals((Object)returnType1) ^ PsiType.VOID.equals((Object)returnType2)) {
                return false;
            }
            return method1.getParameterList().getParametersCount() == method2.getParameterList().getParametersCount();
        }

        private static boolean areOtherParameterTypesConvertible(PsiParameter[] parameters2, PsiParameter[] otherParameters, IntArrayList ignores) {
            for (int i = 0; i < parameters2.length; ++i) {
                PsiType otherType;
                PsiType type2;
                if (ignores.contains(i) || (type2 = TypeConversionUtil.erasure((PsiType)parameters2[i].getType())).isAssignableFrom(otherType = TypeConversionUtil.erasure((PsiType)otherParameters[i].getType())) || otherType.isAssignableFrom(type2)) continue;
                return false;
            }
            return true;
        }
    }
}

