/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.UninitializedReadCollector;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StaticVariableUninitializedUseInspection
extends BaseInspection {
    public boolean m_ignorePrimitives = false;

    @NotNull
    public String getID() {
        if ("StaticVariableUsedBeforeInitialization" == null) {
            StaticVariableUninitializedUseInspection.$$$reportNull$$$0(0);
        }
        return "StaticVariableUsedBeforeInitialization";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.variable.used.before.initialization.display.name", new Object[0]);
        if (string == null) {
            StaticVariableUninitializedUseInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("static.variable.used.before.initialization.problem.descriptor", new Object[0]);
        if (string == null) {
            StaticVariableUninitializedUseInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("primitive.fields.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignorePrimitives");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticVariableInitializationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/initialization/StaticVariableUninitializedUseInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class StaticVariableInitializationVisitor
    extends BaseInspectionVisitor {
        private StaticVariableInitializationVisitor() {
        }

        /*
         * WARNING - void declaration
         */
        public void visitClass(PsiClass aClass) {
            PsiField[] fields = aClass.getFields();
            if (aClass.isEnum()) {
                return;
            }
            for (PsiField field : fields) {
                void var13_17;
                PsiExpression[] moreBadReads;
                PsiType type2;
                if (!field.hasModifierProperty("static") || field.getInitializer() != null || StaticVariableUninitializedUseInspection.this.m_ignorePrimitives && ClassUtils.isPrimitive(type2 = field.getType())) continue;
                UninitializedReadCollector uninitializedReadCollector = new UninitializedReadCollector();
                boolean assignedInInitializer = Arrays.stream(aClass.getInitializers()).filter(initializer -> initializer.hasModifierProperty("static")).map(PsiClassInitializer::getBody).anyMatch(body2 -> uninitializedReadCollector.blockAssignsVariable((PsiCodeBlock)body2, (PsiVariable)field));
                if (assignedInInitializer) {
                    PsiExpression[] badReads;
                    for (PsiExpression psiExpression : badReads = uninitializedReadCollector.getUninitializedReads()) {
                        this.registerError((PsiElement)psiExpression, new Object[0]);
                    }
                    continue;
                }
                PsiMethod[] methods = aClass.getMethods();
                for (PsiExpression psiExpression : methods) {
                    if (!psiExpression.hasModifierProperty("static")) continue;
                    PsiCodeBlock body3 = psiExpression.getBody();
                    uninitializedReadCollector.blockAssignsVariable(body3, (PsiVariable)field);
                }
                PsiExpression[] psiExpressionArray = moreBadReads = uninitializedReadCollector.getUninitializedReads();
                int n = psiExpressionArray.length;
                boolean bl = false;
                while (var13_17 < n) {
                    PsiExpression badRead = psiExpressionArray[var13_17];
                    this.registerError((PsiElement)badRead, new Object[0]);
                    ++var13_17;
                }
            }
        }
    }
}

