/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.fixes.BaseSwitchFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.SwitchUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CreateDefaultBranchFix
extends BaseSwitchFix {
    private static final String PLACEHOLDER_NAME = "$EXPRESSION$";
    private final String myMessage;

    public CreateDefaultBranchFix(@NotNull PsiSwitchBlock block, String message2) {
        if (block == null) {
            CreateDefaultBranchFix.$$$reportNull$$$0(0);
        }
        super(block);
        this.myMessage = message2;
    }

    @NotNull
    public String getText() {
        String string = this.myMessage == null ? this.getName() : this.myMessage;
        if (string == null) {
            CreateDefaultBranchFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        if ("Insert 'default' branch" == null) {
            CreateDefaultBranchFix.$$$reportNull$$$0(2);
        }
        return "Insert 'default' branch";
    }

    @Override
    protected void invoke() {
        PsiSwitchBlock switchBlock = (PsiSwitchBlock)this.myBlock.getElement();
        if (switchBlock == null) {
            return;
        }
        PsiCodeBlock body2 = switchBlock.getBody();
        if (body2 == null) {
            return;
        }
        if (SwitchUtils.calculateBranchCount(switchBlock) < 0) {
            return;
        }
        PsiExpression switchExpression = switchBlock.getExpression();
        if (switchExpression == null) {
            return;
        }
        boolean isRuleBasedFormat = SwitchUtils.isRuleFormatSwitch(switchBlock);
        PsiElement anchor = body2.getLastChild();
        if (anchor == null) {
            return;
        }
        PsiElement parent = anchor.getParent();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)anchor.getProject());
        CreateDefaultBranchFix.generateStatements(switchBlock, isRuleBasedFormat).stream().map(text2 -> factory.createStatementFromText(text2, parent)).forEach(statement -> parent.addBefore((PsiElement)statement, anchor));
        CreateDefaultBranchFix.adjustEditor(switchBlock);
    }

    private static void adjustEditor(@NotNull PsiSwitchBlock block) {
        PsiCodeBlock body2;
        if (block == null) {
            CreateDefaultBranchFix.$$$reportNull$$$0(3);
        }
        if ((body2 = block.getBody()) == null) {
            return;
        }
        Editor editor = CreateDefaultBranchFix.prepareForTemplateAndObtainEditor((PsiElement)block);
        if (editor == null) {
            return;
        }
        PsiStatement lastStatement = (PsiStatement)ArrayUtil.getLastElement((Object[])body2.getStatements());
        if (lastStatement instanceof PsiSwitchLabeledRuleStatement) {
            lastStatement = ((PsiSwitchLabeledRuleStatement)lastStatement).getBody();
        }
        if (lastStatement != null) {
            TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)block);
            builder.replaceElement((PsiElement)lastStatement, (Expression)new ConstantNode(lastStatement.getText()));
            builder.run(editor, true);
        }
    }

    private static List<String> generateStatements(PsiSwitchBlock switchBlock, boolean isRuleBasedFormat) {
        PsiStatement statement;
        Project project = switchBlock.getProject();
        FileTemplate branchTemplate = FileTemplateManager.getInstance((Project)project).getCodeTemplate("Switch Default Branch.java");
        Properties props = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
        PsiExpression expression2 = switchBlock.getExpression();
        props.setProperty("EXPRESSION", PLACEHOLDER_NAME);
        PsiType expressionType = expression2 == null ? null : expression2.getType();
        props.setProperty("EXPRESSION_TYPE", expressionType == null ? "" : expressionType.getCanonicalText());
        try {
            String text2 = branchTemplate.getText(props);
            if (text2.trim().isEmpty() && switchBlock instanceof PsiSwitchExpression) {
                String value2 = TypeUtils.getDefaultValue(((PsiSwitchExpression)switchBlock).getType());
                text2 = isRuleBasedFormat ? value2 + ";" : "break " + value2 + ";";
            }
            statement = JavaPsiFacade.getElementFactory((Project)project).createStatementFromText("{" + text2 + "}", (PsiElement)switchBlock);
            if (expression2 != null) {
                PsiElement[] refs;
                for (PsiElement ref : refs = PsiTreeUtil.collectElements((PsiElement)statement, e -> e instanceof PsiReferenceExpression && e.textMatches((CharSequence)PLACEHOLDER_NAME))) {
                    ref.replace((PsiElement)expression2);
                }
            }
        }
        catch (IncorrectOperationException | IOException e2) {
            throw new IncorrectOperationException("Incorrect file template", e2);
        }
        PsiStatement stripped = ControlFlowUtils.stripBraces(statement);
        if (!isRuleBasedFormat || stripped instanceof PsiThrowStatement || stripped instanceof PsiExpressionStatement) {
            statement = stripped;
        }
        if (isRuleBasedFormat) {
            return Collections.singletonList("default -> " + statement.getText());
        }
        PsiStatement lastStatement = (PsiStatement)ArrayUtil.getLastElement((Object[])Objects.requireNonNull(switchBlock.getBody()).getStatements());
        if (lastStatement != null && ControlFlowUtils.statementMayCompleteNormally(lastStatement)) {
            return Arrays.asList("break;", "default:", statement.getText());
        }
        return Arrays.asList("default:", statement.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/CreateDefaultBranchFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/CreateDefaultBranchFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "adjustEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

