/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import java.util.List;
import java.util.function.BinaryOperator;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcessiveRangeCheckInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher COLLECTION_IS_EMPTY = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "isEmpty").parameterCount(0), CallMatcher.instanceCall("java.util.Map", "isEmpty").parameterCount(0));
    private static final CallMatcher STRING_IS_EMPTY = CallMatcher.instanceCall("java.lang.String", "isEmpty").parameterCount(0);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ExcessiveRangeCheckInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
                IElementType type2 = expression2.getOperationTokenType();
                boolean andChain = type2.equals(JavaTokenType.ANDAND);
                if (!andChain && !type2.equals(JavaTokenType.OROR)) {
                    return;
                }
                for (List run : StreamEx.of((Object[])expression2.getOperands()).map(x$0 -> ExcessiveRangeCheckInspection.extractConstraint(x$0)).groupRuns(RangeConstraint::sameExpression)) {
                    Long value2;
                    if (run.size() <= 1) continue;
                    BinaryOperator reductionOp = andChain ? LongRangeSet::intersect : LongRangeSet::unite;
                    LongRangeSet set = run.stream().map(c -> ((RangeConstraint)c).myConstraint).reduce(reductionOp).orElse(LongRangeSet.empty());
                    if (set.isEmpty()) continue;
                    RangeConstraint constraint = (RangeConstraint)run.get(0);
                    if (!andChain) {
                        set = constraint.getFullRange().subtract(set);
                    }
                    if ((value2 = set.getConstantValue()) == null) continue;
                    String text2 = constraint.myExpression.getText() + constraint.getExpressionSuffix();
                    String replacement = text2 + ' ' + (andChain ? "==" : "!=") + ' ' + value2;
                    String message2 = InspectionGadgetsBundle.message("inspection.excessive.range.check.message", replacement);
                    holder.registerProblem((PsiElement)expression2, new TextRange(constraint.myRange.getStartOffset(), ((RangeConstraint)run.get(run.size() - 1)).myRange.getEndOffset()), message2, new LocalQuickFix[]{new ExcessiveRangeCheckFix(replacement)});
                }
            }
        };
        if (javaElementVisitor == null) {
            ExcessiveRangeCheckInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static RangeConstraint extractConstraint(PsiExpression expression2) {
        PsiExpression qualifier;
        TextRange textRange = expression2.getTextRangeInParent();
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) == null) {
            return null;
        }
        PsiExpression negated = BoolUtils.getNegated(expression2);
        if (negated != null) {
            RangeConstraint constraint = ExcessiveRangeCheckInspection.extractConstraint(negated);
            return constraint == null ? null : constraint.negate(textRange);
        }
        if (expression2 instanceof PsiMethodCallExpression && (qualifier = ((PsiMethodCallExpression)expression2).getMethodExpression().getQualifierExpression()) != null) {
            if (STRING_IS_EMPTY.matches(expression2)) {
                return new RangeConstraint(textRange, qualifier, SpecialField.STRING_LENGTH, LongRangeSet.point(0L));
            }
            if (COLLECTION_IS_EMPTY.matches(expression2)) {
                return new RangeConstraint(textRange, qualifier, SpecialField.COLLECTION_SIZE, LongRangeSet.point(0L));
            }
        }
        if (expression2 instanceof PsiBinaryExpression) {
            PsiExpression compared;
            LongRangeSet set;
            PsiBinaryExpression binOp = (PsiBinaryExpression)expression2;
            DfaRelationValue.RelationType rel = DfaRelationValue.RelationType.fromElementType(binOp.getOperationTokenType());
            if (rel == null) {
                return null;
            }
            PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
            PsiExpression right = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
            if (left == null || right == null) {
                return null;
            }
            if (!TypeConversionUtil.isIntegralNumberType((PsiType)left.getType()) || !TypeConversionUtil.isIntegralNumberType((PsiType)right.getType())) {
                return null;
            }
            Number leftNum = JavaPsiMathUtil.getNumberFromLiteral(left);
            Number rightNum = JavaPsiMathUtil.getNumberFromLiteral(right);
            if (leftNum instanceof Integer || leftNum instanceof Long) {
                set = LongRangeSet.point(leftNum.longValue()).fromRelation(rel.getFlipped());
                compared = right;
            } else if (rightNum instanceof Integer || rightNum instanceof Long) {
                set = LongRangeSet.point(rightNum.longValue()).fromRelation(rel);
                compared = left;
            } else {
                return null;
            }
            return RangeConstraint.create(textRange, compared, set);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/ExcessiveRangeCheckInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/ExcessiveRangeCheckInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExcessiveRangeCheckFix
    implements LocalQuickFix {
        private final String myReplacement;

        ExcessiveRangeCheckFix(String replacement) {
            this.myReplacement = replacement;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myReplacement});
            if (string == null) {
                ExcessiveRangeCheckFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.excessive.range.check.fix.family.name", new Object[0]);
            if (string == null) {
                ExcessiveRangeCheckFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiPolyadicExpression expression2;
            if (project == null) {
                ExcessiveRangeCheckFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ExcessiveRangeCheckFix.$$$reportNull$$$0(3);
            }
            if ((expression2 = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiPolyadicExpression.class)) == null) {
                return;
            }
            TextRange range = descriptor.getTextRangeInElement();
            Object[] allOperands = expression2.getOperands();
            List operands2 = ContainerUtil.filter((Object[])allOperands, op -> range.contains(op.getTextRangeInParent()));
            if (operands2.size() < 2) {
                return;
            }
            PsiExpression firstOperand = (PsiExpression)operands2.get(0);
            RangeConstraint constraint = ExcessiveRangeCheckInspection.extractConstraint(firstOperand);
            if (constraint == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            ct.markUnchanged(constraint.myExpression);
            if (operands2.size() == allOperands.length) {
                ct.replaceAndRestoreComments((PsiElement)expression2, this.myReplacement);
            } else {
                PsiElement firstToDelete = firstOperand.getNextSibling();
                PsiElement lastToDelete = (PsiElement)ContainerUtil.getLastItem((List)operands2);
                for (PsiElement e = firstToDelete; e != lastToDelete; e = e.getNextSibling()) {
                    ct.grabComments(e);
                }
                expression2.deleteChildRange(firstToDelete, lastToDelete);
                ct.replaceAndRestoreComments((PsiElement)firstOperand, this.myReplacement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/ExcessiveRangeCheckInspection$ExcessiveRangeCheckFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/ExcessiveRangeCheckInspection$ExcessiveRangeCheckFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RangeConstraint {
        @NotNull
        private final TextRange myRange;
        @NotNull
        private final PsiExpression myExpression;
        @Nullable
        private final SpecialField myField;
        @NotNull
        private final LongRangeSet myConstraint;

        private RangeConstraint(@NotNull TextRange range, @NotNull PsiExpression expression2, @Nullable SpecialField field, @NotNull LongRangeSet constraint) {
            if (range == null) {
                RangeConstraint.$$$reportNull$$$0(0);
            }
            if (expression2 == null) {
                RangeConstraint.$$$reportNull$$$0(1);
            }
            if (constraint == null) {
                RangeConstraint.$$$reportNull$$$0(2);
            }
            this.myRange = range;
            this.myExpression = expression2;
            this.myField = field;
            this.myConstraint = constraint.intersect(this.getFullRange());
        }

        RangeConstraint negate(TextRange newTextRange) {
            return new RangeConstraint(newTextRange, this.myExpression, this.myField, this.getFullRange().subtract(this.myConstraint));
        }

        static boolean sameExpression(RangeConstraint left, RangeConstraint right) {
            return left != null && right != null && left.myField == right.myField && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(left.myExpression, right.myExpression);
        }

        @NotNull
        LongRangeSet getFullRange() {
            LongRangeSet result;
            if (this.myField != null) {
                DfaValueFactory factory = new DfaValueFactory(null, false);
                result = LongRangeSet.fromDfaValue(this.myField.getDefaultValue(factory, false));
            } else {
                result = LongRangeSet.fromType(this.myExpression.getType());
            }
            LongRangeSet longRangeSet = result == null ? LongRangeSet.all() : result;
            if (longRangeSet == null) {
                RangeConstraint.$$$reportNull$$$0(3);
            }
            return longRangeSet;
        }

        String getExpressionSuffix() {
            if (this.myField == null) {
                return "";
            }
            switch (this.myField) {
                case ARRAY_LENGTH: {
                    return ".length";
                }
                case STRING_LENGTH: {
                    return ".length()";
                }
                case COLLECTION_SIZE: {
                    return ".size()";
                }
            }
            return "";
        }

        @NotNull
        static RangeConstraint create(TextRange textRange, PsiExpression expr, LongRangeSet set) {
            PsiExpression qualifier;
            PsiReferenceExpression ref;
            SpecialField field = null;
            Object object = expr instanceof PsiReferenceExpression ? (PsiReferenceExpression)expr : (ref = expr instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expr).getMethodExpression() : null);
            if (ref != null && (qualifier = ref.getQualifierExpression()) != null && (field = SpecialField.findSpecialField(ref.resolve())) != null) {
                expr = qualifier;
            }
            RangeConstraint rangeConstraint = new RangeConstraint(textRange, expr, field, set);
            if (rangeConstraint == null) {
                RangeConstraint.$$$reportNull$$$0(4);
            }
            return rangeConstraint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constraint";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/ExcessiveRangeCheckInspection$RangeConstraint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/ExcessiveRangeCheckInspection$RangeConstraint";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullRange";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

