/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import com.siyeh.ig.psiutils.LibraryUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ClassInheritanceDepthInspection
extends ClassMetricInspection {
    private static final int CLASS_INHERITANCE_LIMIT = 2;

    @NotNull
    public String getID() {
        if ("ClassTooDeepInInheritanceTree" == null) {
            ClassInheritanceDepthInspection.$$$reportNull$$$0(0);
        }
        return "ClassTooDeepInInheritanceTree";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.too.deep.display.name", new Object[0]);
        if (string == null) {
            ClassInheritanceDepthInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 2;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("class.too.deep.inheritance.depth.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer count = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("class.too.deep.problem.descriptor", count);
        if (string == null) {
            ClassInheritanceDepthInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassNestingLevel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classmetrics/ClassInheritanceDepthInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ClassNestingLevel
    extends BaseInspectionVisitor {
        private ClassNestingLevel() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ClassNestingLevel.$$$reportNull$$$0(0);
            }
            if (aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            int inheritanceDepth = this.getInheritanceDepth(aClass, new HashSet());
            if (inheritanceDepth <= ClassInheritanceDepthInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass, inheritanceDepth);
        }

        private int getInheritanceDepth(PsiClass aClass, Set<? super PsiClass> visited) {
            if (visited.contains(aClass)) {
                return 0;
            }
            visited.add((PsiClass)aClass);
            PsiClass superClass = aClass.getSuperClass();
            if (superClass == null) {
                return 0;
            }
            if (LibraryUtil.classIsInLibrary(aClass) && LibraryUtil.classIsInLibrary(superClass)) {
                return 0;
            }
            return this.getInheritanceDepth(superClass, visited) + 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classmetrics/ClassInheritanceDepthInspection$ClassNestingLevel", "visitClass"));
        }
    }
}

