/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.ui.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubtractionInCompareToInspection
extends BaseInspection {
    protected final MethodMatcher methodMatcher = new MethodMatcher().add("java.util.Collection", "size").add("java.util.Map", "size").add("java.lang.String", "length").add("java.lang.AbstractStringBuilder", "length").finishDefault();

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        ListTable table = new ListTable(new ListWrappingTableModel(Arrays.asList(this.methodMatcher.getClassNames(), this.methodMatcher.getMethodNamePatterns()), new String[]{InspectionGadgetsBundle.message("class.name", new Object[0]), InspectionGadgetsBundle.message("method.name.regex", new Object[0])}));
        JPanel tablePanel = UiUtils.createAddRemoveTreeClassChooserPanel(table, InspectionGadgetsBundle.message("choose.class", new Object[0]), new String[0]);
        panel.add((Component)tablePanel, "Center");
        return panel;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            SubtractionInCompareToInspection.$$$reportNull$$$0(0);
        }
        super.readSettings(node);
        this.methodMatcher.readSettings(node);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            SubtractionInCompareToInspection.$$$reportNull$$$0(1);
        }
        super.writeSettings(node);
        this.methodMatcher.writeSettings(node);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("subtraction.in.compareto.display.name", new Object[0]);
        if (string == null) {
            SubtractionInCompareToInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("subtraction.in.compareto.problem.descriptor", new Object[0]);
        if (string == null) {
            SubtractionInCompareToInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SubtractionInCompareToVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bugs/SubtractionInCompareToInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bugs/SubtractionInCompareToInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SubtractionInCompareToVisitor
    extends BaseInspectionVisitor {
        private SubtractionInCompareToVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression2) {
            PsiClass functionalInterface;
            super.visitBinaryExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.MINUS) || this.isSafeSubtraction(expression2)) {
                return;
            }
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
            if (lambdaExpression != null && (functionalInterface = LambdaUtil.resolveFunctionalInterfaceClass((PsiFunctionalExpression)lambdaExpression)) != null && "java.util.Comparator".equals(functionalInterface.getQualifiedName())) {
                this.registerError((PsiElement)expression2, new Object[0]);
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            if (!MethodUtils.isCompareTo(method) && !MethodUtils.isComparatorCompare(method)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        private boolean isSafeSubtraction(PsiBinaryExpression binaryExpression) {
            PsiType type2 = binaryExpression.getType();
            if (PsiType.FLOAT.equals((Object)type2) || PsiType.DOUBLE.equals((Object)type2)) {
                PsiType castType;
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)binaryExpression.getParent());
                return !(parent instanceof PsiTypeCastExpression) || !PsiType.INT.equals((Object)(castType = ((PsiTypeCastExpression)parent).getType())) && !PsiType.LONG.equals((Object)castType);
            }
            if (ExpressionUtils.isEvaluatedAtCompileTime((PsiExpression)binaryExpression)) {
                return true;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return true;
            }
            PsiType lhsType = lhs.getType();
            PsiType rhsType = rhs.getType();
            if (lhsType == null || rhsType == null) {
                return false;
            }
            if ((PsiType.BYTE.equals((Object)lhsType) || PsiType.SHORT.equals((Object)lhsType) || PsiType.CHAR.equals((Object)lhsType)) && (PsiType.BYTE.equals((Object)rhsType) || PsiType.SHORT.equals((Object)rhsType) || PsiType.CHAR.equals((Object)rhsType))) {
                return true;
            }
            if (this.isSafeOperand(lhs) && this.isSafeOperand(rhs)) {
                return true;
            }
            LongRangeSet leftRange = CommonDataflow.getExpressionFact(lhs, DfaFactType.RANGE);
            LongRangeSet rightRange = CommonDataflow.getExpressionFact(rhs, DfaFactType.RANGE);
            return leftRange != null && !leftRange.isEmpty() && rightRange != null && !rightRange.isEmpty() && !leftRange.subtractionMayOverflow(rightRange, PsiType.LONG.equals((Object)type2));
        }

        private boolean isSafeOperand(PsiExpression operand2) {
            if ((operand2 = ParenthesesUtils.stripParentheses(operand2)) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)operand2;
                return SubtractionInCompareToInspection.this.methodMatcher.matches((PsiCall)methodCallExpression);
            }
            return ExpressionUtils.getArrayFromLengthExpression(operand2) != null;
        }
    }
}

