/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiMethod;
import com.intellij.spellchecker.NamedElementTokenizer;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import org.jetbrains.annotations.NotNull;

public class MethodNameTokenizerJava
extends NamedElementTokenizer<PsiMethod> {
    @Override
    public void tokenize(@NotNull PsiMethod element, TokenConsumer consumer) {
        if (element == null) {
            MethodNameTokenizerJava.$$$reportNull$$$0(0);
        }
        PsiMethod[] methods = element.findDeepestSuperMethods();
        boolean isInSource = true;
        for (PsiMethod psiMethod : methods) {
            isInSource &= MethodNameTokenizerJava.isMethodDeclarationInSource(psiMethod);
        }
        if (isInSource) {
            super.tokenize(element, consumer);
        }
    }

    private static boolean isMethodDeclarationInSource(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            MethodNameTokenizerJava.$$$reportNull$$$0(1);
        }
        if (psiMethod.getContainingFile() == null) {
            return false;
        }
        VirtualFile virtualFile = psiMethod.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return ProjectRootManager.getInstance((Project)psiMethod.getProject()).getFileIndex().isInSource(virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spellchecker/MethodNameTokenizerJava";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tokenize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodDeclarationInSource";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

