/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.migration.MigrationMapEntry;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditMigrationEntryDialog
extends DialogWrapper {
    private JRadioButton myRbPackage;
    private JRadioButton myRbClass;
    private EditorTextField myOldNameField;
    private EditorTextField myNewNameField;
    private final Project myProject;

    public EditMigrationEntryDialog(Project project) {
        super(project, true);
        this.myProject = project;
        this.setTitle(RefactoringBundle.message((String)"edit.migration.entry.title"));
        this.setHorizontalStretch(1.2f);
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myOldNameField;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insets((int)4);
        gbConstraints.weighty = 0.0;
        gbConstraints.gridwidth = -1;
        gbConstraints.fill = 1;
        gbConstraints.weightx = 0.0;
        this.myRbPackage = new JRadioButton(RefactoringBundle.message((String)"migration.entry.package"));
        panel.add((Component)this.myRbPackage, gbConstraints);
        gbConstraints.gridwidth = -1;
        gbConstraints.fill = 1;
        gbConstraints.weightx = 0.0;
        this.myRbClass = new JRadioButton(RefactoringBundle.message((String)"migration.entry.class"));
        panel.add((Component)this.myRbClass, gbConstraints);
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        panel.add((Component)new JPanel(), gbConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myRbPackage);
        buttonGroup.add(this.myRbClass);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = -1;
        gbConstraints.fill = 0;
        JLabel oldNamePrompt = new JLabel(RefactoringBundle.message((String)"migration.entry.old.name"));
        panel.add((Component)oldNamePrompt, gbConstraints);
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 2;
        gbConstraints.weightx = 1.0;
        LanguageTextField.DocumentCreator documentCreator = new LanguageTextField.DocumentCreator(){

            public Document createDocument(String value2, @Nullable Language language, Project project) {
                PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)project).findPackage("");
                PsiJavaCodeReferenceCodeFragment fragment = JavaCodeFragmentFactory.getInstance((Project)project).createReferenceCodeFragment("", (PsiElement)defaultPackage, true, true);
                return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
            }
        };
        this.myOldNameField = new LanguageTextField((Language)JavaLanguage.INSTANCE, this.myProject, "", documentCreator);
        panel.add((Component)this.myOldNameField, gbConstraints);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = -1;
        gbConstraints.fill = 0;
        JLabel newNamePrompt = new JLabel(RefactoringBundle.message((String)"migration.entry.new.name"));
        panel.add((Component)newNamePrompt, gbConstraints);
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 2;
        gbConstraints.weightx = 1.0;
        this.myNewNameField = new LanguageTextField((Language)JavaLanguage.INSTANCE, this.myProject, "", documentCreator);
        panel.setPreferredSize(new Dimension(300, panel.getPreferredSize().height));
        panel.add((Component)this.myNewNameField, gbConstraints);
        DocumentListener documentAdapter = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                EditMigrationEntryDialog.this.validateOKButton();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/migration/EditMigrationEntryDialog$2", "documentChanged"));
            }
        };
        this.myOldNameField.getDocument().addDocumentListener(documentAdapter);
        this.myNewNameField.getDocument().addDocumentListener(documentAdapter);
        return panel;
    }

    private void validateOKButton() {
        boolean isEnabled = true;
        String text2 = this.myOldNameField.getText();
        text2 = text2.trim();
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        if (!PsiNameHelper.getInstance((Project)manager.getProject()).isQualifiedName(text2)) {
            isEnabled = false;
        }
        text2 = this.myNewNameField.getText();
        text2 = text2.trim();
        if (!PsiNameHelper.getInstance((Project)manager.getProject()).isQualifiedName(text2)) {
            isEnabled = false;
        }
        this.setOKActionEnabled(isEnabled);
    }

    public void setEntry(MigrationMapEntry entry) {
        this.myOldNameField.setText(entry.getOldName());
        this.myNewNameField.setText(entry.getNewName());
        this.myRbPackage.setSelected(entry.getType() == 0);
        this.myRbClass.setSelected(entry.getType() == 1);
        this.validateOKButton();
    }

    public void updateEntry(MigrationMapEntry entry) {
        entry.setOldName(this.myOldNameField.getText().trim());
        entry.setNewName(this.myNewNameField.getText().trim());
        if (this.myRbPackage.isSelected()) {
            entry.setType(0);
            entry.setRecursive(true);
        } else {
            entry.setType(1);
        }
    }
}

