/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractSuperclass;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.extractInterface.ExtractClassUtil;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil;
import com.intellij.refactoring.extractSuperclass.ExtractSuperclassDialog;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.memberPullUp.PullUpConflictsUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExtractSuperclassHandler
implements ElementsHandler,
ExtractSuperclassDialog.Callback,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.extractSuperclass.ExtractSuperclassHandler");
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"extract.superclass.title");
    private PsiClass mySubclass;
    private Project myProject;

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        if (editor == null) {
            ExtractSuperclassHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ExtractSuperclassHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            ExtractSuperclassHandler.$$$reportNull$$$0(2);
        }
        return !PsiUtil.isModuleFile((PsiFile)file);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            ExtractSuperclassHandler.$$$reportNull$$$0(3);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.extractSuperclass");
                return;
            }
            if (element instanceof PsiClass) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        ExtractSuperclassDialog dialog;
        Editor editor;
        if (project == null) {
            ExtractSuperclassHandler.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            ExtractSuperclassHandler.$$$reportNull$$$0(5);
        }
        if (elements.length != 1) {
            return;
        }
        this.myProject = project;
        this.mySubclass = (PsiClass)elements[0];
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)this.mySubclass)) {
            return;
        }
        Editor editor2 = editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        if (this.mySubclass.isInterface()) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"superclass.cannot.be.extracted.from.an.interface"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.extractSuperclass");
            return;
        }
        if (this.mySubclass.isEnum()) {
            String message3 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"superclass.cannot.be.extracted.from.an.enum"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message3, (String)REFACTORING_NAME, (String)"refactoring.extractSuperclass");
            return;
        }
        List memberInfos = MemberInfo.extractClassMembers(this.mySubclass, new MemberInfoBase.Filter<PsiMember>(){

            public boolean includeMember(PsiMember element) {
                return true;
            }
        }, false);
        if (this.mySubclass instanceof PsiAnonymousClass) {
            memberInfos = ContainerUtil.filter(memberInfos, memberInfo -> !(memberInfo.getMember() instanceof PsiClass) || memberInfo.getOverrides() == null);
        }
        if (!(dialog = new ExtractSuperclassDialog(project, this.mySubclass, (List<MemberInfo>)memberInfos, this)).showAndGet() || !dialog.isExtractSuperclass()) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            Runnable action = () -> ExtractSuperclassHandler.doRefactoring(project, this.mySubclass, dialog);
            ApplicationManager.getApplication().runWriteAction(action);
        }, REFACTORING_NAME, null);
    }

    @Override
    public boolean checkConflicts(ExtractSuperclassDialog dialog) {
        MemberInfo[] infos = dialog.getSelectedMemberInfos().toArray(new MemberInfo[0]);
        PsiDirectory targetDirectory = dialog.getTargetDirectory();
        PsiPackage targetPackage = targetDirectory != null ? JavaDirectoryService.getInstance().getPackage(targetDirectory) : null;
        MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass superClass;
            Object object = superClass = this.mySubclass.getExtendsListTypes().length > 0 || this.mySubclass instanceof PsiAnonymousClass ? this.mySubclass.getSuperClass() : null;
            if (targetPackage != null) {
                conflicts.putAllValues(PullUpConflictsUtil.checkConflicts(infos, this.mySubclass, superClass, targetPackage, targetDirectory, dialog.getContainmentVerifier(), false));
            }
        }), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, this.myProject)) {
            return false;
        }
        ExtractSuperClassUtil.checkSuperAccessible(targetDirectory, (MultiMap<PsiElement, String>)conflicts, this.mySubclass);
        return ExtractSuperClassUtil.showConflicts((DialogWrapper)dialog, (MultiMap<PsiElement, String>)conflicts, this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRefactoring(Project project, PsiClass subclass, ExtractSuperclassDialog dialog) {
        String superclassName = dialog.getExtractedSuperName();
        PsiDirectory targetDirectory = dialog.getTargetDirectory();
        MemberInfo[] selectedMemberInfos = dialog.getSelectedMemberInfos().toArray(new MemberInfo[0]);
        DocCommentPolicy javaDocPolicy = new DocCommentPolicy(dialog.getDocCommentPolicy());
        LocalHistoryAction a = LocalHistory.getInstance().startAction(ExtractSuperclassHandler.getCommandName(subclass, superclassName));
        try {
            PsiClass superclass;
            try {
                superclass = ExtractSuperClassUtil.extractSuperClass(project, targetDirectory, superclassName, subclass, selectedMemberInfos, javaDocPolicy);
            }
            finally {
                a.finish();
            }
            ExtractClassUtil.suggestToTurnRefsToSuper(project, superclass, subclass);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static String getCommandName(PsiClass subclass, String newName) {
        return RefactoringBundle.message((String)"extract.superclass.command.name", (Object[])new Object[]{newName, DescriptiveNameUtil.getDescriptiveName((PsiElement)subclass)});
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof PsiClass && !((PsiClass)elements[0]).isInterface() && !((PsiClass)elements[0]).isEnum();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractSuperclass/ExtractSuperclassHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForQuickList";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

